/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.console.editor;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Map;
import net.grinder.common.Closer;
import net.grinder.common.UncheckedInterruptedException;
import net.grinder.console.common.DisplayMessageConsoleException;
import net.grinder.console.common.Resources;
import net.grinder.console.editor.Buffer;
import net.grinder.console.editor.EditorException;
import net.grinder.console.editor.TextSource;
import net.grinder.util.ListenerSupport;

final class BufferImplementation
implements Buffer {
    private static final Map s_extensionMap = new HashMap(){
        {
            this.put("bash", Buffer.SHELL_BUFFER);
            this.put("bat", Buffer.MSDOS_BATCH_BUFFER);
            this.put("cmd", Buffer.MSDOS_BATCH_BUFFER);
            this.put("csh", Buffer.SHELL_BUFFER);
            this.put("htm", Buffer.HTML_BUFFER);
            this.put("html", Buffer.HTML_BUFFER);
            this.put("java", Buffer.JAVA_BUFFER);
            this.put("ksh", Buffer.SHELL_BUFFER);
            this.put("properties", Buffer.PROPERTIES_BUFFER);
            this.put("py", Buffer.PYTHON_BUFFER);
            this.put("sh", Buffer.SHELL_BUFFER);
            this.put("text", Buffer.TEXT_BUFFER);
            this.put("txt", Buffer.TEXT_BUFFER);
            this.put("xml", Buffer.XML_BUFFER);
        }
    };
    private final Resources m_resources;
    private final TextSource m_textSource;
    private final ListenerSupport m_listeners = new ListenerSupport();
    private String m_name;
    private File m_file;
    private long m_lastModified = -1L;

    BufferImplementation(Resources resources, TextSource textSource, String name) {
        this.m_resources = resources;
        this.m_textSource = textSource;
        this.m_file = null;
        this.m_name = name;
    }

    BufferImplementation(Resources resources, TextSource textSource, File file) {
        this.m_resources = resources;
        this.m_textSource = textSource;
        this.setFile(file);
    }

    public TextSource getTextSource() {
        return this.m_textSource;
    }

    public void load() throws DisplayMessageConsoleException, EditorException {
        if (this.m_file == null) {
            throw new EditorException("Can't load a buffer that has no associated file");
        }
        StringWriter stringWriter = new StringWriter();
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new FileReader(this.m_file));
            while ((line = reader.readLine()) != null) {
                stringWriter.write(line);
                stringWriter.write(10);
            }
        }
        catch (IOException e) {
            try {
                UncheckedInterruptedException.ioException(e);
                throw new DisplayMessageConsoleException(this.m_resources, "fileReadError.text", new Object[]{this.m_file, ".\n(" + BufferImplementation.extractReasonFromIOException(e) + ")"}, e);
            }
            catch (Throwable throwable) {
                Closer.close(reader);
                throw throwable;
            }
        }
        Closer.close(reader);
        this.m_textSource.setText(stringWriter.toString());
        this.m_lastModified = this.m_file.lastModified();
    }

    public void save() throws DisplayMessageConsoleException, EditorException {
        if (this.m_file == null) {
            throw new EditorException("Can't save a buffer that has no associated file");
        }
        this.save(this.m_file);
    }

    public void save(File file) throws DisplayMessageConsoleException {
        final File oldFile = this.getFile();
        FileWriter fileWriter = null;
        try {
            String text = this.m_textSource.getText();
            String[] lines = text.split("\n", -1);
            fileWriter = new FileWriter(file);
            PrintWriter printWriter = new PrintWriter(fileWriter);
            for (int i = 0; i < lines.length; ++i) {
                printWriter.println(lines[i]);
            }
            this.setFile(file);
            printWriter.close();
            this.m_lastModified = this.m_file.lastModified();
            this.m_listeners.apply(new ListenerSupport.Informer(){

                public void inform(Object listener) {
                    ((Listener)listener).bufferSaved(BufferImplementation.this, oldFile);
                }
            });
        }
        catch (IOException e) {
            try {
                UncheckedInterruptedException.ioException(e);
                throw new DisplayMessageConsoleException(this.m_resources, "fileWriteError.text", new Object[]{this.m_file, "./n(" + BufferImplementation.extractReasonFromIOException(e) + ")"}, e);
            }
            catch (Throwable throwable) {
                Closer.close(fileWriter);
                throw throwable;
            }
        }
        Closer.close(fileWriter);
    }

    public boolean isDirty() {
        return this.m_textSource.isDirty();
    }

    private void setFile(File file) {
        this.m_file = file;
        this.m_name = file.getName();
    }

    public File getFile() {
        return this.m_file;
    }

    public boolean isUpToDate() {
        return this.m_file == null || this.m_lastModified == this.m_file.lastModified();
    }

    public Buffer.Type getType() {
        String extension;
        TypeImplementation type;
        String name;
        int lastDot;
        if (this.m_file != null && (lastDot = (name = this.m_file.getName()).lastIndexOf(46)) >= 0 && (type = (TypeImplementation)s_extensionMap.get(extension = name.substring(lastDot + 1))) != null) {
            return type;
        }
        return UNKNOWN_BUFFER;
    }

    public String getDisplayName() {
        return this.m_name;
    }

    public String toString() {
        return "<Buffer " + this.hashCode() + " '" + this.getDisplayName() + "'>";
    }

    public void addListener(Listener listener) {
        this.m_listeners.add(listener);
    }

    static String extractReasonFromIOException(IOException e) {
        if (e instanceof FileNotFoundException) {
            String message = e.getMessage();
            int firstParenthesis = message.indexOf(40);
            int secondsParenthesis = message.indexOf(41, firstParenthesis);
            if (firstParenthesis >= 0 && secondsParenthesis > firstParenthesis + 1) {
                return message.substring(firstParenthesis + 1, secondsParenthesis);
            }
        }
        return "";
    }

    public static final class TypeImplementation
    implements Buffer.Type {
        private final String m_name;

        TypeImplementation(String name) {
            this.m_name = name;
        }

        public String toString() {
            return this.m_name;
        }
    }

    public static interface Listener
    extends EventListener {
        public void bufferSaved(Buffer var1, File var2);
    }
}

