/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.communication;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import net.grinder.common.Closer;
import net.grinder.common.UncheckedInterruptedException;
import net.grinder.communication.CloseCommunicationMessage;
import net.grinder.communication.CommunicationException;
import net.grinder.communication.Message;
import net.grinder.communication.Receiver;

public class StreamReceiver
implements Receiver {
    private final InputStream m_inputStream;
    private final Object m_streamLock;
    private boolean m_shutdown = false;

    public StreamReceiver(InputStream inputStream) {
        this(inputStream, inputStream);
    }

    private StreamReceiver(InputStream inputStream, Object streamLock) {
        this.m_inputStream = inputStream;
        this.m_streamLock = streamLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Message waitForMessage() throws CommunicationException {
        if (this.m_shutdown) {
            return null;
        }
        try {
            Message message;
            Object object = this.m_streamLock;
            synchronized (object) {
                ObjectInputStream objectStream = new ObjectInputStream(this.m_inputStream);
                message = (Message)objectStream.readObject();
            }
            if (message instanceof CloseCommunicationMessage) {
                this.shutdown();
                return null;
            }
            return message;
        }
        catch (IOException e) {
            UncheckedInterruptedException.ioException(e);
            throw new CommunicationException("Failed to read message", e);
        }
        catch (ClassNotFoundException e) {
            throw new CommunicationException("Failed to read message", e);
        }
    }

    public void shutdown() {
        this.m_shutdown = true;
        Closer.close(this.m_inputStream);
    }
}

