/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.communication;

import net.grinder.communication.CommunicationException;
import net.grinder.communication.Message;
import net.grinder.communication.Sender;

final class MessageRequiringResponse
implements Message {
    private static final long serialVersionUID = 1L;
    private final Message m_message;
    private transient Sender m_responder;
    private transient boolean m_responseSent;

    MessageRequiringResponse(Message message) {
        this.m_message = message;
    }

    public Message getMessage() {
        return this.m_message;
    }

    void setResponder(Sender sender) {
        this.m_responder = sender;
    }

    public void sendResponse(Message message) throws CommunicationException {
        if (this.m_responder == null) {
            throw new CommunicationException("Response sender not set");
        }
        if (this.m_responseSent) {
            throw new CommunicationException("One response message only");
        }
        this.m_responseSent = true;
        this.m_responder.send(message);
    }

    public boolean isResponseSent() {
        return this.m_responseSent;
    }
}

