/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.communication;

import net.grinder.communication.CommunicationException;
import net.grinder.communication.Message;
import net.grinder.util.thread.ThreadSafeQueue;

final class MessageQueue {
    private final ThreadSafeQueue m_queue = new ThreadSafeQueue();
    private final boolean m_passExceptions;

    public MessageQueue(boolean passExceptions) {
        this.m_passExceptions = passExceptions;
    }

    public void queue(Message message) throws ThreadSafeQueue.ShutdownException {
        this.m_queue.queue(message);
    }

    public void queue(Exception exception) throws ThreadSafeQueue.ShutdownException {
        if (!this.m_passExceptions) {
            throw new AssertionError((Object)"This MessageQueue does not allow Exceptions to be queued");
        }
        this.m_queue.queue(exception);
    }

    public Message dequeue(boolean block) throws CommunicationException, ThreadSafeQueue.ShutdownException {
        Object result = this.m_queue.dequeue(block);
        if (this.m_passExceptions && result instanceof Exception) {
            Exception e = (Exception)result;
            throw new CommunicationException(e.getMessage(), e);
        }
        return (Message)result;
    }

    public void shutdown() {
        this.m_queue.shutdown();
    }

    public void checkIfShutdown() throws ThreadSafeQueue.ShutdownException {
        this.m_queue.checkIfShutdown();
    }

    public Object getMonitor() {
        return this.m_queue.getCondition();
    }
}

