/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.common;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import net.grinder.common.UncheckedInterruptedException;

public final class GrinderBuild {
    private static final String s_versionString;
    private static final String s_dateString;

    private GrinderBuild() {
    }

    public static String getName() {
        return "The Grinder " + GrinderBuild.getVersionString();
    }

    public static String getVersionString() {
        return s_versionString;
    }

    public static String getDateString() {
        return s_dateString;
    }

    static {
        try {
            InputStream buildPropertiesStream = GrinderBuild.class.getClassLoader().getResourceAsStream("net/grinder/common/resources/build.properties");
            if (buildPropertiesStream == null) {
                throw new IOException("Could not find build.properties");
            }
            Properties properties = new Properties();
            properties.load(buildPropertiesStream);
            s_versionString = properties.getProperty("version");
            s_dateString = properties.getProperty("date");
        }
        catch (IOException e) {
            UncheckedInterruptedException.ioException(e);
            throw new ExceptionInInitializerError(e);
        }
    }
}

