/*
 * Decompiled with CFR 0.152.
 */
package org.python.indexer.ast;

import org.python.indexer.Scope;
import org.python.indexer.ast.NNode;
import org.python.indexer.ast.NNodeVisitor;
import org.python.indexer.types.NType;

public final class NExec
extends NNode {
    private NNode body;
    private NNode globals;
    private NNode locals;

    public NExec(NNode body, NNode globals, NNode locals) {
        this(null, null, null, 0, 1);
    }

    public NExec(NNode body, NNode globals, NNode locals, int start, int end) {
        super(start, end);
        this.body = body;
        this.globals = globals;
        this.locals = locals;
        this.addChildren(body, globals, locals);
    }

    @Override
    public final NType resolve(Scope s) throws Exception {
        NExec.resolveExpr(this.body, s);
        NExec.resolveExpr(this.globals, s);
        NExec.resolveExpr(this.locals, s);
        return this.getType();
    }

    public final String toString() {
        return "<Exec:" + this.start() + ":" + this.end() + ">";
    }

    @Override
    public final void visit(NNodeVisitor v) {
        if (v.visit(this)) {
            NExec.visitNode(this.body, v);
            NExec.visitNode(this.globals, v);
            NExec.visitNode(this.locals, v);
        }
    }
}

