/*
 * Decompiled with CFR 0.152.
 */
package org.python.google.common.util.concurrent;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.python.google.common.util.concurrent.ListeningExecutorService;

final class MoreExecutors$SameThreadExecutorService
extends ListeningExecutorService {
    private final Lock lock = new ReentrantLock();
    private final Condition termination = this.lock.newCondition();
    private int runningTasks = 0;
    private boolean shutdown = false;

    private MoreExecutors$SameThreadExecutorService() {
    }

    @Override
    public final void execute(Runnable command) {
        MoreExecutors$SameThreadExecutorService moreExecutors$SameThreadExecutorService = this;
        moreExecutors$SameThreadExecutorService.lock.lock();
        try {
            if (moreExecutors$SameThreadExecutorService.isShutdown()) {
                throw new RejectedExecutionException("Executor already shutdown");
            }
            ++moreExecutors$SameThreadExecutorService.runningTasks;
        }
        finally {
            moreExecutors$SameThreadExecutorService.lock.unlock();
        }
        try {
            command.run();
            return;
        }
        finally {
            this.endTask();
        }
    }

    @Override
    public final boolean isShutdown() {
        this.lock.lock();
        try {
            boolean bl = this.shutdown;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public final void shutdown() {
        this.lock.lock();
        try {
            this.shutdown = true;
            return;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public final List<Runnable> shutdownNow() {
        this.shutdown();
        return Collections.emptyList();
    }

    @Override
    public final boolean isTerminated() {
        this.lock.lock();
        try {
            boolean bl = this.shutdown && this.runningTasks == 0;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        long nanos = unit.toNanos(timeout);
        this.lock.lock();
        while (true) {
            try {
                if (this.isTerminated()) {
                    this.lock.unlock();
                    return true;
                }
                if (nanos <= 0L) {
                    this.lock.unlock();
                    return false;
                }
            }
            catch (Throwable throwable) {
                this.lock.unlock();
                throw throwable;
            }
            {
                nanos = this.termination.awaitNanos(nanos);
                continue;
            }
            break;
        }
    }

    private void endTask() {
        this.lock.lock();
        try {
            --this.runningTasks;
            if (this.isTerminated()) {
                this.termination.signalAll();
            }
            return;
        }
        finally {
            this.lock.unlock();
        }
    }

    /* synthetic */ MoreExecutors$SameThreadExecutorService(byte by) {
        this();
    }
}

