/*
 * Decompiled with CFR 0.152.
 */
package jnr.ffi;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NativeLong
extends Number
implements Comparable<NativeLong> {
    private static final NativeLong ZERO = new NativeLong(0);
    private static final NativeLong ONE = new NativeLong(1);
    private static final NativeLong MINUS_ONE = new NativeLong(-1);
    private final long value;

    public NativeLong(long value) {
        this.value = value;
    }

    public NativeLong(int value) {
        this.value = value;
    }

    @Override
    public final int intValue() {
        return (int)this.value;
    }

    @Override
    public final long longValue() {
        return this.value;
    }

    @Override
    public final float floatValue() {
        return this.value;
    }

    @Override
    public final double doubleValue() {
        return this.value;
    }

    public final int hashCode() {
        return (int)(this.value ^ this.value >>> 32);
    }

    public final boolean equals(Object obj) {
        return obj instanceof NativeLong && this.value == ((NativeLong)obj).value;
    }

    public final String toString() {
        return String.valueOf(this.value);
    }

    @Override
    public final int compareTo(NativeLong other) {
        if (this.value < other.value) {
            return -1;
        }
        if (this.value > other.value) {
            return 1;
        }
        return 0;
    }

    private static final NativeLong _valueOf(long value) {
        if (value >= -128L && value <= 127L) {
            return Cache.cache[128 + (int)value];
        }
        return new NativeLong(value);
    }

    private static final NativeLong _valueOf(int value) {
        if (value >= -128 && value <= 127) {
            return Cache.cache[value + 128];
        }
        return new NativeLong(value);
    }

    public static final NativeLong valueOf(long value) {
        if (value == 0L) {
            return ZERO;
        }
        if (value == 1L) {
            return ONE;
        }
        if (value == -1L) {
            return MINUS_ONE;
        }
        return NativeLong._valueOf(value);
    }

    public static final NativeLong valueOf(int value) {
        if (value == 0) {
            return ZERO;
        }
        if (value == 1) {
            return ONE;
        }
        if (value == -1) {
            return MINUS_ONE;
        }
        return NativeLong._valueOf(value);
    }

    static final class Cache {
        static final NativeLong[] cache = new NativeLong[256];

        private Cache() {
        }

        static {
            int i = 0;
            while (true) {
                if (i >= 256) break;
                Cache.cache[i] = new NativeLong(i - 128);
                ++i;
            }
            Cache.cache[128] = ZERO;
            Cache.cache[129] = ONE;
            Cache.cache[127] = MINUS_ONE;
        }
    }
}

