/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.engine.agent;

import net.grinder.common.Logger;
import net.grinder.common.UncheckedInterruptedException;
import net.grinder.engine.agent.Worker;
import net.grinder.engine.agent.WorkerFactory;
import net.grinder.engine.common.EngineException;
import net.grinder.util.thread.Condition;
import net.grinder.util.thread.Executor;
import net.grinder.util.thread.InterruptibleRunnable;

final class WorkerLauncher {
    private final Executor m_executor;
    private final WorkerFactory m_workerFactory;
    private final Condition m_notifyOnFinish;
    private final Logger m_logger;
    private final Worker[] m_workers;
    private int m_nextWorkerIndex = 0;
    static /* synthetic */ Class class$net$grinder$engine$agent$WorkerLauncher;

    public WorkerLauncher(int numberOfWorkers, WorkerFactory workerFactory, Condition notifyOnFinish, Logger logger) {
        this(new Executor(1), numberOfWorkers, workerFactory, notifyOnFinish, logger);
    }

    WorkerLauncher(Executor executor, int numberOfWorkers, WorkerFactory workerFactory, Condition notifyOnFinish, Logger logger) {
        this.m_executor = executor;
        this.m_workerFactory = workerFactory;
        this.m_notifyOnFinish = notifyOnFinish;
        this.m_logger = logger;
        this.m_workers = new Worker[numberOfWorkers];
    }

    public void startAllWorkers() throws EngineException {
        this.startSomeWorkers(this.m_workers.length - this.m_nextWorkerIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public boolean startSomeWorkers(int numberOfWorkers) throws EngineException {
        int numberToStart = Math.min(numberOfWorkers, this.m_workers.length - this.m_nextWorkerIndex);
        for (int i = 0; i < numberToStart; ++i) {
            int workerIndex = this.m_nextWorkerIndex++;
            Worker worker = this.m_workerFactory.create(System.out, System.err);
            Worker[] workerArray = this.m_workers;
            // MONITORENTER : this.m_workers
            this.m_workers[workerIndex] = worker;
            // MONITOREXIT : workerArray
            try {
                this.m_executor.execute(new WaitForWorkerTask(workerIndex));
            }
            catch (Executor.ShutdownException e) {
                this.m_logger.error("Executor unexpectedly shutdown");
                e.printStackTrace(this.m_logger.getErrorLogWriter());
                worker.destroy();
                return false;
            }
            this.m_logger.output("worker " + worker.getIdentity().getName() + " started");
        }
        if (this.m_workers.length <= this.m_nextWorkerIndex) return false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean allFinished() {
        if (this.m_nextWorkerIndex < this.m_workers.length) {
            return false;
        }
        Worker[] workerArray = this.m_workers;
        synchronized (this.m_workers) {
            for (int i = 0; i < this.m_workers.length; ++i) {
                if (this.m_workers[i] == null) continue;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return false;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return true;
        }
    }

    public void shutdown() {
        this.m_executor.gracefulShutdown();
    }

    public void dontStartAnyMore() {
        this.m_nextWorkerIndex = this.m_workers.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyAllWorkers() {
        this.dontStartAnyMore();
        Worker[] workerArray = this.m_workers;
        synchronized (this.m_workers) {
            for (int i = 0; i < this.m_workers.length; ++i) {
                if (this.m_workers[i] == null) continue;
                this.m_workers[i].destroy();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private final class WaitForWorkerTask
    implements InterruptibleRunnable {
        private final int m_workerIndex;
        static final /* synthetic */ boolean $assertionsDisabled;

        public WaitForWorkerTask(int workerIndex) {
            this.m_workerIndex = workerIndex;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void interruptibleRun() {
            Worker worker;
            Object object = WorkerLauncher.this.m_workers;
            synchronized (object) {
                worker = WorkerLauncher.this.m_workers[this.m_workerIndex];
            }
            if (!$assertionsDisabled && worker == null) {
                throw new AssertionError();
            }
            try {
                worker.waitFor();
            }
            catch (UncheckedInterruptedException e) {
                worker.destroy();
            }
            object = WorkerLauncher.this.m_workers;
            synchronized (object) {
                ((WorkerLauncher)WorkerLauncher.this).m_workers[this.m_workerIndex] = null;
            }
            if (WorkerLauncher.this.allFinished()) {
                object = WorkerLauncher.this.m_notifyOnFinish;
                synchronized (object) {
                    WorkerLauncher.this.m_notifyOnFinish.notifyAll();
                }
            }
        }

        static {
            $assertionsDisabled = !(class$net$grinder$engine$agent$WorkerLauncher == null ? (class$net$grinder$engine$agent$WorkerLauncher = WorkerLauncher.class$("net.grinder.engine.agent.WorkerLauncher")) : class$net$grinder$engine$agent$WorkerLauncher).desiredAssertionStatus();
        }
    }
}

