/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.engine.process;

import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import net.grinder.common.GrinderBuild;
import net.grinder.common.GrinderException;
import net.grinder.common.GrinderProperties;
import net.grinder.common.Logger;
import net.grinder.common.Test;
import net.grinder.communication.ClientSender;
import net.grinder.communication.CommunicationException;
import net.grinder.communication.ConnectionType;
import net.grinder.communication.Message;
import net.grinder.communication.MessageDispatchSender;
import net.grinder.communication.MessagePump;
import net.grinder.communication.QueuedSender;
import net.grinder.communication.QueuedSenderDecorator;
import net.grinder.communication.Receiver;
import net.grinder.engine.common.ConnectorFactory;
import net.grinder.engine.common.EngineException;
import net.grinder.engine.communication.ConsoleListener;
import net.grinder.engine.messages.InitialiseGrinderMessage;
import net.grinder.engine.process.GrinderThread;
import net.grinder.engine.process.LoggerImplementation;
import net.grinder.engine.process.ProcessContext;
import net.grinder.engine.process.ProcessContextImplementation;
import net.grinder.engine.process.ScriptEngine;
import net.grinder.engine.process.ThreadStarter;
import net.grinder.engine.process.WorkerThreadSynchronisation;
import net.grinder.engine.process.jython.JythonScriptEngine;
import net.grinder.messages.console.RegisterTestsMessage;
import net.grinder.script.InvalidContextException;
import net.grinder.statistics.ExpressionView;
import net.grinder.statistics.StatisticsIndexMap;
import net.grinder.statistics.StatisticsServices;
import net.grinder.statistics.StatisticsServicesImplementation;
import net.grinder.statistics.StatisticsSet;
import net.grinder.statistics.StatisticsTable;
import net.grinder.statistics.TestStatisticsMap;
import net.grinder.util.JVM;
import net.grinder.util.thread.BooleanCondition;
import net.grinder.util.thread.Condition;

final class GrinderProcess {
    private final ProcessContext m_context;
    private final QueuedSender m_consoleSender;
    private final LoggerImplementation m_loggerImplementation;
    private final InitialiseGrinderMessage m_initialisationMessage;
    private final ConsoleListener m_consoleListener;
    private final TestStatisticsMap m_accumulatedStatistics;
    private final Condition m_eventSynchronisation = new Condition();
    private final MessagePump m_messagePump;
    private final ThreadStarter m_invalidThreadStarter;
    private ThreadStarter m_threadStarter = this.m_invalidThreadStarter = new InvalidThreadStarter();
    private boolean m_shutdownTriggered;
    private boolean m_communicationShutdown;

    public GrinderProcess(Receiver agentReceiver) throws GrinderException {
        this.m_initialisationMessage = (InitialiseGrinderMessage)agentReceiver.waitForMessage();
        if (this.m_initialisationMessage == null) {
            throw new EngineException("No control stream from agent");
        }
        GrinderProperties properties = this.m_initialisationMessage.getProperties();
        this.m_loggerImplementation = new LoggerImplementation(this.m_initialisationMessage.getWorkerIdentity().getName(), properties.getProperty("grinder.logDirectory", "."), properties.getBoolean("grinder.logProcessStreams", true), properties.getInt("grinder.numberOfOldLogs", 1));
        Logger processLogger = this.m_loggerImplementation.getProcessLogger();
        processLogger.output("The Grinder version " + GrinderBuild.getVersionString());
        processLogger.output(JVM.getInstance().toString());
        processLogger.output("time zone is " + new SimpleDateFormat("z (Z)").format(new Date()));
        this.m_consoleSender = this.m_initialisationMessage.getReportToConsole() ? new QueuedSenderDecorator(ClientSender.connect(new ConnectorFactory(ConnectionType.WORKER).create(properties))) : new QueuedSender(){

            public void send(Message message) {
            }

            public void flush() {
            }

            public void queue(Message message) {
            }

            public void shutdown() {
            }
        };
        ThreadStarter delegatingThreadStarter = new ThreadStarter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public int startThread(Object testRunner) throws EngineException, InvalidContextException {
                ThreadStarter threadStarter;
                Condition condition = GrinderProcess.this.m_eventSynchronisation;
                synchronized (condition) {
                    threadStarter = GrinderProcess.this.m_threadStarter;
                }
                return threadStarter.startThread(testRunner);
            }
        };
        this.m_context = new ProcessContextImplementation(this.m_initialisationMessage.getWorkerIdentity(), this.m_initialisationMessage.getFirstWorkerIdentity(), properties, processLogger, this.m_loggerImplementation.getFilenameFactory(), this.m_consoleSender, StatisticsServicesImplementation.getInstance(), delegatingThreadStarter);
        try {
            InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            // empty catch block
        }
        this.m_consoleListener = new ConsoleListener(this.m_eventSynchronisation, processLogger);
        this.m_accumulatedStatistics = new TestStatisticsMap(this.m_context.getStatisticsServices().getStatisticsSetFactory());
        MessageDispatchSender messageDispatcher = new MessageDispatchSender();
        this.m_consoleListener.registerMessageHandlers(messageDispatcher);
        this.m_messagePump = new MessagePump(agentReceiver, messageDispatcher, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws GrinderException {
        Logger logger = this.m_context.getProcessLogger();
        Timer timer = new Timer(true);
        timer.schedule((TimerTask)new TickLoggerTimerTask(), 0L, 1000L);
        JythonScriptEngine scriptEngine = new JythonScriptEngine();
        this.m_context.getTestRegistry().setInstrumenter(scriptEngine);
        StringBuffer numbers = new StringBuffer("worker process ");
        numbers.append(this.m_initialisationMessage.getWorkerIdentity().getNumber());
        int agentNumber = this.m_initialisationMessage.getWorkerIdentity().getAgentIdentity().getNumber();
        if (agentNumber >= 0) {
            numbers.append(" of agent number ");
            numbers.append(agentNumber);
        }
        logger.output(numbers.toString());
        logger.output("executing \"" + this.m_initialisationMessage.getScript() + "\" using " + scriptEngine.getDescription());
        scriptEngine.initialise(this.m_initialisationMessage.getScript());
        GrinderProperties properties = this.m_context.getProperties();
        int numberOfThreads = properties.getShort("grinder.threads", (short)1);
        int reportToConsoleInterval = properties.getInt("grinder.reportToConsole.interval", 500);
        int duration = properties.getInt("grinder.duration", 0);
        PrintWriter dataWriter = this.m_loggerImplementation.getDataWriter();
        dataWriter.print("Thread, Run, Test, Start time (ms since Epoch)");
        StatisticsServices statisticsServices = this.m_context.getStatisticsServices();
        ExpressionView[] detailExpressionViews = statisticsServices.getDetailStatisticsView().getExpressionViews();
        for (int i = 0; i < detailExpressionViews.length; ++i) {
            dataWriter.print(", " + detailExpressionViews[i].getDisplayName());
        }
        dataWriter.println();
        this.m_consoleSender.send(this.m_context.createStatusMessage((short)1, (short)0, (short)numberOfThreads));
        ThreadSynchronisation threadSynchronisation = new ThreadSynchronisation(this.m_eventSynchronisation);
        logger.output("starting threads", 3);
        Condition condition = this.m_eventSynchronisation;
        synchronized (condition) {
            this.m_threadStarter = new ThreadStarterImplementation(threadSynchronisation, scriptEngine);
            for (int i = 0; i < numberOfThreads; ++i) {
                this.m_threadStarter.startThread(null);
            }
        }
        threadSynchronisation.startThreads();
        this.m_context.setExecutionStartTime();
        logger.output("start time is " + this.m_context.getExecutionStartTime() + " ms since Epoch");
        ReportToConsoleTimerTask reportTimerTask = new ReportToConsoleTimerTask(threadSynchronisation);
        ShutdownTimerTask shutdownTimerTask = new ShutdownTimerTask();
        ((TimerTask)reportTimerTask).run();
        timer.schedule((TimerTask)reportTimerTask, reportToConsoleInterval, (long)reportToConsoleInterval);
        try {
            if (duration > 0) {
                logger.output("will shut down after " + duration + " ms", 3);
                timer.schedule((TimerTask)shutdownTimerTask, duration);
            }
            Condition condition2 = this.m_eventSynchronisation;
            synchronized (condition2) {
                while (!threadSynchronisation.isFinished() && !this.m_consoleListener.checkForMessage(14)) {
                    if (this.m_shutdownTriggered) {
                        logger.output("specified duration exceeded, shutting down", 3);
                        break;
                    }
                    this.m_eventSynchronisation.waitNoInterrruptException();
                }
            }
            condition2 = this.m_eventSynchronisation;
            synchronized (condition2) {
                if (!threadSynchronisation.isFinished()) {
                    logger.output("waiting for threads to terminate", 3);
                    this.m_threadStarter = this.m_invalidThreadStarter;
                    this.m_context.shutdown();
                    long time = System.currentTimeMillis();
                    long maximumShutdownTime = 10000L;
                    while (!threadSynchronisation.isFinished()) {
                        if (System.currentTimeMillis() - time > 10000L) {
                            logger.output("ignoring unresponsive threads", 3);
                            break;
                        }
                        this.m_eventSynchronisation.waitNoInterrruptException(10000L);
                    }
                }
            }
        }
        finally {
            reportTimerTask.cancel();
            shutdownTimerTask.cancel();
        }
        scriptEngine.shutdown();
        ((TimerTask)reportTimerTask).run();
        this.m_loggerImplementation.getDataWriter().close();
        if (!this.m_communicationShutdown) {
            this.m_consoleSender.send(this.m_context.createStatusMessage((short)3, (short)0, (short)0));
        }
        this.m_consoleSender.shutdown();
        final long elapsedTime = this.m_context.getElapsedTime();
        logger.output("elapsed time is " + elapsedTime + " ms");
        logger.output("Final statistics for this process:");
        final StatisticsIndexMap.LongIndex periodIndex = statisticsServices.getStatisticsIndexMap().getLongIndex("period");
        TestStatisticsMap testStatisticsMap = this.m_accumulatedStatistics;
        testStatisticsMap.getClass();
        new TestStatisticsMap.ForEach(testStatisticsMap){

            protected void next(Test test, StatisticsSet statistics) {
                statistics.setValue(periodIndex, elapsedTime);
            }
        }.iterate();
        StatisticsTable statisticsTable = new StatisticsTable(statisticsServices.getSummaryStatisticsView(), this.m_accumulatedStatistics);
        statisticsTable.print(logger.getOutputLogWriter());
        timer.cancel();
        logger.output("finished", 3);
    }

    public void shutdown(boolean inputStreamIsStdin) {
        if (!inputStreamIsStdin) {
            this.m_messagePump.shutdown();
        }
        this.m_loggerImplementation.close();
    }

    public Logger getLogger() {
        return this.m_context.getProcessLogger();
    }

    private static final class InvalidThreadStarter
    implements ThreadStarter {
        private InvalidThreadStarter() {
        }

        public int startThread(Object testRunner) throws InvalidContextException {
            throw new InvalidContextException("You should not start worker threads until the main thread has initialised the script engine, or after all other threads have shut down. Typically, you should only call startWorkerThread() from another worker thread.");
        }
    }

    private final class ThreadStarterImplementation
    implements ThreadStarter {
        private final ThreadSynchronisation m_threadSynchronisation;
        private final ScriptEngine m_scriptEngine;
        private int m_i = -1;

        private ThreadStarterImplementation(ThreadSynchronisation threadSynchronisation, ScriptEngine scriptEngine) {
            this.m_threadSynchronisation = threadSynchronisation;
            this.m_scriptEngine = scriptEngine;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int startThread(Object testRunner) throws EngineException {
            int threadNumber;
            ThreadStarterImplementation threadStarterImplementation = this;
            synchronized (threadStarterImplementation) {
                threadNumber = ++this.m_i;
            }
            GrinderThread runnable = testRunner != null ? new GrinderThread(this.m_threadSynchronisation, GrinderProcess.this.m_context, GrinderProcess.this.m_loggerImplementation, this.m_scriptEngine, threadNumber, this.m_scriptEngine.createWorkerRunnable(testRunner)) : new GrinderThread(this.m_threadSynchronisation, GrinderProcess.this.m_context, GrinderProcess.this.m_loggerImplementation, this.m_scriptEngine, threadNumber, null);
            Thread t = new Thread((Runnable)runnable, "Grinder thread " + threadNumber);
            t.setDaemon(true);
            t.start();
            return threadNumber;
        }
    }

    static class ThreadSynchronisation
    implements WorkerThreadSynchronisation {
        private final BooleanCondition m_started = new BooleanCondition();
        private final Condition m_threadEventCondition;
        private short m_numberCreated = 0;
        private short m_numberAwaitingStart = 0;
        private short m_numberFinished = 0;

        ThreadSynchronisation(Condition condition) {
            this.m_threadEventCondition = condition;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public short getNumberOfRunningThreads() {
            Condition condition = this.m_threadEventCondition;
            synchronized (condition) {
                return (short)(this.m_numberCreated - this.m_numberFinished);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isReadyToStart() {
            Condition condition = this.m_threadEventCondition;
            synchronized (condition) {
                return this.m_numberAwaitingStart >= this.getNumberOfRunningThreads();
            }
        }

        public boolean isFinished() {
            return this.getNumberOfRunningThreads() <= 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public short getTotalNumberOfThreads() {
            Condition condition = this.m_threadEventCondition;
            synchronized (condition) {
                return this.m_numberCreated;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void threadCreated() {
            Condition condition = this.m_threadEventCondition;
            synchronized (condition) {
                this.m_numberCreated = (short)(this.m_numberCreated + 1);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void startThreads() {
            Condition condition = this.m_threadEventCondition;
            synchronized (condition) {
                while (!this.isReadyToStart()) {
                    this.m_threadEventCondition.waitNoInterrruptException();
                }
                this.m_numberAwaitingStart = 0;
            }
            this.m_started.set(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void awaitStart() {
            Condition condition = this.m_threadEventCondition;
            synchronized (condition) {
                this.m_numberAwaitingStart = (short)(this.m_numberAwaitingStart + 1);
                if (this.isReadyToStart()) {
                    this.m_threadEventCondition.notifyAll();
                }
            }
            this.m_started.await(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void threadFinished() {
            Condition condition = this.m_threadEventCondition;
            synchronized (condition) {
                this.m_numberFinished = (short)(this.m_numberFinished + 1);
                if (this.isReadyToStart() || this.isFinished()) {
                    this.m_threadEventCondition.notifyAll();
                }
            }
        }
    }

    private static class TickLoggerTimerTask
    extends TimerTask {
        private TickLoggerTimerTask() {
        }

        public void run() {
            LoggerImplementation.tick();
        }
    }

    private class ShutdownTimerTask
    extends TimerTask {
        private ShutdownTimerTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Condition condition = GrinderProcess.this.m_eventSynchronisation;
            synchronized (condition) {
                GrinderProcess.this.m_shutdownTriggered = true;
                GrinderProcess.this.m_eventSynchronisation.notifyAll();
            }
        }
    }

    private class ReportToConsoleTimerTask
    extends TimerTask {
        private final ThreadSynchronisation m_threads;

        public ReportToConsoleTimerTask(ThreadSynchronisation threads) {
            this.m_threads = threads;
        }

        public void run() {
            GrinderProcess.this.m_loggerImplementation.getDataWriter().flush();
            if (!GrinderProcess.this.m_communicationShutdown) {
                try {
                    TestStatisticsMap sample = GrinderProcess.this.m_context.getTestRegistry().getTestStatisticsMap().reset();
                    GrinderProcess.this.m_accumulatedStatistics.add(sample);
                    Collection newTests = GrinderProcess.this.m_context.getTestRegistry().getNewTests();
                    if (newTests != null) {
                        GrinderProcess.this.m_consoleSender.queue(new RegisterTestsMessage(newTests));
                    }
                    if (sample.size() > 0) {
                        GrinderProcess.this.m_consoleSender.queue(GrinderProcess.this.m_context.createReportStatisticsMessage(sample));
                    }
                    GrinderProcess.this.m_consoleSender.send(GrinderProcess.this.m_context.createStatusMessage((short)2, this.m_threads.getNumberOfRunningThreads(), this.m_threads.getTotalNumberOfThreads()));
                }
                catch (CommunicationException e) {
                    Logger logger = GrinderProcess.this.m_context.getProcessLogger();
                    logger.output("Report to console failed: " + e.getMessage(), 3);
                    e.printStackTrace(logger.getErrorLogWriter());
                    GrinderProcess.this.m_communicationShutdown = true;
                }
            }
        }
    }
}

