/*
 * Decompiled with CFR 0.152.
 */
package org.python.indexer.ast;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.python.indexer.Indexer;
import org.python.indexer.NBinding;
import org.python.indexer.Scope;
import org.python.indexer.ast.NAlias;
import org.python.indexer.ast.NImport;
import org.python.indexer.ast.NModule;
import org.python.indexer.ast.NNode;
import org.python.indexer.ast.NNodeVisitor;
import org.python.indexer.ast.NQname;
import org.python.indexer.ast.NStr;
import org.python.indexer.types.NModuleType;
import org.python.indexer.types.NType;
import org.python.indexer.types.NUnknownType;

public final class NImportFrom
extends NNode {
    private String module;
    private NQname qname;
    private List<NAlias> aliases;

    public NImportFrom(String module, NQname qname, List<NAlias> aliases) {
        this(null, null, null, 0, 1);
    }

    public NImportFrom(String module, NQname qname, List<NAlias> aliases, int start, int end) {
        super(start, end);
        this.module = module;
        this.qname = qname;
        this.aliases = aliases;
        this.addChildren(qname);
        this.addChildren(aliases);
    }

    @Override
    public final boolean bindsName() {
        return true;
    }

    @Override
    protected final void bindNames(Scope s) throws Exception {
        if (this.isImportStar()) {
            return;
        }
        NImport.bindAliases(s, this.aliases);
    }

    @Override
    public final NType resolve(Scope s) throws Exception {
        NType bottomType;
        Scope scope = s.getScopeSymtab();
        NImportFrom.resolveExpr(this.qname, s);
        NType nType = bottomType = this.qname.getBottom().getType();
        if (!(bottomType instanceof NModuleType)) {
            return this.setType(new NUnknownType());
        }
        NModuleType mt = (NModuleType)bottomType;
        this.setType(mt);
        NImport.addReferences(s, this.qname, false);
        if (this.isImportStar()) {
            NModule nModule;
            NModuleType nModuleType = mt;
            Scope scope2 = s;
            if (nModuleType != null && nModuleType.getFile() != null && (nModule = Indexer.idx.getAstForFile(nModuleType.getFile())) != null) {
                ArrayList<String> arrayList;
                NModule nModule2 = nModule;
                ArrayList<String> arrayList2 = new ArrayList<String>();
                nType = nModule2.getType();
                if (nType instanceof NModuleType) {
                    for (NStr nStr : nModule2.getExportedNameNodes()) {
                        arrayList2.add(nStr.n.toString());
                    }
                }
                if (!(arrayList = arrayList2).isEmpty()) {
                    for (String string : arrayList) {
                        NBinding nBinding = nModuleType.getTable().lookupLocal(string);
                        if (nBinding == null) continue;
                        scope2.put(string, nBinding);
                    }
                } else {
                    for (Map.Entry<String, NBinding> entry : nModuleType.getTable().entrySet()) {
                        if (entry.getKey().startsWith("_")) continue;
                        scope2.put(entry.getKey(), entry.getValue());
                    }
                }
            }
            return this.getType();
        }
        Iterator<NAlias> i$ = this.aliases.iterator();
        while (i$.hasNext()) {
            String string;
            Object object;
            NAlias a;
            NAlias nAlias = a = i$.next();
            NModuleType nModuleType = mt;
            Scope scope3 = scope;
            NImportFrom nImportFrom = this;
            NBinding nBinding = nModuleType.getTable().lookup(nAlias.name);
            if (nBinding == null && (object = Indexer.idx.loadModule(string = nImportFrom.qname.toQname() + "." + nAlias.qname.toQname())) != null) {
                nBinding = Indexer.idx.lookupQname(((NType)object).getTable().getPath());
            }
            if (nBinding == null) {
                NImportFrom.addError(nAlias, "name " + nAlias.qname.getName().id + " not found in module " + nImportFrom.module);
                continue;
            }
            string = nAlias.qname.getName().id;
            object = nAlias.aname != null ? nAlias.aname.id : null;
            Indexer.idx.putLocation(nAlias.qname.getName(), nBinding);
            if (object != null) {
                Indexer.idx.putLocation(nAlias.aname, nBinding);
                scope3.put((String)object, nBinding);
                continue;
            }
            scope3.put(string, nBinding);
        }
        return this.getType();
    }

    private boolean isImportStar() {
        return this.aliases.size() == 1 && "*".equals(this.aliases.get((int)0).name);
    }

    public final String toString() {
        return "<FromImport:" + this.module + ":" + this.aliases + ">";
    }

    @Override
    public final void visit(NNodeVisitor v) {
        if (v.visit(this)) {
            NImportFrom.visitNode(this.qname, v);
            NImportFrom.visitNodeList(this.aliases, v);
        }
    }
}

