/*
 * Decompiled with CFR 0.152.
 */
package org.python.google.common.cache;

import java.util.Map;
import javax.annotation.Nullable;
import org.python.google.common.base.CharMatcher;
import org.python.google.common.cache.RemovalCause;

public final class RemovalNotification<K, V>
implements Map.Entry<K, V> {
    @Nullable
    private final K key;
    @Nullable
    private final V value;

    RemovalNotification(@Nullable K key, @Nullable V value, RemovalCause cause) {
        this.key = key;
        this.value = value;
        CharMatcher.LookupTable.checkNotNull(cause);
    }

    @Override
    @Nullable
    public final K getKey() {
        return this.key;
    }

    @Override
    @Nullable
    public final V getValue() {
        return this.value;
    }

    @Override
    public final V setValue(V value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final boolean equals(@Nullable Object object) {
        if (object instanceof Map.Entry) {
            Map.Entry that = (Map.Entry)object;
            return CharMatcher.LookupTable.equal(this.getKey(), that.getKey()) && CharMatcher.LookupTable.equal(this.getValue(), that.getValue());
        }
        return false;
    }

    @Override
    public final int hashCode() {
        K k = this.getKey();
        V v = this.getValue();
        return (k == null ? 0 : k.hashCode()) ^ (v == null ? 0 : v.hashCode());
    }

    public final String toString() {
        return this.getKey() + "=" + this.getValue();
    }
}

