/*
 * Decompiled with CFR 0.152.
 */
package org.python.core.io;

import java.io.IOException;
import java.nio.channels.Channel;
import org.python.core.Py;
import org.python.core.io.RawIOBase;

public abstract class SocketIOBase<T extends Channel>
extends RawIOBase {
    protected T socketChannel;
    private boolean readable = false;
    private boolean writable = false;

    public SocketIOBase(T socketChannel, String mode) {
        this.socketChannel = socketChannel;
        this.parseMode(mode);
    }

    protected void parseMode(String mode) {
        if (mode.equals("r")) {
            this.readable = true;
            return;
        }
        if (mode.equals("w")) {
            this.writable = true;
            return;
        }
        if (mode.equals("rw")) {
            this.writable = true;
            this.readable = true;
            return;
        }
        throw Py.ValueError("invalid mode: '" + mode + "'");
    }

    @Override
    public void close() {
        if (this.closed()) {
            return;
        }
        try {
            this.socketChannel.close();
        }
        catch (IOException iOException) {
            IOException ioe = iOException;
            throw Py.IOError(iOException);
        }
        super.close();
    }

    public T getChannel() {
        return this.socketChannel;
    }

    @Override
    public boolean readable() {
        return this.readable;
    }

    @Override
    public boolean writable() {
        return this.writable;
    }
}

