/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.util;

import net.grinder.common.GrinderException;
import net.grinder.common.Logger;
import net.grinder.util.JVM;

public abstract class AbstractMainClass {
    private final String m_usage;
    private final Logger m_logger;

    protected AbstractMainClass(Logger logger, String usage) throws GrinderException {
        this.m_usage = usage;
        this.m_logger = logger;
        if (!JVM.getInstance().haveRequisites(this.m_logger)) {
            throw new LoggedInitialisationException("Unsupported JVM");
        }
    }

    protected final Logger getLogger() {
        return this.m_logger;
    }

    protected final LoggedInitialisationException barfError(String message) {
        this.m_logger.error("Error: " + message);
        return new LoggedInitialisationException(message);
    }

    protected final LoggedInitialisationException barfUsage() {
        return this.barfError("unrecognised or invalid option.\n\nUsage: " + this.m_usage);
    }

    protected static class LoggedInitialisationException
    extends GrinderException {
        public LoggedInitialisationException(String message) {
            super(message);
        }
    }
}

