/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.statistics;

import net.grinder.statistics.ExpressionView;
import net.grinder.statistics.StatisticExpression;
import net.grinder.statistics.StatisticExpressionFactory;
import net.grinder.statistics.StatisticsException;
import net.grinder.statistics.StatisticsView;

final class CommonStatisticsViews {
    private final StatisticsView m_detailStatisticsView = new StatisticsView();
    private final StatisticsView m_summaryStatisticsView = new StatisticsView();
    private final StatisticExpression m_tpsExpression;

    CommonStatisticsViews(StatisticExpressionFactory expressionFactory) {
        try {
            ExpressionView[] detailExpressionViews = new ExpressionView[]{expressionFactory.createExpressionView("Test time", "(sum timedTests)", false), expressionFactory.createExpressionView("Errors", "errors", false)};
            for (int i = 0; i < detailExpressionViews.length; ++i) {
                this.m_detailStatisticsView.add(detailExpressionViews[i]);
            }
            this.m_tpsExpression = expressionFactory.createExpression("(* 1000 (/ (+ (count timedTests) untimedTests) period))");
            ExpressionView[] summaryExpressionViews = new ExpressionView[]{expressionFactory.createExpressionView("Tests", "(+ (count timedTests) untimedTests)", true), expressionFactory.createExpressionView("Errors", "errors", true), expressionFactory.createExpressionView("Mean Test Time (ms)", "(/ (sum timedTests) (count timedTests))", false), expressionFactory.createExpressionView("Test Time Standard Deviation (ms)", "(sqrt (variance timedTests))", false), expressionFactory.createExpressionView("TPS", this.m_tpsExpression)};
            for (int i = 0; i < summaryExpressionViews.length; ++i) {
                this.m_summaryStatisticsView.add(summaryExpressionViews[i]);
            }
        }
        catch (StatisticsException e) {
            throw new AssertionError((Object)e);
        }
    }

    public StatisticsView getDetailStatisticsView() {
        return this.m_detailStatisticsView;
    }

    public StatisticsView getSummaryStatisticsView() {
        return this.m_summaryStatisticsView;
    }

    public StatisticExpression getTPSExpression() {
        return this.m_tpsExpression;
    }
}

