/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.engine.agent;

import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import net.grinder.common.GrinderBuild;
import net.grinder.common.GrinderException;
import net.grinder.common.GrinderProperties;
import net.grinder.common.Logger;
import net.grinder.communication.ClientReceiver;
import net.grinder.communication.ClientSender;
import net.grinder.communication.CommunicationException;
import net.grinder.communication.ConnectionType;
import net.grinder.communication.Connector;
import net.grinder.communication.FanOutStreamSender;
import net.grinder.communication.IgnoreShutdownSender;
import net.grinder.communication.MessageDispatchSender;
import net.grinder.communication.MessagePump;
import net.grinder.communication.TeeSender;
import net.grinder.engine.agent.AbstractWorkerFactory;
import net.grinder.engine.agent.Agent;
import net.grinder.engine.agent.AgentIdentityImplementation;
import net.grinder.engine.agent.DebugThreadWorkerFactory;
import net.grinder.engine.agent.FileStore;
import net.grinder.engine.agent.ProcessWorkerFactory;
import net.grinder.engine.agent.WorkerLauncher;
import net.grinder.engine.agent.WorkerProcessCommandLine;
import net.grinder.engine.common.ConnectorFactory;
import net.grinder.engine.common.EngineException;
import net.grinder.engine.common.ScriptLocation;
import net.grinder.engine.communication.ConsoleListener;
import net.grinder.messages.agent.StartGrinderMessage;
import net.grinder.messages.console.AgentAddress;
import net.grinder.messages.console.AgentProcessReportMessage;
import net.grinder.util.Directory;
import net.grinder.util.thread.Condition;

public final class AgentImplementation
implements Agent {
    private final Logger m_logger;
    private final File m_alternateFile;
    private final boolean m_proceedWithoutConsole;
    private final Timer m_timer = new Timer(true);
    private final Condition m_eventSynchronisation = new Condition();
    private final AgentIdentityImplementation m_agentIdentity;
    private final ConsoleListener m_consoleListener;
    private final FanOutStreamSender m_fanOutStreamSender = new FanOutStreamSender(3);
    private final ConnectorFactory m_connectorFactory = new ConnectorFactory(ConnectionType.AGENT);
    private volatile FileStore m_fileStore;

    public AgentImplementation(Logger logger, File alternateFile, boolean proceedWithoutConsole) throws GrinderException {
        this.m_logger = logger;
        this.m_alternateFile = alternateFile;
        this.m_proceedWithoutConsole = proceedWithoutConsole;
        this.m_consoleListener = new ConsoleListener(this.m_eventSynchronisation, this.m_logger);
        this.m_agentIdentity = new AgentIdentityImplementation(AgentImplementation.getHostName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() throws GrinderException {
        StartGrinderMessage startMessage = null;
        ConsoleCommunication consoleCommunication = null;
        try {
            while (true) {
                GrinderProperties properties;
                this.m_logger.output(GrinderBuild.getName());
                ScriptLocation script = null;
                do {
                    Connector connector;
                    properties = new GrinderProperties(this.m_alternateFile != null ? this.m_alternateFile : GrinderProperties.DEFAULT_PROPERTIES);
                    if (startMessage != null) {
                        properties.putAll((Map<?, ?>)startMessage.getProperties());
                    }
                    this.m_agentIdentity.setName(properties.getProperty("grinder.hostID", AgentImplementation.getHostName()));
                    Connector connector2 = connector = properties.getBoolean("grinder.useConsole", true) ? this.m_connectorFactory.create(properties) : null;
                    if (consoleCommunication != null && !consoleCommunication.getConnector().equals(connector)) {
                        this.shutdownConsoleCommunication(consoleCommunication);
                        consoleCommunication = null;
                    }
                    if (consoleCommunication == null && connector != null) {
                        try {
                            consoleCommunication = new ConsoleCommunication(connector);
                            this.m_logger.output("connected to console at " + connector.getEndpointAsString());
                        }
                        catch (CommunicationException e) {
                            if (!this.m_proceedWithoutConsole) {
                                this.m_logger.error(e.getMessage());
                                this.shutdownConsoleCommunication(consoleCommunication);
                                return;
                            }
                            this.m_logger.error(e.getMessage() + ", proceeding without the console; set " + "grinder.useConsole=false to disable this warning.");
                        }
                    }
                    if (consoleCommunication != null && startMessage == null) {
                        this.m_logger.output("waiting for console signal");
                        this.m_consoleListener.waitForMessage();
                        if (!this.m_consoleListener.received(1)) break;
                        startMessage = this.m_consoleListener.getLastStartGrinderMessage();
                        continue;
                    }
                    if (startMessage != null) {
                        GrinderProperties messageProperties = startMessage.getProperties();
                        Directory fileStoreDirectory = this.m_fileStore.getDirectory();
                        messageProperties.setAssociatedFile(fileStoreDirectory.getFile(messageProperties.getAssociatedFile()));
                        File consoleScript = messageProperties.resolveRelativeFile(messageProperties.getFile("grinder.script", GrinderProperties.DEFAULT_SCRIPT));
                        if (messageProperties.containsKey("grinder.script") || consoleScript.canRead()) {
                            script = new ScriptLocation(fileStoreDirectory, consoleScript);
                        }
                        this.m_agentIdentity.setNumber(startMessage.getAgentNumber());
                    } else {
                        this.m_agentIdentity.setNumber(-1);
                    }
                    if (script == null) {
                        File scriptFile = properties.resolveRelativeFile(properties.getFile("grinder.script", GrinderProperties.DEFAULT_SCRIPT));
                        try {
                            script = new ScriptLocation(scriptFile);
                        }
                        catch (Directory.DirectoryException e) {
                            this.m_logger.error("The script '" + scriptFile + "' does not exist.");
                            break;
                        }
                    }
                    if (script.getFile().canRead()) continue;
                    this.m_logger.error("The script file '" + script + "' does not exist or is not readable.");
                    script = null;
                    break;
                } while (script == null);
                if (script != null) {
                    AbstractWorkerFactory workerFactory;
                    String jvmArguments = properties.getProperty("grinder.jvm.arguments");
                    if (!properties.getBoolean("grinder.debug.singleprocess", false)) {
                        WorkerProcessCommandLine workerCommandLine = new WorkerProcessCommandLine(properties, System.getProperties(), jvmArguments);
                        this.m_logger.output("Worker process command line: " + workerCommandLine);
                        workerFactory = new ProcessWorkerFactory(workerCommandLine, this.m_agentIdentity, this.m_fanOutStreamSender, consoleCommunication != null, script, properties);
                    } else {
                        this.m_logger.output("DEBUG MODE: Spawning threads rather than processes");
                        if (jvmArguments != null) {
                            this.m_logger.output("WARNING grinder.jvm.arguments (" + jvmArguments + ") ignored in single process mode");
                        }
                        workerFactory = new DebugThreadWorkerFactory(this.m_agentIdentity, this.m_fanOutStreamSender, consoleCommunication != null, script, properties);
                    }
                    WorkerLauncher workerLauncher = new WorkerLauncher(properties.getInt("grinder.processes", 1), workerFactory, this.m_eventSynchronisation, this.m_logger);
                    int increment = properties.getInt("grinder.processIncrement", 0);
                    if (increment > 0) {
                        boolean moreProcessesToStart = workerLauncher.startSomeWorkers(properties.getInt("grinder.initialProcesses", increment));
                        if (moreProcessesToStart) {
                            int incrementInterval = properties.getInt("grinder.processIncrementInterval", 60000);
                            RampUpTimerTask rampUpTimerTask = new RampUpTimerTask(workerLauncher, increment);
                            this.m_timer.scheduleAtFixedRate((TimerTask)rampUpTimerTask, incrementInterval, (long)incrementInterval);
                        }
                    } else {
                        workerLauncher.startAllWorkers();
                    }
                    Condition condition = this.m_eventSynchronisation;
                    synchronized (condition) {
                        long maximumShutdownTime = 20000L;
                        long consoleSignalTime = -1L;
                        while (!workerLauncher.allFinished()) {
                            if (consoleSignalTime == -1L && this.m_consoleListener.checkForMessage(14)) {
                                workerLauncher.dontStartAnyMore();
                                consoleSignalTime = System.currentTimeMillis();
                            }
                            if (consoleSignalTime >= 0L && System.currentTimeMillis() - consoleSignalTime > 20000L) {
                                this.m_logger.output("forcibly terminating unresponsive processes");
                                workerLauncher.destroyAllWorkers();
                            }
                            this.m_eventSynchronisation.waitNoInterrruptException(20000L);
                        }
                    }
                    workerLauncher.shutdown();
                }
                if (consoleCommunication == null) break;
                this.m_consoleListener.discardMessages(1);
                if (!this.m_consoleListener.received(15)) {
                    this.m_logger.output("finished, waiting for console signal");
                    this.m_consoleListener.waitForMessage();
                }
                if (this.m_consoleListener.received(1)) {
                    startMessage = this.m_consoleListener.getLastStartGrinderMessage();
                    continue;
                }
                if (this.m_consoleListener.received(12)) break;
                startMessage = null;
            }
            this.shutdownConsoleCommunication(consoleCommunication);
            return;
        }
        catch (Throwable throwable) {
            this.shutdownConsoleCommunication(consoleCommunication);
            throw throwable;
        }
    }

    private void shutdownConsoleCommunication(ConsoleCommunication consoleCommunication) {
        if (consoleCommunication != null) {
            consoleCommunication.shutdown();
        }
        this.m_consoleListener.discardMessages(15);
    }

    public void shutdown() {
        this.m_timer.cancel();
        this.m_fanOutStreamSender.shutdown();
        this.m_consoleListener.shutdown();
        this.m_logger.output("finished");
    }

    private static String getHostName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            return "UNNAMED HOST";
        }
    }

    private final class ConsoleCommunication {
        private final ClientSender m_sender;
        private final Connector m_connector;
        private final TimerTask m_reportRunningTask;
        private final MessagePump m_messagePump;

        public ConsoleCommunication(Connector connector) throws CommunicationException, FileStore.FileStoreException {
            ClientReceiver receiver = ClientReceiver.connect(connector, new AgentAddress(AgentImplementation.this.m_agentIdentity));
            this.m_sender = ClientSender.connect(receiver);
            this.m_connector = connector;
            if (AgentImplementation.this.m_fileStore == null) {
                AgentImplementation.this.m_fileStore = new FileStore(new File("./" + AgentImplementation.this.m_agentIdentity.getName() + "-file-store"), AgentImplementation.this.m_logger);
            }
            this.m_sender.send(new AgentProcessReportMessage(AgentImplementation.this.m_agentIdentity, 1, AgentImplementation.this.m_fileStore.getCacheHighWaterMark()));
            MessageDispatchSender fileStoreMessageDispatcher = new MessageDispatchSender();
            AgentImplementation.this.m_fileStore.registerMessageHandlers(fileStoreMessageDispatcher);
            MessageDispatchSender messageDispatcher = new MessageDispatchSender();
            AgentImplementation.this.m_consoleListener.registerMessageHandlers(messageDispatcher);
            fileStoreMessageDispatcher.addFallback(new TeeSender(messageDispatcher, new IgnoreShutdownSender(AgentImplementation.this.m_fanOutStreamSender)));
            this.m_messagePump = new MessagePump(receiver, fileStoreMessageDispatcher, 1);
            this.m_reportRunningTask = new TimerTask(this){
                private final /* synthetic */ ConsoleCommunication this$1;
                {
                    this.this$1 = this$1;
                }

                public void run() {
                    try {
                        ConsoleCommunication.access$600(this.this$1).send(new AgentProcessReportMessage(AgentImplementation.access$000(ConsoleCommunication.access$500(this.this$1)), 2, AgentImplementation.access$100(ConsoleCommunication.access$500(this.this$1)).getCacheHighWaterMark()));
                    }
                    catch (CommunicationException e) {
                        this.cancel();
                        e.printStackTrace();
                    }
                }
            };
            AgentImplementation.this.m_timer.schedule(this.m_reportRunningTask, 1000L, 1000L);
        }

        public Connector getConnector() {
            return this.m_connector;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void shutdown() {
            this.m_reportRunningTask.cancel();
            try {
                this.m_sender.send(new AgentProcessReportMessage(AgentImplementation.this.m_agentIdentity, 3, AgentImplementation.this.m_fileStore.getCacheHighWaterMark()));
            }
            catch (CommunicationException communicationException) {
            }
            finally {
                this.m_messagePump.shutdown();
            }
        }

        static /* synthetic */ AgentImplementation access$500(ConsoleCommunication x0) {
            return x0.AgentImplementation.this;
        }

        static /* synthetic */ ClientSender access$600(ConsoleCommunication x0) {
            return x0.m_sender;
        }
    }

    private static class RampUpTimerTask
    extends TimerTask {
        private final WorkerLauncher m_processLauncher;
        private final int m_processIncrement;

        public RampUpTimerTask(WorkerLauncher processLauncher, int processIncrement) {
            this.m_processLauncher = processLauncher;
            this.m_processIncrement = processIncrement;
        }

        public void run() {
            try {
                boolean moreProcessesToStart = this.m_processLauncher.startSomeWorkers(this.m_processIncrement);
                if (!moreProcessesToStart) {
                    super.cancel();
                }
            }
            catch (EngineException e) {
                System.err.println("Failed to start processes");
                e.printStackTrace();
            }
        }
    }
}

