/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.common;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Properties;
import net.grinder.common.Closer;
import net.grinder.common.GrinderException;
import net.grinder.common.UncheckedInterruptedException;

public class GrinderProperties
extends Properties {
    private static final long serialVersionUID = 1L;
    public static final String SCRIPT = "grinder.script";
    public static final String CONSOLE_HOST = "grinder.consoleHost";
    public static final String CONSOLE_PORT = "grinder.consolePort";
    public static final File DEFAULT_PROPERTIES = new File("grinder.properties");
    public static final File DEFAULT_SCRIPT = new File("grinder.py");
    private transient PrintWriter m_errorWriter = new PrintWriter(System.err, true);
    private File m_file;

    public GrinderProperties() {
        this.m_file = null;
    }

    public GrinderProperties(File file) throws PersistenceException {
        this.setAssociatedFile(file);
        if (this.m_file.exists()) {
            FileInputStream propertiesInputStream = null;
            try {
                propertiesInputStream = new FileInputStream(this.m_file);
                this.load(propertiesInputStream);
            }
            catch (IOException e) {
                try {
                    UncheckedInterruptedException.ioException(e);
                    throw new PersistenceException("Error loading properties file '" + this.m_file.getPath() + '\'', e);
                }
                catch (Throwable throwable) {
                    Closer.close(propertiesInputStream);
                    throw throwable;
                }
            }
            Closer.close(propertiesInputStream);
        }
        Enumeration<?> systemProperties = System.getProperties().propertyNames();
        while (systemProperties.hasMoreElements()) {
            String name = (String)systemProperties.nextElement();
            if (!name.startsWith("grinder.")) continue;
            this.put(name, System.getProperty(name));
        }
    }

    public final File getAssociatedFile() {
        return this.m_file;
    }

    public final void setAssociatedFile(File file) {
        this.m_file = file;
    }

    public final void save() throws PersistenceException {
        if (this.m_file == null) {
            throw new PersistenceException("No associated file");
        }
        FileOutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(this.m_file);
            this.store(outputStream, this.generateFileHeader());
        }
        catch (IOException e) {
            try {
                UncheckedInterruptedException.ioException(e);
                throw new PersistenceException("Error writing properties file '" + this.m_file.getPath() + '\'', e);
            }
            catch (Throwable throwable) {
                Closer.close(outputStream);
                throw throwable;
            }
        }
        Closer.close(outputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void saveSingleProperty(String name) throws PersistenceException {
        if (this.m_file == null) {
            throw new PersistenceException("No associated file");
        }
        try {
            Properties properties = new Properties();
            FileInputStream inputStream = null;
            try {
                inputStream = new FileInputStream(this.m_file);
                properties.load(inputStream);
            }
            catch (IOException e) {
                try {
                    UncheckedInterruptedException.ioException(e);
                }
                catch (Throwable throwable) {
                    Closer.close(inputStream);
                    throw throwable;
                }
                Closer.close(inputStream);
            }
            Closer.close(inputStream);
            FileOutputStream outputStream = null;
            try {
                outputStream = new FileOutputStream(this.m_file);
                String value = this.getProperty(name);
                if (value != null) {
                    properties.setProperty(name, value);
                } else {
                    properties.remove(name);
                }
                properties.store(outputStream, this.generateFileHeader());
            }
            catch (Throwable throwable) {
                Closer.close(outputStream);
                throw throwable;
            }
            Closer.close(outputStream);
        }
        catch (IOException e) {
            UncheckedInterruptedException.ioException(e);
            throw new PersistenceException("Error writing properties file '" + this.m_file.getPath() + '\'', e);
        }
    }

    private String generateFileHeader() {
        return "Properties file for The Grinder";
    }

    public final void setErrorWriter(PrintWriter writer) {
        this.m_errorWriter = writer;
    }

    public final synchronized GrinderProperties getPropertySubset(String prefix) {
        GrinderProperties result = new GrinderProperties();
        Enumeration<?> propertyNames = this.propertyNames();
        while (propertyNames.hasMoreElements()) {
            String name = (String)propertyNames.nextElement();
            if (!name.startsWith(prefix)) continue;
            result.setProperty(name.substring(prefix.length()), this.getProperty(name));
        }
        return result;
    }

    public final int getInt(String propertyName, int defaultValue) {
        String s = this.getProperty(propertyName);
        if (s != null) {
            try {
                return Integer.parseInt(s.trim());
            }
            catch (NumberFormatException e) {
                this.m_errorWriter.println("Warning, property '" + propertyName + "' does not specify an integer value");
            }
        }
        return defaultValue;
    }

    public final void setInt(String propertyName, int value) {
        this.setProperty(propertyName, Integer.toString(value));
    }

    public final long getLong(String propertyName, long defaultValue) {
        String s = this.getProperty(propertyName);
        if (s != null) {
            try {
                return Long.parseLong(s.trim());
            }
            catch (NumberFormatException e) {
                this.m_errorWriter.println("Warning, property '" + propertyName + "' does not specify an integer value");
            }
        }
        return defaultValue;
    }

    public final void setLong(String propertyName, long value) {
        this.setProperty(propertyName, Long.toString(value));
    }

    public final short getShort(String propertyName, short defaultValue) {
        String s = this.getProperty(propertyName);
        if (s != null) {
            try {
                return Short.parseShort(s.trim());
            }
            catch (NumberFormatException e) {
                this.m_errorWriter.println("Warning, property '" + propertyName + "' does not specify a short value");
            }
        }
        return defaultValue;
    }

    public final void setShort(String propertyName, short value) {
        this.setProperty(propertyName, Short.toString(value));
    }

    public final double getDouble(String propertyName, double defaultValue) {
        String s = this.getProperty(propertyName);
        if (s != null) {
            try {
                return Double.parseDouble(s.trim());
            }
            catch (NumberFormatException e) {
                this.m_errorWriter.println("Warning, property '" + propertyName + "' does not specify a double value");
            }
        }
        return defaultValue;
    }

    public final void setDouble(String propertyName, double value) {
        this.setProperty(propertyName, Double.toString(value));
    }

    public final boolean getBoolean(String propertyName, boolean defaultValue) {
        String s = this.getProperty(propertyName);
        if (s != null) {
            return Boolean.valueOf(s);
        }
        return defaultValue;
    }

    public final void setBoolean(String propertyName, boolean value) {
        this.setProperty(propertyName, String.valueOf(value));
    }

    public final File getFile(String propertyName, File defaultValue) {
        String s = this.getProperty(propertyName);
        if (s != null) {
            return new File(s);
        }
        return defaultValue;
    }

    public final File resolveRelativeFile(File file) {
        if (this.m_file != null && file != null && !file.isAbsolute()) {
            return new File(this.m_file.getParentFile(), file.getPath());
        }
        return file;
    }

    public final void setFile(String propertyName, File value) {
        this.setProperty(propertyName, value.getPath());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.setErrorWriter(new PrintWriter(System.err, true));
    }

    public static final class PersistenceException
    extends GrinderException {
        private PersistenceException(String message) {
            super(message);
        }

        private PersistenceException(String message, Throwable t) {
            super(message, t);
        }
    }
}

