/*
 * Decompiled with CFR 0.152.
 */
package org.python.jsr223;

import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import junit.framework.TestCase;
import org.python.jsr223.PyScriptEngine;
import org.python.jsr223.PyScriptEngineFactory;

public class ScriptEngineIOTest
extends TestCase {
    private ScriptEngineFactory pythonEngineFactory;
    private ScriptEngine pythonEngine;

    public void setUp() throws ScriptException {
        this.pythonEngineFactory = new PyScriptEngineFactory();
        this.pythonEngine = new PyScriptEngine(this.pythonEngineFactory);
    }

    public void testEvalString() throws ScriptException {
        ScriptEngineIOTest.assertNull((Object)this.pythonEngine.eval("x = 5"));
        ScriptEngineIOTest.assertEquals((Object)5, (Object)this.pythonEngine.eval("x"));
    }

    public void testReadline() throws ScriptException {
        this.pythonEngine.getContext().setReader(new StringReader("Shazaam Batman!\n"));
        ScriptEngineIOTest.assertNull((Object)this.pythonEngine.eval("import sys"));
        ScriptEngineIOTest.assertEquals((Object)"Shazaam Batman!\n", (Object)this.pythonEngine.eval("sys.stdin.readline()"));
    }

    public void testReadlines() throws ScriptException {
        this.pythonEngine.getContext().setReader(new StringReader("Holy Smokes Batman!\nBIF!\r\n\nKAPOW!!!\rTHE END."));
        ScriptEngineIOTest.assertNull((Object)this.pythonEngine.eval("import sys"));
        Object o = this.pythonEngine.eval("''.join(sys.stdin.readlines())");
        ScriptEngineIOTest.assertEquals((Object)"Holy Smokes Batman!\nBIF!\n\nKAPOW!!!\nTHE END.\n", (Object)o);
    }

    public void testWriter() throws ScriptException {
        StringWriter sw = new StringWriter();
        this.pythonEngine.getContext().setWriter(sw);
        ScriptEngineIOTest.assertNull((Object)this.pythonEngine.eval("print 'It is a wonderful world.',"));
        ScriptEngineIOTest.assertEquals((String)"It is a wonderful world.", (String)sw.toString());
    }

    public void testErrorWriter() throws ScriptException {
        StringWriter stdout = new StringWriter();
        StringWriter stderr = new StringWriter();
        this.pythonEngine.getContext().setWriter(stdout);
        this.pythonEngine.getContext().setErrorWriter(stderr);
        ScriptEngineIOTest.assertNull((Object)this.pythonEngine.eval("import sys"));
        ScriptEngineIOTest.assertNull((Object)this.pythonEngine.eval("sys.stdout.write('It is a wonderful world.')"));
        ScriptEngineIOTest.assertNull((Object)this.pythonEngine.eval("sys.stderr.write('Stuff happens!')"));
        ScriptEngineIOTest.assertEquals((String)"It is a wonderful world.", (String)stdout.toString());
        ScriptEngineIOTest.assertEquals((String)"Stuff happens!", (String)stderr.toString());
    }

    public void testEvalWithReader() throws ScriptException, FileNotFoundException {
        ScriptEngineManager manager = new ScriptEngineManager();
        ScriptEngine engine = manager.getEngineByName("jython");
        StringWriter stdout = new StringWriter();
        StringWriter stderr = new StringWriter();
        engine.getContext().setWriter(stdout);
        engine.getContext().setErrorWriter(stderr);
        SimpleBindings bindings = new SimpleBindings();
        bindings.put("firstLevelNodes", (Object)10);
        bindings.put("secondLevelNodes", (Object)5);
        engine.setBindings(bindings, 100);
        engine.setBindings(bindings, 100);
        FileReader dfsScript = new FileReader("tests/python/dfs.py");
        for (int i = 1; i <= 10; ++i) {
            engine.eval(dfsScript);
            ScriptEngineIOTest.assertEquals((Object)61, (Object)engine.get("result"));
        }
    }

    public void testGetInterfaceCharSequence1() throws ScriptException, IOException {
        ScriptEngineManager manager = new ScriptEngineManager();
        ScriptEngine engine = manager.getEngineByName("python");
        Invocable invocableEngine = (Invocable)((Object)engine);
        ScriptEngineIOTest.assertNull((Object)engine.eval("from java.lang import CharSequence\nclass MyString(CharSequence):\n   def length(self): return 3\n   def charAt(self, index): return 'a'\n   def subSequence(self, start, end): return \"\"\n   def toString(self): return \"aaa\"\nc = MyString()"));
        CharSequence seq = invocableEngine.getInterface(engine.get("c"), CharSequence.class);
        ScriptEngineIOTest.assertEquals((String)"aaa", (String)seq.toString());
    }

    public void testGetInterfaceCharSequence2() throws ScriptException, IOException {
        ScriptEngineManager manager = new ScriptEngineManager();
        ScriptEngine pythonEngine = manager.getEngineByName("python");
        Invocable invocableEngine = (Invocable)((Object)pythonEngine);
        ScriptEngineIOTest.assertNull((Object)pythonEngine.eval("from java.lang import StringBuilder\r\nc = StringBuilder(\"abc\")\r\n"));
        CharSequence seq = invocableEngine.getInterface(pythonEngine.get("c"), CharSequence.class);
        ScriptEngineIOTest.assertEquals((String)"abc", (String)seq.toString());
    }
}

