/*
 * Decompiled with CFR 0.152.
 */
package org.python.google.common.collect;

import com.kenai.jffi.ArrayFlags;
import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractQueue;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import org.python.google.common.base.CharMatcher;
import org.python.google.common.base.Equivalence;
import org.python.google.common.base.Ticker;
import org.python.google.common.collect.AbstractMapEntry;
import org.python.google.common.collect.AbstractSequentialIterator;
import org.python.google.common.collect.GenericMapMaker;
import org.python.google.common.collect.Iterators;
import org.python.google.common.collect.MapMaker;

class MapMakerInternalMap<K, V>
extends AbstractMap<K, V>
implements Serializable,
ConcurrentMap<K, V> {
    private static final Logger logger = Logger.getLogger(MapMakerInternalMap.class.getName());
    private transient int segmentMask;
    private transient int segmentShift;
    final transient Segment<K, V>[] segments;
    private int concurrencyLevel;
    final Equivalence<Object> keyEquivalence;
    final Equivalence<Object> valueEquivalence;
    private Strength keyStrength;
    final Strength valueStrength;
    private int maximumSize;
    final long expireAfterAccessNanos;
    final long expireAfterWriteNanos;
    final Queue<MapMaker.RemovalNotification<K, V>> removalNotificationQueue;
    private MapMaker.RemovalListener<K, V> removalListener;
    final transient EntryFactory entryFactory;
    final Ticker ticker;
    static final ValueReference<Object, Object> UNSET = new ValueReference<Object, Object>(){

        @Override
        public final Object get() {
            return null;
        }

        @Override
        public final ReferenceEntry<Object, Object> getEntry() {
            return null;
        }

        @Override
        public final ValueReference<Object, Object> copyFor(ReferenceQueue<Object> queue, @Nullable Object value, ReferenceEntry<Object, Object> entry) {
            return this;
        }

        @Override
        public final boolean isComputingReference() {
            return false;
        }

        @Override
        public final Object waitForValue() {
            return null;
        }

        @Override
        public final void clear(ValueReference<Object, Object> newValue) {
        }
    };
    static final Queue<? extends Object> DISCARDING_QUEUE = new AbstractQueue<Object>(){

        @Override
        public final boolean offer(Object o) {
            return true;
        }

        @Override
        public final Object peek() {
            return null;
        }

        @Override
        public final Object poll() {
            return null;
        }

        @Override
        public final int size() {
            return 0;
        }

        @Override
        public final Iterator<Object> iterator() {
            return Iterators.emptyIterator();
        }
    };
    private transient Set<K> keySet;
    private transient Collection<V> values;
    private transient Set<Map.Entry<K, V>> entrySet;

    MapMakerInternalMap(MapMaker builder) {
        int segmentSize;
        int segmentCount;
        this.concurrencyLevel = Math.min(builder.getConcurrencyLevel(), 65536);
        this.keyStrength = builder.getKeyStrength();
        MapMaker mapMaker = builder;
        this.valueStrength = CharMatcher.LookupTable.firstNonNull(mapMaker.valueStrength, Strength.STRONG);
        mapMaker = builder;
        this.keyEquivalence = CharMatcher.LookupTable.firstNonNull(null, mapMaker.getKeyStrength().defaultEquivalence());
        this.valueEquivalence = this.valueStrength.defaultEquivalence();
        this.maximumSize = builder.maximumSize;
        mapMaker = builder;
        this.expireAfterAccessNanos = mapMaker.expireAfterAccessNanos == -1L ? 0L : mapMaker.expireAfterAccessNanos;
        mapMaker = builder;
        this.expireAfterWriteNanos = mapMaker.expireAfterWriteNanos == -1L ? 0L : mapMaker.expireAfterWriteNanos;
        this.entryFactory = EntryFactory.getFactory(this.keyStrength, this.expires(), this.evictsBySize());
        mapMaker = builder;
        this.ticker = CharMatcher.LookupTable.firstNonNull(null, Ticker.systemTicker());
        this.removalListener = builder.getRemovalListener();
        this.removalNotificationQueue = this.removalListener == GenericMapMaker.NullListener.INSTANCE ? DISCARDING_QUEUE : new ConcurrentLinkedQueue();
        int initialCapacity = Math.min(builder.getInitialCapacity(), 0x40000000);
        if (this.evictsBySize()) {
            initialCapacity = Math.min(initialCapacity, this.maximumSize);
        }
        int segmentShift = 0;
        for (segmentCount = 1; !(segmentCount >= this.concurrencyLevel || this.evictsBySize() && segmentCount << 1 > this.maximumSize); segmentCount <<= 1) {
            ++segmentShift;
        }
        this.segmentShift = 32 - segmentShift;
        this.segmentMask = segmentCount - 1;
        int n = segmentCount;
        this.segments = new Segment[n];
        int segmentCapacity = initialCapacity / segmentCount;
        if (segmentCapacity * segmentCount < initialCapacity) {
            ++segmentCapacity;
        }
        for (segmentSize = 1; segmentSize < segmentCapacity; segmentSize <<= 1) {
        }
        if (this.evictsBySize()) {
            int maximumSegmentSize = this.maximumSize / segmentCount + 1;
            int remainder = this.maximumSize % segmentCount;
            for (int i = 0; i < this.segments.length; ++i) {
                if (i == remainder) {
                    --maximumSegmentSize;
                }
                this.segments[i] = this.createSegment(segmentSize, maximumSegmentSize);
            }
            return;
        }
        for (int i = 0; i < this.segments.length; ++i) {
            this.segments[i] = this.createSegment(segmentSize, -1);
        }
    }

    final boolean evictsBySize() {
        return this.maximumSize != -1;
    }

    final boolean expires() {
        MapMakerInternalMap mapMakerInternalMap = this;
        return mapMakerInternalMap.expireAfterWriteNanos > 0L || this.expiresAfterAccess();
    }

    final boolean expiresAfterAccess() {
        return this.expireAfterAccessNanos > 0L;
    }

    final boolean usesKeyReferences() {
        return this.keyStrength != Strength.STRONG;
    }

    final boolean usesValueReferences() {
        return this.valueStrength != Strength.STRONG;
    }

    static <K, V> ValueReference<K, V> unset() {
        return UNSET;
    }

    static <K, V> ReferenceEntry<K, V> nullEntry() {
        return NullEntry.INSTANCE;
    }

    static <E> Queue<E> discardingQueue() {
        return DISCARDING_QUEUE;
    }

    final int hash(Object key) {
        int h;
        int n = h = this.keyEquivalence.hash(key);
        n = h + (n << 15 ^ 0xFFFFCD7D);
        n ^= n >>> 10;
        n += n << 3;
        n ^= n >>> 6;
        n += (n << 2) + (n << 14);
        return n ^ n >>> 16;
    }

    Segment<K, V> segmentFor(int hash) {
        return this.segments[hash >>> this.segmentShift & this.segmentMask];
    }

    Segment<K, V> createSegment(int initialCapacity, int maxSegmentSize) {
        return new Segment(this, initialCapacity, maxSegmentSize);
    }

    final boolean isExpired(ReferenceEntry<K, V> entry) {
        return MapMakerInternalMap.isExpired(entry, this.ticker.read());
    }

    static boolean isExpired(ReferenceEntry<K, V> entry, long now) {
        return now - entry.getExpirationTime() > 0L;
    }

    @GuardedBy(value="Segment.this")
    static <K, V> void connectExpirables(ReferenceEntry<K, V> previous, ReferenceEntry<K, V> next) {
        previous.setNextExpirable(next);
        next.setPreviousExpirable(previous);
    }

    @GuardedBy(value="Segment.this")
    static <K, V> void nullifyExpirable(ReferenceEntry<K, V> nulled) {
        NullEntry nullEntry = NullEntry.INSTANCE;
        nulled.setNextExpirable(nullEntry);
        nulled.setPreviousExpirable(nullEntry);
    }

    final void processPendingNotifications() {
        while (this.removalNotificationQueue.poll() != null) {
            try {
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Exception thrown by removal listener", e);
            }
        }
    }

    @GuardedBy(value="Segment.this")
    static <K, V> void connectEvictables(ReferenceEntry<K, V> previous, ReferenceEntry<K, V> next) {
        previous.setNextEvictable(next);
        next.setPreviousEvictable(previous);
    }

    @GuardedBy(value="Segment.this")
    static <K, V> void nullifyEvictable(ReferenceEntry<K, V> nulled) {
        NullEntry nullEntry = NullEntry.INSTANCE;
        nulled.setNextEvictable(nullEntry);
        nulled.setPreviousEvictable(nullEntry);
    }

    @Override
    public boolean isEmpty() {
        int i;
        long sum = 0L;
        Segment<K, V>[] segments = this.segments;
        for (i = 0; i < segments.length; ++i) {
            if (segments[i].count != 0) {
                return false;
            }
            sum += (long)segments[i].modCount;
        }
        if (sum != 0L) {
            for (i = 0; i < segments.length; ++i) {
                if (segments[i].count != 0) {
                    return false;
                }
                sum -= (long)segments[i].modCount;
            }
            if (sum != 0L) {
                return false;
            }
        }
        return true;
    }

    @Override
    public int size() {
        Segment<K, V>[] segments = this.segments;
        long sum = 0L;
        for (int i = 0; i < segments.length; ++i) {
            sum += (long)segments[i].count;
        }
        return ArrayFlags.saturatedCast(sum);
    }

    @Override
    public V get(@Nullable Object key) {
        if (key == null) {
            return null;
        }
        int hash = this.hash(key);
        return this.segmentFor(hash).get(key, hash);
    }

    @Override
    public boolean containsKey(@Nullable Object key) {
        if (key == null) {
            return false;
        }
        int hash = this.hash(key);
        return this.segmentFor(hash).containsKey(key, hash);
    }

    @Override
    public boolean containsValue(@Nullable Object value) {
        if (value == null) {
            return false;
        }
        Segment<K, V>[] segments = this.segments;
        long last = -1L;
        for (int i = 0; i < 3; ++i) {
            long sum = 0L;
            Segment<K, V>[] arr$ = segments;
            int len$ = segments.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                Segment segment = arr$[i$];
                int cfr_ignored_0 = segment.count;
                AtomicReferenceArray table = segment.table;
                for (int j = 0; j < table.length(); ++j) {
                    for (ReferenceEntry e = table.get(j); e != null; e = e.getNext()) {
                        V v = segment.getLiveValue(e);
                        if (v == null || !this.valueEquivalence.equivalent(value, v)) continue;
                        return true;
                    }
                }
                sum += (long)segment.modCount;
            }
            if (sum == last) break;
            last = sum;
        }
        return false;
    }

    @Override
    public V put(K key, V value) {
        CharMatcher.LookupTable.checkNotNull(key);
        CharMatcher.LookupTable.checkNotNull(value);
        int hash = this.hash(key);
        return this.segmentFor(hash).put(key, hash, value, false);
    }

    @Override
    public V putIfAbsent(K key, V value) {
        CharMatcher.LookupTable.checkNotNull(key);
        CharMatcher.LookupTable.checkNotNull(value);
        int hash = this.hash(key);
        return this.segmentFor(hash).put(key, hash, value, true);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> e : m.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public V remove(@Nullable Object key) {
        if (key == null) {
            return null;
        }
        int hash = this.hash(key);
        return this.segmentFor(hash).remove(key, hash);
    }

    @Override
    public boolean remove(@Nullable Object key, @Nullable Object value) {
        if (key == null || value == null) {
            return false;
        }
        int hash = this.hash(key);
        return this.segmentFor(hash).remove(key, hash, value);
    }

    @Override
    public boolean replace(K key, @Nullable V oldValue, V newValue) {
        CharMatcher.LookupTable.checkNotNull(key);
        CharMatcher.LookupTable.checkNotNull(newValue);
        if (oldValue == null) {
            return false;
        }
        int hash = this.hash(key);
        return this.segmentFor(hash).replace(key, hash, oldValue, newValue);
    }

    @Override
    public V replace(K key, V value) {
        CharMatcher.LookupTable.checkNotNull(key);
        CharMatcher.LookupTable.checkNotNull(value);
        int hash = this.hash(key);
        return this.segmentFor(hash).replace(key, hash, value);
    }

    @Override
    public void clear() {
        Segment<K, V>[] arr$ = this.segments;
        int len$ = this.segments.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Segment segment;
            Segment segment2 = segment = arr$[i$];
            if (segment.count == 0) continue;
            segment2.lock();
            try {
                Segment segment3;
                int n;
                AtomicReferenceArray atomicReferenceArray = segment2.table;
                if (segment2.map.removalNotificationQueue != DISCARDING_QUEUE) {
                    for (n = 0; n < atomicReferenceArray.length(); ++n) {
                        for (ReferenceEntry referenceEntry = atomicReferenceArray.get(n); referenceEntry != null; referenceEntry = referenceEntry.getNext()) {
                            if (referenceEntry.getValueReference().isComputingReference()) continue;
                            segment2.enqueueNotification(referenceEntry, MapMaker.RemovalCause.EXPLICIT);
                        }
                    }
                }
                for (n = 0; n < atomicReferenceArray.length(); ++n) {
                    atomicReferenceArray.set(n, null);
                }
                Segment segment4 = segment2;
                if (segment4.map.usesKeyReferences()) {
                    segment3 = segment4;
                    while (segment3.keyReferenceQueue.poll() != null) {
                    }
                }
                if (segment4.map.usesValueReferences()) {
                    segment3 = segment4;
                    while (segment3.valueReferenceQueue.poll() != null) {
                    }
                }
                segment2.evictionQueue.clear();
                segment2.expirationQueue.clear();
                segment2.readCount.set(0);
                ++segment2.modCount;
                segment2.count = 0;
                continue;
            }
            finally {
                segment2.unlock();
                Segment segment5 = segment2;
                segment5.runUnlockedCleanup();
            }
        }
    }

    @Override
    public Set<K> keySet() {
        Set<K> ks = this.keySet;
        if (ks != null) {
            return ks;
        }
        this.keySet = new KeySet(this);
        return this.keySet;
    }

    @Override
    public Collection<V> values() {
        Collection<V> vs = this.values;
        if (vs != null) {
            return vs;
        }
        this.values = new Values(this);
        return this.values;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        Set<Map.Entry<K, V>> es = this.entrySet;
        if (es != null) {
            return es;
        }
        this.entrySet = new EntrySet(this);
        return this.entrySet;
    }

    final class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private /* synthetic */ MapMakerInternalMap this$0;

        EntrySet(MapMakerInternalMap mapMakerInternalMap) {
            this.this$0 = mapMakerInternalMap;
        }

        @Override
        public final Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator(this.this$0);
        }

        @Override
        public final boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object key = e.getKey();
            if (key == null) {
                return false;
            }
            Object v = this.this$0.get(key);
            return v != null && this.this$0.valueEquivalence.equivalent(e.getValue(), v);
        }

        @Override
        public final boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object key = e.getKey();
            return key != null && this.this$0.remove(key, e.getValue());
        }

        @Override
        public final int size() {
            return this.this$0.size();
        }

        @Override
        public final boolean isEmpty() {
            return this.this$0.isEmpty();
        }

        @Override
        public final void clear() {
            this.this$0.clear();
        }
    }

    final class Values
    extends AbstractCollection<V> {
        private /* synthetic */ MapMakerInternalMap this$0;

        Values(MapMakerInternalMap mapMakerInternalMap) {
            this.this$0 = mapMakerInternalMap;
        }

        @Override
        public final Iterator<V> iterator() {
            return new ValueIterator(this.this$0);
        }

        @Override
        public final int size() {
            return this.this$0.size();
        }

        @Override
        public final boolean isEmpty() {
            return this.this$0.isEmpty();
        }

        @Override
        public final boolean contains(Object o) {
            return this.this$0.containsValue(o);
        }

        @Override
        public final void clear() {
            this.this$0.clear();
        }
    }

    final class KeySet
    extends AbstractSet<K> {
        private /* synthetic */ MapMakerInternalMap this$0;

        KeySet(MapMakerInternalMap mapMakerInternalMap) {
            this.this$0 = mapMakerInternalMap;
        }

        @Override
        public final Iterator<K> iterator() {
            return new KeyIterator(this.this$0);
        }

        @Override
        public final int size() {
            return this.this$0.size();
        }

        @Override
        public final boolean isEmpty() {
            return this.this$0.isEmpty();
        }

        @Override
        public final boolean contains(Object o) {
            return this.this$0.containsKey(o);
        }

        @Override
        public final boolean remove(Object o) {
            return this.this$0.remove(o) != null;
        }

        @Override
        public final void clear() {
            this.this$0.clear();
        }
    }

    final class EntryIterator
    extends HashIterator
    implements Iterator<Map.Entry<K, V>> {
        EntryIterator(MapMakerInternalMap mapMakerInternalMap) {
            super(mapMakerInternalMap);
        }
    }

    final class WriteThroughEntry
    extends AbstractMapEntry<K, V> {
        private K key;
        private V value;
        private /* synthetic */ MapMakerInternalMap this$0;

        WriteThroughEntry(MapMakerInternalMap mapMakerInternalMap, K key, V value) {
            this.this$0 = mapMakerInternalMap;
            this.key = key;
            this.value = value;
        }

        @Override
        public final K getKey() {
            return this.key;
        }

        @Override
        public final V getValue() {
            return this.value;
        }

        @Override
        public final boolean equals(@Nullable Object object) {
            if (object instanceof Map.Entry) {
                Map.Entry that = (Map.Entry)object;
                return this.key.equals(that.getKey()) && this.value.equals(that.getValue());
            }
            return false;
        }

        @Override
        public final int hashCode() {
            return this.key.hashCode() ^ this.value.hashCode();
        }

        @Override
        public final V setValue(V newValue) {
            Object oldValue = this.this$0.put(this.key, newValue);
            this.value = newValue;
            return oldValue;
        }
    }

    final class ValueIterator
    extends HashIterator
    implements Iterator<V> {
        ValueIterator(MapMakerInternalMap mapMakerInternalMap) {
            super(mapMakerInternalMap);
        }

        @Override
        public final V next() {
            return this.nextEntry().getValue();
        }
    }

    final class KeyIterator
    extends HashIterator
    implements Iterator<K> {
        KeyIterator(MapMakerInternalMap mapMakerInternalMap) {
            super(mapMakerInternalMap);
        }

        @Override
        public final K next() {
            return this.nextEntry().getKey();
        }
    }

    abstract class HashIterator {
        private int nextSegmentIndex;
        private int nextTableIndex;
        private Segment<K, V> currentSegment;
        private AtomicReferenceArray<ReferenceEntry<K, V>> currentTable;
        private ReferenceEntry<K, V> nextEntry;
        private WriteThroughEntry nextExternal;
        private WriteThroughEntry lastReturned;
        private /* synthetic */ MapMakerInternalMap this$0;

        HashIterator(MapMakerInternalMap mapMakerInternalMap) {
            this.this$0 = mapMakerInternalMap;
            this.nextSegmentIndex = mapMakerInternalMap.segments.length - 1;
            this.nextTableIndex = -1;
            this.advance();
        }

        private void advance() {
            this.nextExternal = null;
            if (this.nextInChain()) {
                return;
            }
            if (this.nextInTable()) {
                return;
            }
            while (this.nextSegmentIndex >= 0) {
                this.currentSegment = this.this$0.segments[this.nextSegmentIndex--];
                if (this.currentSegment.count == 0) continue;
                this.currentTable = this.currentSegment.table;
                this.nextTableIndex = this.currentTable.length() - 1;
                if (!this.nextInTable()) continue;
                return;
            }
        }

        private boolean nextInChain() {
            if (this.nextEntry != null) {
                this.nextEntry = this.nextEntry.getNext();
                while (this.nextEntry != null) {
                    if (this.advanceTo(this.nextEntry)) {
                        return true;
                    }
                    this.nextEntry = this.nextEntry.getNext();
                }
            }
            return false;
        }

        private boolean nextInTable() {
            while (this.nextTableIndex >= 0) {
                if ((this.nextEntry = this.currentTable.get(this.nextTableIndex--)) == null || !this.advanceTo(this.nextEntry) && !this.nextInChain()) continue;
                return true;
            }
            return false;
        }

        private boolean advanceTo(ReferenceEntry<K, V> entry) {
            try {
                Object value;
                Object v;
                Object key = entry.getKey();
                ReferenceEntry referenceEntry = entry;
                MapMakerInternalMap mapMakerInternalMap = this.this$0;
                if ((referenceEntry.getKey() == null ? null : ((v = referenceEntry.getValueReference().get()) == null ? null : (value = mapMakerInternalMap.expires() && mapMakerInternalMap.isExpired(referenceEntry) ? null : v))) != null) {
                    this.nextExternal = new WriteThroughEntry(this.this$0, key, value);
                    return true;
                }
                return false;
            }
            finally {
                this.currentSegment.postReadCleanup();
            }
        }

        public boolean hasNext() {
            return this.nextExternal != null;
        }

        final WriteThroughEntry nextEntry() {
            if (this.nextExternal == null) {
                throw new NoSuchElementException();
            }
            this.lastReturned = this.nextExternal;
            this.advance();
            return this.lastReturned;
        }

        public void remove() {
            CharMatcher.LookupTable.checkState(this.lastReturned != null);
            this.this$0.remove(this.lastReturned.getKey());
            this.lastReturned = null;
        }
    }

    static final class ExpirationQueue<K, V>
    extends AbstractQueue<ReferenceEntry<K, V>> {
        final ReferenceEntry<K, V> head = new AbstractReferenceEntry<K, V>(this){
            private ReferenceEntry<K, V> nextExpirable = this;
            private ReferenceEntry<K, V> previousExpirable = this;

            @Override
            public final long getExpirationTime() {
                return Long.MAX_VALUE;
            }

            @Override
            public final void setExpirationTime(long time) {
            }

            @Override
            public final ReferenceEntry<K, V> getNextExpirable() {
                return this.nextExpirable;
            }

            @Override
            public final void setNextExpirable(ReferenceEntry<K, V> next) {
                this.nextExpirable = next;
            }

            @Override
            public final ReferenceEntry<K, V> getPreviousExpirable() {
                return this.previousExpirable;
            }

            @Override
            public final void setPreviousExpirable(ReferenceEntry<K, V> previous) {
                this.previousExpirable = previous;
            }
        };

        ExpirationQueue() {
        }

        @Override
        private ReferenceEntry<K, V> peek() {
            ReferenceEntry<K, V> next = this.head.getNextExpirable();
            if (next == this.head) {
                return null;
            }
            return next;
        }

        @Override
        public final boolean remove(Object o) {
            ReferenceEntry e = (ReferenceEntry)o;
            ReferenceEntry previous = e.getPreviousExpirable();
            ReferenceEntry next = e.getNextExpirable();
            MapMakerInternalMap.connectExpirables(previous, next);
            MapMakerInternalMap.nullifyExpirable(e);
            return next != NullEntry.INSTANCE;
        }

        @Override
        public final boolean contains(Object o) {
            ReferenceEntry e = (ReferenceEntry)o;
            return e.getNextExpirable() != NullEntry.INSTANCE;
        }

        @Override
        public final boolean isEmpty() {
            return this.head.getNextExpirable() == this.head;
        }

        @Override
        public final int size() {
            int size = 0;
            for (ReferenceEntry<K, V> e = this.head.getNextExpirable(); e != this.head; e = e.getNextExpirable()) {
                ++size;
            }
            return size;
        }

        @Override
        public final void clear() {
            ReferenceEntry<K, V> e = this.head.getNextExpirable();
            while (e != this.head) {
                ReferenceEntry<K, V> next = e.getNextExpirable();
                MapMakerInternalMap.nullifyExpirable(e);
                e = next;
            }
            this.head.setNextExpirable(this.head);
            this.head.setPreviousExpirable(this.head);
        }

        @Override
        public final Iterator<ReferenceEntry<K, V>> iterator() {
            return new AbstractSequentialIterator<ReferenceEntry<K, V>>(this, (ReferenceEntry)this.peek()){
                private /* synthetic */ ExpirationQueue this$0;
                {
                    this.this$0 = expirationQueue;
                    super(x0);
                }
            };
        }
    }

    static final class EvictionQueue<K, V>
    extends AbstractQueue<ReferenceEntry<K, V>> {
        final ReferenceEntry<K, V> head = new AbstractReferenceEntry<K, V>(this){
            private ReferenceEntry<K, V> nextEvictable = this;
            private ReferenceEntry<K, V> previousEvictable = this;

            @Override
            public final ReferenceEntry<K, V> getNextEvictable() {
                return this.nextEvictable;
            }

            @Override
            public final void setNextEvictable(ReferenceEntry<K, V> next) {
                this.nextEvictable = next;
            }

            @Override
            public final ReferenceEntry<K, V> getPreviousEvictable() {
                return this.previousEvictable;
            }

            @Override
            public final void setPreviousEvictable(ReferenceEntry<K, V> previous) {
                this.previousEvictable = previous;
            }
        };

        EvictionQueue() {
        }

        @Override
        private ReferenceEntry<K, V> peek() {
            ReferenceEntry<K, V> next = this.head.getNextEvictable();
            if (next == this.head) {
                return null;
            }
            return next;
        }

        @Override
        public final boolean remove(Object o) {
            ReferenceEntry e = (ReferenceEntry)o;
            ReferenceEntry previous = e.getPreviousEvictable();
            ReferenceEntry next = e.getNextEvictable();
            MapMakerInternalMap.connectEvictables(previous, next);
            MapMakerInternalMap.nullifyEvictable(e);
            return next != NullEntry.INSTANCE;
        }

        @Override
        public final boolean contains(Object o) {
            ReferenceEntry e = (ReferenceEntry)o;
            return e.getNextEvictable() != NullEntry.INSTANCE;
        }

        @Override
        public final boolean isEmpty() {
            return this.head.getNextEvictable() == this.head;
        }

        @Override
        public final int size() {
            int size = 0;
            for (ReferenceEntry<K, V> e = this.head.getNextEvictable(); e != this.head; e = e.getNextEvictable()) {
                ++size;
            }
            return size;
        }

        @Override
        public final void clear() {
            ReferenceEntry<K, V> e = this.head.getNextEvictable();
            while (e != this.head) {
                ReferenceEntry<K, V> next = e.getNextEvictable();
                MapMakerInternalMap.nullifyEvictable(e);
                e = next;
            }
            this.head.setNextEvictable(this.head);
            this.head.setPreviousEvictable(this.head);
        }

        @Override
        public final Iterator<ReferenceEntry<K, V>> iterator() {
            return new AbstractSequentialIterator<ReferenceEntry<K, V>>(this, (ReferenceEntry)this.peek()){
                private /* synthetic */ EvictionQueue this$0;
                {
                    this.this$0 = evictionQueue;
                    super(x0);
                }
            };
        }
    }

    static class Segment<K, V>
    extends ReentrantLock {
        final MapMakerInternalMap<K, V> map;
        volatile int count;
        int modCount;
        private int threshold;
        volatile AtomicReferenceArray<ReferenceEntry<K, V>> table;
        private int maxSegmentSize;
        final ReferenceQueue<K> keyReferenceQueue;
        final ReferenceQueue<V> valueReferenceQueue;
        private Queue<ReferenceEntry<K, V>> recencyQueue;
        final AtomicInteger readCount = new AtomicInteger();
        @GuardedBy(value="Segment.this")
        final Queue<ReferenceEntry<K, V>> evictionQueue;
        @GuardedBy(value="Segment.this")
        final Queue<ReferenceEntry<K, V>> expirationQueue;

        Segment(MapMakerInternalMap<K, V> map, int initialCapacity, int maxSegmentSize) {
            this.map = map;
            this.maxSegmentSize = maxSegmentSize;
            AtomicReferenceArray<ReferenceEntry<K, V>> atomicReferenceArray = Segment.newEntryArray(initialCapacity);
            Segment segment = this;
            this.threshold = atomicReferenceArray.length() * 3 / 4;
            if (segment.threshold == segment.maxSegmentSize) {
                ++segment.threshold;
            }
            segment.table = atomicReferenceArray;
            this.keyReferenceQueue = map.usesKeyReferences() ? new ReferenceQueue() : null;
            this.valueReferenceQueue = map.usesValueReferences() ? new ReferenceQueue() : null;
            this.recencyQueue = map.evictsBySize() || map.expiresAfterAccess() ? new ConcurrentLinkedQueue() : MapMakerInternalMap.discardingQueue();
            this.evictionQueue = map.evictsBySize() ? new EvictionQueue() : MapMakerInternalMap.discardingQueue();
            this.expirationQueue = map.expires() ? new ExpirationQueue() : MapMakerInternalMap.discardingQueue();
        }

        private static AtomicReferenceArray<ReferenceEntry<K, V>> newEntryArray(int size) {
            return new AtomicReferenceArray(size);
        }

        @GuardedBy(value="Segment.this")
        final ReferenceEntry<K, V> newEntry(K key, int hash, @Nullable ReferenceEntry<K, V> next) {
            return this.map.entryFactory.newEntry(this, key, hash, next);
        }

        @GuardedBy(value="Segment.this")
        private ReferenceEntry<K, V> copyEntry(ReferenceEntry<K, V> original, ReferenceEntry<K, V> newNext) {
            if (original.getKey() == null) {
                return null;
            }
            ValueReference<K, V> valueReference = original.getValueReference();
            V value = valueReference.get();
            if (value == null && !valueReference.isComputingReference()) {
                return null;
            }
            ReferenceEntry<K, V> newEntry = this.map.entryFactory.copyEntry(this, original, newNext);
            newEntry.setValueReference(valueReference.copyFor(this.valueReferenceQueue, value, newEntry));
            return newEntry;
        }

        @GuardedBy(value="Segment.this")
        private void setValue(ReferenceEntry<K, V> entry, V value) {
            ValueReference<K, V> valueReference = this.map.valueStrength.referenceValue(this, entry, value);
            entry.setValueReference(valueReference);
            ReferenceEntry<K, V> referenceEntry = entry;
            Segment segment = this;
            segment.drainRecencyQueue();
            segment.evictionQueue.add(referenceEntry);
            if (segment.map.expires()) {
                long l = segment.map.expiresAfterAccess() ? segment.map.expireAfterAccessNanos : segment.map.expireAfterWriteNanos;
                segment.recordExpirationTime(referenceEntry, l);
                segment.expirationQueue.add(referenceEntry);
            }
        }

        private void tryDrainReferenceQueues() {
            if (this.tryLock()) {
                try {
                    this.drainReferenceQueues();
                    return;
                }
                finally {
                    this.unlock();
                }
            }
        }

        @GuardedBy(value="Segment.this")
        private void drainReferenceQueues() {
            MapMakerInternalMap<K, V> mapMakerInternalMap;
            Object object;
            Object object2;
            Reference<Object> reference;
            int n;
            Segment segment;
            if (this.map.usesKeyReferences()) {
                segment = this;
                n = 0;
                while ((reference = segment.keyReferenceQueue.poll()) != null) {
                    object = object2 = (ReferenceEntry)((Object)reference);
                    mapMakerInternalMap = segment.map;
                    int n2 = object.getHash();
                    mapMakerInternalMap.segmentFor(n2).reclaimKey((ReferenceEntry<K, V>)object, n2);
                    if (++n != 16) continue;
                }
            }
            if (this.map.usesValueReferences()) {
                segment = this;
                n = 0;
                while ((reference = segment.valueReferenceQueue.poll()) != null) {
                    object = object2 = (ValueReference)((Object)reference);
                    mapMakerInternalMap = segment.map;
                    ReferenceEntry referenceEntry = object.getEntry();
                    int n3 = referenceEntry.getHash();
                    mapMakerInternalMap.segmentFor(n3).reclaimValue((K)referenceEntry.getKey(), n3, (ValueReference<K, V>)object);
                    if (++n != 16) continue;
                }
            }
        }

        final void recordRead(ReferenceEntry<K, V> entry) {
            if (this.map.expiresAfterAccess()) {
                this.recordExpirationTime(entry, this.map.expireAfterAccessNanos);
            }
            this.recencyQueue.add(entry);
        }

        @GuardedBy(value="Segment.this")
        final void recordLockedRead(ReferenceEntry<K, V> entry) {
            this.evictionQueue.add(entry);
            if (this.map.expiresAfterAccess()) {
                this.recordExpirationTime(entry, this.map.expireAfterAccessNanos);
                this.expirationQueue.add(entry);
            }
        }

        @GuardedBy(value="Segment.this")
        private void drainRecencyQueue() {
            ReferenceEntry<K, V> e;
            while ((e = this.recencyQueue.poll()) != null) {
                if (this.evictionQueue.contains(e)) {
                    this.evictionQueue.add(e);
                }
                if (!this.map.expiresAfterAccess() || !this.expirationQueue.contains(e)) continue;
                this.expirationQueue.add(e);
            }
        }

        private void recordExpirationTime(ReferenceEntry<K, V> entry, long expirationNanos) {
            entry.setExpirationTime(this.map.ticker.read() + expirationNanos);
        }

        private void tryExpireEntries() {
            if (this.tryLock()) {
                try {
                    this.expireEntries();
                    return;
                }
                finally {
                    this.unlock();
                }
            }
        }

        @GuardedBy(value="Segment.this")
        private void expireEntries() {
            ReferenceEntry<K, V> e;
            this.drainRecencyQueue();
            if (this.expirationQueue.isEmpty()) {
                return;
            }
            long now = this.map.ticker.read();
            while ((e = this.expirationQueue.peek()) != null) {
                if (!MapMakerInternalMap.isExpired(e, now)) break;
                if (!this.removeEntry(e, e.getHash(), MapMaker.RemovalCause.EXPIRED)) {
                    throw new AssertionError();
                }
            }
        }

        final void enqueueNotification(ReferenceEntry<K, V> entry, MapMaker.RemovalCause cause) {
            K k = entry.getKey();
            entry.getHash();
            this.enqueueNotification$15c8a27f(k, entry.getValueReference().get(), cause);
        }

        final void enqueueNotification$15c8a27f(@Nullable K key, @Nullable V value, MapMaker.RemovalCause cause) {
            if (this.map.removalNotificationQueue != DISCARDING_QUEUE) {
                MapMaker.RemovalNotification<K, V> notification = new MapMaker.RemovalNotification<K, V>(key, value, cause);
                this.map.removalNotificationQueue.offer(notification);
            }
        }

        @GuardedBy(value="Segment.this")
        private boolean evictEntries() {
            if (this.map.evictsBySize() && this.count >= this.maxSegmentSize) {
                this.drainRecencyQueue();
                ReferenceEntry<K, V> e = this.evictionQueue.remove();
                if (!this.removeEntry(e, e.getHash(), MapMaker.RemovalCause.SIZE)) {
                    throw new AssertionError();
                }
                return true;
            }
            return false;
        }

        final ReferenceEntry<K, V> getEntry(Object key, int hash) {
            if (this.count != 0) {
                int n = hash;
                Segment segment = this;
                AtomicReferenceArray<ReferenceEntry<K, V>> atomicReferenceArray = segment.table;
                for (ReferenceEntry<K, V> e = atomicReferenceArray.get(n & atomicReferenceArray.length() - 1); e != null; e = e.getNext()) {
                    if (e.getHash() != hash) continue;
                    K entryKey = e.getKey();
                    if (entryKey == null) {
                        this.tryDrainReferenceQueues();
                        continue;
                    }
                    if (!this.map.keyEquivalence.equivalent(key, entryKey)) continue;
                    return e;
                }
            }
            return null;
        }

        private ReferenceEntry<K, V> getLiveEntry(Object key, int hash) {
            ReferenceEntry<K, V> e = this.getEntry(key, hash);
            if (e == null) {
                return null;
            }
            if (this.map.expires() && this.map.isExpired(e)) {
                this.tryExpireEntries();
                return null;
            }
            return e;
        }

        final V get(Object key, int hash) {
            try {
                ReferenceEntry<K, V> e = this.getLiveEntry(key, hash);
                if (e == null) {
                    return null;
                }
                V value = e.getValueReference().get();
                if (value != null) {
                    this.recordRead(e);
                } else {
                    this.tryDrainReferenceQueues();
                }
                V v = value;
                return v;
            }
            finally {
                this.postReadCleanup();
            }
        }

        final boolean containsKey(Object key, int hash) {
            try {
                if (this.count != 0) {
                    ReferenceEntry<K, V> e = this.getLiveEntry(key, hash);
                    if (e == null) {
                        return false;
                    }
                    boolean bl = e.getValueReference().get() != null;
                    return bl;
                }
                return false;
            }
            finally {
                this.postReadCleanup();
            }
        }

        final V put(K key, int hash, V value, boolean onlyIfAbsent) {
            Segment segment;
            this.lock();
            try {
                ReferenceEntry<K, V> first;
                segment = this;
                segment.runLockedCleanup();
                int newCount = this.count + 1;
                if (newCount > this.threshold) {
                    Segment segment2 = this;
                    AtomicReferenceArray<ReferenceEntry<K, V>> atomicReferenceArray = segment2.table;
                    int n = atomicReferenceArray.length();
                    if (n < 0x40000000) {
                        int n2 = segment2.count;
                        AtomicReferenceArray<ReferenceEntry<K, V>> atomicReferenceArray2 = Segment.newEntryArray(n << 1);
                        segment2.threshold = atomicReferenceArray2.length() * 3 / 4;
                        int n3 = atomicReferenceArray2.length() - 1;
                        for (int i = 0; i < n; ++i) {
                            int n4;
                            ReferenceEntry<K, V> referenceEntry;
                            ReferenceEntry<K, V> referenceEntry2 = atomicReferenceArray.get(i);
                            if (referenceEntry2 == null) continue;
                            ReferenceEntry<K, V> referenceEntry3 = referenceEntry2.getNext();
                            int n5 = referenceEntry2.getHash() & n3;
                            if (referenceEntry3 == null) {
                                atomicReferenceArray2.set(n5, referenceEntry2);
                                continue;
                            }
                            ReferenceEntry<K, V> referenceEntry4 = referenceEntry2;
                            int n6 = n5;
                            for (referenceEntry = referenceEntry3; referenceEntry != null; referenceEntry = referenceEntry.getNext()) {
                                n4 = referenceEntry.getHash() & n3;
                                if (n4 == n6) continue;
                                n6 = n4;
                                referenceEntry4 = referenceEntry;
                            }
                            atomicReferenceArray2.set(n6, referenceEntry4);
                            for (referenceEntry = referenceEntry2; referenceEntry != referenceEntry4; referenceEntry = referenceEntry.getNext()) {
                                n4 = referenceEntry.getHash() & n3;
                                ReferenceEntry<K, V> referenceEntry5 = atomicReferenceArray2.get(n4);
                                ReferenceEntry<K, V> referenceEntry6 = segment2.copyEntry(referenceEntry, referenceEntry5);
                                if (referenceEntry6 != null) {
                                    atomicReferenceArray2.set(n4, referenceEntry6);
                                    continue;
                                }
                                segment2.removeCollectedEntry(referenceEntry);
                                --n2;
                            }
                        }
                        segment2.table = atomicReferenceArray2;
                        segment2.count = n2;
                    }
                    newCount = this.count + 1;
                }
                AtomicReferenceArray<ReferenceEntry<K, V>> table = this.table;
                int index = hash & table.length() - 1;
                for (ReferenceEntry<K, V> e = first = table.get(index); e != null; e = e.getNext()) {
                    K entryKey = e.getKey();
                    if (e.getHash() != hash || entryKey == null || !this.map.keyEquivalence.equivalent(key, entryKey)) continue;
                    ValueReference<K, V> valueReference = e.getValueReference();
                    V entryValue = valueReference.get();
                    if (entryValue == null) {
                        ++this.modCount;
                        this.setValue(e, value);
                        if (!valueReference.isComputingReference()) {
                            this.enqueueNotification$15c8a27f(key, entryValue, MapMaker.RemovalCause.COLLECTED);
                            newCount = this.count;
                        } else if (this.evictEntries()) {
                            newCount = this.count + 1;
                        }
                        this.count = newCount;
                        return null;
                    }
                    if (onlyIfAbsent) {
                        this.recordLockedRead(e);
                        V v = entryValue;
                        return v;
                    }
                    ++this.modCount;
                    this.enqueueNotification$15c8a27f(key, entryValue, MapMaker.RemovalCause.REPLACED);
                    this.setValue(e, value);
                    V v = entryValue;
                    return v;
                }
                ++this.modCount;
                ReferenceEntry<K, V> newEntry = this.newEntry(key, hash, first);
                this.setValue(newEntry, value);
                table.set(index, newEntry);
                if (this.evictEntries()) {
                    newCount = this.count + 1;
                }
                this.count = newCount;
                return null;
            }
            finally {
                this.unlock();
                segment = this;
                segment.runUnlockedCleanup();
            }
        }

        final boolean replace(K key, int hash, V oldValue, V newValue) {
            Segment segment;
            this.lock();
            try {
                ReferenceEntry<K, V> first;
                segment = this;
                segment.runLockedCleanup();
                AtomicReferenceArray<ReferenceEntry<K, V>> table = this.table;
                int index = hash & table.length() - 1;
                for (ReferenceEntry<K, V> e = first = table.get(index); e != null; e = e.getNext()) {
                    K entryKey = e.getKey();
                    if (e.getHash() != hash || entryKey == null || !this.map.keyEquivalence.equivalent(key, entryKey)) continue;
                    ValueReference<K, V> valueReference = e.getValueReference();
                    V entryValue = valueReference.get();
                    if (entryValue == null) {
                        if (Segment.isCollected(valueReference)) {
                            ++this.modCount;
                            this.enqueueNotification$15c8a27f(entryKey, entryValue, MapMaker.RemovalCause.COLLECTED);
                            ReferenceEntry<K, V> newFirst = this.removeFromChain(first, e);
                            int newCount = this.count - 1;
                            table.set(index, newFirst);
                            this.count = newCount;
                        }
                        return false;
                    }
                    if (this.map.valueEquivalence.equivalent(oldValue, entryValue)) {
                        ++this.modCount;
                        this.enqueueNotification$15c8a27f(key, entryValue, MapMaker.RemovalCause.REPLACED);
                        this.setValue(e, newValue);
                        return true;
                    }
                    this.recordLockedRead(e);
                    return false;
                }
                return false;
            }
            finally {
                this.unlock();
                segment = this;
                segment.runUnlockedCleanup();
            }
        }

        final V replace(K key, int hash, V newValue) {
            Segment segment;
            this.lock();
            try {
                ReferenceEntry<K, V> first;
                segment = this;
                segment.runLockedCleanup();
                AtomicReferenceArray<ReferenceEntry<K, V>> table = this.table;
                int index = hash & table.length() - 1;
                for (ReferenceEntry<K, V> e = first = table.get(index); e != null; e = e.getNext()) {
                    K entryKey = e.getKey();
                    if (e.getHash() != hash || entryKey == null || !this.map.keyEquivalence.equivalent(key, entryKey)) continue;
                    ValueReference<K, V> valueReference = e.getValueReference();
                    V entryValue = valueReference.get();
                    if (entryValue == null) {
                        if (Segment.isCollected(valueReference)) {
                            ++this.modCount;
                            this.enqueueNotification$15c8a27f(entryKey, entryValue, MapMaker.RemovalCause.COLLECTED);
                            ReferenceEntry<K, V> newFirst = this.removeFromChain(first, e);
                            int newCount = this.count - 1;
                            table.set(index, newFirst);
                            this.count = newCount;
                        }
                        return null;
                    }
                    ++this.modCount;
                    this.enqueueNotification$15c8a27f(key, entryValue, MapMaker.RemovalCause.REPLACED);
                    this.setValue(e, newValue);
                    V v = entryValue;
                    return v;
                }
                return null;
            }
            finally {
                this.unlock();
                segment = this;
                segment.runUnlockedCleanup();
            }
        }

        final V remove(Object key, int hash) {
            Segment segment;
            this.lock();
            try {
                ReferenceEntry<K, V> first;
                segment = this;
                segment.runLockedCleanup();
                AtomicReferenceArray<ReferenceEntry<K, V>> table = this.table;
                int index = hash & table.length() - 1;
                for (ReferenceEntry<K, V> e = first = table.get(index); e != null; e = e.getNext()) {
                    MapMaker.RemovalCause cause;
                    K entryKey = e.getKey();
                    if (e.getHash() != hash || entryKey == null || !this.map.keyEquivalence.equivalent(key, entryKey)) continue;
                    ValueReference<K, V> valueReference = e.getValueReference();
                    V entryValue = valueReference.get();
                    if (entryValue != null) {
                        cause = MapMaker.RemovalCause.EXPLICIT;
                    } else if (Segment.isCollected(valueReference)) {
                        cause = MapMaker.RemovalCause.COLLECTED;
                    } else {
                        return null;
                    }
                    ++this.modCount;
                    this.enqueueNotification$15c8a27f(entryKey, entryValue, cause);
                    ReferenceEntry<K, V> newFirst = this.removeFromChain(first, e);
                    int newCount = this.count - 1;
                    table.set(index, newFirst);
                    this.count = newCount;
                    V v = entryValue;
                    return v;
                }
                return null;
            }
            finally {
                this.unlock();
                segment = this;
                segment.runUnlockedCleanup();
            }
        }

        final boolean remove(Object key, int hash, Object value) {
            Segment segment;
            this.lock();
            try {
                ReferenceEntry<K, V> first;
                segment = this;
                segment.runLockedCleanup();
                AtomicReferenceArray<ReferenceEntry<K, V>> table = this.table;
                int index = hash & table.length() - 1;
                for (ReferenceEntry<K, V> e = first = table.get(index); e != null; e = e.getNext()) {
                    MapMaker.RemovalCause cause;
                    K entryKey = e.getKey();
                    if (e.getHash() != hash || entryKey == null || !this.map.keyEquivalence.equivalent(key, entryKey)) continue;
                    ValueReference<K, V> valueReference = e.getValueReference();
                    V entryValue = valueReference.get();
                    if (this.map.valueEquivalence.equivalent(value, entryValue)) {
                        cause = MapMaker.RemovalCause.EXPLICIT;
                    } else if (Segment.isCollected(valueReference)) {
                        cause = MapMaker.RemovalCause.COLLECTED;
                    } else {
                        return false;
                    }
                    ++this.modCount;
                    this.enqueueNotification$15c8a27f(entryKey, entryValue, cause);
                    ReferenceEntry<K, V> newFirst = this.removeFromChain(first, e);
                    int newCount = this.count - 1;
                    table.set(index, newFirst);
                    this.count = newCount;
                    boolean bl = cause == MapMaker.RemovalCause.EXPLICIT;
                    return bl;
                }
                return false;
            }
            finally {
                this.unlock();
                segment = this;
                segment.runUnlockedCleanup();
            }
        }

        @GuardedBy(value="Segment.this")
        private ReferenceEntry<K, V> removeFromChain(ReferenceEntry<K, V> first, ReferenceEntry<K, V> entry) {
            this.evictionQueue.remove(entry);
            this.expirationQueue.remove(entry);
            int newCount = this.count;
            ReferenceEntry<K, V> newFirst = entry.getNext();
            for (ReferenceEntry<K, V> e = first; e != entry; e = e.getNext()) {
                ReferenceEntry<K, V> next = this.copyEntry(e, newFirst);
                if (next != null) {
                    newFirst = next;
                    continue;
                }
                this.removeCollectedEntry(e);
                --newCount;
            }
            this.count = newCount;
            return newFirst;
        }

        private void removeCollectedEntry(ReferenceEntry<K, V> entry) {
            this.enqueueNotification(entry, MapMaker.RemovalCause.COLLECTED);
            this.evictionQueue.remove(entry);
            this.expirationQueue.remove(entry);
        }

        final boolean reclaimKey(ReferenceEntry<K, V> entry, int hash) {
            this.lock();
            try {
                ReferenceEntry<K, V> first;
                AtomicReferenceArray<ReferenceEntry<K, V>> table = this.table;
                int index = hash & table.length() - 1;
                for (ReferenceEntry<K, V> e = first = table.get(index); e != null; e = e.getNext()) {
                    if (e != entry) continue;
                    ++this.modCount;
                    this.enqueueNotification$15c8a27f(e.getKey(), e.getValueReference().get(), MapMaker.RemovalCause.COLLECTED);
                    ReferenceEntry<K, V> newFirst = this.removeFromChain(first, e);
                    int newCount = this.count - 1;
                    table.set(index, newFirst);
                    this.count = newCount;
                    return true;
                }
                return false;
            }
            finally {
                this.unlock();
                Segment segment = this;
                segment.runUnlockedCleanup();
            }
        }

        final boolean reclaimValue(K key, int hash, ValueReference<K, V> valueReference) {
            this.lock();
            try {
                ReferenceEntry<K, V> first;
                AtomicReferenceArray<ReferenceEntry<K, V>> table = this.table;
                int index = hash & table.length() - 1;
                for (ReferenceEntry<K, V> e = first = table.get(index); e != null; e = e.getNext()) {
                    K entryKey = e.getKey();
                    if (e.getHash() != hash || entryKey == null || !this.map.keyEquivalence.equivalent(key, entryKey)) continue;
                    ValueReference<K, V> v = e.getValueReference();
                    if (v == valueReference) {
                        ++this.modCount;
                        this.enqueueNotification$15c8a27f(key, valueReference.get(), MapMaker.RemovalCause.COLLECTED);
                        ReferenceEntry<K, V> newFirst = this.removeFromChain(first, e);
                        int newCount = this.count - 1;
                        table.set(index, newFirst);
                        this.count = newCount;
                        return true;
                    }
                    return false;
                }
                return false;
            }
            finally {
                this.unlock();
                if (!this.isHeldByCurrentThread()) {
                    Segment segment = this;
                    segment.runUnlockedCleanup();
                }
            }
        }

        final boolean clearValue(K key, int hash, ValueReference<K, V> valueReference) {
            this.lock();
            try {
                ReferenceEntry<K, V> first;
                AtomicReferenceArray<ReferenceEntry<K, V>> table = this.table;
                int index = hash & table.length() - 1;
                for (ReferenceEntry<K, V> e = first = table.get(index); e != null; e = e.getNext()) {
                    K entryKey = e.getKey();
                    if (e.getHash() != hash || entryKey == null || !this.map.keyEquivalence.equivalent(key, entryKey)) continue;
                    ValueReference<K, V> v = e.getValueReference();
                    if (v == valueReference) {
                        ReferenceEntry<K, V> newFirst = this.removeFromChain(first, e);
                        table.set(index, newFirst);
                        return true;
                    }
                    return false;
                }
                return false;
            }
            finally {
                this.unlock();
                Segment segment = this;
                segment.runUnlockedCleanup();
            }
        }

        @GuardedBy(value="Segment.this")
        private boolean removeEntry(ReferenceEntry<K, V> entry, int hash, MapMaker.RemovalCause cause) {
            ReferenceEntry<K, V> first;
            AtomicReferenceArray<ReferenceEntry<K, V>> table = this.table;
            int index = hash & table.length() - 1;
            for (ReferenceEntry<K, V> e = first = table.get(index); e != null; e = e.getNext()) {
                if (e != entry) continue;
                ++this.modCount;
                this.enqueueNotification$15c8a27f(e.getKey(), e.getValueReference().get(), cause);
                ReferenceEntry<K, V> newFirst = this.removeFromChain(first, e);
                int newCount = this.count - 1;
                table.set(index, newFirst);
                this.count = newCount;
                return true;
            }
            return false;
        }

        private static boolean isCollected(ValueReference<K, V> valueReference) {
            if (valueReference.isComputingReference()) {
                return false;
            }
            return valueReference.get() == null;
        }

        final V getLiveValue(ReferenceEntry<K, V> entry) {
            if (entry.getKey() == null) {
                this.tryDrainReferenceQueues();
                return null;
            }
            V value = entry.getValueReference().get();
            if (value == null) {
                this.tryDrainReferenceQueues();
                return null;
            }
            if (this.map.expires() && this.map.isExpired(entry)) {
                this.tryExpireEntries();
                return null;
            }
            return value;
        }

        final void postReadCleanup() {
            if ((this.readCount.incrementAndGet() & 0x3F) == 0) {
                Segment segment = this;
                segment.runLockedCleanup();
                segment.runUnlockedCleanup();
            }
        }

        final void runLockedCleanup() {
            if (this.tryLock()) {
                try {
                    this.drainReferenceQueues();
                    this.expireEntries();
                    this.readCount.set(0);
                    return;
                }
                finally {
                    this.unlock();
                }
            }
        }

        final void runUnlockedCleanup() {
            if (!this.isHeldByCurrentThread()) {
                this.map.processPendingNotifications();
            }
        }
    }

    static final class StrongValueReference<K, V>
    implements ValueReference<K, V> {
        private V referent;

        StrongValueReference(V referent) {
            this.referent = referent;
        }

        @Override
        public final V get() {
            return this.referent;
        }

        @Override
        public final ReferenceEntry<K, V> getEntry() {
            return null;
        }

        @Override
        public final ValueReference<K, V> copyFor(ReferenceQueue<V> queue, V value, ReferenceEntry<K, V> entry) {
            return this;
        }

        @Override
        public final boolean isComputingReference() {
            return false;
        }

        @Override
        public final V waitForValue() {
            return this.get();
        }

        @Override
        public final void clear(ValueReference<K, V> newValue) {
        }
    }

    static final class SoftValueReference<K, V>
    extends SoftReference<V>
    implements ValueReference<K, V> {
        private ReferenceEntry<K, V> entry;

        SoftValueReference(ReferenceQueue<V> queue, V referent, ReferenceEntry<K, V> entry) {
            super(referent, queue);
            this.entry = entry;
        }

        @Override
        public final ReferenceEntry<K, V> getEntry() {
            return this.entry;
        }

        @Override
        public final void clear(ValueReference<K, V> newValue) {
            this.clear();
        }

        @Override
        public final ValueReference<K, V> copyFor(ReferenceQueue<V> queue, V value, ReferenceEntry<K, V> entry) {
            return new SoftValueReference<K, V>(queue, value, entry);
        }

        @Override
        public final boolean isComputingReference() {
            return false;
        }

        @Override
        public final V waitForValue() {
            return (V)this.get();
        }
    }

    static final class WeakValueReference<K, V>
    extends WeakReference<V>
    implements ValueReference<K, V> {
        private ReferenceEntry<K, V> entry;

        WeakValueReference(ReferenceQueue<V> queue, V referent, ReferenceEntry<K, V> entry) {
            super(referent, queue);
            this.entry = entry;
        }

        @Override
        public final ReferenceEntry<K, V> getEntry() {
            return this.entry;
        }

        @Override
        public final void clear(ValueReference<K, V> newValue) {
            this.clear();
        }

        @Override
        public final ValueReference<K, V> copyFor(ReferenceQueue<V> queue, V value, ReferenceEntry<K, V> entry) {
            return new WeakValueReference<K, V>(queue, value, entry);
        }

        @Override
        public final boolean isComputingReference() {
            return false;
        }

        @Override
        public final V waitForValue() {
            return (V)this.get();
        }
    }

    static final class WeakExpirableEvictableEntry<K, V>
    extends WeakEntry<K, V>
    implements ReferenceEntry<K, V> {
        private volatile long time = Long.MAX_VALUE;
        @GuardedBy(value="Segment.this")
        private ReferenceEntry<K, V> nextExpirable = MapMakerInternalMap.nullEntry();
        @GuardedBy(value="Segment.this")
        private ReferenceEntry<K, V> previousExpirable = MapMakerInternalMap.nullEntry();
        @GuardedBy(value="Segment.this")
        private ReferenceEntry<K, V> nextEvictable = MapMakerInternalMap.nullEntry();
        @GuardedBy(value="Segment.this")
        private ReferenceEntry<K, V> previousEvictable = MapMakerInternalMap.nullEntry();

        WeakExpirableEvictableEntry(ReferenceQueue<K> queue, K key, int hash, @Nullable ReferenceEntry<K, V> next) {
            super(queue, key, hash, next);
        }

        @Override
        public final long getExpirationTime() {
            return this.time;
        }

        @Override
        public final void setExpirationTime(long time) {
            this.time = time;
        }

        @Override
        public final ReferenceEntry<K, V> getNextExpirable() {
            return this.nextExpirable;
        }

        @Override
        public final void setNextExpirable(ReferenceEntry<K, V> next) {
            this.nextExpirable = next;
        }

        @Override
        public final ReferenceEntry<K, V> getPreviousExpirable() {
            return this.previousExpirable;
        }

        @Override
        public final void setPreviousExpirable(ReferenceEntry<K, V> previous) {
            this.previousExpirable = previous;
        }

        @Override
        public final ReferenceEntry<K, V> getNextEvictable() {
            return this.nextEvictable;
        }

        @Override
        public final void setNextEvictable(ReferenceEntry<K, V> next) {
            this.nextEvictable = next;
        }

        @Override
        public final ReferenceEntry<K, V> getPreviousEvictable() {
            return this.previousEvictable;
        }

        @Override
        public final void setPreviousEvictable(ReferenceEntry<K, V> previous) {
            this.previousEvictable = previous;
        }
    }

    static final class WeakEvictableEntry<K, V>
    extends WeakEntry<K, V>
    implements ReferenceEntry<K, V> {
        @GuardedBy(value="Segment.this")
        private ReferenceEntry<K, V> nextEvictable = MapMakerInternalMap.nullEntry();
        @GuardedBy(value="Segment.this")
        private ReferenceEntry<K, V> previousEvictable = MapMakerInternalMap.nullEntry();

        WeakEvictableEntry(ReferenceQueue<K> queue, K key, int hash, @Nullable ReferenceEntry<K, V> next) {
            super(queue, key, hash, next);
        }

        @Override
        public final ReferenceEntry<K, V> getNextEvictable() {
            return this.nextEvictable;
        }

        @Override
        public final void setNextEvictable(ReferenceEntry<K, V> next) {
            this.nextEvictable = next;
        }

        @Override
        public final ReferenceEntry<K, V> getPreviousEvictable() {
            return this.previousEvictable;
        }

        @Override
        public final void setPreviousEvictable(ReferenceEntry<K, V> previous) {
            this.previousEvictable = previous;
        }
    }

    static final class WeakExpirableEntry<K, V>
    extends WeakEntry<K, V>
    implements ReferenceEntry<K, V> {
        private volatile long time = Long.MAX_VALUE;
        @GuardedBy(value="Segment.this")
        private ReferenceEntry<K, V> nextExpirable = MapMakerInternalMap.nullEntry();
        @GuardedBy(value="Segment.this")
        private ReferenceEntry<K, V> previousExpirable = MapMakerInternalMap.nullEntry();

        WeakExpirableEntry(ReferenceQueue<K> queue, K key, int hash, @Nullable ReferenceEntry<K, V> next) {
            super(queue, key, hash, next);
        }

        @Override
        public final long getExpirationTime() {
            return this.time;
        }

        @Override
        public final void setExpirationTime(long time) {
            this.time = time;
        }

        @Override
        public final ReferenceEntry<K, V> getNextExpirable() {
            return this.nextExpirable;
        }

        @Override
        public final void setNextExpirable(ReferenceEntry<K, V> next) {
            this.nextExpirable = next;
        }

        @Override
        public final ReferenceEntry<K, V> getPreviousExpirable() {
            return this.previousExpirable;
        }

        @Override
        public final void setPreviousExpirable(ReferenceEntry<K, V> previous) {
            this.previousExpirable = previous;
        }
    }

    static class WeakEntry<K, V>
    extends WeakReference<K>
    implements ReferenceEntry<K, V> {
        private int hash;
        private ReferenceEntry<K, V> next;
        private volatile ValueReference<K, V> valueReference = MapMakerInternalMap.unset();

        WeakEntry(ReferenceQueue<K> queue, K key, int hash, @Nullable ReferenceEntry<K, V> next) {
            super(key, queue);
            this.hash = hash;
            this.next = next;
        }

        @Override
        public final K getKey() {
            return (K)this.get();
        }

        @Override
        public long getExpirationTime() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setExpirationTime(long time) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ReferenceEntry<K, V> getNextExpirable() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setNextExpirable(ReferenceEntry<K, V> next) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ReferenceEntry<K, V> getPreviousExpirable() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setPreviousExpirable(ReferenceEntry<K, V> previous) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ReferenceEntry<K, V> getNextEvictable() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setNextEvictable(ReferenceEntry<K, V> next) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ReferenceEntry<K, V> getPreviousEvictable() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setPreviousEvictable(ReferenceEntry<K, V> previous) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final ValueReference<K, V> getValueReference() {
            return this.valueReference;
        }

        @Override
        public final void setValueReference(ValueReference<K, V> valueReference) {
            ValueReference<K, V> previous = this.valueReference;
            this.valueReference = valueReference;
            previous.clear(valueReference);
        }

        @Override
        public final int getHash() {
            return this.hash;
        }

        @Override
        public final ReferenceEntry<K, V> getNext() {
            return this.next;
        }
    }

    static final class SoftExpirableEvictableEntry<K, V>
    extends SoftEntry<K, V>
    implements ReferenceEntry<K, V> {
        private volatile long time = Long.MAX_VALUE;
        @GuardedBy(value="Segment.this")
        private ReferenceEntry<K, V> nextExpirable = MapMakerInternalMap.nullEntry();
        @GuardedBy(value="Segment.this")
        private ReferenceEntry<K, V> previousExpirable = MapMakerInternalMap.nullEntry();
        @GuardedBy(value="Segment.this")
        private ReferenceEntry<K, V> nextEvictable = MapMakerInternalMap.nullEntry();
        @GuardedBy(value="Segment.this")
        private ReferenceEntry<K, V> previousEvictable = MapMakerInternalMap.nullEntry();

        SoftExpirableEvictableEntry(ReferenceQueue<K> queue, K key, int hash, @Nullable ReferenceEntry<K, V> next) {
            super(queue, key, hash, next);
        }

        @Override
        public final long getExpirationTime() {
            return this.time;
        }

        @Override
        public final void setExpirationTime(long time) {
            this.time = time;
        }

        @Override
        public final ReferenceEntry<K, V> getNextExpirable() {
            return this.nextExpirable;
        }

        @Override
        public final void setNextExpirable(ReferenceEntry<K, V> next) {
            this.nextExpirable = next;
        }

        @Override
        public final ReferenceEntry<K, V> getPreviousExpirable() {
            return this.previousExpirable;
        }

        @Override
        public final void setPreviousExpirable(ReferenceEntry<K, V> previous) {
            this.previousExpirable = previous;
        }

        @Override
        public final ReferenceEntry<K, V> getNextEvictable() {
            return this.nextEvictable;
        }

        @Override
        public final void setNextEvictable(ReferenceEntry<K, V> next) {
            this.nextEvictable = next;
        }

        @Override
        public final ReferenceEntry<K, V> getPreviousEvictable() {
            return this.previousEvictable;
        }

        @Override
        public final void setPreviousEvictable(ReferenceEntry<K, V> previous) {
            this.previousEvictable = previous;
        }
    }

    static final class SoftEvictableEntry<K, V>
    extends SoftEntry<K, V>
    implements ReferenceEntry<K, V> {
        @GuardedBy(value="Segment.this")
        private ReferenceEntry<K, V> nextEvictable = MapMakerInternalMap.nullEntry();
        @GuardedBy(value="Segment.this")
        private ReferenceEntry<K, V> previousEvictable = MapMakerInternalMap.nullEntry();

        SoftEvictableEntry(ReferenceQueue<K> queue, K key, int hash, @Nullable ReferenceEntry<K, V> next) {
            super(queue, key, hash, next);
        }

        @Override
        public final ReferenceEntry<K, V> getNextEvictable() {
            return this.nextEvictable;
        }

        @Override
        public final void setNextEvictable(ReferenceEntry<K, V> next) {
            this.nextEvictable = next;
        }

        @Override
        public final ReferenceEntry<K, V> getPreviousEvictable() {
            return this.previousEvictable;
        }

        @Override
        public final void setPreviousEvictable(ReferenceEntry<K, V> previous) {
            this.previousEvictable = previous;
        }
    }

    static final class SoftExpirableEntry<K, V>
    extends SoftEntry<K, V>
    implements ReferenceEntry<K, V> {
        private volatile long time = Long.MAX_VALUE;
        @GuardedBy(value="Segment.this")
        private ReferenceEntry<K, V> nextExpirable = MapMakerInternalMap.nullEntry();
        @GuardedBy(value="Segment.this")
        private ReferenceEntry<K, V> previousExpirable = MapMakerInternalMap.nullEntry();

        SoftExpirableEntry(ReferenceQueue<K> queue, K key, int hash, @Nullable ReferenceEntry<K, V> next) {
            super(queue, key, hash, next);
        }

        @Override
        public final long getExpirationTime() {
            return this.time;
        }

        @Override
        public final void setExpirationTime(long time) {
            this.time = time;
        }

        @Override
        public final ReferenceEntry<K, V> getNextExpirable() {
            return this.nextExpirable;
        }

        @Override
        public final void setNextExpirable(ReferenceEntry<K, V> next) {
            this.nextExpirable = next;
        }

        @Override
        public final ReferenceEntry<K, V> getPreviousExpirable() {
            return this.previousExpirable;
        }

        @Override
        public final void setPreviousExpirable(ReferenceEntry<K, V> previous) {
            this.previousExpirable = previous;
        }
    }

    static class SoftEntry<K, V>
    extends SoftReference<K>
    implements ReferenceEntry<K, V> {
        private int hash;
        private ReferenceEntry<K, V> next;
        private volatile ValueReference<K, V> valueReference = MapMakerInternalMap.unset();

        SoftEntry(ReferenceQueue<K> queue, K key, int hash, @Nullable ReferenceEntry<K, V> next) {
            super(key, queue);
            this.hash = hash;
            this.next = next;
        }

        @Override
        public final K getKey() {
            return (K)this.get();
        }

        @Override
        public long getExpirationTime() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setExpirationTime(long time) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ReferenceEntry<K, V> getNextExpirable() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setNextExpirable(ReferenceEntry<K, V> next) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ReferenceEntry<K, V> getPreviousExpirable() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setPreviousExpirable(ReferenceEntry<K, V> previous) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ReferenceEntry<K, V> getNextEvictable() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setNextEvictable(ReferenceEntry<K, V> next) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ReferenceEntry<K, V> getPreviousEvictable() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setPreviousEvictable(ReferenceEntry<K, V> previous) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final ValueReference<K, V> getValueReference() {
            return this.valueReference;
        }

        @Override
        public final void setValueReference(ValueReference<K, V> valueReference) {
            ValueReference<K, V> previous = this.valueReference;
            this.valueReference = valueReference;
            previous.clear(valueReference);
        }

        @Override
        public final int getHash() {
            return this.hash;
        }

        @Override
        public final ReferenceEntry<K, V> getNext() {
            return this.next;
        }
    }

    static final class StrongExpirableEvictableEntry<K, V>
    extends StrongEntry<K, V>
    implements ReferenceEntry<K, V> {
        private volatile long time = Long.MAX_VALUE;
        @GuardedBy(value="Segment.this")
        private ReferenceEntry<K, V> nextExpirable = MapMakerInternalMap.nullEntry();
        @GuardedBy(value="Segment.this")
        private ReferenceEntry<K, V> previousExpirable = MapMakerInternalMap.nullEntry();
        @GuardedBy(value="Segment.this")
        private ReferenceEntry<K, V> nextEvictable = MapMakerInternalMap.nullEntry();
        @GuardedBy(value="Segment.this")
        private ReferenceEntry<K, V> previousEvictable = MapMakerInternalMap.nullEntry();

        StrongExpirableEvictableEntry(K key, int hash, @Nullable ReferenceEntry<K, V> next) {
            super(key, hash, next);
        }

        @Override
        public final long getExpirationTime() {
            return this.time;
        }

        @Override
        public final void setExpirationTime(long time) {
            this.time = time;
        }

        @Override
        public final ReferenceEntry<K, V> getNextExpirable() {
            return this.nextExpirable;
        }

        @Override
        public final void setNextExpirable(ReferenceEntry<K, V> next) {
            this.nextExpirable = next;
        }

        @Override
        public final ReferenceEntry<K, V> getPreviousExpirable() {
            return this.previousExpirable;
        }

        @Override
        public final void setPreviousExpirable(ReferenceEntry<K, V> previous) {
            this.previousExpirable = previous;
        }

        @Override
        public final ReferenceEntry<K, V> getNextEvictable() {
            return this.nextEvictable;
        }

        @Override
        public final void setNextEvictable(ReferenceEntry<K, V> next) {
            this.nextEvictable = next;
        }

        @Override
        public final ReferenceEntry<K, V> getPreviousEvictable() {
            return this.previousEvictable;
        }

        @Override
        public final void setPreviousEvictable(ReferenceEntry<K, V> previous) {
            this.previousEvictable = previous;
        }
    }

    static final class StrongEvictableEntry<K, V>
    extends StrongEntry<K, V>
    implements ReferenceEntry<K, V> {
        @GuardedBy(value="Segment.this")
        private ReferenceEntry<K, V> nextEvictable = MapMakerInternalMap.nullEntry();
        @GuardedBy(value="Segment.this")
        private ReferenceEntry<K, V> previousEvictable = MapMakerInternalMap.nullEntry();

        StrongEvictableEntry(K key, int hash, @Nullable ReferenceEntry<K, V> next) {
            super(key, hash, next);
        }

        @Override
        public final ReferenceEntry<K, V> getNextEvictable() {
            return this.nextEvictable;
        }

        @Override
        public final void setNextEvictable(ReferenceEntry<K, V> next) {
            this.nextEvictable = next;
        }

        @Override
        public final ReferenceEntry<K, V> getPreviousEvictable() {
            return this.previousEvictable;
        }

        @Override
        public final void setPreviousEvictable(ReferenceEntry<K, V> previous) {
            this.previousEvictable = previous;
        }
    }

    static final class StrongExpirableEntry<K, V>
    extends StrongEntry<K, V>
    implements ReferenceEntry<K, V> {
        private volatile long time = Long.MAX_VALUE;
        @GuardedBy(value="Segment.this")
        private ReferenceEntry<K, V> nextExpirable = MapMakerInternalMap.nullEntry();
        @GuardedBy(value="Segment.this")
        private ReferenceEntry<K, V> previousExpirable = MapMakerInternalMap.nullEntry();

        StrongExpirableEntry(K key, int hash, @Nullable ReferenceEntry<K, V> next) {
            super(key, hash, next);
        }

        @Override
        public final long getExpirationTime() {
            return this.time;
        }

        @Override
        public final void setExpirationTime(long time) {
            this.time = time;
        }

        @Override
        public final ReferenceEntry<K, V> getNextExpirable() {
            return this.nextExpirable;
        }

        @Override
        public final void setNextExpirable(ReferenceEntry<K, V> next) {
            this.nextExpirable = next;
        }

        @Override
        public final ReferenceEntry<K, V> getPreviousExpirable() {
            return this.previousExpirable;
        }

        @Override
        public final void setPreviousExpirable(ReferenceEntry<K, V> previous) {
            this.previousExpirable = previous;
        }
    }

    static class StrongEntry<K, V>
    implements ReferenceEntry<K, V> {
        private K key;
        private int hash;
        private ReferenceEntry<K, V> next;
        private volatile ValueReference<K, V> valueReference = MapMakerInternalMap.unset();

        StrongEntry(K key, int hash, @Nullable ReferenceEntry<K, V> next) {
            this.key = key;
            this.hash = hash;
            this.next = next;
        }

        @Override
        public final K getKey() {
            return this.key;
        }

        @Override
        public long getExpirationTime() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setExpirationTime(long time) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ReferenceEntry<K, V> getNextExpirable() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setNextExpirable(ReferenceEntry<K, V> next) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ReferenceEntry<K, V> getPreviousExpirable() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setPreviousExpirable(ReferenceEntry<K, V> previous) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ReferenceEntry<K, V> getNextEvictable() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setNextEvictable(ReferenceEntry<K, V> next) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ReferenceEntry<K, V> getPreviousEvictable() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setPreviousEvictable(ReferenceEntry<K, V> previous) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final ValueReference<K, V> getValueReference() {
            return this.valueReference;
        }

        @Override
        public final void setValueReference(ValueReference<K, V> valueReference) {
            ValueReference<K, V> previous = this.valueReference;
            this.valueReference = valueReference;
            previous.clear(valueReference);
        }

        @Override
        public final int getHash() {
            return this.hash;
        }

        @Override
        public final ReferenceEntry<K, V> getNext() {
            return this.next;
        }
    }

    static abstract class AbstractReferenceEntry<K, V>
    implements ReferenceEntry<K, V> {
        AbstractReferenceEntry() {
        }

        @Override
        public final ValueReference<K, V> getValueReference() {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void setValueReference(ValueReference<K, V> valueReference) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final ReferenceEntry<K, V> getNext() {
            throw new UnsupportedOperationException();
        }

        @Override
        public final int getHash() {
            throw new UnsupportedOperationException();
        }

        @Override
        public final K getKey() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long getExpirationTime() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setExpirationTime(long time) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ReferenceEntry<K, V> getNextExpirable() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setNextExpirable(ReferenceEntry<K, V> next) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ReferenceEntry<K, V> getPreviousExpirable() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setPreviousExpirable(ReferenceEntry<K, V> previous) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ReferenceEntry<K, V> getNextEvictable() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setNextEvictable(ReferenceEntry<K, V> next) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ReferenceEntry<K, V> getPreviousEvictable() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setPreviousEvictable(ReferenceEntry<K, V> previous) {
            throw new UnsupportedOperationException();
        }
    }

    static final class NullEntry
    extends Enum<NullEntry>
    implements ReferenceEntry<Object, Object> {
        public static final /* enum */ NullEntry INSTANCE;

        @Override
        public final ValueReference<Object, Object> getValueReference() {
            return null;
        }

        @Override
        public final void setValueReference(ValueReference<Object, Object> valueReference) {
        }

        @Override
        public final ReferenceEntry<Object, Object> getNext() {
            return null;
        }

        @Override
        public final int getHash() {
            return 0;
        }

        @Override
        public final Object getKey() {
            return null;
        }

        @Override
        public final long getExpirationTime() {
            return 0L;
        }

        @Override
        public final void setExpirationTime(long time) {
        }

        @Override
        public final ReferenceEntry<Object, Object> getNextExpirable() {
            return this;
        }

        @Override
        public final void setNextExpirable(ReferenceEntry<Object, Object> next) {
        }

        @Override
        public final ReferenceEntry<Object, Object> getPreviousExpirable() {
            return this;
        }

        @Override
        public final void setPreviousExpirable(ReferenceEntry<Object, Object> previous) {
        }

        @Override
        public final ReferenceEntry<Object, Object> getNextEvictable() {
            return this;
        }

        @Override
        public final void setNextEvictable(ReferenceEntry<Object, Object> next) {
        }

        @Override
        public final ReferenceEntry<Object, Object> getPreviousEvictable() {
            return this;
        }

        @Override
        public final void setPreviousEvictable(ReferenceEntry<Object, Object> previous) {
        }

        static {
            (new NullEntry[1])[0] = INSTANCE = new NullEntry();
        }
    }

    static interface ReferenceEntry<K, V> {
        public ValueReference<K, V> getValueReference();

        public void setValueReference(ValueReference<K, V> var1);

        public ReferenceEntry<K, V> getNext();

        public int getHash();

        public K getKey();

        public long getExpirationTime();

        public void setExpirationTime(long var1);

        public ReferenceEntry<K, V> getNextExpirable();

        public void setNextExpirable(ReferenceEntry<K, V> var1);

        public ReferenceEntry<K, V> getPreviousExpirable();

        public void setPreviousExpirable(ReferenceEntry<K, V> var1);

        public ReferenceEntry<K, V> getNextEvictable();

        public void setNextEvictable(ReferenceEntry<K, V> var1);

        public ReferenceEntry<K, V> getPreviousEvictable();

        public void setPreviousEvictable(ReferenceEntry<K, V> var1);
    }

    static interface ValueReference<K, V> {
        public V get();

        public V waitForValue() throws ExecutionException;

        public ReferenceEntry<K, V> getEntry();

        public ValueReference<K, V> copyFor(ReferenceQueue<V> var1, @Nullable V var2, ReferenceEntry<K, V> var3);

        public void clear(@Nullable ValueReference<K, V> var1);

        public boolean isComputingReference();
    }

    static abstract class EntryFactory
    extends Enum<EntryFactory> {
        private static /* enum */ EntryFactory STRONG = new EntryFactory(){

            @Override
            final <K, V> ReferenceEntry<K, V> newEntry(Segment<K, V> segment, K key, int hash, @Nullable ReferenceEntry<K, V> next) {
                return new StrongEntry<K, V>(key, hash, next);
            }
        };
        private static /* enum */ EntryFactory STRONG_EXPIRABLE = new EntryFactory(){

            @Override
            final <K, V> ReferenceEntry<K, V> newEntry(Segment<K, V> segment, K key, int hash, @Nullable ReferenceEntry<K, V> next) {
                return new StrongExpirableEntry<K, V>(key, hash, next);
            }

            @Override
            final <K, V> ReferenceEntry<K, V> copyEntry(Segment<K, V> segment, ReferenceEntry<K, V> original, ReferenceEntry<K, V> newNext) {
                ReferenceEntry<K, V> newEntry = super.copyEntry(segment, original, newNext);
                2.copyExpirableEntry(original, newEntry);
                return newEntry;
            }
        };
        private static /* enum */ EntryFactory STRONG_EVICTABLE = new EntryFactory(){

            @Override
            final <K, V> ReferenceEntry<K, V> newEntry(Segment<K, V> segment, K key, int hash, @Nullable ReferenceEntry<K, V> next) {
                return new StrongEvictableEntry<K, V>(key, hash, next);
            }

            @Override
            final <K, V> ReferenceEntry<K, V> copyEntry(Segment<K, V> segment, ReferenceEntry<K, V> original, ReferenceEntry<K, V> newNext) {
                ReferenceEntry<K, V> newEntry = super.copyEntry(segment, original, newNext);
                3.copyEvictableEntry(original, newEntry);
                return newEntry;
            }
        };
        private static /* enum */ EntryFactory STRONG_EXPIRABLE_EVICTABLE = new EntryFactory(){

            @Override
            final <K, V> ReferenceEntry<K, V> newEntry(Segment<K, V> segment, K key, int hash, @Nullable ReferenceEntry<K, V> next) {
                return new StrongExpirableEvictableEntry<K, V>(key, hash, next);
            }

            @Override
            final <K, V> ReferenceEntry<K, V> copyEntry(Segment<K, V> segment, ReferenceEntry<K, V> original, ReferenceEntry<K, V> newNext) {
                ReferenceEntry<K, V> newEntry = super.copyEntry(segment, original, newNext);
                4.copyExpirableEntry(original, newEntry);
                4.copyEvictableEntry(original, newEntry);
                return newEntry;
            }
        };
        private static /* enum */ EntryFactory SOFT = new EntryFactory(){

            @Override
            final <K, V> ReferenceEntry<K, V> newEntry(Segment<K, V> segment, K key, int hash, @Nullable ReferenceEntry<K, V> next) {
                return new SoftEntry(segment.keyReferenceQueue, key, hash, next);
            }
        };
        private static /* enum */ EntryFactory SOFT_EXPIRABLE = new EntryFactory(){

            @Override
            final <K, V> ReferenceEntry<K, V> newEntry(Segment<K, V> segment, K key, int hash, @Nullable ReferenceEntry<K, V> next) {
                return new SoftExpirableEntry(segment.keyReferenceQueue, key, hash, next);
            }

            @Override
            final <K, V> ReferenceEntry<K, V> copyEntry(Segment<K, V> segment, ReferenceEntry<K, V> original, ReferenceEntry<K, V> newNext) {
                ReferenceEntry<K, V> newEntry = super.copyEntry(segment, original, newNext);
                6.copyExpirableEntry(original, newEntry);
                return newEntry;
            }
        };
        private static /* enum */ EntryFactory SOFT_EVICTABLE = new EntryFactory(){

            @Override
            final <K, V> ReferenceEntry<K, V> newEntry(Segment<K, V> segment, K key, int hash, @Nullable ReferenceEntry<K, V> next) {
                return new SoftEvictableEntry(segment.keyReferenceQueue, key, hash, next);
            }

            @Override
            final <K, V> ReferenceEntry<K, V> copyEntry(Segment<K, V> segment, ReferenceEntry<K, V> original, ReferenceEntry<K, V> newNext) {
                ReferenceEntry<K, V> newEntry = super.copyEntry(segment, original, newNext);
                7.copyEvictableEntry(original, newEntry);
                return newEntry;
            }
        };
        private static /* enum */ EntryFactory SOFT_EXPIRABLE_EVICTABLE = new EntryFactory(){

            @Override
            final <K, V> ReferenceEntry<K, V> newEntry(Segment<K, V> segment, K key, int hash, @Nullable ReferenceEntry<K, V> next) {
                return new SoftExpirableEvictableEntry(segment.keyReferenceQueue, key, hash, next);
            }

            @Override
            final <K, V> ReferenceEntry<K, V> copyEntry(Segment<K, V> segment, ReferenceEntry<K, V> original, ReferenceEntry<K, V> newNext) {
                ReferenceEntry<K, V> newEntry = super.copyEntry(segment, original, newNext);
                8.copyExpirableEntry(original, newEntry);
                8.copyEvictableEntry(original, newEntry);
                return newEntry;
            }
        };
        private static /* enum */ EntryFactory WEAK = new EntryFactory(){

            @Override
            final <K, V> ReferenceEntry<K, V> newEntry(Segment<K, V> segment, K key, int hash, @Nullable ReferenceEntry<K, V> next) {
                return new WeakEntry(segment.keyReferenceQueue, key, hash, next);
            }
        };
        private static /* enum */ EntryFactory WEAK_EXPIRABLE = new EntryFactory(){

            @Override
            final <K, V> ReferenceEntry<K, V> newEntry(Segment<K, V> segment, K key, int hash, @Nullable ReferenceEntry<K, V> next) {
                return new WeakExpirableEntry(segment.keyReferenceQueue, key, hash, next);
            }

            @Override
            final <K, V> ReferenceEntry<K, V> copyEntry(Segment<K, V> segment, ReferenceEntry<K, V> original, ReferenceEntry<K, V> newNext) {
                ReferenceEntry<K, V> newEntry = super.copyEntry(segment, original, newNext);
                10.copyExpirableEntry(original, newEntry);
                return newEntry;
            }
        };
        private static /* enum */ EntryFactory WEAK_EVICTABLE = new EntryFactory(){

            @Override
            final <K, V> ReferenceEntry<K, V> newEntry(Segment<K, V> segment, K key, int hash, @Nullable ReferenceEntry<K, V> next) {
                return new WeakEvictableEntry(segment.keyReferenceQueue, key, hash, next);
            }

            @Override
            final <K, V> ReferenceEntry<K, V> copyEntry(Segment<K, V> segment, ReferenceEntry<K, V> original, ReferenceEntry<K, V> newNext) {
                ReferenceEntry<K, V> newEntry = super.copyEntry(segment, original, newNext);
                11.copyEvictableEntry(original, newEntry);
                return newEntry;
            }
        };
        private static /* enum */ EntryFactory WEAK_EXPIRABLE_EVICTABLE = new EntryFactory(){

            @Override
            final <K, V> ReferenceEntry<K, V> newEntry(Segment<K, V> segment, K key, int hash, @Nullable ReferenceEntry<K, V> next) {
                return new WeakExpirableEvictableEntry(segment.keyReferenceQueue, key, hash, next);
            }

            @Override
            final <K, V> ReferenceEntry<K, V> copyEntry(Segment<K, V> segment, ReferenceEntry<K, V> original, ReferenceEntry<K, V> newNext) {
                ReferenceEntry<K, V> newEntry = super.copyEntry(segment, original, newNext);
                12.copyExpirableEntry(original, newEntry);
                12.copyEvictableEntry(original, newEntry);
                return newEntry;
            }
        };
        private static EntryFactory[][] factories;

        private EntryFactory() {
        }

        static EntryFactory getFactory(Strength keyStrength, boolean expireAfterWrite, boolean evictsBySize) {
            int flags = (expireAfterWrite ? 1 : 0) | (evictsBySize ? 2 : 0);
            return factories[keyStrength.ordinal()][flags];
        }

        abstract <K, V> ReferenceEntry<K, V> newEntry(Segment<K, V> var1, K var2, int var3, @Nullable ReferenceEntry<K, V> var4);

        @GuardedBy(value="Segment.this")
        <K, V> ReferenceEntry<K, V> copyEntry(Segment<K, V> segment, ReferenceEntry<K, V> original, ReferenceEntry<K, V> newNext) {
            return this.newEntry(segment, original.getKey(), original.getHash(), newNext);
        }

        @GuardedBy(value="Segment.this")
        static <K, V> void copyExpirableEntry(ReferenceEntry<K, V> original, ReferenceEntry<K, V> newEntry) {
            newEntry.setExpirationTime(original.getExpirationTime());
            MapMakerInternalMap.connectExpirables(original.getPreviousExpirable(), newEntry);
            MapMakerInternalMap.connectExpirables(newEntry, original.getNextExpirable());
            MapMakerInternalMap.nullifyExpirable(original);
        }

        @GuardedBy(value="Segment.this")
        static <K, V> void copyEvictableEntry(ReferenceEntry<K, V> original, ReferenceEntry<K, V> newEntry) {
            MapMakerInternalMap.connectEvictables(original.getPreviousEvictable(), newEntry);
            MapMakerInternalMap.connectEvictables(newEntry, original.getNextEvictable());
            MapMakerInternalMap.nullifyEvictable(original);
        }

        /* synthetic */ EntryFactory(String x0, int x1, byte by) {
            this();
        }

        static {
            EntryFactory[] entryFactoryArray = new EntryFactory[]{STRONG, STRONG_EXPIRABLE, STRONG_EVICTABLE, STRONG_EXPIRABLE_EVICTABLE, SOFT, SOFT_EXPIRABLE, SOFT_EVICTABLE, SOFT_EXPIRABLE_EVICTABLE, WEAK, WEAK_EXPIRABLE, WEAK_EVICTABLE, WEAK_EXPIRABLE_EVICTABLE};
            factories = new EntryFactory[][]{{STRONG, STRONG_EXPIRABLE, STRONG_EVICTABLE, STRONG_EXPIRABLE_EVICTABLE}, {SOFT, SOFT_EXPIRABLE, SOFT_EVICTABLE, SOFT_EXPIRABLE_EVICTABLE}, {WEAK, WEAK_EXPIRABLE, WEAK_EVICTABLE, WEAK_EXPIRABLE_EVICTABLE}};
        }
    }

    static abstract class Strength
    extends Enum<Strength> {
        public static final /* enum */ Strength STRONG = new Strength(){

            @Override
            final <K, V> ValueReference<K, V> referenceValue(Segment<K, V> segment, ReferenceEntry<K, V> entry, V value) {
                return new StrongValueReference(value);
            }

            @Override
            final Equivalence<Object> defaultEquivalence() {
                return Equivalence.equals();
            }
        };
        private static /* enum */ Strength SOFT = new Strength(){

            @Override
            final <K, V> ValueReference<K, V> referenceValue(Segment<K, V> segment, ReferenceEntry<K, V> entry, V value) {
                return new SoftValueReference(segment.valueReferenceQueue, value, entry);
            }

            @Override
            final Equivalence<Object> defaultEquivalence() {
                return Equivalence.identity();
            }
        };
        public static final /* enum */ Strength WEAK = new Strength(){

            @Override
            final <K, V> ValueReference<K, V> referenceValue(Segment<K, V> segment, ReferenceEntry<K, V> entry, V value) {
                return new WeakValueReference(segment.valueReferenceQueue, value, entry);
            }

            @Override
            final Equivalence<Object> defaultEquivalence() {
                return Equivalence.identity();
            }
        };

        private Strength() {
        }

        abstract <K, V> ValueReference<K, V> referenceValue(Segment<K, V> var1, ReferenceEntry<K, V> var2, V var3);

        abstract Equivalence<Object> defaultEquivalence();

        /* synthetic */ Strength(String x0, int x1, byte by) {
            this();
        }

        static {
            Strength[] strengthArray = new Strength[]{STRONG, SOFT, WEAK};
        }
    }
}

