/*
 * Decompiled with CFR 0.152.
 */
package org.python.core.buffer;

import org.python.core.PyBuffer;
import org.python.core.buffer.SimpleBuffer;
import org.python.core.buffer.ZeroByteBuffer;
import org.python.core.util.StringUtil;

public class SimpleStringBuffer
extends SimpleBuffer {
    private String bufString;

    public SimpleStringBuffer(int flags, String bufString) {
        this.bufString = bufString;
        this.shape[0] = bufString.length();
        this.checkRequestFlags(flags);
    }

    @Override
    public int getLen() {
        return this.bufString.length();
    }

    @Override
    public byte byteAt(int index) throws IndexOutOfBoundsException {
        return (byte)this.bufString.charAt(index);
    }

    @Override
    public int intAt(int index) throws IndexOutOfBoundsException {
        return this.bufString.charAt(index);
    }

    @Override
    public void copyTo(int srcIndex, byte[] dest, int destPos, int length) throws IndexOutOfBoundsException {
        int endIndex = srcIndex + length;
        int p = destPos;
        for (int i = srcIndex; i < endIndex; ++i) {
            dest[p++] = (byte)this.bufString.charAt(i);
        }
    }

    @Override
    public PyBuffer getBufferSlice(int flags, int start, int length) {
        if (length > 0) {
            return new SimpleStringView(this.getRoot(), flags, this.bufString.substring(start, start + length));
        }
        return new ZeroByteBuffer.View(this.getRoot(), flags);
    }

    @Override
    public PyBuffer getBufferSlice(int flags, int start, int length, int stride) {
        if (stride == 1) {
            return this.getBufferSlice(flags, start, length);
        }
        this.getBuf();
        return super.getBufferSlice(flags, start, length, stride);
    }

    private void ensureHaveBytes() {
        if (this.storage == null) {
            this.storage = StringUtil.toBytes(this.bufString);
        }
    }

    @Override
    public PyBuffer.Pointer getBuf() {
        this.ensureHaveBytes();
        return super.getBuf();
    }

    @Override
    public PyBuffer.Pointer getPointer(int index) {
        this.ensureHaveBytes();
        return super.getPointer(index);
    }

    @Override
    public PyBuffer.Pointer getPointer(int ... indices) {
        this.ensureHaveBytes();
        return super.getPointer(indices);
    }

    @Override
    public String toString() {
        return this.bufString;
    }

    static class SimpleStringView
    extends SimpleStringBuffer {
        private PyBuffer root;

        public SimpleStringView(PyBuffer root, int flags, String bufString) {
            super(flags, bufString);
            this.root = root.getBuffer(284);
        }

        @Override
        protected PyBuffer getRoot() {
            return this.root;
        }

        @Override
        public void releaseAction() {
            this.root.release();
        }
    }
}

