/*
 * Decompiled with CFR 0.152.
 */
package jnr.ffi.provider.jffi;

import com.kenai.jffi.CallContext;
import com.kenai.jffi.Closure;
import com.kenai.jffi.ClosureMagazine;
import com.kenai.jffi.ClosureManager;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import jnr.ffi.Pointer;
import jnr.ffi.annotations.Delegate;
import jnr.ffi.mapper.TypeMapper;
import jnr.ffi.provider.jffi.ClosureUtil;
import jnr.ffi.provider.jffi.FromNativeType;
import jnr.ffi.provider.jffi.InvokerUtil;
import jnr.ffi.provider.jffi.NativeClosurePointer;
import jnr.ffi.provider.jffi.NativeClosureProxy;
import jnr.ffi.provider.jffi.NativeFinalizer;
import jnr.ffi.provider.jffi.NativeRuntime;
import jnr.ffi.provider.jffi.SigType;
import jnr.ffi.provider.jffi.ToNativeType;
import jnr.ffi.util.ref.FinalizableWeakReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NativeClosureFactory<T> {
    private final NativeRuntime runtime;
    private final ConcurrentMap<Integer, ClosureReference> closures = new ConcurrentHashMap<Integer, ClosureReference>();
    private final CallContext callContext;
    private final NativeClosureProxy.Factory closureProxyFactory;
    private final ConcurrentLinkedQueue<NativeClosurePointer> freeQueue = new ConcurrentLinkedQueue();
    private ClosureMagazine currentMagazine;

    protected NativeClosureFactory(NativeRuntime runtime, CallContext callContext, NativeClosureProxy.Factory closureProxyFactory) {
        this.runtime = runtime;
        this.closureProxyFactory = closureProxyFactory;
        this.callContext = callContext;
    }

    static <T> NativeClosureFactory newClosureFactory(NativeRuntime runtime, Class<T> closureClass, TypeMapper typeMapper) {
        Method callMethod = null;
        for (Method m : closureClass.getMethods()) {
            if (!m.isAnnotationPresent(Delegate.class) || !Modifier.isPublic(m.getModifiers()) || Modifier.isStatic(m.getModifiers())) continue;
            callMethod = m;
            break;
        }
        if (callMethod == null) {
            throw new NoSuchMethodError("no public non-static delegate method defined in " + closureClass.getName());
        }
        Class<?>[] parameterTypes = callMethod.getParameterTypes();
        SigType[] parameterSigTypes = new FromNativeType[parameterTypes.length];
        for (int i = 0; i < parameterTypes.length; ++i) {
            parameterSigTypes[i] = ClosureUtil.getParameterType(runtime, callMethod, i, typeMapper);
        }
        ToNativeType resultType = ClosureUtil.getResultType(runtime, callMethod, typeMapper);
        return new NativeClosureFactory<T>(runtime, InvokerUtil.getCallContext(resultType, parameterSigTypes, InvokerUtil.getNativeCallingConvention(callMethod), false), NativeClosureProxy.newProxyFactory(runtime, callMethod, resultType, (FromNativeType[])parameterSigTypes));
    }

    private void expunge(ClosureReference ref, Integer key) {
        if (ref.next == null && this.closures.remove(key, ref)) {
            return;
        }
        ConcurrentMap<Integer, ClosureReference> concurrentMap = this.closures;
        synchronized (concurrentMap) {
            ClosureReference clref;
            ClosureReference prev = clref = (ClosureReference)this.closures.get(key);
            while (clref != null) {
                if (clref == ref) {
                    if (prev != clref) {
                        prev.next = clref.next;
                        break;
                    }
                    if (clref.next != null) {
                        this.closures.replace(key, clref, clref.next);
                        break;
                    }
                    this.closures.remove(key, clref);
                    break;
                }
                prev = clref;
                clref = clref.next;
            }
            return;
        }
    }

    private void recycle(NativeClosurePointer ptr) {
        this.freeQueue.add(ptr);
    }

    private NativeClosurePointer allocateClosurePointer() {
        NativeClosurePointer closurePointer = this.freeQueue.poll();
        if (closurePointer != null) {
            return closurePointer;
        }
        NativeClosureProxy proxy = this.closureProxyFactory.newClosureProxy();
        Closure.Handle closureHandle = null;
        NativeClosureFactory nativeClosureFactory = this;
        synchronized (nativeClosureFactory) {
            do {
                if (this.currentMagazine != null && (closureHandle = this.currentMagazine.allocate(proxy)) != null) continue;
                ClosureManager.getInstance();
                this.currentMagazine = ClosureManager.newClosureMagazine(this.callContext, this.closureProxyFactory.getInvokeMethod());
            } while (closureHandle == null);
        }
        return new NativeClosurePointer(this.runtime, closureHandle, proxy);
    }

    private ClosureReference newClosureReference(Object callable, Integer key) {
        ClosureReference ref;
        NativeClosurePointer ptr = this.allocateClosurePointer();
        ptr.proxy.closureReference = ref = new ClosureReference(this, callable, key, this, ptr, 0);
        if (this.closures.putIfAbsent(key, ref) == null) {
            return ref;
        }
        ConcurrentMap<Integer, ClosureReference> concurrentMap = this.closures;
        synchronized (concurrentMap) {
            do {
                ref.next = (ClosureReference)this.closures.get(key);
            } while ((ref.next != null || this.closures.putIfAbsent(key, ref) != null) && !this.closures.replace(key, ref.next, ref));
        }
        return ref;
    }

    final ClosureReference getClosureReference(Object callable) {
        Integer key = System.identityHashCode(callable);
        ClosureReference ref = (ClosureReference)this.closures.get(key);
        if (ref != null) {
            ClosureReference closureReference = ref;
            if (closureReference.get() == callable) {
                return ref;
            }
            ConcurrentMap<Integer, ClosureReference> concurrentMap = this.closures;
            synchronized (concurrentMap) {
                while ((ref = ref.next) != null) {
                    closureReference = ref;
                    if (closureReference.get() != callable) continue;
                    return ref;
                }
            }
        }
        return this.newClosureReference(callable, key);
    }

    static class 1 {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class ClosureReference
    extends FinalizableWeakReference<Object> {
        volatile ClosureReference next;
        private final NativeClosureFactory factory;
        private final NativeClosurePointer pointer;
        private final Integer key;
        private /* synthetic */ NativeClosureFactory this$0;

        private ClosureReference(NativeClosureFactory nativeClosureFactory, Object referent, Integer key, NativeClosureFactory factory, NativeClosurePointer pointer) {
            super(referent, NativeFinalizer.getInstance().getFinalizerQueue());
            this.factory = factory;
            this.key = key;
            this.pointer = pointer;
        }

        @Override
        public final void finalizeReferent() {
            this.clear();
            this.factory.expunge(this, this.key);
            this.factory.recycle(this.pointer);
        }

        final Pointer getPointer() {
            return this.pointer;
        }

        /* synthetic */ ClosureReference(NativeClosureFactory x0, Object x1, Integer x2, NativeClosureFactory x3, NativeClosurePointer x4, byte by) {
            this(x0, x1, x2, x3, x4);
        }
    }
}

