/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jffi;

import com.kenai.jffi.CallContext;
import com.kenai.jffi.Closure;
import com.kenai.jffi.Foreign;
import com.kenai.jffi.MemoryIO;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class ClosureMagazine {
    private final Foreign foreign;
    private final long magazineAddress;
    private final AtomicBoolean disposed = new AtomicBoolean(false);

    ClosureMagazine(Foreign foreign, CallContext callContext, long magazineAddress) {
        this.foreign = foreign;
        this.magazineAddress = magazineAddress;
    }

    public final Closure.Handle allocate(Object proxy) {
        long closureAddress = this.foreign.closureMagazineGet(this.magazineAddress, proxy);
        if (closureAddress != 0L) {
            return new Closure.Handle(this, closureAddress, MemoryIO.getInstance().getAddress(closureAddress), 0);
        }
        return null;
    }

    protected final void finalize() throws Throwable {
        try {
            if (this.magazineAddress != 0L && !this.disposed.getAndSet(true)) {
                this.foreign.freeClosureMagazine(this.magazineAddress);
            }
            return;
        }
        catch (Throwable t) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "exception when freeing " + this.getClass() + ": %s", t.getLocalizedMessage());
            return;
        }
        finally {
            super.finalize();
        }
    }
}

