/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.util.html;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.grinder.util.html.AbstractHTMLNode;
import net.grinder.util.html.HTMLText;

public class HTMLElement
extends AbstractHTMLNode {
    private final String m_name;
    private final List m_children = new ArrayList();

    public HTMLElement(String name) {
        this.m_name = name;
    }

    public HTMLElement() {
        this.m_name = null;
    }

    public final HTMLElement addElement(String childText) {
        HTMLElement child = new HTMLElement(childText);
        this.m_children.add(child);
        return child;
    }

    public final void addText(String text) {
        this.m_children.add(new HTMLText(text));
    }

    protected final void toStringBuffer(StringBuffer buffer, boolean html) {
        if (this.m_children.size() > 0) {
            if (!this.isFragment() && html) {
                buffer.append('<');
                buffer.append(this.m_name);
                buffer.append(">");
            }
            Iterator iterator = this.m_children.iterator();
            while (iterator.hasNext()) {
                ((AbstractHTMLNode)iterator.next()).toStringBuffer(buffer, html);
            }
            if (!this.isFragment()) {
                if (html) {
                    buffer.append("</");
                    buffer.append(this.m_name);
                    buffer.append(">");
                } else if (this.isNewLineElement()) {
                    buffer.append("\n");
                }
            }
        } else if (!this.isFragment()) {
            if (html) {
                buffer.append("<");
                buffer.append(this.m_name);
                buffer.append("/>");
            } else if (this.isNewLineElement()) {
                buffer.append("\n");
            }
        }
    }

    private boolean isNewLineElement() {
        return this.m_name.equalsIgnoreCase("p") || this.m_name.equalsIgnoreCase("br");
    }

    private boolean isFragment() {
        return this.m_name == null;
    }
}

