/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.util.Arrays;
import java.util.Iterator;
import org.apache.lucene.search.DisiWrapper;
import org.apache.lucene.search.DocIdSetIterator;

public final class DisiPriorityQueue<Iter extends DocIdSetIterator>
implements Iterable<DisiWrapper<Iter>> {
    private final DisiWrapper<Iter>[] heap;
    private int size;

    static int leftNode(int node) {
        return (node + 1 << 1) - 1;
    }

    static int rightNode(int leftNode) {
        return leftNode + 1;
    }

    static int parentNode(int node) {
        return (node + 1 >>> 1) - 1;
    }

    public DisiPriorityQueue(int maxSize) {
        this.heap = new DisiWrapper[maxSize];
        this.size = 0;
    }

    public int size() {
        return this.size;
    }

    public DisiWrapper<Iter> top() {
        return this.heap[0];
    }

    public DisiWrapper<Iter> topList() {
        DisiWrapper<Iter>[] heap = this.heap;
        int size = this.size;
        DisiWrapper<Iter> list = heap[0];
        list.next = null;
        if (size >= 3) {
            list = this.topList(list, heap, size, 1);
            list = this.topList(list, heap, size, 2);
        } else if (size == 2 && heap[1].doc == list.doc) {
            list = this.prepend(heap[1], list);
        }
        return list;
    }

    private DisiWrapper<Iter> prepend(DisiWrapper<Iter> w1, DisiWrapper<Iter> w2) {
        w1.next = w2;
        return w1;
    }

    private DisiWrapper<Iter> topList(DisiWrapper<Iter> list, DisiWrapper<Iter>[] heap, int size, int i) {
        DisiWrapper<Iter> w = heap[i];
        if (w.doc == list.doc) {
            list = this.prepend(w, list);
            int left = DisiPriorityQueue.leftNode(i);
            int right = left + 1;
            if (right < size) {
                list = this.topList(list, heap, size, left);
                list = this.topList(list, heap, size, right);
            } else if (left < size && heap[left].doc == list.doc) {
                list = this.prepend(heap[left], list);
            }
        }
        return list;
    }

    public DisiWrapper<Iter> add(DisiWrapper<Iter> entry) {
        DisiWrapper<Iter>[] heap = this.heap;
        int size = this.size;
        heap[size] = entry;
        this.upHeap(size);
        this.size = size + 1;
        return heap[0];
    }

    public DisiWrapper<Iter> pop() {
        DisiWrapper<Iter>[] heap = this.heap;
        DisiWrapper<Iter> result = heap[0];
        int i = --this.size;
        heap[0] = heap[i];
        heap[i] = null;
        this.downHeap(i);
        return result;
    }

    public DisiWrapper<Iter> updateTop() {
        this.downHeap(this.size);
        return this.heap[0];
    }

    DisiWrapper<Iter> updateTop(DisiWrapper<Iter> topReplacement) {
        this.heap[0] = topReplacement;
        return this.updateTop();
    }

    void upHeap(int i) {
        DisiWrapper<Iter> node = this.heap[i];
        int nodeDoc = node.doc;
        int j = DisiPriorityQueue.parentNode(i);
        while (j >= 0 && nodeDoc < this.heap[j].doc) {
            this.heap[i] = this.heap[j];
            i = j;
            j = DisiPriorityQueue.parentNode(j);
        }
        this.heap[i] = node;
    }

    void downHeap(int size) {
        int i = 0;
        DisiWrapper<Iter> node = this.heap[0];
        int j = DisiPriorityQueue.leftNode(i);
        if (j < size) {
            int k = DisiPriorityQueue.rightNode(j);
            if (k < size && this.heap[k].doc < this.heap[j].doc) {
                j = k;
            }
            if (this.heap[j].doc < node.doc) {
                do {
                    this.heap[i] = this.heap[j];
                    i = j;
                    k = DisiPriorityQueue.rightNode(j = DisiPriorityQueue.leftNode(i));
                    if (k >= size || this.heap[k].doc >= this.heap[j].doc) continue;
                    j = k;
                } while (j < size && this.heap[j].doc < node.doc);
                this.heap[i] = node;
            }
        }
    }

    @Override
    public Iterator<DisiWrapper<Iter>> iterator() {
        return Arrays.asList(this.heap).subList(0, this.size).iterator();
    }
}

