/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.plugin.http;

import HTTPClient.HTTPConnection;
import HTTPClient.HTTPResponse;
import HTTPClient.HttpOutputStream;
import HTTPClient.ModuleException;
import HTTPClient.NVPair;
import HTTPClient.ParseException;
import HTTPClient.ProtocolNotSuppException;
import HTTPClient.URI;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.grinder.common.GrinderException;
import net.grinder.common.Logger;
import net.grinder.plugin.http.HTTPPlugin;
import net.grinder.plugin.http.HTTPPluginThreadState;
import net.grinder.plugin.http.TimeoutException;
import net.grinder.plugin.http.URLException;
import net.grinder.plugininterface.PluginException;
import net.grinder.plugininterface.PluginProcessContext;
import net.grinder.plugininterface.PluginThreadContext;
import net.grinder.script.Grinder;
import net.grinder.script.InvalidContextException;
import net.grinder.script.Statistics;
import net.grinder.util.StreamCopier;

public class HTTPRequest {
    private static final Pattern s_pathParser;
    private static final Pattern s_absoluteURIPattern;
    private volatile URI m_defaultURL;
    private volatile NVPair[] m_defaultHeaders = new NVPair[0];
    private volatile byte[] m_defaultData;
    private volatile NVPair[] m_defaultFormData;
    private volatile boolean m_readResponseBody = true;

    public final String getUrl() {
        URI url = this.m_defaultURL;
        return url != null ? url.toString() : null;
    }

    public final void setUrl(String url) throws ParseException, URLException {
        if (!HTTPRequest.isAbsolute(url)) {
            throw new URLException("URL must be absolute");
        }
        this.m_defaultURL = new URI(url);
    }

    public final NVPair[] getHeaders() {
        return this.m_defaultHeaders;
    }

    private NVPair[] mergeArrays(NVPair[] defaultPairs, NVPair[] overridePairs) {
        int i;
        if (defaultPairs.length == 0) {
            return overridePairs;
        }
        if (overridePairs.length == 0) {
            return defaultPairs;
        }
        NVPair[] result = new NVPair[defaultPairs.length + overridePairs.length];
        HashSet<String> seen = new HashSet<String>();
        for (i = 0; i < overridePairs.length; ++i) {
            result[i] = overridePairs[i];
            seen.add(overridePairs[i].getName());
        }
        for (i = 0; i < defaultPairs.length; ++i) {
            if (seen.contains(defaultPairs[i].getName())) continue;
            result[overridePairs.length + i] = defaultPairs[i];
        }
        return result;
    }

    private NVPair[] mergeHeaders(NVPair[] headers) {
        return this.mergeArrays(this.getHeaders(), headers);
    }

    public final void setHeaders(NVPair[] headers) {
        this.m_defaultHeaders = headers;
    }

    public String toString() {
        StringBuffer result = new StringBuffer("");
        URI url = this.m_defaultURL;
        if (url == null) {
            result.append("<Undefined URL>\n");
        } else {
            result.append(url.toString());
            result.append("\n");
        }
        NVPair[] defaultHeaders = this.m_defaultHeaders;
        for (int i = 0; i < defaultHeaders.length; ++i) {
            result.append(defaultHeaders[i].getName());
            result.append(": ");
            result.append(defaultHeaders[i].getValue());
            result.append("\n");
        }
        return result.toString();
    }

    public final byte[] getData() {
        return this.m_defaultData;
    }

    public final void setData(byte[] data) {
        this.m_defaultData = data;
    }

    public final byte[] setDataFromFile(String filename) throws IOException {
        File file = new File(filename);
        ByteArrayOutputStream byteArrayStream = new ByteArrayOutputStream((int)file.length());
        new StreamCopier(4096, true).copy(new FileInputStream(file), byteArrayStream);
        byte[] defaultData = byteArrayStream.toByteArray();
        this.m_defaultData = defaultData;
        return defaultData;
    }

    public final NVPair[] getFormData() {
        return this.m_defaultFormData;
    }

    public final void setFormData(NVPair[] formData) {
        this.m_defaultFormData = formData;
    }

    public boolean getReadResponseBody() {
        return this.m_readResponseBody;
    }

    public void setReadResponseBody(boolean b) {
        this.m_readResponseBody = b;
    }

    public final HTTPResponse DELETE() throws Exception {
        return this.DELETE(null, this.getHeaders());
    }

    public final HTTPResponse DELETE(String uri) throws Exception {
        return this.DELETE(uri, this.getHeaders());
    }

    public final HTTPResponse DELETE(String uri, final NVPair[] headers) throws Exception {
        return new AbstractRequest(uri){

            HTTPResponse doRequest(HTTPConnection connection, String path) throws IOException, ModuleException {
                return connection.Delete(path, HTTPRequest.this.mergeHeaders(headers));
            }
        }.getHTTPResponse();
    }

    public final HTTPResponse GET() throws Exception {
        return this.GET((String)null);
    }

    public final HTTPResponse GET(String uri) throws Exception {
        return this.GET(uri, this.getFormData(), this.getHeaders());
    }

    public final HTTPResponse GET(NVPair[] queryData) throws Exception {
        return this.GET(null, queryData, this.getHeaders());
    }

    public final HTTPResponse GET(String uri, NVPair[] queryData) throws Exception {
        return this.GET(uri, queryData, this.getHeaders());
    }

    public final HTTPResponse GET(String uri, final NVPair[] queryData, final NVPair[] headers) throws Exception {
        return new AbstractRequest(uri){

            HTTPResponse doRequest(HTTPConnection connection, String path) throws IOException, ModuleException {
                return connection.Get(path, queryData, HTTPRequest.this.mergeHeaders(headers));
            }
        }.getHTTPResponse();
    }

    public final HTTPResponse HEAD() throws Exception {
        return this.HEAD(null, this.getFormData(), this.getHeaders());
    }

    public final HTTPResponse HEAD(String uri) throws Exception {
        return this.HEAD(uri, this.getHeaders());
    }

    public final HTTPResponse HEAD(NVPair[] queryData) throws Exception {
        return this.HEAD(null, queryData, this.getHeaders());
    }

    public final HTTPResponse HEAD(String uri, NVPair[] queryData) throws Exception {
        return this.HEAD(uri, queryData, this.getHeaders());
    }

    public final HTTPResponse HEAD(String uri, final NVPair[] queryData, final NVPair[] headers) throws Exception {
        return new AbstractRequest(uri){

            HTTPResponse doRequest(HTTPConnection connection, String path) throws IOException, ModuleException {
                return connection.Head(path, queryData, HTTPRequest.this.mergeHeaders(headers));
            }
        }.getHTTPResponse();
    }

    public final HTTPResponse OPTIONS() throws Exception {
        return this.OPTIONS(null, this.getData(), this.getHeaders());
    }

    public final HTTPResponse OPTIONS(String uri) throws Exception {
        return this.OPTIONS(uri, this.getData(), this.getHeaders());
    }

    public final HTTPResponse OPTIONS(String uri, byte[] data) throws Exception {
        return this.OPTIONS(uri, data, this.getHeaders());
    }

    public final HTTPResponse OPTIONS(String uri, final byte[] data, final NVPair[] headers) throws Exception {
        return new AbstractRequest(uri){

            HTTPResponse doRequest(HTTPConnection connection, String path) throws IOException, ModuleException {
                return connection.Options(path, HTTPRequest.this.mergeHeaders(headers), data);
            }
        }.getHTTPResponse();
    }

    public final HTTPResponse OPTIONS(String uri, InputStream inputStream) throws Exception {
        return this.OPTIONS(uri, inputStream, this.getHeaders());
    }

    public final HTTPResponse OPTIONS(String uri, final InputStream inputStream, final NVPair[] headers) throws Exception {
        return new AbstractStreamingRequest(uri){

            InputStream getInputStream() {
                return inputStream;
            }

            HTTPResponse doStreamingRequest(HTTPConnection connection, String path, HttpOutputStream outputStream) throws IOException, ModuleException {
                return connection.Options(path, HTTPRequest.this.mergeHeaders(headers), outputStream);
            }
        }.getHTTPResponse();
    }

    public final HTTPResponse POST() throws Exception {
        return this.POST((String)null);
    }

    public final HTTPResponse POST(String uri) throws Exception {
        byte[] data = this.getData();
        if (data != null) {
            return this.POST(uri, data, this.getHeaders());
        }
        return this.POST(uri, this.getFormData(), this.getHeaders());
    }

    public final HTTPResponse POST(NVPair[] formData) throws Exception {
        return this.POST(null, formData, this.getHeaders());
    }

    public final HTTPResponse POST(String uri, NVPair[] formData) throws Exception {
        return this.POST(uri, formData, this.getHeaders());
    }

    public final HTTPResponse POST(String uri, final NVPair[] formData, final NVPair[] headers) throws Exception {
        return new AbstractRequest(uri){

            HTTPResponse doRequest(HTTPConnection connection, String path) throws IOException, ModuleException {
                return connection.Post(path, formData, HTTPRequest.this.mergeHeaders(headers));
            }
        }.getHTTPResponse();
    }

    public final HTTPResponse POST(String uri, byte[] data) throws Exception {
        return this.POST(uri, data, this.getHeaders());
    }

    public final HTTPResponse POST(String uri, final byte[] data, final NVPair[] headers) throws Exception {
        return new AbstractRequest(uri){

            HTTPResponse doRequest(HTTPConnection connection, String path) throws IOException, ModuleException {
                return connection.Post(path, data, HTTPRequest.this.mergeHeaders(headers));
            }
        }.getHTTPResponse();
    }

    public final HTTPResponse POST(String uri, InputStream inputStream) throws Exception {
        return this.POST(uri, inputStream, this.getHeaders());
    }

    public final HTTPResponse POST(String uri, final InputStream inputStream, final NVPair[] headers) throws Exception {
        return new AbstractStreamingRequest(uri){

            InputStream getInputStream() {
                return inputStream;
            }

            HTTPResponse doStreamingRequest(HTTPConnection connection, String path, HttpOutputStream outputStream) throws IOException, ModuleException {
                return connection.Post(path, outputStream, HTTPRequest.this.mergeHeaders(headers));
            }
        }.getHTTPResponse();
    }

    public final HTTPResponse PUT() throws Exception {
        return this.PUT(null, this.getData(), this.getHeaders());
    }

    public final HTTPResponse PUT(String uri) throws Exception {
        return this.PUT(uri, this.getData(), this.getHeaders());
    }

    public final HTTPResponse PUT(String uri, byte[] data) throws Exception {
        return this.PUT(uri, data, this.getHeaders());
    }

    public final HTTPResponse PUT(String uri, final byte[] data, final NVPair[] headers) throws Exception {
        return new AbstractRequest(uri){

            HTTPResponse doRequest(HTTPConnection connection, String path) throws IOException, ModuleException {
                return connection.Put(path, data, HTTPRequest.this.mergeHeaders(headers));
            }
        }.getHTTPResponse();
    }

    public final HTTPResponse PUT(String uri, InputStream inputStream) throws Exception {
        return this.PUT(uri, inputStream, this.getHeaders());
    }

    public final HTTPResponse PUT(String uri, final InputStream inputStream, final NVPair[] headers) throws Exception {
        return new AbstractStreamingRequest(uri){

            InputStream getInputStream() {
                return inputStream;
            }

            HTTPResponse doStreamingRequest(HTTPConnection connection, String path, HttpOutputStream outputStream) throws IOException, ModuleException {
                return connection.Put(path, outputStream, HTTPRequest.this.mergeHeaders(headers));
            }
        }.getHTTPResponse();
    }

    public final HTTPResponse TRACE() throws Exception {
        return this.TRACE(null, this.getHeaders());
    }

    public final HTTPResponse TRACE(String uri) throws Exception {
        return this.TRACE(uri, this.getHeaders());
    }

    public final HTTPResponse TRACE(String uri, final NVPair[] headers) throws Exception {
        return new AbstractRequest(uri){

            HTTPResponse doRequest(HTTPConnection connection, String path) throws IOException, ModuleException {
                return connection.Trace(path, HTTPRequest.this.mergeHeaders(headers));
            }
        }.getHTTPResponse();
    }

    protected void processResponse(HTTPResponse response) {
    }

    private static boolean isAbsolute(String uri) {
        return s_absoluteURIPattern.matcher(uri).matches();
    }

    static {
        HTTPPlugin.getPlugin();
        s_pathParser = Pattern.compile("([^?#]*)(\\?([^#]*))?(#(.*))?");
        s_absoluteURIPattern = Pattern.compile("^[^:/?#]*:.*");
    }

    private abstract class AbstractStreamingRequest
    extends AbstractRequest {
        public AbstractStreamingRequest(String uri) throws ParseException, URLException {
            super(uri);
        }

        HTTPResponse doRequest(HTTPConnection connection, String path) throws IOException, ModuleException {
            HttpOutputStream outputStream = new HttpOutputStream();
            HTTPResponse result = this.doStreamingRequest(connection, path, outputStream);
            new StreamCopier(4096, true).copy(this.getInputStream(), outputStream);
            return result;
        }

        abstract InputStream getInputStream();

        abstract HTTPResponse doStreamingRequest(HTTPConnection var1, String var2, HttpOutputStream var3) throws IOException, ModuleException;
    }

    private abstract class AbstractRequest {
        private final URI m_url;

        public AbstractRequest(String uri) throws ParseException, URLException {
            URI defaultURL = HTTPRequest.this.m_defaultURL;
            if (uri == null) {
                if (defaultURL == null) {
                    throw new URLException("URL not specified");
                }
                this.m_url = defaultURL;
            } else if (HTTPRequest.isAbsolute(uri)) {
                this.m_url = new URI(uri);
            } else {
                if (defaultURL == null) {
                    throw new URLException("URL must be absolute");
                }
                if (uri.startsWith("//")) {
                    Matcher matcher = s_pathParser.matcher(uri);
                    matcher.matches();
                    String path = matcher.group(1);
                    String query = matcher.group(2);
                    String fragment = matcher.group(3);
                    this.m_url = new URI(defaultURL.getScheme(), defaultURL.getUserinfo(), defaultURL.getHost(), defaultURL.getPort(), path, query, fragment);
                } else {
                    this.m_url = new URI(defaultURL, uri);
                }
            }
        }

        public final HTTPResponse getHTTPResponse() throws GrinderException, IOException, ModuleException, ParseException, ProtocolNotSuppException {
            int responseLength;
            HTTPResponse httpResponse;
            HTTPPlugin plugin = HTTPPlugin.getPlugin();
            PluginProcessContext pluginProcessContext = plugin.getPluginProcessContext();
            HTTPPluginThreadState threadState = (HTTPPluginThreadState)pluginProcessContext.getPluginThreadListener();
            PluginThreadContext threadContext = threadState.getThreadContext();
            String pathAndQuery = this.m_url.getPathAndQuery();
            String fragment = this.m_url.getFragment();
            String path = fragment != null ? pathAndQuery + '#' + fragment : pathAndQuery;
            HTTPConnection connection = threadState.getConnectionWrapper(this.m_url).getConnection();
            long startTime = connection.getTimeAuthority().getTimeInMilliseconds();
            try {
                httpResponse = this.doRequest(connection, path);
            }
            catch (InterruptedIOException e) {
                throw new TimeoutException(e);
            }
            if (HTTPRequest.this.m_readResponseBody) {
                responseLength = httpResponse.getData().length;
            } else {
                httpResponse.getStatusCode();
                responseLength = 0;
            }
            threadContext.pauseClock();
            long dnsTime = connection.getDnsTime() - startTime;
            long connectTime = connection.getConnectTime() - startTime;
            long timeToFirstByte = httpResponse.getTimeToFirstByte() - startTime;
            int statusCode = httpResponse.getStatusCode();
            String message = httpResponse.getOriginalURI() + " -> " + statusCode + " " + httpResponse.getReasonLine() + ", " + responseLength + " bytes";
            Grinder.ScriptContext scriptContext = pluginProcessContext.getScriptContext();
            Logger logger = scriptContext.getLogger();
            switch (statusCode) {
                case 301: 
                case 302: 
                case 307: {
                    logger.output(message + " [Redirect, ensure the next URL is " + httpResponse.getHeader("Location") + "]");
                    break;
                }
                default: {
                    logger.output(message);
                }
            }
            try {
                Statistics statistics = scriptContext.getStatistics();
                if (statistics.isTestInProgress()) {
                    Statistics.StatisticsForTest statisticsForCurrentTest = statistics.getForCurrentTest();
                    statisticsForCurrentTest.addLong("httpplugin.responseLength", responseLength);
                    statisticsForCurrentTest.setLong("httpplugin.responseStatus", statusCode);
                    if (dnsTime >= 0L) {
                        statisticsForCurrentTest.addLong("httpplugin.dnsTime", dnsTime);
                    }
                    if (connectTime >= 0L) {
                        statisticsForCurrentTest.addLong("httpplugin.connectTime", connectTime);
                    }
                    statisticsForCurrentTest.addLong("httpplugin.firstByteTime", timeToFirstByte);
                    if (statusCode >= 400) {
                        statisticsForCurrentTest.addLong("httpplugin.responseErrors", 1L);
                    }
                }
            }
            catch (InvalidContextException e) {
                throw new PluginException("Failed to set statistic", e);
            }
            HTTPRequest.this.processResponse(httpResponse);
            threadState.setLastResponse(httpResponse);
            threadContext.resumeClock();
            return httpResponse;
        }

        abstract HTTPResponse doRequest(HTTPConnection var1, String var2) throws IOException, ModuleException;
    }
}

