/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.engine.agent;

import java.io.OutputStream;
import net.grinder.common.GrinderProperties;
import net.grinder.common.UncheckedGrinderException;
import net.grinder.common.processidentity.WorkerIdentity;
import net.grinder.communication.CommunicationException;
import net.grinder.communication.FanOutStreamSender;
import net.grinder.communication.StreamSender;
import net.grinder.engine.agent.AgentIdentityImplementation;
import net.grinder.engine.agent.Worker;
import net.grinder.engine.agent.WorkerFactory;
import net.grinder.engine.common.EngineException;
import net.grinder.engine.common.ScriptLocation;
import net.grinder.engine.messages.InitialiseGrinderMessage;

abstract class AbstractWorkerFactory
implements WorkerFactory {
    private final AgentIdentityImplementation m_agentIdentity;
    private final FanOutStreamSender m_fanOutStreamSender;
    private final boolean m_reportToConsole;
    private final ScriptLocation m_script;
    private final GrinderProperties m_properties;
    private WorkerIdentity m_firstWorkerIdentity;

    protected AbstractWorkerFactory(AgentIdentityImplementation agentIdentity, FanOutStreamSender fanOutStreamSender, boolean reportToConsole, ScriptLocation script, GrinderProperties properties) {
        this.m_agentIdentity = agentIdentity;
        this.m_fanOutStreamSender = fanOutStreamSender;
        this.m_reportToConsole = reportToConsole;
        this.m_script = script;
        this.m_properties = properties;
    }

    public Worker create(OutputStream outputStream, OutputStream errorStream) throws EngineException {
        AgentIdentityImplementation.WorkerIdentityImplementation workerIdentity = this.m_agentIdentity.createWorkerIdentity();
        if (this.m_firstWorkerIdentity == null) {
            this.m_firstWorkerIdentity = workerIdentity;
        }
        Worker worker = this.createWorker(workerIdentity, outputStream, errorStream);
        OutputStream processStdin = worker.getCommunicationStream();
        try {
            InitialiseGrinderMessage initialisationMessage = new InitialiseGrinderMessage(workerIdentity, this.m_firstWorkerIdentity, this.m_reportToConsole, this.m_script, this.m_properties);
            new StreamSender(processStdin).send(initialisationMessage);
        }
        catch (CommunicationException e) {
            worker.destroy();
            throw new EngineException("Failed to send initialisation message", e);
        }
        catch (UncheckedGrinderException e) {
            worker.destroy();
            throw e;
        }
        this.m_fanOutStreamSender.add(processStdin);
        return worker;
    }

    protected abstract Worker createWorker(AgentIdentityImplementation.WorkerIdentityImplementation var1, OutputStream var2, OutputStream var3) throws EngineException;
}

