/*
 * Copyright (c) 2014 Spotify AB.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package com.spotify.docker.client.messages;

import com.google.common.base.MoreObjects;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;
import java.util.Objects;

public class Info {

  @JsonProperty("Containers") private int containers;
  @JsonProperty("Images") private int images;
  @JsonProperty("Driver") private String storageDriver;
  @JsonProperty("DriverStatus") private List<List<String>> driverStatus;
  @JsonProperty("SystemStatus") private List<List<String>> systemStatus;
  @JsonProperty("ExecutionDriver") private String executionDriver;
  @JsonProperty("KernelVersion") private String kernelVersion;
  @JsonProperty("NCPU") private int cpus;
  @JsonProperty("MemTotal") private long memTotal;
  @JsonProperty("Name") private String name;
  @JsonProperty("ID") private String id;
  @JsonProperty("OperatingSystem") private String operatingSystem;
  @JsonProperty("Debug") private Boolean debug;
  @JsonProperty("NFd") private int fileDescriptors;
  @JsonProperty("NGoroutines") private int goroutines;
  @JsonProperty("NEventsListener") private int eventsListener;
  @JsonProperty("InitPath") private String initPath;
  @JsonProperty("InitSha1") private String initSha1;
  @JsonProperty("IndexServerAddress") private String indexServerAddress;
  @JsonProperty("MemoryLimit") private Boolean memoryLimit;
  @JsonProperty("SwapLimit") private Boolean swapLimit;
  @JsonProperty("IPv4Forwarding") private boolean ipv4Forwarding;
  @JsonProperty("Labels") private List<String> labels;
  @JsonProperty("DockerRootDir") private String dockerRootDir;

  public int containers() {
    return containers;
  }

  public int images() {
    return images;
  }

  public String storageDriver() {
    return storageDriver;
  }

  public List<List<String>> driverStatus() {
    return driverStatus;
  }

  public List<List<String>> systemStatus() {
    return systemStatus;
  }

  public int cpus() {
    return cpus;
  }

  public long memTotal() {
    return memTotal;
  }

  public String name() {
    return name;
  }

  public String id() {
    return id;
  }

  public String executionDriver() {
    return executionDriver;
  }

  public String kernelVersion() {
    return kernelVersion;
  }

  public String operatingSystem() {
    return operatingSystem;
  }

  public boolean debug() {
    return debug;
  }

  public int fileDescriptors() {
    return fileDescriptors;
  }

  public int goroutines() {
    return goroutines;
  }

  public int eventsListener() {
    return eventsListener;
  }

  public String initPath() {
    return initPath;
  }

  public String initSha1() {
    return initSha1;
  }

  public String indexServerAddress() {
    return indexServerAddress;
  }

  public boolean memoryLimit() {
    return memoryLimit;
  }

  public boolean swapLimit() {
    return swapLimit;
  }

  public boolean ipv4Forwarding() {
    return ipv4Forwarding;
  }

  public List<String> labels() {
    return labels;
  }

  public String dockerRootDir() {
    return dockerRootDir;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }

    final Info that = (Info) o;

    return Objects.equals(this.containers, that.containers) &&
        Objects.equals(this.images, that.images) &&
        Objects.equals(this.storageDriver, that.storageDriver) &&
        Objects.equals(this.driverStatus, that.driverStatus) &&
        Objects.equals(this.systemStatus, that.systemStatus) &&
        Objects.equals(this.executionDriver, that.executionDriver) &&
        Objects.equals(this.kernelVersion, that.kernelVersion) &&
        Objects.equals(this.cpus, that.cpus) &&
        Objects.equals(this.memTotal, that.memTotal) &&
        Objects.equals(this.name, that.name) &&
        Objects.equals(this.id, that.id) &&
        Objects.equals(this.operatingSystem, that.operatingSystem) &&
        Objects.equals(this.debug, that.debug) &&
        Objects.equals(this.fileDescriptors, that.fileDescriptors) &&
        Objects.equals(this.goroutines, that.goroutines) &&
        Objects.equals(this.eventsListener, that.eventsListener) &&
        Objects.equals(this.initPath, that.initPath) &&
        Objects.equals(this.initSha1, that.initSha1) &&
        Objects.equals(this.indexServerAddress, that.indexServerAddress) &&
        Objects.equals(this.memoryLimit, that.memoryLimit) &&
        Objects.equals(this.swapLimit, that.swapLimit) &&
        Objects.equals(this.ipv4Forwarding, that.ipv4Forwarding) &&
        Objects.equals(this.labels, that.labels) &&
        Objects.equals(this.dockerRootDir, that.dockerRootDir);
  }

  @Override
  public int hashCode() {
    return Objects.hash(containers, images, storageDriver, driverStatus, systemStatus, cpus,
                        memTotal, name, executionDriver, kernelVersion, debug, fileDescriptors,
                        goroutines, eventsListener, initPath, initSha1, indexServerAddress,
                        memoryLimit, swapLimit);
  }

  @Override
  public String toString() {
    return MoreObjects.toStringHelper(this)
        .add("containers", containers)
        .add("images", images)
        .add("storageDriver", storageDriver)
        .add("driverStatus", driverStatus)
        .add("systemStatus", systemStatus)
        .add("cpus", cpus)
        .add("memTotal", memTotal)
        .add("name", name)
        .add("executionDriver", executionDriver)
        .add("kernelVersion", kernelVersion)
        .add("debug", debug)
        .add("fileDescriptors", fileDescriptors)
        .add("goroutines", goroutines)
        .add("eventsListener", eventsListener)
        .add("initPath", initPath)
        .add("initSha1", initSha1)
        .add("indexServerAddress", indexServerAddress)
        .add("memoryLimit", memoryLimit)
        .add("swapLimit", swapLimit)
        .toString();
  }
}
