#!/bin/bash
set -euo pipefail
IFS=$'\n\t'

REPO_ROOT=$(cd "$(dirname "$0")/../"; pwd -P)
SOURCE_ROOT=$REPO_ROOT/sources
GIT_COMMIT=4fc99b8b5e0ac61b661359d8e633001137ae1a5c
VERSION_SEED_DATE=2017-04-11
OFFICIAL_BUILD_ID=20180328-01

pushd $SOURCE_ROOT/coreclr

export DOTNET_TOOLSET_DIR=$REPO_ROOT/toolsets/dotnet
export BUILD_TOOLS_TOOLSET_DIR=$REPO_ROOT/toolsets/buildtools

./sync.sh -p
./build.sh Release x64 skipnuget skiptests -skiprestore -OfficialBuildId=$OFFICIAL_BUILD_ID -LatestCommit=$GIT_COMMIT -VersionSeedDate=$VERSION_SEED_DATE
./build-packages.sh -BuildType=Release -BuildArch=x64 -OfficialBuildId=$OFFICIAL_BUILD_ID -LatestCommit=$GIT_COMMIT -VersionSeedDate=$VERSION_SEED_DATE

cp bin/Product/Linux.x64.Release/.nuget/pkg/*.nupkg $SOURCE_ROOT/../packages/source-built

popd
