#!/bin/bash
set -euo pipefail
IFS=$'\n\t'

REPO_ROOT=$(cd "$(dirname "$0")/../"; pwd -P)
SOURCE_ROOT=$REPO_ROOT/sources
LIBUV_PACKAGE_SOURCE_ROOT=$SOURCE_ROOT/libuv-package
BUILD_DIR2=$LIBUV_PACKAGE_SOURCE_ROOT/artifacts/build
DOTNET_CMD=$REPO_ROOT/toolsets/dotnet/1.0.0-preview2-003121/dotnet

export DOTNET_SKIP_FIRST_TIME_EXPERIENCE=1
export DOTNET_CLI_TELEMETRY_OPTOUT=1
export NUGET_PACKAGES=$LIBUV_PACKAGE_SOURCE_ROOT/packages

pushd $LIBUV_PACKAGE_SOURCE_ROOT

$DOTNET_CMD restore

cd src/Libuv

$DOTNET_CMD run -p ../../tools/LibuvCopier/project.json
$DOTNET_CMD pack -o $BUILD_DIR2

cp $BUILD_DIR2/*.nupkg $REPO_ROOT/packages/source-built

popd
