﻿// Copyright (c) Microsoft.  All Rights Reserved.  Licensed under the Apache License, Version 2.0.  See License.txt in the project root for license information.

using Microsoft.CodeAnalysis.Text;

namespace Microsoft.CodeAnalysis
{
    /// <summary>
    /// A class that provides constants for common language names.
    /// </summary>
    public static class LanguageNames
    {
        /// <summary>
        /// The common name used for the C# language.
        /// </summary>
        public const string CSharp = "C#";

        /// <summary>
        /// The common name used for the Visual Basic language.
        /// </summary>
        public const string VisualBasic = "Visual Basic";
    }
}
