// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.
// See the LICENSE file in the project root for more information.

#include "pal_types.h"

#include <openssl/evp.h>

/*
Shims the EVP_PKEY_new method.

Returns the new EVP_PKEY instance.
*/
extern "C" EVP_PKEY* CryptoNative_EvpPkeyCreate();

/*
Cleans up and deletes a EVP_PKEY instance.

Implemented by calling EVP_PKEY_free.

No-op if pkey is null.
The given EVP_PKEY pointer is invalid after this call.
Always succeeds.
*/
extern "C" void CryptoNative_EvpPkeyDestroy(EVP_PKEY* pkey);

/*
Used by System.Security.Cryptography.X509Certificates' OpenSslX509CertificateReader when
duplicating a private key context as part of duplicating the Pal object.

Returns the number (as of this call) of references to the EVP_PKEY. Anything less than
2 is an error, because the key is already in the process of being freed.
*/
extern "C" int32_t CryptoNative_UpRefEvpPkey(EVP_PKEY* pkey);
