#!/bin/bash
set -euo pipefail
IFS=$'\n\t'

REPO_ROOT=$(cd "$(dirname "$0")/../"; pwd -P)
SOURCE_ROOT=$REPO_ROOT/sources
GIT_COMMIT=718443a10dbd456b6c8f08ee594a92cfbf2ef8db
VERSION_SEED_DATE=2017-04-20
OFFICIAL_BUILD_ID=20190418-01

pushd $SOURCE_ROOT/corefx

export DOTNET_TOOLSET_DIR=$REPO_ROOT/toolsets/dotnet
export BUILD_TOOLS_TOOLSET_DIR=$REPO_ROOT/toolsets/buildtools

./build-managed.sh -OfficialBuildId=$OFFICIAL_BUILD_ID -LatestCommit=$GIT_COMMIT -VersionSeedDate=$VERSION_SEED_DATE -- /t:GenerateVersionSourceFile /p:GenerateVersionSourceFile=true 
./build-managed.sh -Platform=AnyCPU -ConfigurationGroup=Release -BuildTests=false -BuildPackages=false -OfficialBuildId=$OFFICIAL_BUILD_ID -LatestCommit=$GIT_COMMIT -VersionSeedDate=$VERSION_SEED_DATE -- /p:SkipVerifyPackageVersions=true
./build-native.sh -buildArch=x64 -Release
./build-packages.sh -ConfigurationGroup=Release -OfficialBuildId=$OFFICIAL_BUILD_ID -LatestCommit=$GIT_COMMIT -VersionSeedDate=$VERSION_SEED_DATE -- /p:BuildPackageLibraryReferences=false /p:SkipGenerationCheck=true /p:BuildAllPackages=true

cp bin/packages/Release/*.nupkg ../../packages/source-built

popd
