#!/bin/bash
set -euo pipefail
IFS=$'\n\t'

REPO_ROOT=$(cd "$(dirname "$0")/../"; pwd -P)
SOURCE_ROOT=$REPO_ROOT/sources
RID=rhel.7.6-x64

export GIT_COMMIT_HASH=5917a1a3431dd5f151965172f3ee6cd7b50bc348
export GIT_COMMIT_COUNT=1809

export DOTNET_TOOLSET_DIR=$REPO_ROOT/toolsets/dotnet
export BUILD_TOOLS_TOOLSET_DIR=$REPO_ROOT/toolsets/buildtools

pushd $SOURCE_ROOT/core-setup

./build.sh --configuration Release --targets Init,Compile,Package

cp artifacts/$RID/corehost/*.nupkg $REPO_ROOT/packages/source-built
cp artifacts/$RID/packages/*.tar.gz $REPO_ROOT/packages/source-built

popd
