#!/bin/bash
set -euo pipefail
IFS=$'\n\t'

REPO_ROOT=$(cd "$(dirname "$0")/../"; pwd -P)
SOURCE_ROOT=$REPO_ROOT/sources
LIBUV_BUILD_SOURCE_ROOT=$SOURCE_ROOT/libuv-build
LIBUV_BUILD_SUBMODULE_LIBUV_ROOT=$LIBUV_BUILD_SOURCE_ROOT/submodules/libuv
LIBUV_OUTPUT_LIBRARY=$LIBUV_BUILD_SOURCE_ROOT/src/libuv/bin/linux/libuv.so
if $(command -v clang > /dev/null 2>&1); then
    CLANG=clang
else
    CLANG=clang-3.5
fi
BUILD_DIR2=$LIBUV_BUILD_SOURCE_ROOT/artifacts/build
DOTNET_CMD=$REPO_ROOT/toolsets/dotnet/1.0.0-preview2-003121/dotnet
XPLAT_NUGET_CMD=$REPO_ROOT/toolsets/nuget/3.5.0-beta2-1484/NuGet.CommandLine.XPlat.dll
LIBUV_BUILD_PACKAGE_VERSION=1.9.2

pushd $LIBUV_BUILD_SOURCE_ROOT

export DOTNET_SKIP_FIRST_TIME_EXPERIENCE=1
export DOTNET_CLI_TELEMETRY_OPTOUT=1
export NUGET_PACKAGES=$LIBUV_BUILD_SOURCE_ROOT/packages

mkdir -p $(dirname $LIBUV_OUTPUT_LIBRARY)

$CLANG $LIBUV_BUILD_SUBMODULE_LIBUV_ROOT/src/fs-poll.c \
       $LIBUV_BUILD_SUBMODULE_LIBUV_ROOT/src/inet.c \
       $LIBUV_BUILD_SUBMODULE_LIBUV_ROOT/src/threadpool.c \
       $LIBUV_BUILD_SUBMODULE_LIBUV_ROOT/src/uv-common.c \
       $LIBUV_BUILD_SUBMODULE_LIBUV_ROOT/src/version.c \
       $LIBUV_BUILD_SUBMODULE_LIBUV_ROOT/src/unix/async.c \
       $LIBUV_BUILD_SUBMODULE_LIBUV_ROOT/src/unix/core.c \
       $LIBUV_BUILD_SUBMODULE_LIBUV_ROOT/src/unix/dl.c \
       $LIBUV_BUILD_SUBMODULE_LIBUV_ROOT/src/unix/fs.c \
       $LIBUV_BUILD_SUBMODULE_LIBUV_ROOT/src/unix/getaddrinfo.c \
       $LIBUV_BUILD_SUBMODULE_LIBUV_ROOT/src/unix/getnameinfo.c \
       $LIBUV_BUILD_SUBMODULE_LIBUV_ROOT/src/unix/loop.c \
       $LIBUV_BUILD_SUBMODULE_LIBUV_ROOT/src/unix/loop-watcher.c \
       $LIBUV_BUILD_SUBMODULE_LIBUV_ROOT/src/unix/pipe.c \
       $LIBUV_BUILD_SUBMODULE_LIBUV_ROOT/src/unix/poll.c \
       $LIBUV_BUILD_SUBMODULE_LIBUV_ROOT/src/unix/process.c \
       $LIBUV_BUILD_SUBMODULE_LIBUV_ROOT/src/unix/signal.c \
       $LIBUV_BUILD_SUBMODULE_LIBUV_ROOT/src/unix/stream.c \
       $LIBUV_BUILD_SUBMODULE_LIBUV_ROOT/src/unix/tcp.c \
       $LIBUV_BUILD_SUBMODULE_LIBUV_ROOT/src/unix/thread.c \
       $LIBUV_BUILD_SUBMODULE_LIBUV_ROOT/src/unix/timer.c \
       $LIBUV_BUILD_SUBMODULE_LIBUV_ROOT/src/unix/tty.c \
       $LIBUV_BUILD_SUBMODULE_LIBUV_ROOT/src/unix/udp.c \
       $LIBUV_BUILD_SUBMODULE_LIBUV_ROOT/src/unix/proctitle.c \
       $LIBUV_BUILD_SUBMODULE_LIBUV_ROOT/src/unix/linux-core.c \
       $LIBUV_BUILD_SUBMODULE_LIBUV_ROOT/src/unix/linux-inotify.c \
       $LIBUV_BUILD_SUBMODULE_LIBUV_ROOT/src/unix/linux-syscalls.c \
       -lm \
       -pthread \
       -ldl \
       -lrt \
       -fPIC \
       -shared \
       -o $LIBUV_OUTPUT_LIBRARY \
       -I $LIBUV_BUILD_SUBMODULE_LIBUV_ROOT/include \
       -I $LIBUV_BUILD_SUBMODULE_LIBUV_ROOT/src \
       -Wall \
       -Wextra \
       -Wno-unused-parameter \
       -Wstrict-aliasing \
       -g \
       --std=gnu89 \
       -pedantic \
       -D_GNU_SOURCE \
       -D_BUILDING_UV_SHARED=1

for runtime in debian rhel fedora opensuse;
do
    DESTINATION_PATH=$BUILD_DIR2/package-src-linux/contents/runtimes/$runtime-x64/native
    mkdir -p $DESTINATION_PATH
    cp $LIBUV_OUTPUT_LIBRARY $DESTINATION_PATH
done

cp $LIBUV_BUILD_SOURCE_ROOT/build/License.txt $BUILD_DIR2/package-src-linux/contents/
cp $LIBUV_BUILD_SOURCE_ROOT/build/Microsoft.AspNetCore.Internal.libuv-Linux.nuspec $BUILD_DIR2/package-src-linux/

$DOTNET_CMD $XPLAT_NUGET_CMD pack --output-directory $BUILD_DIR2 --version $LIBUV_BUILD_PACKAGE_VERSION --no-package-analysis $BUILD_DIR2/package-src-linux/Microsoft.AspNetCore.Internal.libuv-Linux.nuspec

cp $BUILD_DIR2/*.nupkg $REPO_ROOT/packages/source-built

popd
