#!/bin/bash
set -euo pipefail
IFS=$'\n\t'

REPO_ROOT=$(cd "$(dirname "$0")/../"; pwd -P)
SOURCE_ROOT=$REPO_ROOT/sources
RID=rhel.7.5-x64

export GIT_COMMIT_HASH=fb160dff5f4af17c6c8db02a83242a20444a525b
export GIT_COMMIT_COUNT=1076

pushd $SOURCE_ROOT/core-setup

./build.sh --configuration Release --targets Init,Compile,Package

cp artifacts/$RID/corehost/*.nupkg $REPO_ROOT/packages/source-built
cp artifacts/$RID/packages/*.tar.gz $REPO_ROOT/packages/source-built

popd
