
## ViBenchToJson.exe Arguments

`{branch}` is generated by the git command `git rev-parse --abbrev-ref HEAD`

`{date}` is generated by the git command `git show --format="%aI" branchname`

`{checkin-hash}` is generated by the git command `git show --format"%h" branchname`

`{username}` is generated by the command `whoami`

`{machine name}` is generated by the command `hostname`

* `compilertime:compiler_time.csv` The csv file that contains the compiler time data
* `jobName:RoslynPerf-{checkin-hash}-{date}` The name of the job that was kicked off.  This should be the same
  as every other job that was kicked off on other machines
* `jobGroupName:Roslyn-{branchname}` The group name is the same as the branch name
* `jobTypeName:official|private|lab` Official is for rolling releases, private is for personal tests, lab is for personal
  tests that were kicked off in the lab
* `buildInfoName:{date}-{branch}-{checkin-hash}` Used for the name of the dat point
* `configName:Default-Configuration` We aren't going to use this one for now
* `machinePoolName:4-core-windows|8-core-windows|etc..` The "type" of machine that is running the test
* `architectureName:x86-64|x86` The hardware architecture of the CPU that is running the test
* `manufacturerName:unknown-manufacturer` We don't care about this
* `microarchName:unknown-microarch` We don't care about this either
* `userName:{username}` The name for the user that did the tests
* `userAlias:{username}` The alias for the user that did the tests
* `osInfoName:Windows|OSX|Linux` The operating system that is running the test
* `machine:{machine name}` The name of the machine running the test
* `buildNumber:{date}-{checkin-hash}` This shows up when you hover over a datapoint.

Example invocation
```
# Powershell
\\vcuts-server\tools\ViBenchCsvToJson\ViBenchToJson.exe compilertime:"compiler_time.csv" `
    jobName:"RoslynPerf-aa444d7-2016-02-17T15:24:59-08:00" `
    jobGroupName:"Roslyn-master" `
    jobTypeName:"official" `
    buildInfoName:"2016-02-17T15:24:59-08:00-master-aa444d7" `
    configName:"Default-Configuration" `
    machinePoolName:"4-core-windows" `
    architectureName:"x86-64" `
    manufacturerName:"unknown-manufacturer" `
    microarchName:"unknown-microarch" `
    userName:"tyoverby" `
    userAlias:"tyoverby" `
    osInfoName:"Windows" `
    machineName:"TYOVERBY-4" `
    buildNumber:"2016-02-17T15:24:59-08:00-aa444d7"
```

## CSV format

### compiler_time.csv

* suite
* test
* value
