#!/bin/bash
set -euo pipefail
IFS=$'\n\t'

REPO_ROOT=$(cd "$(dirname "$0")"; pwd -P)
SOURCE_ROOT=$REPO_ROOT/sources
PACKAGES_ROOT=$REPO_ROOT/packages

export DOTNET_SKIP_FIRST_TIME_EXPERIENCE=1
export DOTNET_CLI_TELEMETRY_OPTOUT=1

$REPO_ROOT/scripts/build-coreclr.sh

$REPO_ROOT/scripts/build-corefx.sh

$REPO_ROOT/scripts/build-roslyn.sh

$REPO_ROOT/scripts/build-symreader.sh

$REPO_ROOT/scripts/build-libuv-build.sh

$REPO_ROOT/scripts/build-libuv-package.sh

$REPO_ROOT/scripts/build-nuget-client.sh

$REPO_ROOT/scripts/build-core-setup.sh

$REPO_ROOT/scripts/build-newtonsoft-json.sh

$REPO_ROOT/scripts/build-applicationinsights-dotnet.sh

$REPO_ROOT/scripts/build-cli.sh


