// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.
// See the LICENSE file in the project root for more information.

// 

using System;
using System.Collections.Generic;

namespace System.Security.Policy
{
    /// <summary>
    ///     IRuntimeEvidenceFactory is implemented by runtime types which the CLR knows how to delay
    ///     generate evidence for.  It is used by the Evidence class to get evidence on demand when we first
    ///     need it.
    /// </summary>
    internal interface IRuntimeEvidenceFactory
    {
        /// <summary>
        ///     Object which the evidence generated by this factory is used for
        /// </summary>
        IEvidenceFactory Target { get; }

        /// <summary>
        ///     Get the collection of evidence objects supplied by the factory itself, rather than by the
        ///     runtime.
        /// </summary>
        IEnumerable<EvidenceBase> GetFactorySuppliedEvidence();

        /// <summary>
        ///     Generate a specific type of evidence for this object, returning null if the specified type of
        ///     evidence cannot be generated.
        /// </summary>
        EvidenceBase GenerateEvidence(Type evidenceType);
    }
}
