#!/bin/bash
set -euo pipefail
IFS=$'\n\t'

ROSLYN_VERSION=1.3.0

REPO_ROOT=$(cd "$(dirname "$0")/../"; pwd -P)
SOURCE_ROOT=$REPO_ROOT/sources
DOTNET_CMD=$REPO_ROOT/toolsets/dotnet/1.0.0-preview2-003121/dotnet
XPLAT_NUGET_CMD=$REPO_ROOT/toolsets/nuget/3.5.0-beta2-1484/NuGet.CommandLine.XPlat.dll

pushd $SOURCE_ROOT/roslyn

export DOTNET_SKIP_FIRST_TIME_EXPERIENCE=1
export DOTNET_CLI_TELEMETRY_OPTOUT=1
export NUGET_PACKAGES=$SOURCE_ROOT/roslyn/packages

./cibuild.sh --release
./Binaries/Release/csicore/corerun ./Binaries/Release/csicore/csi.exe build/BuildCoreNuGets.csx Binaries/Release $ROSLYN_VERSION Binaries/Packages $DOTNET_CMD $XPLAT_NUGET_CMD
cp ./Binaries/Packages/*.nupkg $REPO_ROOT/packages/source-built

popd
