#!/bin/bash
set -euo pipefail
IFS=$'\n\t'

REPO_ROOT=$(cd "$(dirname "$0")/../"; pwd -P)
SOURCE_ROOT=$REPO_ROOT/sources
GIT_COMMIT=04fca2db84861ca70fed61add0e4c8a5faf97730
VERSION_SEED_DATE=2017-04-11
OFFICIAL_BUILD_ID=20170914-02

pushd $SOURCE_ROOT/coreclr

./sync.sh -p
./build.sh Release x64 skiptests skiprestore skipnuget /p:OfficialBuildId=$OFFICIAL_BUILD_ID /p:LatestCommit=$GIT_COMMIT /p:VersionSeedDate=$VERSION_SEED_DATE
./build-packages.sh Release x64 /p:OfficialBuildId=$OFFICIAL_BUILD_ID /p:LatestCommit=$GIT_COMMIT /p:VersionSeedDate=$VERSION_SEED_DATE

cp bin/Product/Linux.x64.Release/.nuget/pkg/*.nupkg $SOURCE_ROOT/../packages/source-built

popd
