#!/bin/bash
set -euo pipefail
IFS=$'\n\t'

REPO_ROOT=$(cd "$(dirname "$0")/../"; pwd -P)
SOURCE_ROOT=$REPO_ROOT/sources
SHARED_FRAMEWORK_TGZ_FILENAME=dotnet-rhel-x64.1.0.7.tar.gz
RID=rhel.7.4-x64
SHARED_FRAMEWORK_VERSION=1.0.7

pushd $SOURCE_ROOT/cli

export GIT_COMMIT_COUNT=3200
export GIT_COMMIT_HASH=acac3e7a47a7297635bae71cea2c44c6ca9eaf5b

export DOTNET_CLI_FRAMEWORK_HOST_COMPRESSED_FILE=$REPO_ROOT/packages/source-built/$SHARED_FRAMEWORK_TGZ_FILENAME

./build.sh --configuration Release --skip-prereqs --targets Init,Prepare,Compile,Package

cp artifacts/$RID/packages/*.nupkg $REPO_ROOT/packages/source-built
cp artifacts/$RID/packages/*.tar.gz $REPO_ROOT/packages/source-built

popd
