#!/bin/bash
set -e

VERSION=1.0.0-preview2-003260

projectOutput=false
keepProjects=false

function usage {
    echo "projectOutput: echo dotnet's output to console"
    echo "keepProjects: keep projects after tests are complete"
}

while :; do
    if [ $# -le 0 ]; then
        break
    fi

    lowerI="$(echo $1 | awk '{print tolower($0)}')"
    case $lowerI in
        -?|-h|--help)
            usage
            exit 1
            ;;
        projectoutput)
            projectOutput=true
            ;;
        keepprojects)
            keepProjects=true
            ;;
        *)
            usage
            exit 1
            ;;
    esac

    shift
done

function doCommand {
    lang=$1
    proj=$2
    shift; shift;

    echo "starting language $lang, type $proj" | tee -a smoke_test.log

    mkdir "${lang}_${proj}"
    cd "${lang}_${proj}"

    while :; do
        if [ $# -le 0 ]; then
            break
        fi

        echo "    running $1" | tee -a ../smoke_test.log

        if [ "$1" == "new" ]; then
            if [ "$projectOutput" == "true" ]; then
                ../builtCli/dotnet new -l $lang -t $proj
            else
                ../builtCli/dotnet new -l $lang -t $proj >> ../smoke_test.log 2>&1
            fi
        elif [[ "$1" == "run" && "$proj" == "Web" ]]; then
            if [ "$projectOutput" == "true" ]; then
                ../builtCli/dotnet $1 &
            else
                ../builtCli/dotnet $1 >> ../smoke_test.log 2>&1 &
            fi
            webPid=$!
            echo "    waiting 20 seconds for web project with pid $webPid"
            sleep 20
            echo "    sending SIGINT to $webPid"
            pkill -SIGINT -P $webPid
            wait $!
            echo "    terminated with exit code $?"
        else
            if [ "$projectOutput" == "true" ]; then
                ../builtCli/dotnet $1
            else
                ../builtCli/dotnet $1 >> ../smoke_test.log 2>&1
            fi
        fi
        if [ $? -eq 0 ]; then
            echo "    $1 succeeded" >> ../smoke_test.log
        else
            echo "    $1 failed with exit code $?" >> tee -a ../smoke_test.log
        fi

        shift
    done

    cd ..

    if [ "$keepProjects" == "false" ]; then
       rm -rf "${lang}_${proj}"
    fi

    echo "finished language $lang, type $proj" | tee -a smoke_test.log
}

mkdir testing-smoke
cd testing-smoke
mkdir builtCli
cd builtCli
tar xzf ../../packages/source-built/dotnet-dev-rhel-x64.${VERSION}.tar.gz
cd ..

doCommand C# Console new restore run
doCommand C# Web new restore build run
doCommand C# Lib new restore build
doCommand C# xunittest new restore test
doCommand F# Console new restore run
doCommand F# Web new restore build run
doCommand F# Lib new restore build
doCommand F# xunittest new restore test

rm -rf builtCli

echo "ALL TESTS PASSED!"

