#!/bin/bash
set -euo pipefail
IFS=$'\n\t'

REPO_ROOT=$(cd "$(dirname "$0")/../"; pwd -P)
SOURCE_ROOT=$REPO_ROOT/sources
GIT_COMMIT=400bffd32fb9584f4800f788407dbf4e52f0ae90
VERSION_SEED_DATE=2017-04-11
OFFICIAL_BUILD_ID=20180201-01

pushd $SOURCE_ROOT/coreclr

./sync.sh -p
./build.sh Release x64 skiptests skiprestore skipnuget /p:OfficialBuildId=$OFFICIAL_BUILD_ID /p:LatestCommit=$GIT_COMMIT /p:VersionSeedDate=$VERSION_SEED_DATE
./build-packages.sh Release x64 /p:OfficialBuildId=$OFFICIAL_BUILD_ID /p:LatestCommit=$GIT_COMMIT /p:VersionSeedDate=$VERSION_SEED_DATE

cp bin/Product/Linux.x64.Release/.nuget/pkg/*.nupkg $SOURCE_ROOT/../packages/source-built

popd
