// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.
// See the LICENSE file in the project root for more information.

using Xunit;

namespace ManagedTests.DynamicCSharp.Conformance.dynamic.declarations.localVariable.simple.declaration001.declaration001
{
    using ManagedTests.DynamicCSharp.Conformance.dynamic.declarations.localVariable.simple.declaration001.declaration001;

    public class Test
    {
        [Fact]
        public static void DynamicCSharpRunTest()
        {
            Assert.Equal(0, MainMethod(null));
        }

        public static int MainMethod(string[] args)
        {
            dynamic d;
            return 0;
        }
    }
    // </Code>
}



namespace ManagedTests.DynamicCSharp.Conformance.dynamic.declarations.localVariable.simple.declaration002.declaration002
{
    using ManagedTests.DynamicCSharp.Conformance.dynamic.declarations.localVariable.simple.declaration002.declaration002;

    public class Test
    {
        [Fact]
        public static void DynamicCSharpRunTest()
        {
            Assert.Equal(0, MainMethod(null));
        }

        public static int MainMethod(string[] args)
        {
            dynamic d = null;
            object o = (object)d;
            if (o != null)
                return 1;
            return 0;
        }
    }
    // </Code>
}



namespace ManagedTests.DynamicCSharp.Conformance.dynamic.declarations.localVariable.simple.declaration004.declaration004
{
    using ManagedTests.DynamicCSharp.Conformance.dynamic.declarations.localVariable.simple.declaration004.declaration004;

    public class Test
    {
        [Fact]
        public static void DynamicCSharpRunTest()
        {
            Assert.Equal(0, MainMethod(null));
        }

        public static int MainMethod(string[] args)
        {
            dynamic d = 4;
            dynamic dd = d;
            object o = (object)dd;
            if ((int)o != 4)
                return 1;
            return 0;
        }
    }
    // </Code>
}



namespace ManagedTests.DynamicCSharp.Conformance.dynamic.declarations.localVariable.simple.declaration005.declaration005
{
    using ManagedTests.DynamicCSharp.Conformance.dynamic.declarations.localVariable.simple.declaration005.declaration005;

    public class Test
    {
        [Fact]
        public static void DynamicCSharpRunTest()
        {
            Assert.Equal(0, MainMethod(null));
        }

        public static int MainMethod(string[] args)
        {
            int x = 4;
            dynamic d = (dynamic)x;
            object o = (object)d;
            if ((int)o != x)
                return 1;
            return 0;
        }
    }
    // </Code>
}



namespace ManagedTests.DynamicCSharp.Conformance.dynamic.declarations.localVariable.simple.declaration006.declaration006
{
    using ManagedTests.DynamicCSharp.Conformance.dynamic.declarations.localVariable.simple.declaration006.declaration006;

    public class Test
    {
        [Fact]
        public static void DynamicCSharpRunTest()
        {
            Assert.Equal(0, MainMethod(null));
        }

        public static int MainMethod(string[] args)
        {
            dynamic d = 4;
            object o = d;
            if ((int)o != 4)
                return 1;
            return 0;
        }
    }
    // </Code>
}



namespace ManagedTests.DynamicCSharp.Conformance.dynamic.declarations.localVariable.simple.declaration007.declaration007
{
    using ManagedTests.DynamicCSharp.Conformance.dynamic.declarations.localVariable.simple.declaration007.declaration007;

    public class Test
    {
        [Fact]
        public static void DynamicCSharpRunTest()
        {
            Assert.Equal(0, MainMethod(null));
        }

        public static int MainMethod(string[] args)
        {
            object o = 4.5;
            dynamic d = o;
            if ((double)d != 4.5)
                return 1;
            return 0;
        }
    }
    // </Code>
}



namespace ManagedTests.DynamicCSharp.Conformance.dynamic.declarations.localVariable.simple.declaration008.declaration008
{
    using ManagedTests.DynamicCSharp.Conformance.dynamic.declarations.localVariable.simple.declaration008.declaration008;

    public class Test
    {
        [Fact]
        public static void DynamicCSharpRunTest()
        {
            Assert.Equal(0, MainMethod(null));
        }

        public static int MainMethod(string[] args)
        {
            int x = 3;
            dynamic d = x;
            if ((int)d != x)
                return 1;
            return 0;
        }
    }
    // </Code>
}



namespace ManagedTests.DynamicCSharp.Conformance.dynamic.declarations.localVariable.simple.declaration009.declaration009
{
    using ManagedTests.DynamicCSharp.Conformance.dynamic.declarations.localVariable.simple.declaration009.declaration009;

    public class Test
    {
        public enum MyEnum
        {
            First,
            Second,
            Third
        }

        [Fact]
        public static void DynamicCSharpRunTest()
        {
            Assert.Equal(0, MainMethod(null));
        }

        public static int MainMethod(string[] args)
        {
            MyEnum e = MyEnum.Second;
            dynamic d = e;
            if ((MyEnum)d != MyEnum.Second)
                return 1;
            return 0;
        }
    }
    // </Code>
}



namespace ManagedTests.DynamicCSharp.Conformance.dynamic.declarations.localVariable.simple.declaration010.declaration010
{
    using ManagedTests.DynamicCSharp.Conformance.dynamic.declarations.localVariable.simple.declaration010.declaration010;

    public class Test
    {
        public struct MyStruct
        {
            public string myStr;
        }

        [Fact]
        public static void DynamicCSharpRunTest()
        {
            Assert.Equal(0, MainMethod(null));
        }

        public static int MainMethod(string[] args)
        {
            MyStruct s = new MyStruct()
            {
                myStr = "dynamic"
            }

            ;
            dynamic d = s;
            if (((MyStruct)d).myStr != "dynamic")
                return 1;
            return 0;
        }
    }
    // </Code>
}



namespace ManagedTests.DynamicCSharp.Conformance.dynamic.declarations.localVariable.simple.declaration011.declaration011
{
    using ManagedTests.DynamicCSharp.Conformance.dynamic.declarations.localVariable.simple.declaration011.declaration011;

    public class Test
    {
        public struct MyStruct
        {
            public string myStr;
        }

        [Fact]
        public static void DynamicCSharpRunTest()
        {
            Assert.Equal(0, MainMethod(null));
        }

        public static int MainMethod(string[] args)
        {
            MyStruct? s = new MyStruct()
            {
                myStr = "dynamic"
            }

            ;
            dynamic d = s;
            if (((MyStruct)d).myStr != "dynamic")
                return 1;
            return 0;
        }
    }
    // </Code>
}



namespace ManagedTests.DynamicCSharp.Conformance.dynamic.declarations.localVariable.simple.declaration012.declaration012
{
    using ManagedTests.DynamicCSharp.Conformance.dynamic.declarations.localVariable.simple.declaration012.declaration012;

    public class Test
    {
        public struct MyClass
        {
            public string myStr;
        }

        [Fact]
        public static void DynamicCSharpRunTest()
        {
            Assert.Equal(0, MainMethod(null));
        }

        public static int MainMethod(string[] args)
        {
            MyClass s = new MyClass()
            {
                myStr = "dynamic"
            }

            ;
            dynamic d = s;
            if (((MyClass)d).myStr != "dynamic")
                return 1;
            return 0;
        }
    }
    // </Code>
}



namespace ManagedTests.DynamicCSharp.Conformance.dynamic.declarations.localVariable.simple.declaration013.declaration013
{
    using ManagedTests.DynamicCSharp.Conformance.dynamic.declarations.localVariable.simple.declaration013.declaration013;

    public class Test
    {
        [Fact]
        public static void DynamicCSharpRunTest()
        {
            Assert.Equal(0, MainMethod(null));
        }

        public static int MainMethod(string[] args)
        {
            dynamic d = null;
            if ((object)d != null)
                return 1;
            return 0;
        }
    }
    // </Code>
}



namespace ManagedTests.DynamicCSharp.Conformance.dynamic.declarations.localVariable.simple.errordeclaration001.errordeclaration001
{
    using ManagedTests.DynamicCSharp.Conformance.dynamic.declarations.localVariable.simple.errordeclaration001.errordeclaration001;

    public class Test
    {
        [Fact]
        public static void DynamicCSharpRunTest()
        {
            Assert.Equal(0, MainMethod(null));
        }

        public static int MainMethod(string[] args)
        {
            dynamic d = 4;
            int x = d;
            return x == (int)d ? 0 : 1;
        }
    }
    // </Code>
}
