#!/bin/bash
set -euo pipefail
IFS=$'\n\t'

REPO_ROOT=$(cd "$(dirname "$0")/../"; pwd -P)
SOURCE_ROOT=$REPO_ROOT/sources
GIT_COMMIT=f2153aa3636eae670b1a5e7b1d6ba9e72fb0e119
VERSION_SEED_DATE=2017-04-11
OFFICIAL_BUILD_ID=20171211-01

pushd $SOURCE_ROOT/coreclr

./sync.sh -p
./build.sh Release x64 skiptests skiprestore skipnuget /p:OfficialBuildId=$OFFICIAL_BUILD_ID /p:LatestCommit=$GIT_COMMIT /p:VersionSeedDate=$VERSION_SEED_DATE
./build-packages.sh Release x64 /p:OfficialBuildId=$OFFICIAL_BUILD_ID /p:LatestCommit=$GIT_COMMIT /p:VersionSeedDate=$VERSION_SEED_DATE

cp bin/Product/Linux.x64.Release/.nuget/pkg/*.nupkg $SOURCE_ROOT/../packages/source-built

popd
