// Copyright (c) .NET Foundation. All rights reserved.
// Licensed under the Apache License, Version 2.0. See License.txt in the project root for license information.

// This file is used by Code Analysis to maintain SuppressMessage 
// attributes that are applied to this project.
// Project-level suppressions either have no target or are given 
// a specific target and scoped to a namespace, type, member, etc.

using System.Diagnostics.CodeAnalysis;

[assembly: SuppressMessage("Microsoft.Usage", "CA1801:ReviewUnusedParameters", MessageId = "nuGetProjectContext", Scope = "member", Target = "NuGet.PackageManagement.VisualStudio.RuntimeHelpers.#AddBindingRedirectsAsync(NuGet.PackageManagement.ISolutionManager,EnvDTE.Project,System.AppDomain,System.Collections.Generic.IDictionary`2<System.String,System.Collections.Generic.HashSet`1<System.String>>,Microsoft.VisualStudio.Shell.Interop.IVsFrameworkMultiTargeting,NuGet.ProjectManagement.INuGetProjectContext)")]
[assembly: SuppressMessage("Usage", "VSTHRD110:Observe result of async calls", Justification = "https://github.com/NuGet/Home/issues/7674", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.ProjectRetargetingHandler.Microsoft#VisualStudio#Shell#Interop#IVsTrackProjectRetargetingEvents#OnRetargetingAfterChange(System.String,Microsoft.VisualStudio.Shell.Interop.IVsHierarchy,System.String,System.String)~System.Int32")]
[assembly: SuppressMessage("Usage", "VSTHRD110:Observe result of async calls", Justification = "https://github.com/NuGet/Home/issues/7674", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.ProjectRetargetingHandler.Microsoft#VisualStudio#Shell#Interop#IVsTrackBatchRetargetingEvents#OnBatchRetargetingEnd~System.Int32")]
[assembly: SuppressMessage("Usage", "VSTHRD011:Use AsyncLazy<T>", Justification = "https://github.com/NuGet/Home/issues/7675", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.VSSolutionManager.InitializeAsync~System.Threading.Tasks.Task")]
[assembly: SuppressMessage("Usage", "VSTHRD110:Observe result of async calls", Justification = "https://github.com/NuGet/Home/issues/7674", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.RuntimeHelpers.QueueUnloadAndForget(System.AppDomain)")]
[assembly: SuppressMessage("Usage", "VSTHRD003:Avoid awaiting foreign Tasks", Justification = "All these methods are free threaded.", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.MultiSourcePackageMetadataProvider.GetLocalPackageMetadataAsync(NuGet.Packaging.Core.PackageIdentity,System.Boolean,System.Threading.CancellationToken)~System.Threading.Tasks.Task{NuGet.Protocol.Core.Types.IPackageSearchMetadata}")]
[assembly: SuppressMessage("Build", "CA2213:'PackageFeedEnumerator' contains field '_current' that is of IDisposable type 'IEnumerator<IPackageSearchMetadata>', but it is never disposed. Change the Dispose method on 'PackageFeedEnumerator' to call Close or Dispose on this field.", Justification = "<Pending>", Scope = "member", Target = "~F:NuGet.PackageManagement.VisualStudio.PackageFeedEnumerator._current")]
[assembly: SuppressMessage("Build", "CA2213:'ProjectRetargetingHandler' contains field '_errorListProvider' that is of IDisposable type 'ErrorListProvider', but it is never disposed. Change the Dispose method on 'ProjectRetargetingHandler' to call Close or Dispose on this field.", Justification = "<Pending>", Scope = "member", Target = "~F:NuGet.PackageManagement.VisualStudio.ProjectRetargetingHandler._errorListProvider")]
[assembly: SuppressMessage("Build", "CA2211:Non-constant fields should not be visible", Justification = "<Pending>", Scope = "member", Target = "~F:NuGet.PackageManagement.VisualStudio.VSRestoreSettingsUtilities.AdditionalValue")]
[assembly: SuppressMessage("Build", "CA1802:Field 'VSNuGetClientName' is declared as 'readonly' but is initialized with a constant value. Mark this field as 'const' instead.", Justification = "<Pending>", Scope = "member", Target = "~F:NuGet.PackageManagement.VisualStudio.VSSolutionManager.VSNuGetClientName")]
[assembly: SuppressMessage("Build", "CA1305:The behavior of 'string.ToString()' could vary based on the current user's locale settings. Replace this call in 'ProjectTelemetryEvent.ProjectTelemetryEvent(string, string, NuGetProjectType, bool)' with a call to 'string.ToString(IFormatProvider)'.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.Telemetry.ProjectTelemetryEvent.#ctor(System.String,System.String,NuGet.PackageManagement.Telemetry.NuGetProjectType,System.Boolean)")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'ProjectTelemetryEvent.ProjectTelemetryEvent(string nuGetVersion, string projectId, NuGetProjectType nuGetProjectType, bool isPRUpgradable)', validate parameter 'projectId' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.Telemetry.ProjectTelemetryEvent.#ctor(System.String,System.String,NuGet.PackageManagement.Telemetry.NuGetProjectType,System.Boolean)")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'SearchPageTelemetryEvent.SearchPageTelemetryEvent(Guid parentId, int pageIndex, int resultCount, TimeSpan duration, IEnumerable<TimeSpan> sourceTimings, TimeSpan aggregationTime, LoadingStatus loadingStatus)', validate parameter 'sourceTimings' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.Telemetry.SearchPageTelemetryEvent.#ctor(System.Guid,System.Int32,System.Int32,System.TimeSpan,System.Collections.Generic.IEnumerable{System.TimeSpan},System.TimeSpan,NuGet.PackageManagement.VisualStudio.LoadingStatus)")]
[assembly: SuppressMessage("Build", "CA1031:Modify 'GetProjectTelemetryEventAsync' to catch a more specific allowed exception type, or rethrow the exception.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.Telemetry.VSTelemetryServiceUtility.GetProjectTelemetryEventAsync(NuGet.ProjectManagement.NuGetProject)~System.Threading.Tasks.Task{NuGet.PackageManagement.Telemetry.ProjectTelemetryEvent}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task<ProjectTelemetryEvent> VSTelemetryServiceUtility.GetProjectTelemetryEventAsync(NuGetProject nuGetProject)', validate parameter 'nuGetProject' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.Telemetry.VSTelemetryServiceUtility.GetProjectTelemetryEventAsync(NuGet.ProjectManagement.NuGetProject)~System.Threading.Tasks.Task{NuGet.PackageManagement.Telemetry.ProjectTelemetryEvent}")]
[assembly: SuppressMessage("Build", "CA1507:Use nameof in place of string literal 'bindingRedirects'", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.BindingRedirectManager.AddBindingRedirects(System.Collections.Generic.IEnumerable{NuGet.VisualStudio.AssemblyBinding})")]
[assembly: SuppressMessage("Build", "CA1305:The behavior of 'string.Format(string, object, object)' could vary based on the current user's locale settings. Replace this call in 'BindingRedirectManager.GetConfiguration(string)' with a call to 'string.Format(IFormatProvider, string, params object[])'.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.BindingRedirectManager.GetConfiguration(System.String)~System.Xml.Linq.XDocument")]
[assembly: SuppressMessage("Build", "CA1507:Use nameof in place of string literal 'bindingRedirects'", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.BindingRedirectManager.RemoveBindingRedirects(System.Collections.Generic.IEnumerable{NuGet.VisualStudio.AssemblyBinding})")]
[assembly: SuppressMessage("Build", "CA1507:Use nameof in place of string literal 'assemblies'", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.BindingRedirectResolver.GetBindingRedirects(System.Collections.Generic.IEnumerable{NuGet.VisualStudio.IAssembly})~System.Collections.Generic.IEnumerable{NuGet.VisualStudio.AssemblyBinding}")]
[assembly: SuppressMessage("Build", "CA1507:Use nameof in place of string literal 'domain'", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.BindingRedirectResolver.GetBindingRedirects(System.Collections.Generic.IEnumerable{System.String},System.AppDomain)~System.Collections.Generic.IEnumerable{NuGet.VisualStudio.AssemblyBinding}")]
[assembly: SuppressMessage("Build", "CA1507:Use nameof in place of string literal 'domain'", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.BindingRedirectResolver.GetBindingRedirects(System.String,System.AppDomain)~System.Collections.Generic.IEnumerable{NuGet.VisualStudio.AssemblyBinding}")]
[assembly: SuppressMessage("Build", "CA1303:Method 'Task<SearchResult<IPackageSearchMetadata>> ConsolidatePackageFeed.ContinueSearchAsync(ContinuationToken continuationToken, CancellationToken cancellationToken)' passes a literal string as parameter 'message' of a call to 'InvalidOperationException.InvalidOperationException(string message)'. Retrieve the following string(s) from a resource table instead: \"Invalid token\".", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.ConsolidatePackageFeed.ContinueSearchAsync(NuGet.PackageManagement.VisualStudio.ContinuationToken,System.Threading.CancellationToken)~System.Threading.Tasks.Task{NuGet.PackageManagement.VisualStudio.SearchResult{NuGet.Protocol.Core.Types.IPackageSearchMetadata}}")]
[assembly: SuppressMessage("Build", "CA1031:Modify 'IsSourceControlBound' to catch a more specific allowed exception type, or rethrow the exception.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.DefaultTFSSourceControlManager.IsSourceControlBound(System.String)~System.Boolean")]
[assembly: SuppressMessage("Build", "CA1031:Modify 'TryAddCredentialProviders' to catch a more specific allowed exception type, or rethrow the exception.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.DefaultVSCredentialServiceProvider.TryAddCredentialProviders(System.Collections.Generic.List{NuGet.Credentials.ICredentialProvider},System.String,System.Func{System.Collections.Generic.IEnumerable{NuGet.Credentials.ICredentialProvider}})")]
[assembly: SuppressMessage("Build", "CA1031:Modify 'TryAddCredentialProvidersAsync' to catch a more specific allowed exception type, or rethrow the exception.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.DefaultVSCredentialServiceProvider.TryAddCredentialProvidersAsync(System.Collections.Generic.List{NuGet.Credentials.ICredentialProvider},System.String,System.Func{System.Threading.Tasks.Task{System.Collections.Generic.IEnumerable{NuGet.Credentials.ICredentialProvider}}})~System.Threading.Tasks.Task")]
[assembly: SuppressMessage("Build", "CA1305:The behavior of 'Guid.ToString(string)' could vary based on the current user's locale settings. Replace this call in 'DeferredProjectWorkspaceService.GetProjectTypeGuidAsync(string)' with a call to 'Guid.ToString(string, IFormatProvider)'.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.DeferredProjectWorkspaceService.GetProjectTypeGuidAsync(System.String)~System.Threading.Tasks.Task{System.String}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'DeprecatedFrameworkModel.DeprecatedFrameworkModel(NuGetFramework deprecated, string migrationUrl, IEnumerable<NuGetProject> projects)', validate parameter 'deprecated' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.DeprecatedFrameworkModel.#ctor(NuGet.Frameworks.NuGetFramework,System.String,System.Collections.Generic.IEnumerable{NuGet.ProjectManagement.NuGetProject})")]
[assembly: SuppressMessage("Build", "CA1054:Uri parameters should not be strings", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.DeprecatedFrameworkModel.#ctor(NuGet.Frameworks.NuGetFramework,System.String,System.Collections.Generic.IReadOnlyList{System.String})")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'IEnumerable<NuGetProject> DotnetDeprecatedPrompt.GetAffectedProjects(IEnumerable<ResolvedAction> actions)', validate parameter 'actions' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.DotnetDeprecatedPrompt.GetAffectedProjects(System.Collections.Generic.IEnumerable{NuGet.PackageManagement.ResolvedAction})~System.Collections.Generic.IEnumerable{NuGet.ProjectManagement.NuGetProject}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task<bool> EnvDTEProjectUtility.ContainsFile(Project envDTEProject, string path)', validate parameter 'envDTEProject' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.EnvDTEProjectUtility.ContainsFile(EnvDTE.Project,System.String)~System.Threading.Tasks.Task{System.Boolean}")]
[assembly: SuppressMessage("Build", "CA1825:Avoid unnecessary zero-length array allocations.  Use Array.Empty<VSDOCUMENTPRIORITY>() instead.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.EnvDTEProjectUtility.ContainsFile(EnvDTE.Project,System.String)~System.Threading.Tasks.Task{System.Boolean}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task<NuGetProject> EnvDTEProjectUtility.GetNuGetProjectAsync(Project project, ISolutionManager solutionManager)', validate parameter 'project' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.EnvDTEProjectUtility.GetNuGetProjectAsync(EnvDTE.Project,NuGet.PackageManagement.ISolutionManager)~System.Threading.Tasks.Task{NuGet.ProjectManagement.NuGetProject}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task<ProjectItems> EnvDTEProjectUtility.GetProjectItemsAsync(Project envDTEProject, string folderPath, bool createIfNotExists)', validate parameter 'envDTEProject' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.EnvDTEProjectUtility.GetProjectItemsAsync(EnvDTE.Project,System.String,System.Boolean)~System.Threading.Tasks.Task{EnvDTE.ProjectItems}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task<bool> EnvDTEProjectUtility.HasBuildIntegratedConfig(Project project)', validate parameter 'project' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.EnvDTEProjectUtility.HasBuildIntegratedConfig(EnvDTE.Project)~System.Threading.Tasks.Task{System.Boolean}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'bool EnvDTEProjectUtility.IsExplicitlyUnsupported(Project envDTEProject)', validate parameter 'envDTEProject' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.EnvDTEProjectUtility.IsExplicitlyUnsupported(EnvDTE.Project)~System.Boolean")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'bool EnvDTEProjectUtility.IsParentProjectExplicitlyUnsupported(Project envDTEProject)', validate parameter 'envDTEProject' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.EnvDTEProjectUtility.IsParentProjectExplicitlyUnsupported(EnvDTE.Project)~System.Boolean")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'bool EnvDTEProjectUtility.IsSupported(Project envDTEProject)', validate parameter 'envDTEProject' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.EnvDTEProjectUtility.IsSupported(EnvDTE.Project)~System.Boolean")]
[assembly: SuppressMessage("Build", "CA1308:In method 'GetHashCode', replace the call to 'ToLowerInvariant' with 'ToUpperInvariant'.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.EnvDTEProjectUtility.PathComparer.GetHashCode(System.String)~System.Int32")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task<IEnumerable<Project>> EnvDTESolutionUtility.GetAllEnvDTEProjectsAsync(DTE dte)', validate parameter 'dte' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.EnvDTESolutionUtility.GetAllEnvDTEProjectsAsync(EnvDTE.DTE)~System.Threading.Tasks.Task{System.Collections.Generic.IEnumerable{EnvDTE.Project}}")]
[assembly: SuppressMessage("Build", "CA1031:Modify 'GetFrameworkAssemblies' to catch a more specific allowed exception type, or rethrow the exception.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.FrameworkAssemblyResolver.GetFrameworkAssemblies(System.String)~System.Collections.Generic.List{NuGet.PackageManagement.VisualStudio.FrameworkAssembly}")]
[assembly: SuppressMessage("Build", "CA1031:Modify 'RemoveReferenceAsync' to catch a more specific allowed exception type, or rethrow the exception.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.FSharpProjectSystem.RemoveReferenceAsync(System.String)~System.Threading.Tasks.Task")]
[assembly: SuppressMessage("Build", "CA1303:Method 'Task<SearchResult<IPackageSearchMetadata>> InstalledPackageFeed.ContinueSearchAsync(ContinuationToken continuationToken, CancellationToken cancellationToken)' passes a literal string as parameter 'message' of a call to 'InvalidOperationException.InvalidOperationException(string message)'. Retrieve the following string(s) from a resource table instead: \"Invalid token\".", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.InstalledPackageFeed.ContinueSearchAsync(NuGet.PackageManagement.VisualStudio.ContinuationToken,System.Threading.CancellationToken)~System.Threading.Tasks.Task{NuGet.PackageManagement.VisualStudio.SearchResult{NuGet.Protocol.Core.Types.IPackageSearchMetadata}}")]
[assembly: SuppressMessage("Build", "CA1304:The behavior of 'string.ToLower()' could vary based on the current user's locale settings. Replace this call in 'InteractiveLoginProvider.IsValidScheme(Uri)' with a call to 'string.ToLower(CultureInfo)'.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.InteractiveLoginProvider.IsValidScheme(System.Uri)~System.Boolean")]
[assembly: SuppressMessage("Build", "CA1307:The behavior of 'string.Equals(string, string)' could vary based on the current user's locale settings. Replace this call in 'NuGet.PackageManagement.VisualStudio.InteractiveLoginProvider.LookupTenant(System.Uri, System.Net.IWebProxy, System.Threading.CancellationToken)' with a call to 'string.Equals(string, string, System.StringComparison)'.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.InteractiveLoginProvider.LookupTenant(System.Uri,System.Net.IWebProxy,System.Threading.CancellationToken)~System.Threading.Tasks.Task{System.String}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'LegacyPackageReferenceProject.LegacyPackageReferenceProject(IVsProjectAdapter vsProjectAdapter, string projectId, INuGetProjectServices projectServices, IVsProjectThreadingService threadingService)', validate parameter 'vsProjectAdapter' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.LegacyPackageReferenceProject.#ctor(NuGet.VisualStudio.IVsProjectAdapter,System.String,NuGet.ProjectManagement.INuGetProjectServices,NuGet.PackageManagement.VisualStudio.IVsProjectThreadingService)")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task LegacyPackageReferenceProject.AddFileToProjectAsync(string filePath)', validate parameter 'filePath' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.LegacyPackageReferenceProject.AddFileToProjectAsync(System.String)~System.Threading.Tasks.Task")]
[assembly: SuppressMessage("Build", "CA1822:Member GetConfigFilePaths does not access instance data and can be marked as static (Shared in VisualBasic)", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.LegacyPackageReferenceProject.GetConfigFilePaths(NuGet.Configuration.ISettings)~System.Collections.Generic.IList{System.String}")]
[assembly: SuppressMessage("Build", "CA1801:Parameter shouldThrow of method GetFallbackFolders is never used. Remove the parameter or use it in the method body.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.LegacyPackageReferenceProject.GetFallbackFolders(NuGet.Configuration.ISettings,System.Boolean)~System.Collections.Generic.IList{System.String}")]
[assembly: SuppressMessage("Build", "CA1305:The behavior of 'string.Format(string, object, object)' could vary based on the current user's locale settings. Replace this call in 'LegacyPackageReferenceProject.GetMSBuildProjectExtensionsPath([bool])' with a call to 'string.Format(IFormatProvider, string, params object[])'.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.LegacyPackageReferenceProject.GetMSBuildProjectExtensionsPath(System.Boolean)~System.String")]
[assembly: SuppressMessage("Build", "CA1825:Avoid unnecessary zero-length array allocations.  Use Array.Empty<string>() instead.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.LegacyPackageReferenceProject.GetPackageSpecAsync(NuGet.Configuration.ISettings)~System.Threading.Tasks.Task{NuGet.ProjectModel.PackageSpec}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task<bool> LegacyPackageReferenceProject.InstallPackageAsync(string packageId, VersionRange range, INuGetProjectContext _, BuildIntegratedInstallationContext __, CancellationToken token)', validate parameter '__' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.LegacyPackageReferenceProject.InstallPackageAsync(System.String,NuGet.Versioning.VersionRange,NuGet.ProjectManagement.INuGetProjectContext,NuGet.ProjectManagement.BuildIntegratedInstallationContext,System.Threading.CancellationToken)~System.Threading.Tasks.Task{System.Boolean}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task<bool> LegacyPackageReferenceProject.UninstallPackageAsync(PackageIdentity packageIdentity, INuGetProjectContext _, CancellationToken token)', validate parameter 'packageIdentity' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.LegacyPackageReferenceProject.UninstallPackageAsync(NuGet.Packaging.Core.PackageIdentity,NuGet.ProjectManagement.INuGetProjectContext,System.Threading.CancellationToken)~System.Threading.Tasks.Task{System.Boolean}")]
[assembly: SuppressMessage("Build", "CA1822:Member CreateCoreProjectSystemServices does not access instance data and can be marked as static (Shared in VisualBasic)", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.LegacyPackageReferenceProjectProvider.CreateCoreProjectSystemServices(NuGet.VisualStudio.IVsProjectAdapter,Microsoft.VisualStudio.ComponentModelHost.IComponentModel)~NuGet.ProjectManagement.INuGetProjectServices")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task<NuGetProject> LegacyPackageReferenceProjectProvider.TryCreateNuGetProjectAsync(IVsProjectAdapter vsProjectAdapter, ProjectProviderContext context, bool forceProjectType)', validate parameter 'vsProjectAdapter' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.LegacyPackageReferenceProjectProvider.TryCreateNuGetProjectAsync(NuGet.VisualStudio.IVsProjectAdapter,NuGet.PackageManagement.VisualStudio.ProjectProviderContext,System.Boolean)~System.Threading.Tasks.Task{NuGet.ProjectManagement.NuGetProject}")]
[assembly: SuppressMessage("Build", "CA1031:Modify 'GetAssemblyReferences' to catch a more specific allowed exception type, or rethrow the exception.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.MicrosoftBuildEvaluationProjectUtility.GetAssemblyReferences(Microsoft.Build.Evaluation.Project)~System.Collections.Generic.IEnumerable{System.Tuple{Microsoft.Build.Evaluation.ProjectItem,System.Reflection.AssemblyName}}")]
[assembly: SuppressMessage("Build", "CA1303:Method 'MultiSourcePackageFeed.MultiSourcePackageFeed(IEnumerable<SourceRepository> sourceRepositories, INuGetUILogger logger, INuGetTelemetryService telemetryService)' passes a literal string as parameter 'message' of a call to 'ArgumentException.ArgumentException(string message, string paramName)'. Retrieve the following string(s) from a resource table instead: \"Collection of source repositories cannot be empty\".", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.MultiSourcePackageFeed.#ctor(System.Collections.Generic.IEnumerable{NuGet.Protocol.Core.Types.SourceRepository},NuGet.PackageManagement.VisualStudio.INuGetUILogger,NuGet.Common.INuGetTelemetryService)")]
[assembly: SuppressMessage("Build", "CA1822:Member AggregateSearchResultsAsync does not access instance data and can be marked as static (Shared in VisualBasic)", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.MultiSourcePackageFeed.AggregateSearchResultsAsync(System.String,System.Collections.Generic.IEnumerable{NuGet.PackageManagement.VisualStudio.SearchResult{NuGet.Protocol.Core.Types.IPackageSearchMetadata}},NuGet.PackageManagement.VisualStudio.MultiSourcePackageFeed.TelemetryState)~System.Threading.Tasks.Task{NuGet.PackageManagement.VisualStudio.SearchResult{NuGet.Protocol.Core.Types.IPackageSearchMetadata}}")]
[assembly: SuppressMessage("Build", "CA1303:Method 'Task<SearchResult<IPackageSearchMetadata>> MultiSourcePackageFeed.ContinueSearchAsync(ContinuationToken continuationToken, CancellationToken cancellationToken)' passes a literal string as parameter 'message' of a call to 'InvalidOperationException.InvalidOperationException(string message)'. Retrieve the following string(s) from a resource table instead: \"Invalid token\".", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.MultiSourcePackageFeed.ContinueSearchAsync(NuGet.PackageManagement.VisualStudio.ContinuationToken,System.Threading.CancellationToken)~System.Threading.Tasks.Task{NuGet.PackageManagement.VisualStudio.SearchResult{NuGet.Protocol.Core.Types.IPackageSearchMetadata}}")]
[assembly: SuppressMessage("Build", "CA1303:Method 'Task<SearchResult<IPackageSearchMetadata>> MultiSourcePackageFeed.RefreshSearchAsync(RefreshToken refreshToken, CancellationToken cancellationToken)' passes a literal string as parameter 'message' of a call to 'InvalidOperationException.InvalidOperationException(string message)'. Retrieve the following string(s) from a resource table instead: \"Invalid token\".", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.MultiSourcePackageFeed.RefreshSearchAsync(NuGet.PackageManagement.VisualStudio.RefreshToken,System.Threading.CancellationToken)~System.Threading.Tasks.Task{NuGet.PackageManagement.VisualStudio.SearchResult{NuGet.Protocol.Core.Types.IPackageSearchMetadata}}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task<SearchResult<IPackageSearchMetadata>> MultiSourcePackageFeed.SearchAsync(string searchText, SearchFilter filter, CancellationToken cancellationToken)', validate parameter 'filter' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.MultiSourcePackageFeed.SearchAsync(System.String,NuGet.Protocol.Core.Types.SearchFilter,System.Threading.CancellationToken)~System.Threading.Tasks.Task{NuGet.PackageManagement.VisualStudio.SearchResult{NuGet.Protocol.Core.Types.IPackageSearchMetadata}}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task<IPackageSearchMetadata> MultiSourcePackageMetadataProvider.GetLatestPackageMetadataAsync(PackageIdentity identity, NuGetProject project, bool includePrerelease, CancellationToken cancellationToken)', validate parameter 'project' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.MultiSourcePackageMetadataProvider.GetLatestPackageMetadataAsync(NuGet.Packaging.Core.PackageIdentity,NuGet.ProjectManagement.NuGetProject,System.Boolean,System.Threading.CancellationToken)~System.Threading.Tasks.Task{NuGet.Protocol.Core.Types.IPackageSearchMetadata}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task<IPackageSearchMetadata> MultiSourcePackageMetadataProvider.GetLocalPackageMetadataAsync(PackageIdentity identity, bool includePrerelease, CancellationToken cancellationToken)', validate parameter 'identity' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.MultiSourcePackageMetadataProvider.GetLocalPackageMetadataAsync(NuGet.Packaging.Core.PackageIdentity,System.Boolean,System.Threading.CancellationToken)~System.Threading.Tasks.Task{NuGet.Protocol.Core.Types.IPackageSearchMetadata}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task<IPackageSearchMetadata> MultiSourcePackageMetadataProvider.GetPackageMetadataAsync(PackageIdentity identity, bool includePrerelease, CancellationToken cancellationToken)', validate parameter 'identity' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.MultiSourcePackageMetadataProvider.GetPackageMetadataAsync(NuGet.Packaging.Core.PackageIdentity,System.Boolean,System.Threading.CancellationToken)~System.Threading.Tasks.Task{NuGet.Protocol.Core.Types.IPackageSearchMetadata}")]
[assembly: SuppressMessage("Build", "CA1801:Parameter identity of method MergeDeprecationMetadataAsync is never used. Remove the parameter or use it in the method body.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.MultiSourcePackageMetadataProvider.MergeDeprecationMetadataAsync(NuGet.Packaging.Core.PackageIdentity,System.Collections.Generic.IEnumerable{NuGet.Protocol.Core.Types.IPackageSearchMetadata})~System.Threading.Tasks.Task{NuGet.Protocol.PackageDeprecationMetadata}")]
[assembly: SuppressMessage("Build", "CA1305:The behavior of 'string.Format(string, object)' could vary based on the current user's locale settings. Replace this call in 'CpsPackageReferenceProject.GetAssetsFilePathAsync(bool)' with a call to 'string.Format(IFormatProvider, string, params object[])'.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.CpsPackageReferenceProject.GetAssetsFilePathAsync(System.Boolean)~System.Threading.Tasks.Task{System.String}")]
[assembly: SuppressMessage("Build", "CA1305:The behavior of 'string.Format(string, object)' could vary based on the current user's locale settings. Replace this call in 'CpsPackageReferenceProject.GetCacheFilePathAsync()' with a call to 'string.Format(IFormatProvider, string, params object[])'.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.CpsPackageReferenceProject.GetCacheFilePathAsync~System.Threading.Tasks.Task{System.String}")]
[assembly: SuppressMessage("Build", "CA1825:Avoid unnecessary zero-length array allocations.  Use Array.Empty<PackageReference>() instead.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.CpsPackageReferenceProject.GetInstalledPackagesAsync(System.Threading.CancellationToken)~System.Threading.Tasks.Task{System.Collections.Generic.IEnumerable{NuGet.Packaging.PackageReference}}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task<bool> CpsPackageReferenceProject.InstallPackageAsync(string packageId, VersionRange range, INuGetProjectContext nuGetProjectContext, BuildIntegratedInstallationContext installationContext, CancellationToken token)', validate parameter 'range' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.CpsPackageReferenceProject.InstallPackageAsync(System.String,NuGet.Versioning.VersionRange,NuGet.ProjectManagement.INuGetProjectContext,NuGet.ProjectManagement.BuildIntegratedInstallationContext,System.Threading.CancellationToken)~System.Threading.Tasks.Task{System.Boolean}")]
[assembly: SuppressMessage("Build", "CA1305:The behavior of 'string.Format(string, object)' could vary based on the current user's locale settings. Replace this call in 'CpsPackageReferenceProject.InstallPackageAsync(string, VersionRange, INuGetProjectContext, BuildIntegratedInstallationContext, CancellationToken)' with a call to 'string.Format(IFormatProvider, string, params object[])'.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.CpsPackageReferenceProject.InstallPackageAsync(System.String,NuGet.Versioning.VersionRange,NuGet.ProjectManagement.INuGetProjectContext,NuGet.ProjectManagement.BuildIntegratedInstallationContext,System.Threading.CancellationToken)~System.Threading.Tasks.Task{System.Boolean}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task<bool> CpsPackageReferenceProject.UninstallPackageAsync(PackageIdentity packageIdentity, INuGetProjectContext nuGetProjectContext, CancellationToken token)', validate parameter 'packageIdentity' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.CpsPackageReferenceProject.UninstallPackageAsync(NuGet.Packaging.Core.PackageIdentity,NuGet.ProjectManagement.INuGetProjectContext,System.Threading.CancellationToken)~System.Threading.Tasks.Task{System.Boolean}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task<NuGetProject> CpsPackageReferenceProjectProvider.TryCreateNuGetProjectAsync(IVsProjectAdapter vsProject, ProjectProviderContext context, bool forceProjectType)', validate parameter 'vsProject' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.CpsPackageReferenceProjectProvider.TryCreateNuGetProjectAsync(NuGet.VisualStudio.IVsProjectAdapter,NuGet.PackageManagement.VisualStudio.ProjectProviderContext,System.Boolean)~System.Threading.Tasks.Task{NuGet.ProjectManagement.NuGetProject}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'NuGetLockService.NuGetLockService(JoinableTaskContext joinableTaskContext)', validate parameter 'joinableTaskContext' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.NuGetLockService.#ctor(Microsoft.VisualStudio.Threading.JoinableTaskContext)")]
[assembly: SuppressMessage("Build", "CA1031:Modify 'CreateNuGetProjectAsync' to catch a more specific allowed exception type, or rethrow the exception.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.NuGetProjectFactory.CreateNuGetProjectAsync``1(NuGet.VisualStudio.IVsProjectAdapter,NuGet.PackageManagement.VisualStudio.ProjectProviderContext)~System.Threading.Tasks.Task{``0}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task<TProject> NuGetProjectFactory.CreateNuGetProjectAsync<TProject>(IVsProjectAdapter vsProjectAdapter, ProjectProviderContext optionalContext = null)', validate parameter 'vsProjectAdapter' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.NuGetProjectFactory.CreateNuGetProjectAsync``1(NuGet.VisualStudio.IVsProjectAdapter,NuGet.PackageManagement.VisualStudio.ProjectProviderContext)~System.Threading.Tasks.Task{``0}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task<NuGetProject> NuGetProjectFactory.TryCreateNuGetProjectAsync(IVsProjectAdapter vsProjectAdapter, ProjectProviderContext context)', validate parameter 'vsProjectAdapter' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.NuGetProjectFactory.TryCreateNuGetProjectAsync(NuGet.VisualStudio.IVsProjectAdapter,NuGet.PackageManagement.VisualStudio.ProjectProviderContext)~System.Threading.Tasks.Task{NuGet.ProjectManagement.NuGetProject}")]
[assembly: SuppressMessage("Build", "CA1031:Modify 'TryCreateNuGetProjectAsync' to catch a more specific allowed exception type, or rethrow the exception.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.NuGetProjectFactory.TryCreateNuGetProjectAsync(NuGet.VisualStudio.IVsProjectAdapter,NuGet.PackageManagement.VisualStudio.ProjectProviderContext)~System.Threading.Tasks.Task{NuGet.ProjectManagement.NuGetProject}")]
[assembly: SuppressMessage("Build", "CA1305:The behavior of 'string.Format(string, object)' could vary based on the current user's locale settings. Replace this call in 'ProjectJsonToPackageRefMigrator.MigrateAsync(BuildIntegratedNuGetProject)' with a call to 'string.Format(IFormatProvider, string, params object[])'.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.ProjectJsonToPackageRefMigrator.MigrateAsync(NuGet.ProjectManagement.Projects.BuildIntegratedNuGetProject)~System.Threading.Tasks.Task")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task ProjectJsonToPackageRefMigrator.MigrateAsync(BuildIntegratedNuGetProject project)', validate parameter 'project' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.ProjectJsonToPackageRefMigrator.MigrateAsync(NuGet.ProjectManagement.Projects.BuildIntegratedNuGetProject)~System.Threading.Tasks.Task")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'List<PackageIdentity> ProjectRetargetingUtility.GetPackagesToBeReinstalled(NuGetFramework projectFramework, IEnumerable<PackageReference> packageReferences)', validate parameter 'packageReferences' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.ProjectRetargetingUtility.GetPackagesToBeReinstalled(NuGet.Frameworks.NuGetFramework,System.Collections.Generic.IEnumerable{NuGet.Packaging.PackageReference})~System.Collections.Generic.List{NuGet.Packaging.Core.PackageIdentity}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task ProjectRetargetingUtility.MarkPackagesForReinstallation(NuGetProject project, IList<PackageIdentity> packagesToBeReinstalled)', validate parameter 'project' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.ProjectRetargetingUtility.MarkPackagesForReinstallation(NuGet.ProjectManagement.NuGetProject,System.Collections.Generic.IList{NuGet.Packaging.Core.PackageIdentity})~System.Threading.Tasks.Task")]
[assembly: SuppressMessage("Build", "CA1031:Modify 'MarkPackagesForReinstallation' to catch a more specific allowed exception type, or rethrow the exception.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.ProjectRetargetingUtility.MarkPackagesForReinstallation(NuGet.ProjectManagement.NuGetProject,System.Collections.Generic.IList{NuGet.Packaging.Core.PackageIdentity})~System.Threading.Tasks.Task")]
[assembly: SuppressMessage("Build", "CA1031:Modify 'ShouldPackageBeReinstalled' to catch a more specific allowed exception type, or rethrow the exception.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.ProjectRetargetingUtility.ShouldPackageBeReinstalled(NuGet.Frameworks.NuGetFramework,NuGet.Frameworks.NuGetFramework,NuGet.Packaging.Core.PackageIdentity,NuGet.PackageManagement.NuGetPackageManager)~System.Boolean")]
[assembly: SuppressMessage("Build", "CA1507:Use nameof in place of string literal 'projectSystem'", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.RefreshFileUtility.CreateRefreshFile(NuGet.PackageManagement.VisualStudio.VsMSBuildProjectSystem,System.String)")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'void RefreshFileUtility.CreateRefreshFile(string root, string assemblyPath, IMSBuildProjectSystem msbuildNuGetProjectSystem)', validate parameter 'msbuildNuGetProjectSystem' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.RefreshFileUtility.CreateRefreshFile(System.String,System.String,NuGet.ProjectManagement.IMSBuildProjectSystem)")]
[assembly: SuppressMessage("Build", "CA1031:Modify 'SafeResolveRefreshPath' to catch a more specific allowed exception type, or rethrow the exception.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.RefreshFileUtility.SafeResolveRefreshPath(System.String,System.String)~System.String")]
[assembly: SuppressMessage("Build", "CA1031:Modify 'GetBooleanSetting' to catch a more specific allowed exception type, or rethrow the exception.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.RegistrySettingUtility.GetBooleanSetting(System.String)~System.Boolean")]
[assembly: SuppressMessage("Build", "CA1031:Modify 'SetBooleanSetting' to catch a more specific allowed exception type, or rethrow the exception.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.RegistrySettingUtility.SetBooleanSetting(System.String,System.Boolean)")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task<IEnumerable<AssemblyBinding>> RuntimeHelpers.AddBindingRedirectsAsync(ISolutionManager solutionManager, IVsProjectAdapter vsProjectAdapter, AppDomain domain, IDictionary<string, HashSet<string>> projectAssembliesCache, IVsFrameworkMultiTargeting frameworkMultiTargeting, INuGetProjectContext nuGetProjectContext)', validate parameter 'projectAssembliesCache' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.RuntimeHelpers.AddBindingRedirectsAsync(NuGet.PackageManagement.ISolutionManager,NuGet.VisualStudio.IVsProjectAdapter,System.AppDomain,System.Collections.Generic.IDictionary{System.String,System.Collections.Generic.HashSet{System.String}},Microsoft.VisualStudio.Shell.Interop.IVsFrameworkMultiTargeting,NuGet.ProjectManagement.INuGetProjectContext)~System.Threading.Tasks.Task{System.Collections.Generic.IEnumerable{NuGet.VisualStudio.AssemblyBinding}}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task RuntimeHelpers.AddBindingRedirectsAsync(VSSolutionManager vsSolutionManager, IVsProjectAdapter vsProjectAdapter, IVsFrameworkMultiTargeting frameworkMultiTargeting, INuGetProjectContext nuGetProjectContext)', validate parameter 'vsSolutionManager' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.RuntimeHelpers.AddBindingRedirectsAsync(NuGet.PackageManagement.VisualStudio.VSSolutionManager,NuGet.VisualStudio.IVsProjectAdapter,Microsoft.VisualStudio.Shell.Interop.IVsFrameworkMultiTargeting,NuGet.ProjectManagement.INuGetProjectContext)~System.Threading.Tasks.Task")]
[assembly: SuppressMessage("Build", "CA1031:Modify 'QueueUnloadAndForget' to catch a more specific allowed exception type, or rethrow the exception.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.RuntimeHelpers.QueueUnloadAndForget(System.AppDomain)")]
[assembly: SuppressMessage("Build", "CA1825:Avoid unnecessary zero-length array allocations.  Use Array.Empty<T>() instead.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.SearchResult.Empty``1~NuGet.PackageManagement.VisualStudio.SearchResult{``0}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'SearchResult<T> SearchResult.FromItems<T>(IReadOnlyList<T> items)', validate parameter 'items' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.SearchResult.FromItems``1(System.Collections.Generic.IReadOnlyList{``0})~NuGet.PackageManagement.VisualStudio.SearchResult{``0}")]
[assembly: SuppressMessage("Build", "CA1303:Method 'void SettingsHelper.AddSource(string name, string source)' passes a literal string as parameter 'message' of a call to 'ArgumentException.ArgumentException(string message)'. Retrieve the following string(s) from a resource table instead: \"sourceRepositoryProvider\".", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.SettingsHelper.AddSource(System.String,System.String)")]
[assembly: SuppressMessage("Build", "CA1303:Method 'void SettingsHelper.RemoveSource(string name)' passes a literal string as parameter 'message' of a call to 'ArgumentException.ArgumentException(string message)'. Retrieve the following string(s) from a resource table instead: \"sourceRepositoryProvider\".", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.SettingsHelper.RemoveSource(System.String)")]
[assembly: SuppressMessage("Build", "CA1507:Use nameof in place of string literal 'serviceProvider'", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.SettingsManagerBase.#ctor(Microsoft.VisualStudio.Shell.IAsyncServiceProvider)")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'string[] SettingsManagerBase.ReadStrings(string settingsRoot, string[] properties, string defaultValue = \"\")', validate parameter 'properties' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.SettingsManagerBase.ReadStrings(System.String,System.String[],System.String)~System.String[]")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'void SettingsManagerBase.WriteStrings(string settingsRoot, string[] properties, string[] values)', validate parameter 'properties' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.SettingsManagerBase.WriteStrings(System.String,System.String[],System.String[])")]
[assembly: SuppressMessage("Build", "CA1303:Method 'Task<SearchResult<IPackageSearchMetadata>> SourceRepositoryExtensions.SearchAsync(SourceRepository sourceRepository, ContinuationToken continuationToken, int pageSize, CancellationToken cancellationToken)' passes a literal string as parameter 'message' of a call to 'InvalidOperationException.InvalidOperationException(string message)'. Retrieve the following string(s) from a resource table instead: \"Invalid token\".", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.SourceRepositoryExtensions.SearchAsync(NuGet.Protocol.Core.Types.SourceRepository,NuGet.PackageManagement.VisualStudio.ContinuationToken,System.Int32,System.Threading.CancellationToken)~System.Threading.Tasks.Task{NuGet.PackageManagement.VisualStudio.SearchResult{NuGet.Protocol.Core.Types.IPackageSearchMetadata}}")]
[assembly: SuppressMessage("Build", "CA1825:Avoid unnecessary zero-length array allocations.  Use Array.Empty<IPackageSearchMetadata>() instead.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.SourceRepositoryExtensions.SearchAsync(NuGet.Protocol.Core.Types.SourceRepository,NuGet.PackageManagement.VisualStudio.ContinuationToken,System.Int32,System.Threading.CancellationToken)~System.Threading.Tasks.Task{NuGet.PackageManagement.VisualStudio.SearchResult{NuGet.Protocol.Core.Types.IPackageSearchMetadata}}")]
[assembly: SuppressMessage("Build", "CA1303:Method 'Task<SearchResult<IPackageSearchMetadata>> UpdatePackageFeed.ContinueSearchAsync(ContinuationToken continuationToken, CancellationToken cancellationToken)' passes a literal string as parameter 'message' of a call to 'InvalidOperationException.InvalidOperationException(string message)'. Retrieve the following string(s) from a resource table instead: \"Invalid token\".", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.UpdatePackageFeed.ContinueSearchAsync(NuGet.PackageManagement.VisualStudio.ContinuationToken,System.Threading.CancellationToken)~System.Threading.Tasks.Task{NuGet.PackageManagement.VisualStudio.SearchResult{NuGet.Protocol.Core.Types.IPackageSearchMetadata}}")]
[assembly: SuppressMessage("Build", "CA1031:Modify 'SaveProjectAsync' to catch a more specific allowed exception type, or rethrow the exception.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.VsCoreProjectSystem.SaveProjectAsync(System.Threading.CancellationToken)~System.Threading.Tasks.Task")]
[assembly: SuppressMessage("Build", "CA1031:Modify 'GetProjectReferencesAsync' to catch a more specific allowed exception type, or rethrow the exception.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.VsCoreProjectSystemReferenceReader.GetProjectReferencesAsync(NuGet.Common.ILogger,System.Threading.CancellationToken)~System.Threading.Tasks.Task{System.Collections.Generic.IEnumerable{NuGet.ProjectModel.ProjectRestoreReference}}")]
[assembly: SuppressMessage("Build", "CA1031:Modify 'IsProjectReference' to catch a more specific allowed exception type, or rethrow the exception.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.VsCoreProjectSystemReferenceReader.IsProjectReference(VSLangProj80.Reference3,NuGet.Common.ILogger)~System.Boolean")]
[assembly: SuppressMessage("Build", "CA1031:Modify 'IsReferenceResolved' to catch a more specific allowed exception type, or rethrow the exception.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.VsCoreProjectSystemReferenceReader.IsReferenceResolved(VSLangProj80.Reference3,NuGet.Common.ILogger)~System.Boolean")]
[assembly: SuppressMessage("Build", "CA1307:The behavior of 'string.CompareTo(string)' could vary based on the current user's locale settings. Replace this call in 'NuGet.PackageManagement.VisualStudio.VsCredentialProviderImporter.GetProviders()' with a call to 'string.Compare(string, string, System.StringComparison)'.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.VsCredentialProviderImporter.GetProviders~System.Collections.Generic.IReadOnlyCollection{NuGet.Credentials.ICredentialProvider}")]
[assembly: SuppressMessage("Build", "CA1031:Modify 'TryImportCredentialProviders' to catch a more specific allowed exception type, or rethrow the exception.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.VsCredentialProviderImporter.TryImportCredentialProviders(System.Collections.Generic.List{NuGet.Credentials.ICredentialProvider},System.Collections.Generic.IEnumerable{System.Lazy{NuGet.VisualStudio.IVsCredentialProvider}})")]
[assembly: SuppressMessage("Build", "CA1305:The behavior of 'string.Format(string, object)' could vary based on the current user's locale settings. Replace this call in 'VsCredentialProviderImporter.TryImportCredentialProviders(List<ICredentialProvider>, IEnumerable<Lazy<IVsCredentialProvider>>)' with a call to 'string.Format(IFormatProvider, string, params object[])'.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.VsCredentialProviderImporter.TryImportCredentialProviders(System.Collections.Generic.List{NuGet.Credentials.ICredentialProvider},System.Collections.Generic.IEnumerable{System.Lazy{NuGet.VisualStudio.IVsCredentialProvider}})")]
[assembly: SuppressMessage("Build", "CA1825:Avoid unnecessary zero-length array allocations.  Use Array.Empty<LibraryDependency>() instead.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.VsManagedLanguagesProjectSystemServices.GetPackageReferencesAsync(NuGet.Frameworks.NuGetFramework,System.Threading.CancellationToken)~System.Threading.Tasks.Task{System.Collections.Generic.IEnumerable{NuGet.LibraryModel.LibraryDependency}}")]
[assembly: SuppressMessage("Build", "CA1825:Avoid unnecessary zero-length array allocations.  Use Array.Empty<ProjectRestoreReference>() instead.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.VsManagedLanguagesProjectSystemServices.GetProjectReferencesAsync(NuGet.Common.ILogger,System.Threading.CancellationToken)~System.Threading.Tasks.Task{System.Collections.Generic.IEnumerable{NuGet.ProjectModel.ProjectRestoreReference}}")]
[assembly: SuppressMessage("Build", "CA1307:The behavior of 'string.Equals(string)' could vary based on the current user's locale settings. Replace this call in 'NuGet.PackageManagement.VisualStudio.VsMSBuildProjectSystem.AddFileCoreAsync(string, System.Action)' with a call to 'string.Equals(string, System.StringComparison)'.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.VsMSBuildProjectSystem.AddFileCoreAsync(System.String,System.Action)~System.Threading.Tasks.Task")]
[assembly: SuppressMessage("Build", "CA1031:Modify 'AddReferenceAsync' to catch a more specific allowed exception type, or rethrow the exception.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.VsMSBuildProjectSystem.AddReferenceAsync(System.String)~System.Threading.Tasks.Task")]
[assembly: SuppressMessage("Build", "CA1801:Parameter desiredKind of method GetChildItems is never used. Remove the parameter or use it in the method body.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.VsMSBuildProjectSystem.GetChildItems(System.String,System.String,System.String)~System.Collections.Generic.IEnumerable{System.String}")]
[assembly: SuppressMessage("Build", "CA1031:Modify 'ReferenceExistsAsync' to catch a more specific allowed exception type, or rethrow the exception.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.VsMSBuildProjectSystem.ReferenceExistsAsync(System.String)~System.Threading.Tasks.Task{System.Boolean}")]
[assembly: SuppressMessage("Build", "CA1031:Modify 'RemoveReferenceAsync' to catch a more specific allowed exception type, or rethrow the exception.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.VsMSBuildProjectSystem.RemoveReferenceAsync(System.String)~System.Threading.Tasks.Task")]
[assembly: SuppressMessage("Build", "CA1031:Modify 'SaveProjectAsync' to catch a more specific allowed exception type, or rethrow the exception.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.VsMSBuildProjectSystem.SaveProjectAsync(System.Threading.CancellationToken)~System.Threading.Tasks.Task")]
[assembly: SuppressMessage("Build", "CA1031:Modify 'UpdateImportStamp' to catch a more specific allowed exception type, or rethrow the exception.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.VsMSBuildProjectSystem.UpdateImportStamp(NuGet.VisualStudio.IVsProjectAdapter)")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'void VsMSBuildProjectSystem.UpdateImportStamp(IVsProjectAdapter vsProjectAdapter)', validate parameter 'vsProjectAdapter' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.VsMSBuildProjectSystem.UpdateImportStamp(NuGet.VisualStudio.IVsProjectAdapter)")]
[assembly: SuppressMessage("Build", "CA1305:The behavior of 'string.Format(string, object, object)' could vary based on the current user's locale settings. Replace this call in 'VsProjectJsonNuGetProject.GetMSBuildProjectExtensionsPathAsync()' with a call to 'string.Format(IFormatProvider, string, params object[])'.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.VsProjectJsonNuGetProject.GetMSBuildProjectExtensionsPathAsync~System.Threading.Tasks.Task{System.String}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'IEnumerable<string> VSRestoreSettingsUtilities.GetEntriesWithAdditional(string[] values, string[] additional)', validate parameter 'additional' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.VSRestoreSettingsUtilities.GetEntriesWithAdditional(System.String[],System.String[])~System.Collections.Generic.IEnumerable{System.String}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'IList<string> VSRestoreSettingsUtilities.GetFallbackFolders(ISettings settings, PackageSpec project)', validate parameter 'project' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.VSRestoreSettingsUtilities.GetFallbackFolders(NuGet.Configuration.ISettings,NuGet.ProjectModel.PackageSpec)~System.Collections.Generic.IList{System.String}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'string VSRestoreSettingsUtilities.GetPackagesPath(ISettings settings, PackageSpec project)', validate parameter 'project' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.VSRestoreSettingsUtilities.GetPackagesPath(NuGet.Configuration.ISettings,NuGet.ProjectModel.PackageSpec)~System.String")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'IList<PackageSource> VSRestoreSettingsUtilities.GetSources(ISettings settings, PackageSpec project)', validate parameter 'project' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.VSRestoreSettingsUtilities.GetSources(NuGet.Configuration.ISettings,NuGet.ProjectModel.PackageSpec)~System.Collections.Generic.IList{NuGet.Configuration.PackageSource}")]
[assembly: SuppressMessage("Build", "CA1307:The behavior of 'string.Equals(string, string)' could vary based on the current user's locale settings. Replace this call in 'NuGet.PackageManagement.VisualStudio.VSSettings.ResetSolutionSettingsIfNeeded()' with a call to 'string.Equals(string, string, System.StringComparison)'.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.VSSettings.ResetSolutionSettingsIfNeeded~System.Boolean")]
[assembly: SuppressMessage("Build", "CA1031:Modify 'EnsureInitializeAsync' to catch a more specific allowed exception type, or rethrow the exception.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.VSSolutionManager.EnsureInitializeAsync~System.Threading.Tasks.Task")]
[assembly: SuppressMessage("Build", "CA1031:Modify 'EnsureNuGetAndVsProjectAdapterCacheAsync' to catch a more specific allowed exception type, or rethrow the exception.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.VSSolutionManager.EnsureNuGetAndVsProjectAdapterCacheAsync~System.Threading.Tasks.Task")]
[assembly: SuppressMessage("Build", "CA1031:Modify 'FireNuGetCacheUpdatedEventAsync' to catch a more specific allowed exception type, or rethrow the exception.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.VSSolutionManager.FireNuGetCacheUpdatedEventAsync(NuGet.PackageManagement.NuGetEventArgs{System.String})~System.Threading.Tasks.Task")]
[assembly: SuppressMessage("Build", "CA1507:Use nameof in place of string literal 'nuGetProject'", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.VSSolutionManager.GetNuGetProjectSafeNameAsync(NuGet.ProjectManagement.NuGetProject)~System.Threading.Tasks.Task{System.String}")]
[assembly: SuppressMessage("Build", "CA1305:The behavior of 'Guid.ToString(string)' could vary based on the current user's locale settings. Replace this call in 'VSSolutionManager.InitializeAsync()' with a call to 'Guid.ToString(string, IFormatProvider)'.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.VSSolutionManager.InitializeAsync~System.Threading.Tasks.Task")]
[assembly: SuppressMessage("Build", "CA1031:Modify 'RemoveDTEReference' to catch a more specific allowed exception type, or rethrow the exception.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.WebSiteProjectSystem.RemoveDTEReference(System.String)")]
[assembly: SuppressMessage("Build", "CA1031:Modify 'RemoveReferenceAsync' to catch a more specific allowed exception type, or rethrow the exception.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.VisualStudio.WebSiteProjectSystem.RemoveReferenceAsync(System.String)~System.Threading.Tasks.Task")]
[assembly: SuppressMessage("Build", "CA1056:Change the type of property DeprecatedFrameworkModel.MigrationUrl from string to System.Uri.", Justification = "<Pending>", Scope = "member", Target = "~P:NuGet.PackageManagement.VisualStudio.DeprecatedFrameworkModel.MigrationUrl")]
[assembly: SuppressMessage("Build", "CA2227:Change 'SourceSearchException' to be read-only by removing the property setter.", Justification = "<Pending>", Scope = "member", Target = "~P:NuGet.PackageManagement.VisualStudio.SearchResult`1.SourceSearchException")]
[assembly: SuppressMessage("Build", "CA2227:Change 'SourceSearchStatus' to be read-only by removing the property setter.", Justification = "<Pending>", Scope = "member", Target = "~P:NuGet.PackageManagement.VisualStudio.SearchResult`1.SourceSearchStatus")]
[assembly: SuppressMessage("Build", "CA1052:Type 'DotnetDeprecatedPrompt' is a static holder type but is neither static nor NotInheritable", Justification = "<Pending>", Scope = "type", Target = "~T:NuGet.PackageManagement.VisualStudio.DotnetDeprecatedPrompt")]
[assembly: SuppressMessage("Build", "CA1052:Type 'NuGetProjectUpgradeUtility' is a static holder type but is neither static nor NotInheritable", Justification = "<Pending>", Scope = "type", Target = "~T:NuGet.PackageManagement.VisualStudio.NuGetProjectUpgradeUtility")]
[assembly: SuppressMessage("Build", "CA1001:Type 'ProjectSystemCache' owns disposable field(s) '_readerWriterLock' but is not disposable", Justification = "<Pending>", Scope = "type", Target = "~T:NuGet.PackageManagement.VisualStudio.ProjectSystemCache")]
[assembly: SuppressMessage("Build", "CA1052:Type 'VSRestoreSettingsUtilities' is a static holder type but is neither static nor NotInheritable", Justification = "<Pending>", Scope = "type", Target = "~T:NuGet.PackageManagement.VisualStudio.VSRestoreSettingsUtilities")]
[assembly: SuppressMessage("Performance", "CA1802:Use literals where appropriate", Justification = "<Pending>", Scope = "member", Target = "~F:NuGet.PackageManagement.Telemetry.GetInstalledPackagesAsyncTelemetryEvent.EventName")]
