// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.

namespace System.Reflection.Tests
{
    internal static class TestData
    {
        // // Metadata version: v4.0.30319
        // .assembly extern mscorlib
        // {
        //   .publickeytoken = (B7 7A 5C 56 19 34 E0 89 )                         // .z\V.4..
        //   .ver 4:0:0:0
        // }
        // .assembly SimpleAssembly
        // {
        //   .publickey = (00 24 00 00 04 80 00 00 94 00 00 00 06 02 00 00   // .$..............
        //                 00 24 00 00 52 53 41 31 00 04 00 00 01 00 01 00   // .$..RSA1........
        //                 7D D6 FF A7 DC 4C 39 9D 0B F8 AA 1C 33 17 45 C5   // }....L9.....3.E.
        //                 81 16 4C A8 90 5C 36 CF B1 A0 E4 EC 49 5B C4 F4   // ..L..\6.....I[..
        //                 77 90 05 E6 18 DC B5 CD 5C B8 D9 30 73 CF 2A 6D   // w.......\..0s.*m
        //                 6D FE 66 E4 42 64 2B 05 B5 59 6F 7F 29 34 55 3F   // m.f.Bd+..Yo.)4U?
        //                 D0 A1 0B 6C D5 23 26 C9 ED 7B A2 81 A0 B3 6A 51   // ...l.#&..{....jQ
        //                 04 2B C8 EE 19 35 A3 A3 58 C2 D4 B8 0E 09 C2 BC   // .+...5..X.......
        //                 B9 AE F5 C6 97 E9 31 F1 CA 96 AD 2F 63 A3 41 BA   // ......1..../c.A.
        //                 C8 0F 64 77 18 B8 09 FA D8 A7 4B 9C F6 C8 60 9E ) // ..dw......K...`.
        //   .hash algorithm 0x00008004
        //   .ver 0:0:0:0
        // }
        // .module SimpleAssembly.dll
        // MVID: {33BEE212-AE78-455E-BBD1-DF3241DBF803}
        // .imagebase 0x10000000
        // .file alignment 0x00000200
        // .stackreserve 0x00100000
        // .subsystem 0x0003       // WINDOWS_CUI
        // .corflags 0x00000001    //  ILONLY
        //
        // .class public auto ansi beforefieldinit SimpleAssembly
        //        extends [mscorlib]System.Object
        // {
        //   .method public hidebysig specialname rtspecialname
        //           instance void  .ctor() cil managed
        //   {
        //     // Code size       8 (0x8)
        //     .maxstack  8
        //     IL_0000:  ldarg.0
        //     IL_0001:  call       instance void [mscorlib]System.Object::.ctor()
        //     IL_0006:  nop
        //     IL_0007:  ret
        //   } // end of method SimpleAssembly::.ctor
        //
        // } // end of class SimpleAssembly
        public static readonly string s_SimpleAssemblyFullName = "SimpleAssembly, Version=0.0.0.0, Culture=neutral, PublicKeyToken=00ebb29cd7a0d3d4";
        public static readonly Guid s_SimpleAssemblyMvid = new Guid("33BEE212-AE78-455E-BBD1-DF3241DBF803");
        public static readonly byte[] s_SimpleAssemblyImage = Convert.FromBase64String(
            "TVqQAAMAAAAEAAAA//8AALgAAAAAAAAAQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAgAAAAA4fug4AtAnNIbgBTM0hVGhpcyBwcm9ncmFt" +
            "IGNhbm5vdCBiZSBydW4gaW4gRE9TIG1vZGUuDQ0KJAAAAAAAAABQRQAATAECAIfQXFsAAAAAAAAAAOAAAiELAQsAAAQAAAACAAAAAAAATiMAAAAgAAAAQAAA" +
            "AAAAEAAgAAAAAgAABAAAAAAAAAAEAAAAAAAAAABgAAAAAgAAAAAAAAMAQIUAABAAABAAAAAAEAAAEAAAAAAAABAAAAAAAAAAAAAAAPwiAABPAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAEAAAAwAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAIAAACAAAAAAAAAAAAAAA" +
            "CCAAAEgAAAAAAAAAAAAAAC50ZXh0AAAAVAMAAAAgAAAABAAAAAIAAAAAAAAAAAAAAAAAACAAAGAucmVsb2MAAAwAAAAAQAAAAAIAAAAGAAAAAAAAAAAAAAAA" +
            "AABAAABCAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAwIwAAAAAAAEgAAAACAAUA3CAAACACAAABAAAA" +
            "AAAAAAAAAAAAAAAAUCAAAIAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "IgIoAQAACgAqAAAAQlNKQgEAAQAAAAAADAAAAHY0LjAuMzAzMTkAAAAABQBsAAAAoAAAACN+AAAMAQAATAAAACNTdHJpbmdzAAAAAFgBAAAIAAAAI1VTAGAB" +
            "AAAQAAAAI0dVSUQAAABwAQAAsAAAACNCbG9iAAAAAAAAAAIAAAFHBAAACQAAAAD6JTMAFgAAAQAAAAEAAAACAAAAAQAAAAEAAAABAAAAAQAAAAAAHgABAAAA" +
            "AAAGABEACgAAAAAAAQAAAAAAAQABAAEAEAA6AAAABQABAAEA0CAAAAAAhhgYAAEAAQAJABgAAQAEgAAAAAAAAAAAAAABAAAADgA6AAAABAAAAAAAAAAAAAAA" +
            "BQAxAAAAAAAAAAA8TW9kdWxlPgBTeXN0ZW0AT2JqZWN0AC5jdG9yAFNpbXBsZUFzc2VtYmx5LmRsbABtc2NvcmxpYgBTaW1wbGVBc3NlbWJseQAAAAAAAyAA" +
            "AAAAABLivjN4rl5Fu9HfMkHb+AMAAyAAAQi3elxWGTTgiYCgACQAAASAAACUAAAABgIAAAAkAABSU0ExAAQAAAEAAQB91v+n3Ew5nQv4qhwzF0XFgRZMqJBc" +
            "Ns+xoOTsSVvE9HeQBeYY3LXNXLjZMHPPKm1t/mbkQmQrBbVZb38pNFU/0KELbNUjJsnte6KBoLNqUQQryO4ZNaOjWMLUuA4Jwry5rvXGl+kx8cqWrS9jo0G6" +
            "yA9kdxi4CfrYp0uc9shgniQjAAAAAAAAAAAAAD4jAAAAIAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAwIwAAAAAAAAAAAAAAAF9Db3JEbGxNYWluAG1zY29yZWUu" +
            "ZGxsAAAAAAD/JQAgABAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAACAAAAwAAABQMwAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA="
            );

        // .assembly extern mscorlib
        // {
        //   .publickeytoken = (B7 7A 5C 56 19 34 E0 89 )                         // .z\V.4..
        //   .ver 4:0:0:0
        // }
        // .assembly SimpleAssembly
        // {
        //   .publickey = (00 24 00 00 04 80 00 00 94 00 00 00 06 02 00 00   // .$..............
        //                 00 24 00 00 52 53 41 31 00 04 00 00 01 00 01 00   // .$..RSA1........
        //                 7D D6 FF A7 DC 4C 39 9D 0B F8 AA 1C 33 17 45 C5   // }....L9.....3.E.
        //                 81 16 4C A8 90 5C 36 CF B1 A0 E4 EC 49 5B C4 F4   // ..L..\6.....I[..
        //                 77 90 05 E6 18 DC B5 CD 5C B8 D9 30 73 CF 2A 6D   // w.......\..0s.*m
        //                 6D FE 66 E4 42 64 2B 05 B5 59 6F 7F 29 34 55 3F   // m.f.Bd+..Yo.)4U?
        //                 D0 A1 0B 6C D5 23 26 C9 ED 7B A2 81 A0 B3 6A 51   // ...l.#&..{....jQ
        //                 04 2B C8 EE 19 35 A3 A3 58 C2 D4 B8 0E 09 C2 BC   // .+...5..X.......
        //                 B9 AE F5 C6 97 E9 31 F1 CA 96 AD 2F 63 A3 41 BA   // ......1..../c.A.
        //                 C8 0F 64 77 18 B8 09 FA D8 A7 4B 9C F6 C8 60 9E ) // ..dw......K...`.
        //   .hash algorithm 0x00008004
        //   .ver 0:0:0:0
        // }
        // .module SimpleAssembly.dll
        // // MVID: {A3BAB2EF-E351-4BD7-B45E-9C27A6B2B159}
        // .imagebase 0x10000000
        // .file alignment 0x00000200
        // .stackreserve 0x00100000
        // .subsystem 0x0003       // WINDOWS_CUI
        // .corflags 0x00000001    //  ILONLY
        // Image base: 0x0000024789A30000
        //
        //
        // =============== CLASS MEMBERS DECLARATION ===================
        //
        // .class public auto ansi beforefieldinit SimpleAssembly
        //        extends [mscorlib]System.Object
        // {
        //   .method public hidebysig specialname rtspecialname
        //           instance void  .ctor() cil managed
        //   {
        //     // Code size       8 (0x8)
        //     .maxstack  8
        //     IL_0000:  ldarg.0
        //     IL_0001:  call       instance void [mscorlib]System.Object::.ctor()
        //     IL_0006:  nop
        //     IL_0007:  ret
        //   } // end of method SimpleAssembly::.ctor
        //
        // } // end of class SimpleAssembly
        public static readonly Guid s_SimpleAssemblyRecompiledMvid = new Guid("A3BAB2EF-E351-4BD7-B45E-9C27A6B2B159");
        public static readonly byte[] s_SimpleAssemblyRecompiledImage = Convert.FromBase64String(
            "TVqQAAMAAAAEAAAA//8AALgAAAAAAAAAQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAgAAAAA4fug4AtAnNIbgBTM0hVGhpcyBwcm9ncmFt" +
            "IGNhbm5vdCBiZSBydW4gaW4gRE9TIG1vZGUuDQ0KJAAAAAAAAABQRQAATAECAAfXXFsAAAAAAAAAAOAAAiELAQsAAAQAAAACAAAAAAAATiMAAAAgAAAAQAAA" +
            "AAAAEAAgAAAAAgAABAAAAAAAAAAEAAAAAAAAAABgAAAAAgAAAAAAAAMAQIUAABAAABAAAAAAEAAAEAAAAAAAABAAAAAAAAAAAAAAAPwiAABPAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAEAAAAwAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAIAAACAAAAAAAAAAAAAAA" +
            "CCAAAEgAAAAAAAAAAAAAAC50ZXh0AAAAVAMAAAAgAAAABAAAAAIAAAAAAAAAAAAAAAAAACAAAGAucmVsb2MAAAwAAAAAQAAAAAIAAAAGAAAAAAAAAAAAAAAA" +
            "AABAAABCAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAwIwAAAAAAAEgAAAACAAUA3CAAACACAAABAAAA" +
            "AAAAAAAAAAAAAAAAUCAAAIAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "IgIoAQAACgAqAAAAQlNKQgEAAQAAAAAADAAAAHY0LjAuMzAzMTkAAAAABQBsAAAAoAAAACN+AAAMAQAATAAAACNTdHJpbmdzAAAAAFgBAAAIAAAAI1VTAGAB" +
            "AAAQAAAAI0dVSUQAAABwAQAAsAAAACNCbG9iAAAAAAAAAAIAAAFHBAAACQAAAAD6JTMAFgAAAQAAAAEAAAACAAAAAQAAAAEAAAABAAAAAQAAAAAAHgABAAAA" +
            "AAAGABEACgAAAAAAAQAAAAAAAQABAAEAEAA6AAAABQABAAEA0CAAAAAAhhgYAAEAAQAJABgAAQAEgAAAAAAAAAAAAAABAAAADgA6AAAABAAAAAAAAAAAAAAA" +
            "BQAxAAAAAAAAAAA8TW9kdWxlPgBTeXN0ZW0AT2JqZWN0AC5jdG9yAFNpbXBsZUFzc2VtYmx5LmRsbABtc2NvcmxpYgBTaW1wbGVBc3NlbWJseQAAAAAAAyAA" +
            "AAAAAO+yuqNR49dLtF6cJ6aysVkAAyAAAQi3elxWGTTgiYCgACQAAASAAACUAAAABgIAAAAkAABSU0ExAAQAAAEAAQB91v+n3Ew5nQv4qhwzF0XFgRZMqJBc" +
            "Ns+xoOTsSVvE9HeQBeYY3LXNXLjZMHPPKm1t/mbkQmQrBbVZb38pNFU/0KELbNUjJsnte6KBoLNqUQQryO4ZNaOjWMLUuA4Jwry5rvXGl+kx8cqWrS9jo0G6" +
            "yA9kdxi4CfrYp0uc9shgniQjAAAAAAAAAAAAAD4jAAAAIAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAwIwAAAAAAAAAAAAAAAF9Db3JEbGxNYWluAG1zY29yZWUu" +
            "ZGxsAAAAAAD/JQAgABAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAACAAAAwAAABQMwAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA="
        );

        // (NetFX20AsssemblyImage was built with v3.5 C# compiler - has v2.0.50727 ImageRuntimeVersion)
        // // Metadata version: v2.0.50727
        // .assembly extern mscorlib
        // {
        //   .publickeytoken = (B7 7A 5C 56 19 34 E0 89 )                         // .z\V.4..
        //   .ver 2:0:0:0
        // }
        // .assembly 'NetFx2.0'
        // {
        //   .custom instance void [mscorlib]System.Runtime.CompilerServices.CompilationRelaxationsAttribute::.ctor(int32) = ( 01 00 08 00 00 00 00 00 )
        //   .custom instance void [mscorlib]System.Runtime.CompilerServices.RuntimeCompatibilityAttribute::.ctor() = ( 01 00 01 00 54 02 16 57 72 61 70 4E 6F 6E 45 78   // ....T..WrapNonEx
        //                                                                                                              63 65 70 74 69 6F 6E 54 68 72 6F 77 73 01 )       // ceptionThrows.
        //   .hash algorithm 0x00008004
        //   .ver 0:0:0:0
        // }
        // .module 'NetFx2.0.dll'
        // // MVID: {30DB3E54-916F-483E-877B-58876C452926}
        // .imagebase 0x00400000
        // .file alignment 0x00000200
        // .stackreserve 0x00100000
        // .subsystem 0x0003       // WINDOWS_CUI
        // .corflags 0x00000001    //  ILONLY
        // // Image base: 0x000001E6DAC00000
        public static readonly byte[] s_NetFx20AssemblyImage = Convert.FromBase64String(
            "TVqQAAMAAAAEAAAA//8AALgAAAAAAAAAQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAgAAAAA4fug4AtAnNIbgBTM0hVGhpcyBwcm9ncmFt" +
            "IGNhbm5vdCBiZSBydW4gaW4gRE9TIG1vZGUuDQ0KJAAAAAAAAABQRQAATAEDAJb7XFsAAAAAAAAAAOAAAiELAQgAAAQAAAAGAAAAAAAAjiIAAAAgAAAAQAAA" +
            "AABAAAAgAAAAAgAABAAAAAAAAAAEAAAAAAAAAACAAAAAAgAAAAAAAAMAQIUAABAAABAAAAAAEAAAEAAAAAAAABAAAAAAAAAAAAAAADwiAABPAAAAAEAAAKgC" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAGAAAAwAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAIAAACAAAAAAAAAAAAAAA" +
            "CCAAAEgAAAAAAAAAAAAAAC50ZXh0AAAAlAIAAAAgAAAABAAAAAIAAAAAAAAAAAAAAAAAACAAAGAucnNyYwAAAKgCAAAAQAAAAAQAAAAGAAAAAAAAAAAAAAAA" +
            "AABAAABALnJlbG9jAAAMAAAAAGAAAAACAAAACgAAAAAAAAAAAAAAAAAAQAAAQgAAAAAAAAAAAAAAAAAAAABwIgAAAAAAAEgAAAACAAUAUCAAAOwBAAABAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAEJTSkIBAAEAAAAAAAwAAAB2Mi4wLjUwNzI3AAAAAAUAbAAAAJwA" +
            "AAAjfgAACAEAAJAAAAAjU3RyaW5ncwAAAACYAQAACAAAACNVUwCgAQAAEAAAACNHVUlEAAAAsAEAADwAAAAjQmxvYgAAAAAAAAACAAABBxQAAAkAAAAA+gEz" +
            "ABYAAAEAAAACAAAAAQAAAAIAAAACAAAAAQAAAAEAAAAAAAoAAQAAAAAABgBAACAABgBmACAAAAAAAAEAAAAAAAEAAQAJAGAACgARAGAADwAuAAsAEwAuABMA" +
            "HAAEgAAAAAAAAAAAAAAAAAAAAACEAAAAAgAAAAAAAAAAAAAAAQAXAAAAAAAAAAA8TW9kdWxlPgBOZXRGeDIuMC5kbGwAbXNjb3JsaWIAU3lzdGVtLlJ1bnRp" +
            "bWUuQ29tcGlsZXJTZXJ2aWNlcwBDb21waWxhdGlvblJlbGF4YXRpb25zQXR0cmlidXRlAC5jdG9yAFJ1bnRpbWVDb21wYXRpYmlsaXR5QXR0cmlidXRlAE5l" +
            "dEZ4Mi4wAAAAAAADIAAAAAAAVD7bMG+RPkiHe1iHbEUpJgAIt3pcVhk04IkEIAEBCAMgAAEIAQAIAAAAAAAeAQABAFQCFldyYXBOb25FeGNlcHRpb25UaHJv" +
            "d3MBAGQiAAAAAAAAAAAAAH4iAAAAIAAAAAAAAAAAAAAAAAAAAAAAAAAAAABwIgAAAAAAAAAAAAAAAF9Db3JEbGxNYWluAG1zY29yZWUuZGxsAAAAAAD/JQAg" +
            "QAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAABABAAAAAYAACAAAAAAAAAAAAAAAAAAAABAAEAAAAwAACAAAAAAAAAAAAAAAAAAAABAAAAAABIAAAAWEAAAEwCAAAAAAAA" +
            "AAAAAEwCNAAAAFYAUwBfAFYARQBSAFMASQBPAE4AXwBJAE4ARgBPAAAAAAC9BO/+AAABAAAAAAAAAAAAAAAAAAAAAAA/AAAAAAAAAAQAAAACAAAAAAAAAAAA" +
            "AAAAAAAARAAAAAEAVgBhAHIARgBpAGwAZQBJAG4AZgBvAAAAAAAkAAQAAABUAHIAYQBuAHMAbABhAHQAaQBvAG4AAAAAAAAAsASsAQAAAQBTAHQAcgBpAG4A" +
            "ZwBGAGkAbABlAEkAbgBmAG8AAACIAQAAAQAwADAAMAAwADAANABiADAAAAAsAAIAAQBGAGkAbABlAEQAZQBzAGMAcgBpAHAAdABpAG8AbgAAAAAAIAAAADAA" +
            "CAABAEYAaQBsAGUAVgBlAHIAcwBpAG8AbgAAAAAAMAAuADAALgAwAC4AMAAAADwADQABAEkAbgB0AGUAcgBuAGEAbABOAGEAbQBlAAAATgBlAHQARgB4ADIA" +
            "LgAwAC4AZABsAGwAAAAAACgAAgABAEwAZQBnAGEAbABDAG8AcAB5AHIAaQBnAGgAdAAAACAAAABEAA0AAQBPAHIAaQBnAGkAbgBhAGwARgBpAGwAZQBuAGEA" +
            "bQBlAAAATgBlAHQARgB4ADIALgAwAC4AZABsAGwAAAAAADQACAABAFAAcgBvAGQAdQBjAHQAVgBlAHIAcwBpAG8AbgAAADAALgAwAC4AMAAuADAAAAA4AAgA" +
            "AQBBAHMAcwBlAG0AYgBsAHkAIABWAGUAcgBzAGkAbwBuAAAAMAAuADAALgAwAC4AMAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAgAAAMAAAAkDIAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAA"
            );

        // // Metadata version: v4.0.30319
        // .module extern Bob.netmodule
        // .assembly extern mscorlib
        // {
        //   .publickeytoken = (B7 7A 5C 56 19 34 E0 89 )                         // .z\V.4..
        //   .ver 4:0:0:0
        // }
        // .assembly Main
        // {
        //   .hash algorithm 0x00008004
        //   .ver 0:0:0:0
        // }
        // .file Bob.netmodule
        //     .hash = (2C AC C4 C5 3E 60 1A E1 D7 F6 A2 1B 92 57 BF 3C   // ,...>`.......W.<
        //              34 51 93 12 )                                     // 4Q..
        // .class extern public JoeType1
        // {
        //   .file Bob.netmodule
        //   .class 0x02000002
        // }
        // .class extern public JoeType2
        // {
        //   .file Bob.netmodule
        //   .class 0x02000003
        // }
        // .module Main.dll
        // MVID: {7B43F7C7-A795-48C8-9DD2-C00D4FACA4CC}
        // .imagebase 0x10000000
        // .file alignment 0x00000200
        // .stackreserve 0x00100000
        // .subsystem 0x0003       // WINDOWS_CUI
        // .corflags 0x00000001    //  ILONLY
        // // Image base: 0x000001EDC3B20000
        //
        //
        // .class public auto ansi beforefieldinit MainType1
        //        extends [.module Bob.netmodule]JoeType1
        // {
        //   .method public hidebysig specialname rtspecialname
        //           instance void  .ctor() cil managed
        //   {
        //     // Code size       8 (0x8)
        //     .maxstack  8
        //     IL_0000:  ldarg.0
        //     IL_0001:  call       instance void [.module Bob.netmodule]JoeType1::.ctor()
        //     IL_0006:  nop
        //     IL_0007:  ret
        //   } // end of method MainType1::.ctor
        //
        // } // end of class MainType1
        //
        // .class public auto ansi beforefieldinit MainType2
        //        extends [.module Bob.netmodule]JoeType2
        // {
        //   .method public hidebysig specialname rtspecialname
        //           instance void  .ctor() cil managed
        //   {
        //     // Code size       8 (0x8)
        //     .maxstack  8
        //     IL_0000:  ldarg.0
        //     IL_0001:  call       instance void [.module Bob.netmodule]JoeType2::.ctor()
        //     IL_0006:  nop
        //     IL_0007:  ret
        //   } // end of method MainType2::.ctor
        //
        // } // end of class MainType2
        public static readonly Guid s_MultiModuleDllMvid = new Guid("7B43F7C7-A795-48C8-9DD2-C00D4FACA4CC");
        public static readonly byte[] s_MultiModuleDllImage = Convert.FromBase64String(
            "TVqQAAMAAAAEAAAA//8AALgAAAAAAAAAQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAgAAAAA4fug4AtAnNIbgBTM0hVGhpcyBwcm9ncmFt" +
            "IGNhbm5vdCBiZSBydW4gaW4gRE9TIG1vZGUuDQ0KJAAAAAAAAABQRQAATAECAHRLXlsAAAAAAAAAAOAAAiELAQsAAAQAAAACAAAAAAAAviIAAAAgAAAAQAAA" +
            "AAAAEAAgAAAAAgAABAAAAAAAAAAEAAAAAAAAAABgAAAAAgAAAAAAAAMAQIUAABAAABAAAAAAEAAAEAAAAAAAABAAAAAAAAAAAAAAAGQiAABXAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAEAAAAwAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAIAAACAAAAAAAAAAAAAAA" +
            "CCAAAEgAAAAAAAAAAAAAAC50ZXh0AAAAxAIAAAAgAAAABAAAAAIAAAAAAAAAAAAAAAAAACAAAGAucmVsb2MAAAwAAAAAQAAAAAIAAAAGAAAAAAAAAAAAAAAA" +
            "AABAAABCAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACgIgAAAAAAAEgAAAACAAUAZCAAAAACAAABAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACICKAEAAAoAKiICKAIAAAoAKgAAQlNKQgEAAQAAAAAADAAAAHY0" +
            "LjAuMzAzMTkAAAAABQBsAAAA/AAAACN+AABoAQAAXAAAACNTdHJpbmdzAAAAAMQBAAAIAAAAI1VTAMwBAAAQAAAAI0dVSUQAAADcAQAAJAAAACNCbG9iAAAA" +
            "AAAAAAIAAAFHBAAEyQAAAAD6JTMAFgAAAQAAAAIAAAADAAAAAgAAAAIAAAABAAAAAQAAAAEAAAABAAAAAgAAAAAAIgABAAAAAAAFAAoAAAAFABkAAAAAAAAA" +
            "AQAAAAAAAQABAAEAEABCAAAABQABAAEAAQAQAEwAAAAJAAEAAgBQIAAAAACGGBMAAQABAFkgAAAAAIYYEwABAAEACQATAAEAEQATAAEAKwAEgAAAAAAAAAAA" +
            "AAAAAAAAAABWAAAABAAAAAAAAAAAAAAABQA5AAAAAAAAAAAAKwAOAAEAAAACAAACCgAAAAQAAQAAAAMAAAIZAAAABAAAAAAAADxNb2R1bGU+AEpvZVR5cGUx" +
            "AC5jdG9yAEpvZVR5cGUyAE1haW4uZGxsAEJvYi5uZXRtb2R1bGUAbXNjb3JsaWIATWFpblR5cGUxAE1haW5UeXBlMgBNYWluAAAAAyAAAAAAAMf3Q3uVp8hI" +
            "ndLADU+spMwAAyAAAQi3elxWGTTgiRQsrMTFPmAa4df2ohuSV788NFGTEgCMIgAAAAAAAAAAAACuIgAAACAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAoCIAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAF9Db3JEbGxNYWluAG1zY29yZWUuZGxsAAAAAAD/JQAgABAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAACAAAAwAAADAMgAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA="
        );

        // // Metadata version: v4.0.30319
        // .assembly extern mscorlib
        // {
        //   .publickeytoken = (B7 7A 5C 56 19 34 E0 89 )                         // .z\V.4..
        //   .ver 4:0:0:0
        // }
        // .module Joe.netmodule
        // // MVID: {0B58D7F6-4E0D-49FB-870A-1D492B846154}
        // .imagebase 0x10000000
        // .file alignment 0x00000200
        // .stackreserve 0x00100000
        // .subsystem 0x0003       // WINDOWS_CUI
        // .corflags 0x00000001    //  ILONLY
        // // Image base: 0x000002291F730000
        //
        //
        // // =============== CLASS MEMBERS DECLARATION ===================
        //
        // .class public auto ansi beforefieldinit JoeType1
        //        extends [mscorlib]System.Object
        // {
        //   .method public hidebysig specialname rtspecialname
        //           instance void  .ctor() cil managed
        //   {
        //     // Code size       8 (0x8)
        //     .maxstack  8
        //     IL_0000:  ldarg.0
        //     IL_0001:  call       instance void [mscorlib]System.Object::.ctor()
        //     IL_0006:  nop
        //     IL_0007:  ret
        //   } // end of method JoeType1::.ctor
        //
        // } // end of class JoeType1
        //
        // .class public auto ansi beforefieldinit JoeType2
        //        extends [mscorlib]System.Object
        // {
        //   .method public hidebysig specialname rtspecialname
        //           instance void  .ctor() cil managed
        //   {
        //     // Code size       8 (0x8)
        //     .maxstack  8
        //     IL_0000:  ldarg.0
        //     IL_0001:  call       instance void [mscorlib]System.Object::.ctor()
        //     IL_0006:  nop
        //     IL_0007:  ret
        //   } // end of method JoeType2::.ctor
        //
        // } // end of class JoeType2
        public static readonly string s_JoeScopeName = "Joe.netmodule";
        public static readonly Guid s_JoeNetModuleMvid = new Guid("0B58D7F6-4E0D-49FB-870A-1D492B846154");
        public static readonly byte[] s_JoeNetModuleImage = Convert.FromBase64String(
            "TVqQAAMAAAAEAAAA//8AALgAAAAAAAAAQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAgAAAAA4fug4AtAnNIbgBTM0hVGhpcyBwcm9ncmFt" +
            "IGNhbm5vdCBiZSBydW4gaW4gRE9TIG1vZGUuDQ0KJAAAAAAAAABQRQAATAEDAEZNXlsAAAAAAAAAAOAAIiALATAAAAQAAAAGAAAAAAAAKiIAAAAgAAAAQAAA" +
            "AAAAEAAgAAAAAgAABAAAAAAAAAAEAAAAAAAAAACAAAAAAgAAAAAAAAMAQIUAABAAABAAAAAAEAAAEAAAAAAAABAAAAAAAAAAAAAAANghAABPAAAAAEAAAKgC" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAGAAAAwAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAIAAACAAAAAAAAAAAAAAA" +
            "CCAAAEgAAAAAAAAAAAAAAC50ZXh0AAAAMAIAAAAgAAAABAAAAAIAAAAAAAAAAAAAAAAAACAAAGAucnNyYwAAAKgCAAAAQAAAAAQAAAAGAAAAAAAAAAAAAAAA" +
            "AABAAABALnJlbG9jAAAMAAAAAGAAAAACAAAACgAAAAAAAAAAAAAAAAAAQAAAQgAAAAAAAAAAAAAAAAAAAAAMIgAAAAAAAEgAAAACAAUAXCAAAHwBAAABAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACICKAEAAAoAKgAAAEJTSkIBAAEAAAAAAAwAAAB2NC4wLjMwMzE5" +
            "AAAAAAUAbAAAAKQAAAAjfgAAEAEAAEgAAAAjU3RyaW5ncwAAAABYAQAABAAAACNVUwBcAQAAEAAAACNHVUlEAAAAbAEAABAAAAAjQmxvYgAAAAAAAAACAAAB" +
            "RwQAAAgAAAAA+gEzABYAAAEAAAABAAAAAwAAAAIAAAABAAAAAQAAAAAAJQABAAAAAAAGAEAAMwAAAAAAEwAAAAAAAQABAAEAEAABAAAABQABAAEAAQAQAAoA" +
            "AAAFAAEAAgBQIAAAAACGGDoAAQABAFAgAAAAAIYYOgABAAEACQA6AAEABAAAAAAAAAAAAAAABQAcAAAAAAAAAAAAAEpvZVR5cGUxAEpvZVR5cGUyADxNb2R1" +
            "bGU+AG1zY29ybGliAEpvZS5uZXRtb2R1bGUAU3lzdGVtAC5jdG9yAE9iamVjdAAAAAAAAPbXWAsNTvtJhwodSSuEYVQAAyAAAQi3elxWGTTgiQAAACIAAAAA" +
            "AAAAAAAAGiIAAAAgAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAwiAAAAAAAAAAAAAAAAX0NvckRsbE1haW4AbXNjb3JlZS5kbGwAAAAAAP8lACAAEAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAABABAAAAAYAACAAAAAAAAAAAAAAAAAAAABAAEAAAAwAACAAAAAAAAAAAAAAAAAAAABAAAAAABIAAAAWEAAAEwCAAAAAAAA" +
            "AAAAAEwCNAAAAFYAUwBfAFYARQBSAFMASQBPAE4AXwBJAE4ARgBPAAAAAAC9BO/+AAABAAAAAAAAAAAAAAAAAAAAAAA/AAAAAAAAAAQAAAACAAAAAAAAAAAA" +
            "AAAAAAAARAAAAAEAVgBhAHIARgBpAGwAZQBJAG4AZgBvAAAAAAAkAAQAAABUAHIAYQBuAHMAbABhAHQAaQBvAG4AAAAAAAAAsASsAQAAAQBTAHQAcgBpAG4A" +
            "ZwBGAGkAbABlAEkAbgBmAG8AAACIAQAAAQAwADAAMAAwADAANABiADAAAAAsAAIAAQBGAGkAbABlAEQAZQBzAGMAcgBpAHAAdABpAG8AbgAAAAAAIAAAADAA" +
            "CAABAEYAaQBsAGUAVgBlAHIAcwBpAG8AbgAAAAAAMAAuADAALgAwAC4AMAAAADwADgABAEkAbgB0AGUAcgBuAGEAbABOAGEAbQBlAAAASgBvAGUALgBuAGUA" +
            "dABtAG8AZAB1AGwAZQAAACgAAgABAEwAZQBnAGEAbABDAG8AcAB5AHIAaQBnAGgAdAAAACAAAABEAA4AAQBPAHIAaQBnAGkAbgBhAGwARgBpAGwAZQBuAGEA" +
            "bQBlAAAASgBvAGUALgBuAGUAdABtAG8AZAB1AGwAZQAAADQACAABAFAAcgBvAGQAdQBjAHQAVgBlAHIAcwBpAG8AbgAAADAALgAwAC4AMAAuADAAAAA4AAgA" +
            "AQBBAHMAcwBlAG0AYgBsAHkAIABWAGUAcgBzAGkAbwBuAAAAMAAuADAALgAwAC4AMAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAgAAAMAAAALDIAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAA"
        );

        // using System;
        // using System.Runtime.CompilerServices;
        //
        // [assembly:TypeForwardedTo(typeof(object))]   // Built against "mscorlib"
        //
        // public abstract class Base<T> {}
        //
        // public sealed class Derived : Base<object>
        // {
        // }
        //
        // This is a "core assembly" that only exposes System.Object and as a facade at that.
        //
        public static readonly string s_PhonyCoreAssemblySimpleName = "PhonyCoreAssembly";
        public static readonly string s_PhonyCoreAssemblyFullName = "PhonyCoreAssembly, Version=0.0.0.0, Culture=neutral, PublicKeyToken=null";
        public static readonly byte[] s_PhonyCoreAssemblyImage = Convert.FromBase64String(
            "TVqQAAMAAAAEAAAA//8AALgAAAAAAAAAQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAgAAAAA4fug4AtAnNIbgBTM0hVGhpcyBwcm9ncmFt" +
            "IGNhbm5vdCBiZSBydW4gaW4gRE9TIG1vZGUuDQ0KJAAAAAAAAABQRQAATAEDAFE8X1sAAAAAAAAAAOAAIiALATAAAAQAAAAGAAAAAAAAoiMAAAAgAAAAQAAA" +
            "AAAAEAAgAAAAAgAABAAAAAAAAAAEAAAAAAAAAACAAAAAAgAAAAAAAAMAQIUAABAAABAAAAAAEAAAEAAAAAAAABAAAAAAAAAAAAAAAFAjAABPAAAAAEAAAMgC" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAGAAAAwAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAIAAACAAAAAAAAAAAAAAA" +
            "CCAAAEgAAAAAAAAAAAAAAC50ZXh0AAAAqAMAAAAgAAAABAAAAAIAAAAAAAAAAAAAAAAAACAAAGAucnNyYwAAAMgCAAAAQAAAAAQAAAAGAAAAAAAAAAAAAAAA" +
            "AABAAABALnJlbG9jAAAMAAAAAGAAAAACAAAACgAAAAAAAAAAAAAAAAAAQAAAQgAAAAAAAAAAAAAAAAAAAACEIwAAAAAAAEgAAAACAAUAZCAAAOwCAAABAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACICKAQAAAoAKiICKAUAAAoAKgAAQlNKQgEAAQAAAAAADAAAAHY0" +
            "LjAuMzAzMTkAAAAABQBsAAAAKAEAACN+AACUAQAA9AAAACNTdHJpbmdzAAAAAIgCAAAEAAAAI1VTAIwCAAAQAAAAI0dVSUQAAACcAgAAUAAAACNCbG9iAAAA" +
            "AAAAAAIAAAFHFAAIiQQAAAD6ATMAFgAAAQAAAAUAAAADAAAAAgAAAAUAAAADAAAAAQAAAAEAAAABAAAAAQAAAAEAAAAAAHYAAQAAAAAABgA4AKwABgBYAKwA" +
            "BgAkAJkADwDMAAAABgDbAIwAAAAAAAgAAAAAAAEAAQCBABAAAQAAABUAAQABAAEBEAAcAAAABgABAAIAUCAAAAAAhBiTAAYAAQBZIAAAAACGGJMABgABAAkA" +
            "kwABABEAkwAGABkAkwAKACkAkwAGAAwAkwAGAC4ACwAfAC4AEwAoAC4AGwBHABAABIAAAAAAAAAAAAAAAAAAAAAA4gAAAAQAAAAAAAAAAAAAABYAEwAAAAAA" +
            "AAAgAAAAAADbAIwABQAAAAAABAARAAAAAAAAQmFzZWAxADxNb2R1bGU+AFQAbXNjb3JsaWIARGVyaXZlZABEZWJ1Z2dhYmxlQXR0cmlidXRlAENvbXBpbGF0" +
            "aW9uUmVsYXhhdGlvbnNBdHRyaWJ1dGUAUnVudGltZUNvbXBhdGliaWxpdHlBdHRyaWJ1dGUAUGhvbnlDb3JlQXNzZW1ibHkuZGxsAFN5c3RlbQAuY3RvcgBT" +
            "eXN0ZW0uRGlhZ25vc3RpY3MAU3lzdGVtLlJ1bnRpbWUuQ29tcGlsZXJTZXJ2aWNlcwBEZWJ1Z2dpbmdNb2RlcwBPYmplY3QAUGhvbnlDb3JlQXNzZW1ibHkA" +
            "AAAAAOxwjqXsJ19Hi9wABnfTc5kABCABAQgDIAABBSABARERBRUSCAEcCLd6XFYZNOCJCAEACAAAAAAAHgEAAQBUAhZXcmFwTm9uRXhjZXB0aW9uVGhyb3dz" +
            "AQgBAAcBAAAAAHgjAAAAAAAAAAAAAJIjAAAAIAAAAAAAAAAAAAAAAAAAAAAAAAAAAACEIwAAAAAAAAAAAAAAAF9Db3JEbGxNYWluAG1zY29yZWUuZGxsAAAA" +
            "AAD/JQAgABAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAABABAAAAAYAACAAAAAAAAAAAAAAAAAAAABAAEAAAAwAACAAAAAAAAAAAAAAAAAAAABAAAAAABIAAAAWEAAAGwCAAAAAAAA" +
            "AAAAAGwCNAAAAFYAUwBfAFYARQBSAFMASQBPAE4AXwBJAE4ARgBPAAAAAAC9BO/+AAABAAAAAAAAAAAAAAAAAAAAAAA/AAAAAAAAAAQAAAACAAAAAAAAAAAA" +
            "AAAAAAAARAAAAAEAVgBhAHIARgBpAGwAZQBJAG4AZgBvAAAAAAAkAAQAAABUAHIAYQBuAHMAbABhAHQAaQBvAG4AAAAAAAAAsATMAQAAAQBTAHQAcgBpAG4A" +
            "ZwBGAGkAbABlAEkAbgBmAG8AAACoAQAAAQAwADAAMAAwADAANABiADAAAAAsAAIAAQBGAGkAbABlAEQAZQBzAGMAcgBpAHAAdABpAG8AbgAAAAAAIAAAADAA" +
            "CAABAEYAaQBsAGUAVgBlAHIAcwBpAG8AbgAAAAAAMAAuADAALgAwAC4AMAAAAEwAFgABAEkAbgB0AGUAcgBuAGEAbABOAGEAbQBlAAAAUABoAG8AbgB5AEMA" +
            "bwByAGUAQQBzAHMAZQBtAGIAbAB5AC4AZABsAGwAAAAoAAIAAQBMAGUAZwBhAGwAQwBvAHAAeQByAGkAZwBoAHQAAAAgAAAAVAAWAAEATwByAGkAZwBpAG4A" +
            "YQBsAEYAaQBsAGUAbgBhAG0AZQAAAFAAaABvAG4AeQBDAG8AcgBlAEEAcwBzAGUAbQBiAGwAeQAuAGQAbABsAAAANAAIAAEAUAByAG8AZAB1AGMAdABWAGUA" +
            "cgBzAGkAbwBuAAAAMAAuADAALgAwAC4AMAAAADgACAABAEEAcwBzAGUAbQBiAGwAeQAgAFYAZQByAHMAaQBvAG4AAAAwAC4AMAAuADAALgAwAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAgAAAMAAAApDMAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAA"
        );

        // .assembly SimpleNameOnly
        // {
        //   .hash algorithm 0x00008004
        //   .ver 0:0:0:0
        // }
        public static readonly byte[] s_SimpleNameOnlyImage = Convert.FromBase64String(
            "TVqQAAMAAAAEAAAA//8AALgAAAAAAAAAQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAgAAAAA4fug4AtAnNIbgBTM0hVGhpcyBwcm9ncmFt" +
            "IGNhbm5vdCBiZSBydW4gaW4gRE9TIG1vZGUuDQ0KJAAAAAAAAABQRQAATAEDAFlyX1sAAAAAAAAAAOAAIiALATAAAAQAAAAGAAAAAAAA8iIAAAAgAAAAQAAA" +
            "AAAAEAAgAAAAAgAABAAAAAAAAAAEAAAAAAAAAACAAAAAAgAAAAAAAAMAQIUAABAAABAAAAAAEAAAEAAAAAAAABAAAAAAAAAAAAAAAKAiAABPAAAAAEAAAMAC" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAGAAAAwAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAIAAACAAAAAAAAAAAAAAA" +
            "CCAAAEgAAAAAAAAAAAAAAC50ZXh0AAAA+AIAAAAgAAAABAAAAAIAAAAAAAAAAAAAAAAAACAAAGAucnNyYwAAAMACAAAAQAAAAAQAAAAGAAAAAAAAAAAAAAAA" +
            "AABAAABALnJlbG9jAAAMAAAAAGAAAAACAAAACgAAAAAAAAAAAAAAAAAAQAAAQgAAAAAAAAAAAAAAAAAAAADUIgAAAAAAAEgAAAACAAUAUCAAAFACAAABAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAEJTSkIBAAEAAAAAAAwAAAB2NC4wLjMwMzE5AAAAAAUAbAAAALQA" +
            "AAAjfgAAIAEAANAAAAAjU3RyaW5ncwAAAADwAQAABAAAACNVUwD0AQAAEAAAACNHVUlEAAAABAIAAEwAAAAjQmxvYgAAAAAAAAACAAABBxQAAAkAAAAA+gEz" +
            "ABYAAAEAAAAEAAAAAQAAAAMAAAADAAAAAQAAAAEAAAAAAGUAAQAAAAAABgAnAJEABgBHAJEABgATAH4ADwCxAAAAAAAAAAEAAAAAAAEAAQAJAHgAAQARAHgA" +
            "BgAZAHgACgAuAAsAGQAuABMAIgAuABsAQQAEgAAAAAAAAAAAAAAAAAAAAADAAAAABAAAAAAAAAAAAAAAEAAKAAAAAAAAAAA8TW9kdWxlPgBtc2NvcmxpYgBE" +
            "ZWJ1Z2dhYmxlQXR0cmlidXRlAENvbXBpbGF0aW9uUmVsYXhhdGlvbnNBdHRyaWJ1dGUAUnVudGltZUNvbXBhdGliaWxpdHlBdHRyaWJ1dGUAU2ltcGxlTmFt" +
            "ZU9ubHkuZGxsAC5jdG9yAFN5c3RlbS5EaWFnbm9zdGljcwBTeXN0ZW0uUnVudGltZS5Db21waWxlclNlcnZpY2VzAERlYnVnZ2luZ01vZGVzAFNpbXBsZU5h" +
            "bWVPbmx5AAAAAAAAlQG8FLXKY0WTP70y4IIRdAAEIAEBCAMgAAEFIAEBEREIt3pcVhk04IkIAQAIAAAAAAAeAQABAFQCFldyYXBOb25FeGNlcHRpb25UaHJv" +
            "d3MBCAEABwEAAAAAAADIIgAAAAAAAAAAAADiIgAAACAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA1CIAAAAAAAAAAAAAAABfQ29yRGxsTWFpbgBtc2NvcmVlLmRs" +
            "bAAAAAAA/yUAIAAQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAABABAAAAAYAACAAAAAAAAAAAAAAAAAAAABAAEAAAAwAACAAAAAAAAAAAAAAAAAAAABAAAAAABIAAAAWEAAAGQCAAAAAAAA" +
            "AAAAAGQCNAAAAFYAUwBfAFYARQBSAFMASQBPAE4AXwBJAE4ARgBPAAAAAAC9BO/+AAABAAAAAAAAAAAAAAAAAAAAAAA/AAAAAAAAAAQAAAACAAAAAAAAAAAA" +
            "AAAAAAAARAAAAAEAVgBhAHIARgBpAGwAZQBJAG4AZgBvAAAAAAAkAAQAAABUAHIAYQBuAHMAbABhAHQAaQBvAG4AAAAAAAAAsATEAQAAAQBTAHQAcgBpAG4A" +
            "ZwBGAGkAbABlAEkAbgBmAG8AAACgAQAAAQAwADAAMAAwADAANABiADAAAAAsAAIAAQBGAGkAbABlAEQAZQBzAGMAcgBpAHAAdABpAG8AbgAAAAAAIAAAADAA" +
            "CAABAEYAaQBsAGUAVgBlAHIAcwBpAG8AbgAAAAAAMAAuADAALgAwAC4AMAAAAEYAEwABAEkAbgB0AGUAcgBuAGEAbABOAGEAbQBlAAAAUwBpAG0AcABsAGUA" +
            "TgBhAG0AZQBPAG4AbAB5AC4AZABsAGwAAAAAACgAAgABAEwAZQBnAGEAbABDAG8AcAB5AHIAaQBnAGgAdAAAACAAAABOABMAAQBPAHIAaQBnAGkAbgBhAGwA" +
            "RgBpAGwAZQBuAGEAbQBlAAAAUwBpAG0AcABsAGUATgBhAG0AZQBPAG4AbAB5AC4AZABsAGwAAAAAADQACAABAFAAcgBvAGQAdQBjAHQAVgBlAHIAcwBpAG8A" +
            "bgAAADAALgAwAC4AMAAuADAAAAA4AAgAAQBBAHMAcwBlAG0AYgBsAHkAIABWAGUAcgBzAGkAbwBuAAAAMAAuADAALgAwAC4AMAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAgAAAMAAAA9DIAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAA"
            );

        // .assembly Version1_2_65534_4
        // {
        //   .hash algorithm 0x00008004
        //   .ver 1:2:65534:4
        // }
        public static readonly byte[] s_Version1_2_65534_4Image = Convert.FromBase64String(
            "TVqQAAMAAAAEAAAA//8AALgAAAAAAAAAQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAgAAAAA4fug4AtAnNIbgBTM0hVGhpcyBwcm9ncmFt" +
            "IGNhbm5vdCBiZSBydW4gaW4gRE9TIG1vZGUuDQ0KJAAAAAAAAABQRQAATAEDAFB2X1sAAAAAAAAAAOAAIiALATAAAAQAAAAGAAAAAAAA+iIAAAAgAAAAQAAA" +
            "AAAAEAAgAAAAAgAABAAAAAAAAAAEAAAAAAAAAACAAAAAAgAAAAAAAAMAQIUAABAAABAAAAAAEAAAEAAAAAAAABAAAAAAAAAAAAAAAKgiAABPAAAAAEAAAOgC" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAGAAAAwAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAIAAACAAAAAAAAAAAAAAA" +
            "CCAAAEgAAAAAAAAAAAAAAC50ZXh0AAAAAAMAAAAgAAAABAAAAAIAAAAAAAAAAAAAAAAAACAAAGAucnNyYwAAAOgCAAAAQAAAAAQAAAAGAAAAAAAAAAAAAAAA" +
            "AABAAABALnJlbG9jAAAMAAAAAGAAAAACAAAACgAAAAAAAAAAAAAAAAAAQAAAQgAAAAAAAAAAAAAAAAAAAADcIgAAAAAAAEgAAAACAAUAUCAAAFgCAAABAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAEJTSkIBAAEAAAAAAAwAAAB2NC4wLjMwMzE5AAAAAAUAbAAAALQA" +
            "AAAjfgAAIAEAANgAAAAjU3RyaW5ncwAAAAD4AQAABAAAACNVUwD8AQAAEAAAACNHVUlEAAAADAIAAEwAAAAjQmxvYgAAAAAAAAACAAABBxQAAAkAAAAA+gEz" +
            "ABYAAAEAAAAEAAAAAQAAAAMAAAADAAAAAQAAAAEAAAAAAHgAAQAAAAAABgA6AKgABgBaAKgABgAmAJUADwDIAAAAAAAAABQAAAAAAAEAAQAJAI8AAQARAI8A" +
            "BgAZAI8ACgAuAAsAGQAuABMAIgAuABsAQQAEgAAAAQACAP7/BAAAAAAAAAABAAAABAAAAAAAAAAAAAAAEAAdAAAAAAAAAABWZXJzaW9uMV8yXzY1NTM0XzQA" +
            "PE1vZHVsZT4AbXNjb3JsaWIARGVidWdnYWJsZUF0dHJpYnV0ZQBDb21waWxhdGlvblJlbGF4YXRpb25zQXR0cmlidXRlAFJ1bnRpbWVDb21wYXRpYmlsaXR5" +
            "QXR0cmlidXRlAFZlcnNpb24xXzJfNjU1MzRfNC5kbGwALmN0b3IAU3lzdGVtLkRpYWdub3N0aWNzAFN5c3RlbS5SdW50aW1lLkNvbXBpbGVyU2VydmljZXMA" +
            "RGVidWdnaW5nTW9kZXMAAAAAAABZ5JihAS/qQq6NEY8Qu5fBAAQgAQEIAyAAAQUgAQEREQi3elxWGTTgiQgBAAgAAAAAAB4BAAEAVAIWV3JhcE5vbkV4Y2Vw" +
            "dGlvblRocm93cwEIAQAHAQAAAAAAANAiAAAAAAAAAAAAAOoiAAAAIAAAAAAAAAAAAAAAAAAAAAAAAAAAAADcIgAAAAAAAAAAAAAAAF9Db3JEbGxNYWluAG1z" +
            "Y29yZWUuZGxsAAAAAAD/JQAgABAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAABABAAAAAYAACAAAAAAAAAAAAAAAAAAAABAAEAAAAwAACAAAAAAAAAAAAAAAAAAAABAAAAAABIAAAAWEAAAIwCAAAAAAAA" +
            "AAAAAIwCNAAAAFYAUwBfAFYARQBSAFMASQBPAE4AXwBJAE4ARgBPAAAAAAC9BO/+AAABAAIAAQAEAP7/AgABAAQA/v8/AAAAAAAAAAQAAAACAAAAAAAAAAAA" +
            "AAAAAAAARAAAAAEAVgBhAHIARgBpAGwAZQBJAG4AZgBvAAAAAAAkAAQAAABUAHIAYQBuAHMAbABhAHQAaQBvAG4AAAAAAAAAsATsAQAAAQBTAHQAcgBpAG4A" +
            "ZwBGAGkAbABlAEkAbgBmAG8AAADIAQAAAQAwADAAMAAwADAANABiADAAAAAsAAIAAQBGAGkAbABlAEQAZQBzAGMAcgBpAHAAdABpAG8AbgAAAAAAIAAAADgA" +
            "DAABAEYAaQBsAGUAVgBlAHIAcwBpAG8AbgAAAAAAMQAuADIALgA2ADUANQAzADQALgA0AAAATgAXAAEASQBuAHQAZQByAG4AYQBsAE4AYQBtAGUAAABWAGUA" +
            "cgBzAGkAbwBuADEAXwAyAF8ANgA1ADUAMwA0AF8ANAAuAGQAbABsAAAAAAAoAAIAAQBMAGUAZwBhAGwAQwBvAHAAeQByAGkAZwBoAHQAAAAgAAAAVgAXAAEA" +
            "TwByAGkAZwBpAG4AYQBsAEYAaQBsAGUAbgBhAG0AZQAAAFYAZQByAHMAaQBvAG4AMQBfADIAXwA2ADUANQAzADQAXwA0AC4AZABsAGwAAAAAADwADAABAFAA" +
            "cgBvAGQAdQBjAHQAVgBlAHIAcwBpAG8AbgAAADEALgAyAC4ANgA1ADUAMwA0AC4ANAAAAEAADAABAEEAcwBzAGUAbQBiAGwAeQAgAFYAZQByAHMAaQBvAG4A" +
            "AAAxAC4AMgAuADYANQA1ADMANAAuADQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAgAAAMAAAA/DIAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAA"
        );

        // .assembly Version1_2_65535_65535
        // {
        //   .hash algorithm 0x00008004
        //   .ver 1:2:65535:65535
        // }
        public static readonly byte[] s_Version1_2_65535_65535Image = Convert.FromBase64String(
            "TVqQAAMAAAAEAAAA//8AALgAAAAAAAAAQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAgAAAAA4fug4AtAnNIbgBTM0hVGhpcyBwcm9ncmFt" +
            "IGNhbm5vdCBiZSBydW4gaW4gRE9TIG1vZGUuDQ0KJAAAAAAAAABQRQAATAEDAKh5X1sAAAAAAAAAAOAAIiALATAAAAQAAAAGAAAAAAAAAiMAAAAgAAAAQAAA" +
            "AAAAEAAgAAAAAgAABAAAAAAAAAAEAAAAAAAAAACAAAAAAgAAAAAAAAMAQIUAABAAABAAAAAAEAAAEAAAAAAAABAAAAAAAAAAAAAAALAiAABPAAAAAEAAAPgC" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAGAAAAwAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAIAAACAAAAAAAAAAAAAAA" +
            "CCAAAEgAAAAAAAAAAAAAAC50ZXh0AAAACAMAAAAgAAAABAAAAAIAAAAAAAAAAAAAAAAAACAAAGAucnNyYwAAAPgCAAAAQAAAAAQAAAAGAAAAAAAAAAAAAAAA" +
            "AABAAABALnJlbG9jAAAMAAAAAGAAAAACAAAACgAAAAAAAAAAAAAAAAAAQAAAQgAAAAAAAAAAAAAAAAAAAADkIgAAAAAAAEgAAAACAAUAUCAAAGACAAABAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAEJTSkIBAAEAAAAAAAwAAAB2NC4wLjMwMzE5AAAAAAUAbAAAALQA" +
            "AAAjfgAAIAEAAOAAAAAjU3RyaW5ncwAAAAAAAgAABAAAACNVUwAEAgAAEAAAACNHVUlEAAAAFAIAAEwAAAAjQmxvYgAAAAAAAAACAAABBxQAAAkAAAAA+gEz" +
            "ABYAAAEAAAAEAAAAAQAAAAMAAAADAAAAAQAAAAEAAAAAAHwAAQAAAAAABgA+ALAABgBeALAABgAqAJ0ADwDQAAAAAAAAABgAAAAAAAEAAQAJAJcAAQARAJcA" +
            "BgAZAJcACgAuAAsAGQAuABMAIgAuABsAQQAEgAAAAQACAP////8AAAAAAAABAAAABAAAAAAAAAAAAAAAEAAhAAAAAAAAAABWZXJzaW9uMV8yXzY1NTM1XzY1" +
            "NTM1ADxNb2R1bGU+AG1zY29ybGliAERlYnVnZ2FibGVBdHRyaWJ1dGUAQ29tcGlsYXRpb25SZWxheGF0aW9uc0F0dHJpYnV0ZQBSdW50aW1lQ29tcGF0aWJp" +
            "bGl0eUF0dHJpYnV0ZQBWZXJzaW9uMV8yXzY1NTM1XzY1NTM1LmRsbAAuY3RvcgBTeXN0ZW0uRGlhZ25vc3RpY3MAU3lzdGVtLlJ1bnRpbWUuQ29tcGlsZXJT" +
            "ZXJ2aWNlcwBEZWJ1Z2dpbmdNb2RlcwAAAAAAAPBxYPbBvr1PrDRtWg2pP1AABCABAQgDIAABBSABARERCLd6XFYZNOCJCAEACAAAAAAAHgEAAQBUAhZXcmFw" +
            "Tm9uRXhjZXB0aW9uVGhyb3dzAQgBAAcBAAAAAAAA2CIAAAAAAAAAAAAA8iIAAAAgAAAAAAAAAAAAAAAAAAAAAAAAAAAAAOQiAAAAAAAAAAAAAAAAX0NvckRs" +
            "bE1haW4AbXNjb3JlZS5kbGwAAAAAAP8lACAAEAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAABABAAAAAYAACAAAAAAAAAAAAAAAAAAAABAAEAAAAwAACAAAAAAAAAAAAAAAAAAAABAAAAAABIAAAAWEAAAJwCAAAAAAAA" +
            "AAAAAJwCNAAAAFYAUwBfAFYARQBSAFMASQBPAE4AXwBJAE4ARgBPAAAAAAC9BO/+AAABAAIAAQAEAP7/AgABAAQA/v8/AAAAAAAAAAQAAAACAAAAAAAAAAAA" +
            "AAAAAAAARAAAAAEAVgBhAHIARgBpAGwAZQBJAG4AZgBvAAAAAAAkAAQAAABUAHIAYQBuAHMAbABhAHQAaQBvAG4AAAAAAAAAsAT8AQAAAQBTAHQAcgBpAG4A" +
            "ZwBGAGkAbABlAEkAbgBmAG8AAADYAQAAAQAwADAAMAAwADAANABiADAAAAAsAAIAAQBGAGkAbABlAEQAZQBzAGMAcgBpAHAAdABpAG8AbgAAAAAAIAAAADgA" +
            "DAABAEYAaQBsAGUAVgBlAHIAcwBpAG8AbgAAAAAAMQAuADIALgA2ADUANQAzADQALgA0AAAAVgAbAAEASQBuAHQAZQByAG4AYQBsAE4AYQBtAGUAAABWAGUA" +
            "cgBzAGkAbwBuADEAXwAyAF8ANgA1ADUAMwA1AF8ANgA1ADUAMwA1AC4AZABsAGwAAAAAACgAAgABAEwAZQBnAGEAbABDAG8AcAB5AHIAaQBnAGgAdAAAACAA" +
            "AABeABsAAQBPAHIAaQBnAGkAbgBhAGwARgBpAGwAZQBuAGEAbQBlAAAAVgBlAHIAcwBpAG8AbgAxAF8AMgBfADYANQA1ADMANQBfADYANQA1ADMANQAuAGQA" +
            "bABsAAAAAAA8AAwAAQBQAHIAbwBkAHUAYwB0AFYAZQByAHMAaQBvAG4AAAAxAC4AMgAuADYANQA1ADMANAAuADQAAABAAAwAAQBBAHMAcwBlAG0AYgBsAHkA" +
            "IABWAGUAcgBzAGkAbwBuAAAAMQAuADIALgA2ADUANQAzADQALgA0AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAgAAAMAAAABDMAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAA"
        );

        // .assembly CultureFrCh
        // {
        //   .hash algorithm 0x00008004
        //   .ver 0:0:0:0
        //   .locale = (66 00 72 00 2D 00 43 00 48 00 00 00 )             // f.r.-.C.H...
        // }
        public static readonly byte[] s_CultureFrChImage = Convert.FromBase64String(
            "TVqQAAMAAAAEAAAA//8AALgAAAAAAAAAQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAgAAAAA4fug4AtAnNIbgBTM0hVGhpcyBwcm9ncmFt" +
            "IGNhbm5vdCBiZSBydW4gaW4gRE9TIG1vZGUuDQ0KJAAAAAAAAABQRQAATAEDADp7X1sAAAAAAAAAAOAAIiALATAAAAQAAAAGAAAAAAAA8iIAAAAgAAAAQAAA" +
            "AAAAEAAgAAAAAgAABAAAAAAAAAAEAAAAAAAAAACAAAAAAgAAAAAAAAMAQIUAABAAABAAAAAAEAAAEAAAAAAAABAAAAAAAAAAAAAAAKAiAABPAAAAAEAAALAC" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAGAAAAwAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAIAAACAAAAAAAAAAAAAAA" +
            "CCAAAEgAAAAAAAAAAAAAAC50ZXh0AAAA+AIAAAAgAAAABAAAAAIAAAAAAAAAAAAAAAAAACAAAGAucnNyYwAAALACAAAAQAAAAAQAAAAGAAAAAAAAAAAAAAAA" +
            "AABAAABALnJlbG9jAAAMAAAAAGAAAAACAAAACgAAAAAAAAAAAAAAAAAAQAAAQgAAAAAAAAAAAAAAAAAAAADUIgAAAAAAAEgAAAACAAUAUCAAAFACAAABAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAEJTSkIBAAEAAAAAAAwAAAB2NC4wLjMwMzE5AAAAAAUAbAAAALQA" +
            "AAAjfgAAIAEAANAAAAAjU3RyaW5ncwAAAADwAQAABAAAACNVUwD0AQAAEAAAACNHVUlEAAAABAIAAEwAAAAjQmxvYgAAAAAAAAACAAABBxQAAAkAAAAA+gEz" +
            "ABYAAAEAAAAEAAAAAQAAAAMAAAADAAAAAQAAAAEAAAAAAHcAAQAAAAAABgAtAKAABgBNAKAABgAZAI0ADwDAAAAAAAAAAAEAAAAAAAEAAQAJAIcAAQARAIcA" +
            "BgAZAIcACgAuAAsAGQAuABMAIgAuABsAQQAEgAAAAAAAAAAAAAAAAAAAAABrAAoABAAAAAAAAAAAAAAAEAAQAAAAAAAAAAA8TW9kdWxlPgBmci1DSABtc2Nv" +
            "cmxpYgBEZWJ1Z2dhYmxlQXR0cmlidXRlAENvbXBpbGF0aW9uUmVsYXhhdGlvbnNBdHRyaWJ1dGUAUnVudGltZUNvbXBhdGliaWxpdHlBdHRyaWJ1dGUAQ3Vs" +
            "dHVyZUZyQ2gAQ3VsdHVyZUZyQ2guZGxsAC5jdG9yAFN5c3RlbS5EaWFnbm9zdGljcwBTeXN0ZW0uUnVudGltZS5Db21waWxlclNlcnZpY2VzAERlYnVnZ2lu" +
            "Z01vZGVzAAAAAAAAiUt8zmbz2EehhV2tlkU0hAAEIAEBCAMgAAEFIAEBEREIt3pcVhk04IkIAQAIAAAAAAAeAQABAFQCFldyYXBOb25FeGNlcHRpb25UaHJv" +
            "d3MBCAEABwEAAAAAAADIIgAAAAAAAAAAAADiIgAAACAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA1CIAAAAAAAAAAAAAAABfQ29yRGxsTWFpbgBtc2NvcmVlLmRs" +
            "bAAAAAAA/yUAIAAQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAABABAAAAAYAACAAAAAAAAAAAAAAAAAAAABAAEAAAAwAACAAAAAAAAAAAAAAAAAAAABAAAAAABIAAAAWEAAAFQCAAAAAAAA" +
            "AAAAAFQCNAAAAFYAUwBfAFYARQBSAFMASQBPAE4AXwBJAE4ARgBPAAAAAAC9BO/+AAABAAAAAAAAAAAAAAAAAAAAAAA/AAAAAAAAAAQAAAACAAAAAAAAAAAA" +
            "AAAAAAAARAAAAAEAVgBhAHIARgBpAGwAZQBJAG4AZgBvAAAAAAAkAAQAAABUAHIAYQBuAHMAbABhAHQAaQBvAG4AAAAAAAAAsAS0AQAAAQBTAHQAcgBpAG4A" +
            "ZwBGAGkAbABlAEkAbgBmAG8AAACQAQAAAQAwADAAMAAwADAANABiADAAAAAsAAIAAQBGAGkAbABlAEQAZQBzAGMAcgBpAHAAdABpAG8AbgAAAAAAIAAAADAA" +
            "CAABAEYAaQBsAGUAVgBlAHIAcwBpAG8AbgAAAAAAMAAuADAALgAwAC4AMAAAAEAAEAABAEkAbgB0AGUAcgBuAGEAbABOAGEAbQBlAAAAQwB1AGwAdAB1AHIA" +
            "ZQBGAHIAQwBoAC4AZABsAGwAAAAoAAIAAQBMAGUAZwBhAGwAQwBvAHAAeQByAGkAZwBoAHQAAAAgAAAASAAQAAEATwByAGkAZwBpAG4AYQBsAEYAaQBsAGUA" +
            "bgBhAG0AZQAAAEMAdQBsAHQAdQByAGUARgByAEMAaAAuAGQAbABsAAAANAAIAAEAUAByAG8AZAB1AGMAdABWAGUAcgBzAGkAbwBuAAAAMAAuADAALgAwAC4A" +
            "MAAAADgACAABAEEAcwBzAGUAbQBiAGwAeQAgAFYAZQByAHMAaQBvAG4AAAAwAC4AMAAuADAALgAwAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAgAAAMAAAA9DIAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAA"
        );

        // .assembly PublicKeyToken1ee753223f71263d
        // {
        //   .publickey = (00 24 00 00 04 80 00 00 94 00 00 00 06 02 00 00   // .$..............
        //                 00 24 00 00 52 53 41 31 00 04 00 00 01 00 01 00   // .$..RSA1........
        //                 CD C5 28 4A 57 69 AE 13 C5 4A 4C 74 E0 63 DC 02   // ..(JWi...JLt.c..
        //                 05 5D A1 69 0A 41 E5 83 9B FC 89 1A 21 C8 39 AD   // .].i.A......!.9.
        //                 91 93 43 4D F4 00 10 2D 18 05 E6 C2 FC F7 27 06   // ..CM...-......'.
        //                 04 96 00 E7 71 6C 9C DB 19 75 54 B2 20 5F 1C E0   // ....ql...uT. _..
        //                 0D DD 65 BB 54 42 99 3E 5C 2C 74 9B DC DE 45 F3   // ..e.TB.>\,t...E.
        //                 7A 3C AF D3 BE 65 BD 07 5F 98 09 93 81 83 D8 5C   // z<...e.._......\
        //                 E9 11 41 07 58 06 5C 66 28 BE B6 8B DE 42 AF 66   // ..A.X.\f(....B.f
        //                 05 7A FE DB 60 8C AD 7F 84 3E C9 78 E7 45 DD DA ) // .z..`....>.x.E..
        //   .hash algorithm 0x00008004
        //   .ver 0:0:0:0
        // }
        public static readonly byte[] s_PublicKeyToken1ee753223f71263d_Pk =
            (
                "0024000004800000940000000602000000240000525341310004000001000100" +
                "CDC5284A5769AE13C54A4C74E063DC02055DA1690A41E5839BFC891A21C839AD" +
                "9193434DF400102D1805E6C2FCF72706049600E7716C9CDB197554B2205F1CE0" +
                "0DDD65BB5442993E5C2C749BDCDE45F37A3CAFD3BE65BD075F9809938183D85C" +
                "E911410758065C6628BEB68BDE42AF66057AFEDB608CAD7F843EC978E745DDDA"
            ).HexToByteArray();

        public static readonly byte[] s_PublicKeyToken1ee753223f71263dImage = Convert.FromBase64String(
            "TVqQAAMAAAAEAAAA//8AALgAAAAAAAAAQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAgAAAAA4fug4AtAnNIbgBTM0hVGhpcyBwcm9ncmFt" +
            "IGNhbm5vdCBiZSBydW4gaW4gRE9TIG1vZGUuDQ0KJAAAAAAAAABQRQAATAEDAPZ8X1sAAAAAAAAAAOAAIiALATAAAAYAAAAGAAAAAAAAMiQAAAAgAAAAQAAA" +
            "AAAAEAAgAAAAAgAABAAAAAAAAAAEAAAAAAAAAACAAAAAAgAAHo8AAAMAQIUAABAAABAAAAAAEAAAEAAAAAAAABAAAAAAAAAAAAAAAOAjAABPAAAAAEAAAAAD" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAGAAAAwAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAIAAACAAAAAAAAAAAAAAA" +
            "CCAAAEgAAAAAAAAAAAAAAC50ZXh0AAAAOAQAAAAgAAAABgAAAAIAAAAAAAAAAAAAAAAAACAAAGAucnNyYwAAAAADAAAAQAAAAAQAAAAIAAAAAAAAAAAAAAAA" +
            "AABAAABALnJlbG9jAAAMAAAAAGAAAAACAAAADAAAAAAAAAAAAAAAAAAAQAAAQgAAAAAAAAAAAAAAAAAAAAAUJAAAAAAAAEgAAAACAAUAUCAAABADAAAJAAAA" +
            "AAAAAAAAAAAAAAAAYCMAAIAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAEJTSkIBAAEAAAAAAAwAAAB2NC4wLjMwMzE5AAAAAAUAbAAAALQA" +
            "AAAjfgAAIAEAAPAAAAAjU3RyaW5ncwAAAAAQAgAABAAAACNVUwAUAgAAEAAAACNHVUlEAAAAJAIAAOwAAAAjQmxvYgAAAAAAAAACAAABBxQAAAkAAAAA+gEz" +
            "ABYAAAEAAAAEAAAAAQAAAAMAAAADAAAAAQAAAAEAAAAAAIQAAQAAAAAABgBGAMAABgBmAMAABgAyAK0ADwDgAAAAAAAAAAEAAAAAAAEAAQAJAKcAAQARAKcA" +
            "BgAZAKcACgAuAAsAuwAuABMAxAAuABsA4wAEgAAAAAAAAAAAAAABAAAAGQATAAAABAAAAAAAAAAAAAAAEAAKAAAAAAAAAAA8TW9kdWxlPgBtc2NvcmxpYgBQ" +
            "dWJsaWNLZXlUb2tlbjFlZTc1MzIyM2Y3MTI2M2QARGVidWdnYWJsZUF0dHJpYnV0ZQBDb21waWxhdGlvblJlbGF4YXRpb25zQXR0cmlidXRlAFJ1bnRpbWVD" +
            "b21wYXRpYmlsaXR5QXR0cmlidXRlAFB1YmxpY0tleVRva2VuMWVlNzUzMjIzZjcxMjYzZC5kbGwALmN0b3IAU3lzdGVtLkRpYWdub3N0aWNzAFN5c3RlbS5S" +
            "dW50aW1lLkNvbXBpbGVyU2VydmljZXMARGVidWdnaW5nTW9kZXMAAAAAAADW97hAH9iWTJeCHwswtnH4AAQgAQEIAyAAAQUgAQEREQi3elxWGTTgiYCgACQA" +
            "AASAAACUAAAABgIAAAAkAABSU0ExAAQAAAEAAQDNxShKV2muE8VKTHTgY9wCBV2haQpB5YOb/IkaIcg5rZGTQ030ABAtGAXmwvz3JwYElgDncWyc2xl1VLIg" +
            "XxzgDd1lu1RCmT5cLHSb3N5F83o8r9O+Zb0HX5gJk4GD2FzpEUEHWAZcZii+toveQq9mBXr+22CMrX+EPsl450Xd2ggBAAgAAAAAAB4BAAEAVAIWV3JhcE5v" +
            "bkV4Y2VwdGlvblRocm93cwEIAQAHAQAAAACWSYLpg/aQPHb67VrUnYt6y+bP5Dyk7iKIygG0zhQzjQg08NgXTzbStFB9EBpERPggMgdz5aPboT6E1VNPRVDt" +
            "W8BSUW3tXfoiojzS5Kh0riKFX/Mxdhv6G3tAG9FTqh9gxsDhghBqLWtBQeiLYkKkyI6nGZCeRR6mxL/0lRDC1wgkAAAAAAAAAAAAACIkAAAAIAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAUJAAAAAAAAAAAAAAAAF9Db3JEbGxNYWluAG1zY29yZWUuZGxsAAAAAAD/JQAgABAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAEAEAAAABgA" +
            "AIAAAAAAAAAAAAAAAAAAAAEAAQAAADAAAIAAAAAAAAAAAAAAAAAAAAEAAAAAAEgAAABYQAAApAIAAAAAAAAAAAAApAI0AAAAVgBTAF8AVgBFAFIAUwBJAE8A" +
            "TgBfAEkATgBGAE8AAAAAAL0E7/4AAAEAAAAAAAAAAAAAAAAAAAAAAD8AAAAAAAAABAAAAAIAAAAAAAAAAAAAAAAAAABEAAAAAQBWAGEAcgBGAGkAbABlAEkA" +
            "bgBmAG8AAAAAACQABAAAAFQAcgBhAG4AcwBsAGEAdABpAG8AbgAAAAAAAACwBAQCAAABAFMAdAByAGkAbgBnAEYAaQBsAGUASQBuAGYAbwAAAOABAAABADAA" +
            "MAAwADAAMAA0AGIAMAAAACwAAgABAEYAaQBsAGUARABlAHMAYwByAGkAcAB0AGkAbwBuAAAAAAAgAAAAMAAIAAEARgBpAGwAZQBWAGUAcgBzAGkAbwBuAAAA" +
            "AAAwAC4AMAAuADAALgAwAAAAZgAjAAEASQBuAHQAZQByAG4AYQBsAE4AYQBtAGUAAABQAHUAYgBsAGkAYwBLAGUAeQBUAG8AawBlAG4AMQBlAGUANwA1ADMA" +
            "MgAyADMAZgA3ADEAMgA2ADMAZAAuAGQAbABsAAAAAAAoAAIAAQBMAGUAZwBhAGwAQwBvAHAAeQByAGkAZwBoAHQAAAAgAAAAbgAjAAEATwByAGkAZwBpAG4A" +
            "YQBsAEYAaQBsAGUAbgBhAG0AZQAAAFAAdQBiAGwAaQBjAEsAZQB5AFQAbwBrAGUAbgAxAGUAZQA3ADUAMwAyADIAMwBmADcAMQAyADYAMwBkAC4AZABsAGwA" +
            "AAAAADQACAABAFAAcgBvAGQAdQBjAHQAVgBlAHIAcwBpAG8AbgAAADAALgAwAC4AMAAuADAAAAA4AAgAAQBBAHMAcwBlAG0AYgBsAHkAIABWAGUAcgBzAGkA" +
            "bwBuAAAAMAAuADAALgAwAC4AMAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAACAAAAwAAAA0NAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA="
        );

        // .assembly HashWithSha256
        // {
        //   .hash algorithm 0x0000800C
        //   .ver 0:0:0:0
        // }
        public static readonly byte[] s_HashWithSha256Image = Convert.FromBase64String(
            "TVqQAAMAAAAEAAAA//8AALgAAAAAAAAAQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAgAAAAA4fug4AtAnNIbgBTM0hVGhpcyBwcm9ncmFt" +
            "IGNhbm5vdCBiZSBydW4gaW4gRE9TIG1vZGUuDQ0KJAAAAAAAAABQRQAATAECACCPX1sAAAAAAAAAAOAAAiELAQsAAAQAAAACAAAAAAAA/iIAAAAgAAAAQAAA" +
            "AAAAEAAgAAAAAgAABAAAAAAAAAAEAAAAAAAAAABgAAAAAgAAAAAAAAMAQIUAABAAABAAAAAAEAAAEAAAAAAAABAAAAAAAAAAAAAAAKQiAABXAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAEAAAAwAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAIAAACAAAAAAAAAAAAAAA" +
            "CCAAAEgAAAAAAAAAAAAAAC50ZXh0AAAABAMAAAAgAAAABAAAAAIAAAAAAAAAAAAAAAAAACAAAGAucmVsb2MAAAwAAAAAQAAAAAIAAAAGAAAAAAAAAAAAAAAA" +
            "AABAAABCAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAADgIgAAAAAAAEgAAAACAAUA0CAAANQBAAABAAAA" +
            "AAAAAAAAAAAAAAAAUCAAAIAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "QlNKQgEAAQAAAAAADAAAAHY0LjAuMzAzMTkAAAAABQBsAAAAbAAAACN+AADYAAAAOAAAACNTdHJpbmdzAAAAABABAAAIAAAAI1VTABgBAAAQAAAAI0dVSUQA" +
            "AAAoAQAArAAAACNCbG9iAAAAAAAAAAIAAAEFAAAACQAAAAD6JTMAFgAAAQAAAAEAAAABAAAAAQAAAAAACgABAAAAAAAAAAAAAQAAAAAAAQABAAyAAAAAAAAA" +
            "AAAAAAEAAAAKACYAAAAEAAAAAAAAAAAAAAABAB0AAAAAAAAAADxNb2R1bGU+AEhhc2hXaXRoU2hhMjU2LmRsbABtc2NvcmxpYgBIYXNoV2l0aFNoYTI1NgAA" +
            "AAAAAyAAAAAAAJ3pXbTH6PtBjcuZLVqc190ACLd6XFYZNOCJgKAAJAAABIAAAJQAAAAGAgAAACQAAFJTQTEABAAAAQABAM3FKEpXaa4TxUpMdOBj3AIFXaFp" +
            "CkHlg5v8iRohyDmtkZNDTfQAEC0YBebC/PcnBgSWAOdxbJzbGXVUsiBfHOAN3WW7VEKZPlwsdJvc3kXzejyv075lvQdfmAmTgYPYXOkRQQdYBlxmKL62i95C" +
            "r2YFev7bYIytf4Q+yXjnRd3azCIAAAAAAAAAAAAA7iIAAAAgAAAAAAAAAAAAAAAAAAAAAAAAAAAAAOAiAAAAAAAAAAAAAAAAAAAAAAAAAABfQ29yRGxsTWFp" +
            "bgBtc2NvcmVlLmRsbAAAAAAA/yUAIAAQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAACAAAAwAAAAAMwAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA="
        );

        // Built with csc /platform:anycpu
        public static readonly byte[] s_PlatformAnyCpu = Convert.FromBase64String(
            "TVqQAAMAAAAEAAAA//8AALgAAAAAAAAAQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAgAAAAA4fug4AtAnNIbgBTM0hVGhpcyBwcm9ncmFt" +
            "IGNhbm5vdCBiZSBydW4gaW4gRE9TIG1vZGUuDQ0KJAAAAAAAAABQRQAATAEDAFGzX1sAAAAAAAAAAOAAIiALATAAAAQAAAAGAAAAAAAA/iIAAAAgAAAAQAAA" +
            "AAAAEAAgAAAAAgAABAAAAAAAAAAEAAAAAAAAAACAAAAAAgAAAAAAAAMAQIUAABAAABAAAAAAEAAAEAAAAAAAABAAAAAAAAAAAAAAAKwiAABPAAAAAEAAANgC" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAGAAAAwAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAIAAACAAAAAAAAAAAAAAA" +
            "CCAAAEgAAAAAAAAAAAAAAC50ZXh0AAAABAMAAAAgAAAABAAAAAIAAAAAAAAAAAAAAAAAACAAAGAucnNyYwAAANgCAAAAQAAAAAQAAAAGAAAAAAAAAAAAAAAA" +
            "AABAAABALnJlbG9jAAAMAAAAAGAAAAACAAAACgAAAAAAAAAAAAAAAAAAQAAAQgAAAAAAAAAAAAAAAAAAAADgIgAAAAAAAEgAAAACAAUAUCAAAFwCAAABAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAEJTSkIBAAEAAAAAAAwAAAB2NC4wLjMwMzE5AAAAAAUAbAAAALQA" +
            "AAAjfgAAIAEAANwAAAAjU3RyaW5ncwAAAAD8AQAABAAAACNVUwAAAgAAEAAAACNHVUlEAAAAEAIAAEwAAAAjQmxvYgAAAAAAAAACAAABBxQAAAkAAAAA+gEz" +
            "ABYAAAEAAAAEAAAAAQAAAAMAAAADAAAAAQAAAAEAAAAAAGUAAQAAAAAABgAnAKwABgBHAKwABgATAJkADwDMAAAAAAAAAAEAAAAAAAEAAQAJAJMAAQARAJMA" +
            "BgAZAJMACgAuAAsAGQAuABMAIgAuABsAQQAEgAAAAAAAAAAAAAAAAAAAAAB+AAAABAAAAAAAAAAAAAAAEAAKAAAAAAAAAAA8TW9kdWxlPgBtc2NvcmxpYgBE" +
            "ZWJ1Z2dhYmxlQXR0cmlidXRlAENvbXBpbGF0aW9uUmVsYXhhdGlvbnNBdHRyaWJ1dGUAUnVudGltZUNvbXBhdGliaWxpdHlBdHRyaWJ1dGUAVGFyZ2V0UGxh" +
            "dGZvcm1UZXN0ZXIuZGxsAFRhcmdldFBsYXRmb3JtVGVzdGVyAC5jdG9yAFN5c3RlbS5EaWFnbm9zdGljcwBTeXN0ZW0uUnVudGltZS5Db21waWxlclNlcnZp" +
            "Y2VzAERlYnVnZ2luZ01vZGVzAAAAAAAAnRMZDOb4W0CHkO7NeVOSpwAEIAEBCAMgAAEFIAEBEREIt3pcVhk04IkIAQAIAAAAAAAeAQABAFQCFldyYXBOb25F" +
            "eGNlcHRpb25UaHJvd3MBCAEABwEAAAAAAADUIgAAAAAAAAAAAADuIgAAACAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA4CIAAAAAAAAAAAAAAABfQ29yRGxsTWFp" +
            "bgBtc2NvcmVlLmRsbAAAAAAA/yUAIAAQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAABABAAAAAYAACAAAAAAAAAAAAAAAAAAAABAAEAAAAwAACAAAAAAAAAAAAAAAAAAAABAAAAAABIAAAAWEAAAHwCAAAAAAAA" +
            "AAAAAHwCNAAAAFYAUwBfAFYARQBSAFMASQBPAE4AXwBJAE4ARgBPAAAAAAC9BO/+AAABAAAAAAAAAAAAAAAAAAAAAAA/AAAAAAAAAAQAAAACAAAAAAAAAAAA" +
            "AAAAAAAARAAAAAEAVgBhAHIARgBpAGwAZQBJAG4AZgBvAAAAAAAkAAQAAABUAHIAYQBuAHMAbABhAHQAaQBvAG4AAAAAAAAAsATcAQAAAQBTAHQAcgBpAG4A" +
            "ZwBGAGkAbABlAEkAbgBmAG8AAAC4AQAAAQAwADAAMAAwADAANABiADAAAAAsAAIAAQBGAGkAbABlAEQAZQBzAGMAcgBpAHAAdABpAG8AbgAAAAAAIAAAADAA" +
            "CAABAEYAaQBsAGUAVgBlAHIAcwBpAG8AbgAAAAAAMAAuADAALgAwAC4AMAAAAFIAGQABAEkAbgB0AGUAcgBuAGEAbABOAGEAbQBlAAAAVABhAHIAZwBlAHQA" +
            "UABsAGEAdABmAG8AcgBtAFQAZQBzAHQAZQByAC4AZABsAGwAAAAAACgAAgABAEwAZQBnAGEAbABDAG8AcAB5AHIAaQBnAGgAdAAAACAAAABaABkAAQBPAHIA" +
            "aQBnAGkAbgBhAGwARgBpAGwAZQBuAGEAbQBlAAAAVABhAHIAZwBlAHQAUABsAGEAdABmAG8AcgBtAFQAZQBzAHQAZQByAC4AZABsAGwAAAAAADQACAABAFAA" +
            "cgBvAGQAdQBjAHQAVgBlAHIAcwBpAG8AbgAAADAALgAwAC4AMAAuADAAAAA4AAgAAQBBAHMAcwBlAG0AYgBsAHkAIABWAGUAcgBzAGkAbwBuAAAAMAAuADAA" +
            "LgAwAC4AMAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAgAAAMAAAAADMAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAA"
        );

        // Built with csc /platform:anycpu32bitpreferred
        public static readonly byte[] s_PlatformAnyCpu32BitPreferred = Convert.FromBase64String(
            "TVqQAAMAAAAEAAAA//8AALgAAAAAAAAAQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAgAAAAA4fug4AtAnNIbgBTM0hVGhpcyBwcm9ncmFt" +
            "IGNhbm5vdCBiZSBydW4gaW4gRE9TIG1vZGUuDQ0KJAAAAAAAAABQRQAATAEDAIq2X1sAAAAAAAAAAOAAIgALATAAAAQAAAAIAAAAAAAAQiMAAAAgAAAAQAAA" +
            "AABAAAAgAAAAAgAABAAAAAAAAAAEAAAAAAAAAACAAAAAAgAAAAAAAAMAQIUAABAAABAAAAAAEAAAEAAAAAAAABAAAAAAAAAAAAAAAPAiAABPAAAAAEAAAKwE" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAGAAAAwAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAIAAACAAAAAAAAAAAAAAA" +
            "CCAAAEgAAAAAAAAAAAAAAC50ZXh0AAAASAMAAAAgAAAABAAAAAIAAAAAAAAAAAAAAAAAACAAAGAucnNyYwAAAKwEAAAAQAAAAAYAAAAGAAAAAAAAAAAAAAAA" +
            "AABAAABALnJlbG9jAAAMAAAAAGAAAAACAAAADAAAAAAAAAAAAAAAAAAAQAAAQgAAAAAAAAAAAAAAAAAAAAAkIwAAAAAAAEgAAAACAAUAVCAAAJwCAAADAAIA" +
            "AQAABgAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAoAKgBCU0pCAQABAAAAAAAMAAAAdjQuMC4zMDMxOQAAAAAFAGwA" +
            "AADcAAAAI34AAEgBAADwAAAAI1N0cmluZ3MAAAAAOAIAAAQAAAAjVVMAPAIAABAAAAAjR1VJRAAAAEwCAABQAAAAI0Jsb2IAAAAAAAAAAgAAAUcUAAAJAAAA" +
            "APoBMwAWAAABAAAABQAAAAIAAAABAAAAAwAAAAMAAAABAAAAAQAAAAAAZwABAAAAAAAGACkAugAGAEkAugAGABUApwAPANoAAAAGAOkAgAAAAAAAAQAAAAAA" +
            "AQABAIABEAAKAAAAFQABAAEAUCAAAAAAkQCHABkAAQAJAKEAAQARAKEABgAZAKEACgAuAAsAHQAuABMAJgAuABsARQAEgAAAAAAAAAAAAAAAAAAAAACMAAAA" +
            "BAAAAAAAAAAAAAAAEAAMAAAAAAAAAAAAADxNb2R1bGU+AE4AbXNjb3JsaWIARGVidWdnYWJsZUF0dHJpYnV0ZQBDb21waWxhdGlvblJlbGF4YXRpb25zQXR0" +
            "cmlidXRlAFJ1bnRpbWVDb21wYXRpYmlsaXR5QXR0cmlidXRlAFRhcmdldFBsYXRmb3JtVGVzdGVyLmV4ZQBTeXN0ZW0ATWFpbgBUYXJnZXRQbGF0Zm9ybVRl" +
            "c3RlcgAuY3RvcgBTeXN0ZW0uRGlhZ25vc3RpY3MAU3lzdGVtLlJ1bnRpbWUuQ29tcGlsZXJTZXJ2aWNlcwBEZWJ1Z2dpbmdNb2RlcwBPYmplY3QAAAAAAEjl" +
            "EBoLGvJGlV310i+D9QsABCABAQgDIAABBSABARERCLd6XFYZNOCJAwAAAQgBAAgAAAAAAB4BAAEAVAIWV3JhcE5vbkV4Y2VwdGlvblRocm93cwEIAQAHAQAA" +
            "AAAAABgjAAAAAAAAAAAAADIjAAAAIAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAkIwAAAAAAAAAAAAAAAF9Db3JFeGVNYWluAG1zY29yZWUuZGxsAAAAAAD/JQAg" +
            "QAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAACABAAAAAgAACAGAAAAFAAAIAAAAAAAAAAAAAAAAAAAAEAAQAAADgAAIAAAAAAAAAAAAAAAAAAAAEAAAAAAIAAAAAAAAAA" +
            "AAAAAAAAAAAAAAEAAQAAAGgAAIAAAAAAAAAAAAAAAAAAAAEAAAAAAKwCAACQQAAAHAIAAAAAAAAAAAAAHAI0AAAAVgBTAF8AVgBFAFIAUwBJAE8ATgBfAEkA" +
            "TgBGAE8AAAAAAL0E7/4AAAEAAAAAAAAAAAAAAAAAAAAAAD8AAAAAAAAABAAAAAEAAAAAAAAAAAAAAAAAAABEAAAAAQBWAGEAcgBGAGkAbABlAEkAbgBmAG8A" +
            "AAAAACQABAAAAFQAcgBhAG4AcwBsAGEAdABpAG8AbgAAAAAAAACwBHwBAAABAFMAdAByAGkAbgBnAEYAaQBsAGUASQBuAGYAbwAAAFgBAAABADAAMAAwADAA" +
            "MAA0AGIAMAAAACwAAgABAEYAaQBsAGUARABlAHMAYwByAGkAcAB0AGkAbwBuAAAAAAAgAAAAMAAIAAEARgBpAGwAZQBWAGUAcgBzAGkAbwBuAAAAAAAwAC4A" +
            "MAAuADAALgAwAAAAJAACAAEASQBuAHQAZQByAG4AYQBsAE4AYQBtAGUAAAA/AAAAKAACAAEATABlAGcAYQBsAEMAbwBwAHkAcgBpAGcAaAB0AAAAIAAAACwA" +
            "AgABAE8AcgBpAGcAaQBuAGEAbABGAGkAbABlAG4AYQBtAGUAAAA/AAAANAAIAAEAUAByAG8AZAB1AGMAdABWAGUAcgBzAGkAbwBuAAAAMAAuADAALgAwAC4A" +
            "MAAAADgACAABAEEAcwBzAGUAbQBiAGwAeQAgAFYAZQByAHMAaQBvAG4AAAAwAC4AMAAuADAALgAwAAAAvEIAAOoBAAAAAAAAAAAAAO+7vzw/eG1sIHZlcnNp" +
            "b249IjEuMCIgZW5jb2Rpbmc9IlVURi04IiBzdGFuZGFsb25lPSJ5ZXMiPz4NCg0KPGFzc2VtYmx5IHhtbG5zPSJ1cm46c2NoZW1hcy1taWNyb3NvZnQtY29t" +
            "OmFzbS52MSIgbWFuaWZlc3RWZXJzaW9uPSIxLjAiPg0KICA8YXNzZW1ibHlJZGVudGl0eSB2ZXJzaW9uPSIxLjAuMC4wIiBuYW1lPSJNeUFwcGxpY2F0aW9u" +
            "LmFwcCIvPg0KICA8dHJ1c3RJbmZvIHhtbG5zPSJ1cm46c2NoZW1hcy1taWNyb3NvZnQtY29tOmFzbS52MiI+DQogICAgPHNlY3VyaXR5Pg0KICAgICAgPHJl" +
            "cXVlc3RlZFByaXZpbGVnZXMgeG1sbnM9InVybjpzY2hlbWFzLW1pY3Jvc29mdC1jb206YXNtLnYzIj4NCiAgICAgICAgPHJlcXVlc3RlZEV4ZWN1dGlvbkxl" +
            "dmVsIGxldmVsPSJhc0ludm9rZXIiIHVpQWNjZXNzPSJmYWxzZSIvPg0KICAgICAgPC9yZXF1ZXN0ZWRQcml2aWxlZ2VzPg0KICAgIDwvc2VjdXJpdHk+DQog" +
            "IDwvdHJ1c3RJbmZvPg0KPC9hc3NlbWJseT4AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAACAAAAwAAABEMwAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA="
        );

        // Built with csc /platform:x86
        public static readonly byte[] s_PlatformX86 = Convert.FromBase64String(
            "TVqQAAMAAAAEAAAA//8AALgAAAAAAAAAQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAgAAAAA4fug4AtAnNIbgBTM0hVGhpcyBwcm9ncmFt" +
            "IGNhbm5vdCBiZSBydW4gaW4gRE9TIG1vZGUuDQ0KJAAAAAAAAABQRQAATAEDAJmzX1sAAAAAAAAAAOAAAiELATAAAAQAAAAGAAAAAAAA/iIAAAAgAAAAQAAA" +
            "AAAAEAAgAAAAAgAABAAAAAAAAAAEAAAAAAAAAACAAAAAAgAAAAAAAAMAQIUAABAAABAAAAAAEAAAEAAAAAAAABAAAAAAAAAAAAAAAKwiAABPAAAAAEAAANgC" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAGAAAAwAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAIAAACAAAAAAAAAAAAAAA" +
            "CCAAAEgAAAAAAAAAAAAAAC50ZXh0AAAABAMAAAAgAAAABAAAAAIAAAAAAAAAAAAAAAAAACAAAGAucnNyYwAAANgCAAAAQAAAAAQAAAAGAAAAAAAAAAAAAAAA" +
            "AABAAABALnJlbG9jAAAMAAAAAGAAAAACAAAACgAAAAAAAAAAAAAAAAAAQAAAQgAAAAAAAAAAAAAAAAAAAADgIgAAAAAAAEgAAAACAAUAUCAAAFwCAAADAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAEJTSkIBAAEAAAAAAAwAAAB2NC4wLjMwMzE5AAAAAAUAbAAAALQA" +
            "AAAjfgAAIAEAANwAAAAjU3RyaW5ncwAAAAD8AQAABAAAACNVUwAAAgAAEAAAACNHVUlEAAAAEAIAAEwAAAAjQmxvYgAAAAAAAAACAAABBxQAAAkAAAAA+gEz" +
            "ABYAAAEAAAAEAAAAAQAAAAMAAAADAAAAAQAAAAEAAAAAAGUAAQAAAAAABgAnAKwABgBHAKwABgATAJkADwDMAAAAAAAAAAEAAAAAAAEAAQAJAJMAAQARAJMA" +
            "BgAZAJMACgAuAAsAGQAuABMAIgAuABsAQQAEgAAAAAAAAAAAAAAAAAAAAAB+AAAABAAAAAAAAAAAAAAAEAAKAAAAAAAAAAA8TW9kdWxlPgBtc2NvcmxpYgBE" +
            "ZWJ1Z2dhYmxlQXR0cmlidXRlAENvbXBpbGF0aW9uUmVsYXhhdGlvbnNBdHRyaWJ1dGUAUnVudGltZUNvbXBhdGliaWxpdHlBdHRyaWJ1dGUAVGFyZ2V0UGxh" +
            "dGZvcm1UZXN0ZXIuZGxsAFRhcmdldFBsYXRmb3JtVGVzdGVyAC5jdG9yAFN5c3RlbS5EaWFnbm9zdGljcwBTeXN0ZW0uUnVudGltZS5Db21waWxlclNlcnZp" +
            "Y2VzAERlYnVnZ2luZ01vZGVzAAAAAAAAyr24H+Skn0avgMIHpuX3UwAEIAEBCAMgAAEFIAEBEREIt3pcVhk04IkIAQAIAAAAAAAeAQABAFQCFldyYXBOb25F" +
            "eGNlcHRpb25UaHJvd3MBCAEABwEAAAAAAADUIgAAAAAAAAAAAADuIgAAACAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA4CIAAAAAAAAAAAAAAABfQ29yRGxsTWFp" +
            "bgBtc2NvcmVlLmRsbAAAAAAA/yUAIAAQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAABABAAAAAYAACAAAAAAAAAAAAAAAAAAAABAAEAAAAwAACAAAAAAAAAAAAAAAAAAAABAAAAAABIAAAAWEAAAHwCAAAAAAAA" +
            "AAAAAHwCNAAAAFYAUwBfAFYARQBSAFMASQBPAE4AXwBJAE4ARgBPAAAAAAC9BO/+AAABAAAAAAAAAAAAAAAAAAAAAAA/AAAAAAAAAAQAAAACAAAAAAAAAAAA" +
            "AAAAAAAARAAAAAEAVgBhAHIARgBpAGwAZQBJAG4AZgBvAAAAAAAkAAQAAABUAHIAYQBuAHMAbABhAHQAaQBvAG4AAAAAAAAAsATcAQAAAQBTAHQAcgBpAG4A" +
            "ZwBGAGkAbABlAEkAbgBmAG8AAAC4AQAAAQAwADAAMAAwADAANABiADAAAAAsAAIAAQBGAGkAbABlAEQAZQBzAGMAcgBpAHAAdABpAG8AbgAAAAAAIAAAADAA" +
            "CAABAEYAaQBsAGUAVgBlAHIAcwBpAG8AbgAAAAAAMAAuADAALgAwAC4AMAAAAFIAGQABAEkAbgB0AGUAcgBuAGEAbABOAGEAbQBlAAAAVABhAHIAZwBlAHQA" +
            "UABsAGEAdABmAG8AcgBtAFQAZQBzAHQAZQByAC4AZABsAGwAAAAAACgAAgABAEwAZQBnAGEAbABDAG8AcAB5AHIAaQBnAGgAdAAAACAAAABaABkAAQBPAHIA" +
            "aQBnAGkAbgBhAGwARgBpAGwAZQBuAGEAbQBlAAAAVABhAHIAZwBlAHQAUABsAGEAdABmAG8AcgBtAFQAZQBzAHQAZQByAC4AZABsAGwAAAAAADQACAABAFAA" +
            "cgBvAGQAdQBjAHQAVgBlAHIAcwBpAG8AbgAAADAALgAwAC4AMAAuADAAAAA4AAgAAQBBAHMAcwBlAG0AYgBsAHkAIABWAGUAcgBzAGkAbwBuAAAAMAAuADAA" +
            "LgAwAC4AMAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAgAAAMAAAAADMAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAA"
        );

        // Built with csc /platform:x64
        public static readonly byte[] s_PlatformX64 = Convert.FromBase64String(
            "TVqQAAMAAAAEAAAA//8AALgAAAAAAAAAQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAgAAAAA4fug4AtAnNIbgBTM0hVGhpcyBwcm9ncmFt" +
            "IGNhbm5vdCBiZSBydW4gaW4gRE9TIG1vZGUuDQ0KJAAAAAAAAABQRQAAZIYCAK+zX1sAAAAAAAAAAPAAIiALAjAAAAQAAAAEAAAAAAAAAAAAAAAgAAAAAACA" +
            "AQAAAAAgAAAAAgAABAAAAAAAAAAEAAAAAAAAAABgAAAAAgAAAAAAAAMAQIUAAEAAAAAAAABAAAAAAAAAAAAQAAAAAAAAIAAAAAAAAAAAAAAQAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAABAAADYAgAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAgAABIAAAAAAAAAAAAAAAudGV4dAAAAKQCAAAAIAAAAAQAAAACAAAAAAAAAAAAAAAAAAAgAABgLnJzcmMAAADYAgAAAEAAAAAE" +
            "AAAABgAAAAAAAAAAAAAAAAAAQAAAQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAABIAAAAAgAFAEggAABcAgAAAQAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAABCU0pCAQABAAAAAAAMAAAAdjQuMC4zMDMxOQAAAAAFAGwAAAC0AAAAI34AACAB" +
            "AADcAAAAI1N0cmluZ3MAAAAA/AEAAAQAAAAjVVMAAAIAABAAAAAjR1VJRAAAABACAABMAAAAI0Jsb2IAAAAAAAAAAgAAAQcUAAAJAAAAAPoBMwAWAAABAAAA" +
            "BAAAAAEAAAADAAAAAwAAAAEAAAABAAAAAABlAAEAAAAAAAYAJwCsAAYARwCsAAYAEwCZAA8AzAAAAAAAAAABAAAAAAABAAEACQCTAAEAEQCTAAYAGQCTAAoA" +
            "LgALABkALgATACIALgAbAEEABIAAAAAAAAAAAAAAAAAAAAAAfgAAAAQAAAAAAAAAAAAAABAACgAAAAAAAAAAPE1vZHVsZT4AbXNjb3JsaWIARGVidWdnYWJs" +
            "ZUF0dHJpYnV0ZQBDb21waWxhdGlvblJlbGF4YXRpb25zQXR0cmlidXRlAFJ1bnRpbWVDb21wYXRpYmlsaXR5QXR0cmlidXRlAFRhcmdldFBsYXRmb3JtVGVz" +
            "dGVyLmRsbABUYXJnZXRQbGF0Zm9ybVRlc3RlcgAuY3RvcgBTeXN0ZW0uRGlhZ25vc3RpY3MAU3lzdGVtLlJ1bnRpbWUuQ29tcGlsZXJTZXJ2aWNlcwBEZWJ1" +
            "Z2dpbmdNb2RlcwAAAAAAABBemeCb9I5Im5YZGYiXUjsABCABAQgDIAABBSABARERCLd6XFYZNOCJCAEACAAAAAAAHgEAAQBUAhZXcmFwTm9uRXhjZXB0aW9u" +
            "VGhyb3dzAQgBAAcBAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAABABAAAAAYAACAAAAAAAAAAAAAAAAAAAABAAEAAAAwAACAAAAAAAAAAAAAAAAAAAABAAAAAABIAAAAWEAAAHwCAAAAAAAA" +
            "AAAAAHwCNAAAAFYAUwBfAFYARQBSAFMASQBPAE4AXwBJAE4ARgBPAAAAAAC9BO/+AAABAAAAAAAAAAAAAAAAAAAAAAA/AAAAAAAAAAQAAAACAAAAAAAAAAAA" +
            "AAAAAAAARAAAAAEAVgBhAHIARgBpAGwAZQBJAG4AZgBvAAAAAAAkAAQAAABUAHIAYQBuAHMAbABhAHQAaQBvAG4AAAAAAAAAsATcAQAAAQBTAHQAcgBpAG4A" +
            "ZwBGAGkAbABlAEkAbgBmAG8AAAC4AQAAAQAwADAAMAAwADAANABiADAAAAAsAAIAAQBGAGkAbABlAEQAZQBzAGMAcgBpAHAAdABpAG8AbgAAAAAAIAAAADAA" +
            "CAABAEYAaQBsAGUAVgBlAHIAcwBpAG8AbgAAAAAAMAAuADAALgAwAC4AMAAAAFIAGQABAEkAbgB0AGUAcgBuAGEAbABOAGEAbQBlAAAAVABhAHIAZwBlAHQA" +
            "UABsAGEAdABmAG8AcgBtAFQAZQBzAHQAZQByAC4AZABsAGwAAAAAACgAAgABAEwAZQBnAGEAbABDAG8AcAB5AHIAaQBnAGgAdAAAACAAAABaABkAAQBPAHIA" +
            "aQBnAGkAbgBhAGwARgBpAGwAZQBuAGEAbQBlAAAAVABhAHIAZwBlAHQAUABsAGEAdABmAG8AcgBtAFQAZQBzAHQAZQByAC4AZABsAGwAAAAAADQACAABAFAA" +
            "cgBvAGQAdQBjAHQAVgBlAHIAcwBpAG8AbgAAADAALgAwAC4AMAAuADAAAAA4AAgAAQBBAHMAcwBlAG0AYgBsAHkAIABWAGUAcgBzAGkAbwBuAAAAMAAuADAA" +
            "LgAwAC4AMAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA=="
        );

        // Built with csc /platform:Itanium
        public static readonly byte[] s_PlatformItanium = Convert.FromBase64String(
            "TVqQAAMAAAAEAAAA//8AALgAAAAAAAAAQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAgAAAAA4fug4AtAnNIbgBTM0hVGhpcyBwcm9ncmFt" +
            "IGNhbm5vdCBiZSBydW4gaW4gRE9TIG1vZGUuDQ0KJAAAAAAAAABQRQAAAAICAMWzX1sAAAAAAAAAAPAAIiALAjAAAAQAAAAEAAAAAAAAAAAAAAAgAAAAAACA" +
            "AQAAAAAgAAAAAgAABAAAAAAAAAAEAAAAAAAAAABgAAAAAgAAAAAAAAMAQIUAAEAAAAAAAABAAAAAAAAAAAAQAAAAAAAAIAAAAAAAAAAAAAAQAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAABAAADYAgAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAgAABIAAAAAAAAAAAAAAAudGV4dAAAAKQCAAAAIAAAAAQAAAACAAAAAAAAAAAAAAAAAAAgAABgLnJzcmMAAADYAgAAAEAAAAAE" +
            "AAAABgAAAAAAAAAAAAAAAAAAQAAAQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAABIAAAAAgAFAEggAABcAgAAAQAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAABCU0pCAQABAAAAAAAMAAAAdjQuMC4zMDMxOQAAAAAFAGwAAAC0AAAAI34AACAB" +
            "AADcAAAAI1N0cmluZ3MAAAAA/AEAAAQAAAAjVVMAAAIAABAAAAAjR1VJRAAAABACAABMAAAAI0Jsb2IAAAAAAAAAAgAAAQcUAAAJAAAAAPoBMwAWAAABAAAA" +
            "BAAAAAEAAAADAAAAAwAAAAEAAAABAAAAAABlAAEAAAAAAAYAJwCsAAYARwCsAAYAEwCZAA8AzAAAAAAAAAABAAAAAAABAAEACQCTAAEAEQCTAAYAGQCTAAoA" +
            "LgALABkALgATACIALgAbAEEABIAAAAAAAAAAAAAAAAAAAAAAfgAAAAQAAAAAAAAAAAAAABAACgAAAAAAAAAAPE1vZHVsZT4AbXNjb3JsaWIARGVidWdnYWJs" +
            "ZUF0dHJpYnV0ZQBDb21waWxhdGlvblJlbGF4YXRpb25zQXR0cmlidXRlAFJ1bnRpbWVDb21wYXRpYmlsaXR5QXR0cmlidXRlAFRhcmdldFBsYXRmb3JtVGVz" +
            "dGVyLmRsbABUYXJnZXRQbGF0Zm9ybVRlc3RlcgAuY3RvcgBTeXN0ZW0uRGlhZ25vc3RpY3MAU3lzdGVtLlJ1bnRpbWUuQ29tcGlsZXJTZXJ2aWNlcwBEZWJ1" +
            "Z2dpbmdNb2RlcwAAAAAAAF4u4bGKZDJBl86xptvvm2UABCABAQgDIAABBSABARERCLd6XFYZNOCJCAEACAAAAAAAHgEAAQBUAhZXcmFwTm9uRXhjZXB0aW9u" +
            "VGhyb3dzAQgBAAcBAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAABABAAAAAYAACAAAAAAAAAAAAAAAAAAAABAAEAAAAwAACAAAAAAAAAAAAAAAAAAAABAAAAAABIAAAAWEAAAHwCAAAAAAAA" +
            "AAAAAHwCNAAAAFYAUwBfAFYARQBSAFMASQBPAE4AXwBJAE4ARgBPAAAAAAC9BO/+AAABAAAAAAAAAAAAAAAAAAAAAAA/AAAAAAAAAAQAAAACAAAAAAAAAAAA" +
            "AAAAAAAARAAAAAEAVgBhAHIARgBpAGwAZQBJAG4AZgBvAAAAAAAkAAQAAABUAHIAYQBuAHMAbABhAHQAaQBvAG4AAAAAAAAAsATcAQAAAQBTAHQAcgBpAG4A" +
            "ZwBGAGkAbABlAEkAbgBmAG8AAAC4AQAAAQAwADAAMAAwADAANABiADAAAAAsAAIAAQBGAGkAbABlAEQAZQBzAGMAcgBpAHAAdABpAG8AbgAAAAAAIAAAADAA" +
            "CAABAEYAaQBsAGUAVgBlAHIAcwBpAG8AbgAAAAAAMAAuADAALgAwAC4AMAAAAFIAGQABAEkAbgB0AGUAcgBuAGEAbABOAGEAbQBlAAAAVABhAHIAZwBlAHQA" +
            "UABsAGEAdABmAG8AcgBtAFQAZQBzAHQAZQByAC4AZABsAGwAAAAAACgAAgABAEwAZQBnAGEAbABDAG8AcAB5AHIAaQBnAGgAdAAAACAAAABaABkAAQBPAHIA" +
            "aQBnAGkAbgBhAGwARgBpAGwAZQBuAGEAbQBlAAAAVABhAHIAZwBlAHQAUABsAGEAdABmAG8AcgBtAFQAZQBzAHQAZQByAC4AZABsAGwAAAAAADQACAABAFAA" +
            "cgBvAGQAdQBjAHQAVgBlAHIAcwBpAG8AbgAAADAALgAwAC4AMAAuADAAAAA4AAgAAQBBAHMAcwBlAG0AYgBsAHkAIABWAGUAcgBzAGkAbwBuAAAAMAAuADAA" +
            "LgAwAC4AMAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA=="
        );

        // Built with csc /platform:arm
        public static readonly byte[] s_PlatformArm = Convert.FromBase64String(
            "TVqQAAMAAAAEAAAA//8AALgAAAAAAAAAQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAgAAAAA4fug4AtAnNIbgBTM0hVGhpcyBwcm9ncmFt" +
            "IGNhbm5vdCBiZSBydW4gaW4gRE9TIG1vZGUuDQ0KJAAAAAAAAABQRQAAxAECANazX1sAAAAAAAAAAOAAIiALATAAAAQAAAAEAAAAAAAAAAAAAAAgAAAAQAAA" +
            "AAAAEAAgAAAAAgAABAAAAAAAAAAGAAIAAAAAAABgAAAAAgAAAAAAAAMAQIUAABAAABAAAAAAEAAAEAAAAAAAABAAAAAAAAAAAAAAAAAAAAAAAAAAAEAAANgC" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "ACAAAEgAAAAAAAAAAAAAAC50ZXh0AAAApAIAAAAgAAAABAAAAAIAAAAAAAAAAAAAAAAAACAAAGAucnNyYwAAANgCAAAAQAAAAAQAAAAGAAAAAAAAAAAAAAAA" +
            "AABAAABAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAABIAAAAAgAFAEggAABcAgAAAQAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAABCU0pCAQABAAAAAAAMAAAAdjQuMC4zMDMxOQAAAAAFAGwAAAC0AAAAI34AACAB" +
            "AADcAAAAI1N0cmluZ3MAAAAA/AEAAAQAAAAjVVMAAAIAABAAAAAjR1VJRAAAABACAABMAAAAI0Jsb2IAAAAAAAAAAgAAAQcUAAAJAAAAAPoBMwAWAAABAAAA" +
            "BAAAAAEAAAADAAAAAwAAAAEAAAABAAAAAABlAAEAAAAAAAYAJwCsAAYARwCsAAYAEwCZAA8AzAAAAAAAAAABAAAAAAABAAEACQCTAAEAEQCTAAYAGQCTAAoA" +
            "LgALABkALgATACIALgAbAEEABIAAAAAAAAAAAAAAAAAAAAAAfgAAAAQAAAAAAAAAAAAAABAACgAAAAAAAAAAPE1vZHVsZT4AbXNjb3JsaWIARGVidWdnYWJs" +
            "ZUF0dHJpYnV0ZQBDb21waWxhdGlvblJlbGF4YXRpb25zQXR0cmlidXRlAFJ1bnRpbWVDb21wYXRpYmlsaXR5QXR0cmlidXRlAFRhcmdldFBsYXRmb3JtVGVz" +
            "dGVyLmRsbABUYXJnZXRQbGF0Zm9ybVRlc3RlcgAuY3RvcgBTeXN0ZW0uRGlhZ25vc3RpY3MAU3lzdGVtLlJ1bnRpbWUuQ29tcGlsZXJTZXJ2aWNlcwBEZWJ1" +
            "Z2dpbmdNb2RlcwAAAAAAAEPBQICY7c5GszyW5N5GZDoABCABAQgDIAABBSABARERCLd6XFYZNOCJCAEACAAAAAAAHgEAAQBUAhZXcmFwTm9uRXhjZXB0aW9u" +
            "VGhyb3dzAQgBAAcBAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAABABAAAAAYAACAAAAAAAAAAAAAAAAAAAABAAEAAAAwAACAAAAAAAAAAAAAAAAAAAABAAAAAABIAAAAWEAAAHwCAAAAAAAA" +
            "AAAAAHwCNAAAAFYAUwBfAFYARQBSAFMASQBPAE4AXwBJAE4ARgBPAAAAAAC9BO/+AAABAAAAAAAAAAAAAAAAAAAAAAA/AAAAAAAAAAQAAAACAAAAAAAAAAAA" +
            "AAAAAAAARAAAAAEAVgBhAHIARgBpAGwAZQBJAG4AZgBvAAAAAAAkAAQAAABUAHIAYQBuAHMAbABhAHQAaQBvAG4AAAAAAAAAsATcAQAAAQBTAHQAcgBpAG4A" +
            "ZwBGAGkAbABlAEkAbgBmAG8AAAC4AQAAAQAwADAAMAAwADAANABiADAAAAAsAAIAAQBGAGkAbABlAEQAZQBzAGMAcgBpAHAAdABpAG8AbgAAAAAAIAAAADAA" +
            "CAABAEYAaQBsAGUAVgBlAHIAcwBpAG8AbgAAAAAAMAAuADAALgAwAC4AMAAAAFIAGQABAEkAbgB0AGUAcgBuAGEAbABOAGEAbQBlAAAAVABhAHIAZwBlAHQA" +
            "UABsAGEAdABmAG8AcgBtAFQAZQBzAHQAZQByAC4AZABsAGwAAAAAACgAAgABAEwAZQBnAGEAbABDAG8AcAB5AHIAaQBnAGgAdAAAACAAAABaABkAAQBPAHIA" +
            "aQBnAGkAbgBhAGwARgBpAGwAZQBuAGEAbQBlAAAAVABhAHIAZwBlAHQAUABsAGEAdABmAG8AcgBtAFQAZQBzAHQAZQByAC4AZABsAGwAAAAAADQACAABAFAA" +
            "cgBvAGQAdQBjAHQAVgBlAHIAcwBpAG8AbgAAADAALgAwAC4AMAAuADAAAAA4AAgAAQBBAHMAcwBlAG0AYgBsAHkAIABWAGUAcgBzAGkAbwBuAAAAMAAuADAA" +
            "LgAwAC4AMAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA=="
        );

        // .assembly extern mscorlib
        // {
        //   .publickeytoken = (B7 7A 5C 56 19 34 E0 89 )                         // .z\V.4..
        //   .ver 4:0:0:0
        // }
        // .assembly extern dep1
        // {
        //   .ver 0:0:0:0
        // }
        // .assembly extern dep2
        // {
        //   .ver 1:2:3:4
        //   .locale = (61 00 72 00 2D 00 4C 00 59 00 00 00 )             // a.r.-.L.Y...
        // }
        // .assembly AssemblyReferenceTest
        // {
        //   .custom instance void [mscorlib]System.Runtime.CompilerServices.CompilationRelaxationsAttribute::.ctor(int32) = ( 01 00 08 00 00 00 00 00 )
        //   .custom instance void [mscorlib]System.Runtime.CompilerServices.RuntimeCompatibilityAttribute::.ctor() = ( 01 00 01 00 54 02 16 57 72 61 70 4E 6F 6E 45 78   // ....T..WrapNonEx
        //                                                                                                              63 65 70 74 69 6F 6E 54 68 72 6F 77 73 01 )       // ceptionThrows.
        //
        //   // --- The following custom attribute is added automatically, do not uncomment -------
        //   //  .custom instance void [mscorlib]System.Diagnostics.DebuggableAttribute::.ctor(valuetype [mscorlib]System.Diagnostics.DebuggableAttribute/DebuggingModes) = ( 01 00 07 01 00 00 00 00 )
        //
        //   .hash algorithm 0x00008004
        //   .ver 0:0:0:0
        // }
        // .module AssemblyReferenceTest.dll
        // // MVID: {E38F9CD2-02F2-4668-B594-EECBCA4B20D3}
        // .imagebase 0x10000000
        // .file alignment 0x00000200
        // .stackreserve 0x00100000
        // .subsystem 0x0003       // WINDOWS_CUI
        // .corflags 0x00000001    //  ILONLY
        // // Image base: 0x0000023E9C200000
        public static readonly byte[] s_AssemblyReferencesTestImage = Convert.FromBase64String(
            "TVqQAAMAAAAEAAAA//8AALgAAAAAAAAAQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAgAAAAA4fug4AtAnNIbgBTM0hVGhpcyBwcm9ncmFt" +
            "IGNhbm5vdCBiZSBydW4gaW4gRE9TIG1vZGUuDQ0KJAAAAAAAAABQRQAATAECAOGVYFsAAAAAAAAAAOAAAiELAQsAAAQAAAACAAAAAAAA3iIAAAAgAAAAQAAA" +
            "AAAAEAAgAAAAAgAABAAAAAAAAAAEAAAAAAAAAABgAAAAAgAAAAAAAAMAQIUAABAAABAAAAAAEAAAEAAAAAAAABAAAAAAAAAAAAAAAIwiAABPAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAEAAAAwAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAIAAACAAAAAAAAAAAAAAA" +
            "CCAAAEgAAAAAAAAAAAAAAC50ZXh0AAAA5AIAAAAgAAAABAAAAAIAAAAAAAAAAAAAAAAAACAAAGAucmVsb2MAAAwAAAAAQAAAAAIAAAAGAAAAAAAAAAAAAAAA" +
            "AABAAABCAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAADAIgAAAAAAAEgAAAACAAUAUCAAADwCAAABAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAEJTSkIBAAEAAAAAAAwAAAB2NC4wLjMwMzE5AAAAAAUAbAAAAMQA" +
            "AAAjfgAAMAEAALgAAAAjU3RyaW5ncwAAAADoAQAACAAAACNVUwDwAQAAEAAAACNHVUlEAAAAAAIAADwAAAAjQmxvYgAAAAAAAAACAAABBxQAAAkAAAAA+iUz" +
            "ABYAAAEAAAACAAAAAQAAAAIAAAACAAAAAQAAAAMAAAAAAG4AAQAAAAAABgAqAAoABgBQAAoAAAAAAAEAAAAAAAEAAQAJAEoAAQARAEoABgAuAAsAEwAuABMA" +
            "HAAEgAAAAAAAAAAAAAAAAAAAAAChAAAABAAAAAAAAAAAAAAACgCIAAAAAAAAAAAAAAAAAAAAAAAAAJEAAAAAAAEAAgADAAQAAAAAAAAAlgCbAAAAAAAAPE1v" +
            "ZHVsZT4AU3lzdGVtLlJ1bnRpbWUuQ29tcGlsZXJTZXJ2aWNlcwBDb21waWxhdGlvblJlbGF4YXRpb25zQXR0cmlidXRlAC5jdG9yAFJ1bnRpbWVDb21wYXRp" +
            "YmlsaXR5QXR0cmlidXRlAEFzc2VtYmx5UmVmZXJlbmNlVGVzdC5kbGwAbXNjb3JsaWIAZGVwMQBkZXAyAGFyLUxZAEFzc2VtYmx5UmVmZXJlbmNlVGVzdAAA" +
            "AAMgAAAAAAD+latRaKErR6lFRbe04zMTAAQgAQEIAyAAAQi3elxWGTTgiQgBAAgAAAAAAB4BAAEAVAIWV3JhcE5vbkV4Y2VwdGlvblRocm93cwEAtCIAAAAA" +
            "AAAAAAAAziIAAAAgAAAAAAAAAAAAAAAAAAAAAAAAAAAAAMAiAAAAAAAAAAAAAAAAX0NvckRsbE1haW4AbXNjb3JlZS5kbGwAAAAAAP8lACAAEAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAACAAAAwAAADgMgAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA="
            );

        // .assembly extern norevision
        // {
        //   .ver 1:2:3:65535
        // }
        // .assembly extern nobuildrevision
        // {
        //   .ver 1:2:65535:65535
        // }
        // .assembly extern nobuildrevisionalternate
        // {
        //   .ver 1:2:65535:4
        // }
        // .assembly extern illegal1
        // {
        //   .ver 1:65535:65535:65535
        // }
        // .assembly extern illegal2
        // {
        //   .ver 65535:65535:65535:65535
        // }
        // .assembly extern illegal3
        // {
        //   .ver 1:65535:3:4
        // }
        // .assembly PartialVersionsTest
        // {
        //   .hash algorithm 0x00008004
        //   .ver 0:0:0:0
        // }
        // .module PartialVersionsTest.dll
        // // MVID: {A79B4F5A-B0A1-4613-A880-05B5CD37C15B}
        // .imagebase 0x10000000
        // .file alignment 0x00000200
        // .stackreserve 0x00100000
        // .subsystem 0x0003       // WINDOWS_CUI
        // .corflags 0x00000001    //  ILONLY
        // // Image base: 0x0000024A7B400000
        //
        public static readonly byte[] s_PartialVersionsImage = Convert.FromBase64String(
            "TVqQAAMAAAAEAAAA//8AALgAAAAAAAAAQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAgAAAAA4fug4AtAnNIbgBTM0hVGhpcyBwcm9ncmFt" +
            "IGNhbm5vdCBiZSBydW4gaW4gRE9TIG1vZGUuDQ0KJAAAAAAAAABQRQAATAECACemYFsAAAAAAAAAAOAAAiELAQsAAAQAAAACAAAAAAAAbiIAAAAgAAAAQAAA" +
            "AAAAEAAgAAAAAgAABAAAAAAAAAAEAAAAAAAAAABgAAAAAgAAAAAAAAMAQIUAABAAABAAAAAAEAAAEAAAAAAAABAAAAAAAAAAAAAAABwiAABPAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAEAAAAwAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAIAAACAAAAAAAAAAAAAAA" +
            "CCAAAEgAAAAAAAAAAAAAAC50ZXh0AAAAdAIAAAAgAAAABAAAAAIAAAAAAAAAAAAAAAAAACAAAGAucmVsb2MAAAwAAAAAQAAAAAIAAAAGAAAAAAAAAAAAAAAA" +
            "AABAAABCAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAABQIgAAAAAAAEgAAAACAAUAUCAAAMwBAAABAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAEJTSkIBAAEAAAAAAAwAAAB2NC4wLjMwMzE5AAAAAAQAXAAAANAA" +
            "AAAjfgAALAEAAIgAAAAjU3RyaW5ncwAAAAC0AQAACAAAACNVUwC8AQAAEAAAACNHVUlEAAAAAAAAAAIAAAEFAAAACQAAAAD6JTMAFgAAAQAAAAEAAAABAAAA" +
            "BgAAAAAACgABAAAAAAAAAAAAAQAAAAAAAQABAASAAAAAAAAAAAAAAAAAAAAAAHEAAAABAAIAAwD//wAAAAAAACIAAAAAAAEAAgD/////AAAAAAAALQAAAAAA" +
            "AQACAP//BAAAAAAAAAA9AAAAAAABAP///////wAAAAAAAFYAAAAAAP//////////AAAAAAAAXwAAAAAAAQD//wMABAAAAAAAAABoAAAAAAAAAAA8TW9kdWxl" +
            "PgBQYXJ0aWFsVmVyc2lvbnNUZXN0LmRsbABub3JldmlzaW9uAG5vYnVpbGRyZXZpc2lvbgBub2J1aWxkcmV2aXNpb25hbHRlcm5hdGUAaWxsZWdhbDEAaWxs" +
            "ZWdhbDIAaWxsZWdhbDMAUGFydGlhbFZlcnNpb25zVGVzdAAAAAAAAyAAAAAAAFpPm6ehsBNGqIAFtc03wVtEIgAAAAAAAAAAAABeIgAAACAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAUCIAAAAAAAAAAAAAAABfQ29yRGxsTWFpbgBtc2NvcmVlLmRsbAAAAAAA/yUAIAAQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAACAAAAwAAABwMgAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA="
            );

        // // Metadata version: v4.0.30319
        // .assembly extern mscorlib
        // {
        //   .publickey = (00 00 00 00 00 00 00 00 04 00 00 00 00 00 00 00 )    // <---- full public key specified in assemblyref (usually, it's just the PKT)
        //   .ver 4:0:0:0
        // }
        // .assembly AssemblyRefUsingFullPublicKey
        // {
        //   .hash algorithm 0x00008004
        //   .ver 0:0:0:0
        // }
        // .module AssemblyRefUsingFullPublicKey.dll
        // // MVID: {DD0A4722-ADA9-47C8-9FA4-1D70DE0C8666}
        // .imagebase 0x10000000
        // .file alignment 0x00000200
        // .stackreserve 0x00100000
        // .subsystem 0x0003       // WINDOWS_CUI
        // .corflags 0x00000001    //  ILONLY
        //
        // .class public auto ansi beforefieldinit C
        //        extends [mscorlib]System.Object
        // {
        //   .method public hidebysig specialname rtspecialname
        //           instance void  .ctor() cil managed
        //   {
        //     // Code size       8 (0x8)
        //     .maxstack  8
        //     IL_0000:  ldarg.0
        //     IL_0001:  call       instance void [mscorlib]System.Object::.ctor()
        //     IL_0006:  nop
        //     IL_0007:  ret
        //   } // end of method C::.ctor
        //
        // } // end of class C
        public static readonly byte[] s_AssemblyRefUsingFullPublicKeyImage = Convert.FromBase64String(
            "TVqQAAMAAAAEAAAA//8AALgAAAAAAAAAQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAgAAAAA4fug4AtAnNIbgBTM0hVGhpcyBwcm9ncmFt" +
            "IGNhbm5vdCBiZSBydW4gaW4gRE9TIG1vZGUuDQ0KJAAAAAAAAABQRQAATAECABOdY1sAAAAAAAAAAOAAAiELAQsAAAQAAAACAAAAAAAAXiIAAAAgAAAAQAAA" +
            "AAAAEAAgAAAAAgAABAAAAAAAAAAEAAAAAAAAAABgAAAAAgAAAAAAAAMAQIUAABAAABAAAAAAEAAAEAAAAAAAABAAAAAAAAAAAAAAAAQiAABXAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAEAAAAwAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAIAAACAAAAAAAAAAAAAAA" +
            "CCAAAEgAAAAAAAAAAAAAAC50ZXh0AAAAZAIAAAAgAAAABAAAAAIAAAAAAAAAAAAAAAAAACAAAGAucmVsb2MAAAwAAAAAQAAAAAIAAAAGAAAAAAAAAAAAAAAA" +
            "AABAAABCAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAABAIgAAAAAAAEgAAAACAAUAXCAAAKgBAAABAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACICKAEAAAoAKgAAAEJTSkIBAAEAAAAAAAwAAAB2NC4wLjMwMzE5" +
            "AAAAAAUAbAAAAKAAAAAjfgAADAEAAGwAAAAjU3RyaW5ncwAAAAB4AQAACAAAACNVUwCAAQAAEAAAACNHVUlEAAAAkAEAABgAAAAjQmxvYgAAAAAAAAACAAAB" +
            "RwQAAAkAAAAA+iUzABYAAAEAAAABAAAAAgAAAAEAAAABAAAAAQAAAAEAAAAAAB4AAQAAAAAABgARAAoAAAAAAAEAAAAAAAEAAQABABAASQAAAAUAAQABAFAg" +
            "AAAAAIYYGAABAAEACQAYAAEABIAAAAAAAAAAAAAAAAAAAAAASwAAAAQAAAAAAAAAAQAAAAUAQAAAAAAAAAAAPE1vZHVsZT4AU3lzdGVtAE9iamVjdAAuY3Rv" +
            "cgBBc3NlbWJseVJlZlVzaW5nRnVsbFB1YmxpY0tleS5kbGwAbXNjb3JsaWIAQwBBc3NlbWJseVJlZlVzaW5nRnVsbFB1YmxpY0tleQAAAAAAAyAAAAAAACJH" +
            "Ct2prchHn6QdcN4MhmYAAyAAARAAAAAAAAAAAAQAAAAAAAAAAAAsIgAAAAAAAAAAAABOIgAAACAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAQCIAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAF9Db3JEbGxNYWluAG1zY29yZWUuZGxsAAAAAAD/JQAgABAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAACAAAAwAAABgMgAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA="
            );

        // // Metadata version: v4.0.30319
        // .assembly extern mscorlib
        // {
        //   .publickeytoken = (B7 7A 5C 56 19 34 E0 89 )                         // .z\V.4..
        //   .ver 4:0:0:0
        // }
        // .assembly CustomModifiers
        // {
        //   .custom instance void [mscorlib]System.Runtime.CompilerServices.CompilationRelaxationsAttribute::.ctor(int32) = ( 01 00 08 00 00 00 00 00 )
        //   .custom instance void [mscorlib]System.Runtime.CompilerServices.RuntimeCompatibilityAttribute::.ctor() = ( 01 00 01 00 54 02 16 57 72 61 70 4E 6F 6E 45 78   // ....T..WrapNonEx
        //                                                                                                              63 65 70 74 69 6F 6E 54 68 72 6F 77 73 01 )       // ceptionThrows.
        //   .hash algorithm 0x00008004
        //   .ver 0:0:0:0
        // }
        // .module CustomModifiers.dll
        // // MVID: {A5A40F77-F9AA-4E98-ADB2-66FF7F5AC50C}
        // .imagebase 0x10000000
        // .file alignment 0x00000200
        // .stackreserve 0x00100000
        // .subsystem 0x0003       // WINDOWS_CUI
        // .corflags 0x00000001    //  ILONLY
        // // Image base: 0x0000025996320000
        //
        //
        // // =============== CLASS MEMBERS DECLARATION ===================
        //
        // .class public abstract auto ansi sealed beforefieldinit N
        //        extends [mscorlib]System.Object
        // {
        //   .field public static int32 modreq(ReqA) modopt(OptA) modreq(ReqB) modopt(OptB) modreq(ReqC) modopt(OptC) MyField
        //   .field public static int32 modreq(ReqA)[] modreq(ReqB) MyArrayField
        //   .method public hidebysig specialname static
        //           int32 modreq(ReqA) modopt(OptA) modreq(ReqB) modopt(OptB) modreq(ReqC) modopt(OptC)
        //           get_MyProperty() cil managed
        //   {
        //     // Code size       2 (0x2)
        //     .maxstack  8
        //     IL_0000:  ldc.i4.0
        //     IL_0001:  ret
        //   } // end of method N::get_MyProperty
        //
        //   .method public hidebysig static void  MyMethod(int32 modreq(ReqA) modopt(OptA) modreq(ReqB) modopt(OptB) modreq(ReqC) modopt(OptC) i) cil managed
        //   {
        //     // Code size       2 (0x2)
        //     .maxstack  8
        //     IL_0000:  nop
        //     IL_0001:  ret
        //   } // end of method N::MyMethod
        //
        //   .property int32 modreq(ReqA) modopt(OptA) modreq(ReqB) modopt(OptB) modreq(ReqC) modopt(OptC)
        //           MyProperty()
        //   {
        //     .get int32 modreq(ReqA) modopt(OptA) modreq(ReqB) modopt(OptB) modreq(ReqC) modopt(OptC) N::get_MyProperty()
        //   } // end of property N::MyProperty
        // } // end of class N
        //
        // .class public abstract auto ansi sealed beforefieldinit ReqA
        //        extends [mscorlib]System.Object
        // {
        // } // end of class ReqA
        //
        // .class public abstract auto ansi sealed beforefieldinit OptA
        //        extends [mscorlib]System.Object
        // {
        // } // end of class OptA
        //
        // .class public abstract auto ansi sealed beforefieldinit ReqB
        //        extends [mscorlib]System.Object
        // {
        // } // end of class ReqB
        //
        // .class public abstract auto ansi sealed beforefieldinit OptB
        //        extends [mscorlib]System.Object
        // {
        // } // end of class OptB
        //
        // .class public abstract auto ansi sealed beforefieldinit ReqC
        //        extends [mscorlib]System.Object
        // {
        // } // end of class ReqC
        //
        // .class public abstract auto ansi sealed beforefieldinit OptC
        //        extends [mscorlib]System.Object
        // {
        // } // end of class OptC
        //
        // .class public abstract auto ansi sealed beforefieldinit G`1<T>
        //        extends [mscorlib]System.Object
        // {
        // } // end of class G`1
        //
        public static readonly byte[] s_CustomModifiersImage = Convert.FromBase64String(
            "TVqQAAMAAAAEAAAA//8AALgAAAAAAAAAQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAgAAAAA4fug4AtAnNIbgBTM0hVGhpcyBwcm9ncmFt" +
            "IGNhbm5vdCBiZSBydW4gaW4gRE9TIG1vZGUuDQ0KJAAAAAAAAABQRQAATAECAC9WZlsAAAAAAAAAAOAAAiELAQsAAAYAAAACAAAAAAAALiQAAAAgAAAAQAAA" +
            "AAAAEAAgAAAAAgAABAAAAAAAAAAEAAAAAAAAAABgAAAAAgAAAAAAAAMAQIUAABAAABAAAAAAEAAAEAAAAAAAABAAAAAAAAAAAAAAAOAjAABLAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAEAAAAwAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAIAAACAAAAAAAAAAAAAAA" +
            "CCAAAEgAAAAAAAAAAAAAAC50ZXh0AAAANAQAAAAgAAAABgAAAAIAAAAAAAAAAAAAAAAAACAAAGAucmVsb2MAAAwAAAAAQAAAAAIAAAAIAAAAAAAAAAAAAAAA" +
            "AABAAABCAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAQJAAAAAAAAEgAAAACAAUAWCAAAIgDAAABAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAoWKgoAKgAAQlNKQgEAAQAAAAAADAAAAHY0LjAuMzAzMTkAAAAA" +
            "BQBsAAAAdAEAACN+AADgAQAADAEAACNTdHJpbmdzAAAAAOwCAAAIAAAAI1VTAPQCAAAQAAAAI0dVSUQAAAAEAwAAhAAAACNCbG9iAAAAAAAAAAIAAAFXFaAB" +
            "CQQAAAD6JTMAFgAAAQAAAAMAAAAJAAAAAgAAAAIAAAABAAAAAgAAAAIAAAABAAAAAQAAAAEAAAABAAAAAQAAAAEAAAAAAHwAAQAAAAAABgAqAAoABgBQAAoA" +
            "BgB1AG4AAAAAAAEAAAAAAAEAAQCBARAAmQAAAA0AAQABAIEBEACbAAAADQADAAMAgQEQAKAAAAANAAMAAwCBARAApQAAAA0AAwADAIEBEACqAAAADQADAAMA" +
            "gQEQAK8AAAANAAMAAwCBARAAtAAAAA0AAwADAIEBEAC5AAAADQADAAMAFgC/ABMAFgDHACIAUCAAAAAAlgjUACoAAQBTIAAAAACWAOMAOgABAAAAAQDsAAkA" +
            "SgABABEASgAGAC4ACwBbAC4AEwBkAAIAAQAAAO4ASwACAAEAAwAEgAAAAAAAAAAAAAAAAAAAAAD5AAAABAAAAAAAAAAAAAAACgCQAAAAAAAAAAAAEgC9AAAA" +
            "ADxNb2R1bGU+AFN5c3RlbS5SdW50aW1lLkNvbXBpbGVyU2VydmljZXMAQ29tcGlsYXRpb25SZWxheGF0aW9uc0F0dHJpYnV0ZQAuY3RvcgBSdW50aW1lQ29t" +
            "cGF0aWJpbGl0eUF0dHJpYnV0ZQBTeXN0ZW0AT2JqZWN0AEN1c3RvbU1vZGlmaWVycy5kbGwAbXNjb3JsaWIATgBSZXFBAE9wdEEAUmVxQgBPcHRCAFJlcUMA" +
            "T3B0QwBHYDEAVABNeUZpZWxkAE15QXJyYXlGaWVsZABnZXRfTXlQcm9wZXJ0eQBNeU1ldGhvZABpAE15UHJvcGVydHkAQ3VzdG9tTW9kaWZpZXJzAAAAAAAD" +
            "IAAAAAAAdw+kpar5mE6tsmb/f1rFDAAEIAEBCAMgAAEIt3pcVhk04IkOBiAgHxwgGB8UIBAfDAgHBh8UHR8MCA8AACAgHxwgGB8UIBAfDAgQAAEBICAfHCAY" +
            "HxQgEB8MCA8IACAgHxwgGB8UIBAfDAgIAQAIAAAAAAAeAQABAFQCFldyYXBOb25FeGNlcHRpb25UaHJvd3MBAAgkAAAAAAAAAAAAAB4kAAAAIAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAQJAAAAAAAAAAAX0NvckRsbE1haW4AbXNjb3JlZS5kbGwAAAAAAP8lACAAEAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAIAAADAAAADA0AAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA=="
        );

        // public static class Lower1 {}
        // public static class Lower2 {}
        // public static class Lower3 {}
        //
        // public static class Middle2 {}
        //
        // public static class Upper3
        // {
        //     public class Upper3a {}
        //     protected class Upper3b {}
        //     internal class Upper3c {}
        //     private class Upper3d {}
        //     protected internal class Upper3e {}
        // }
        public static readonly byte[] s_LowerImage = Convert.FromBase64String(
            "TVqQAAMAAAAEAAAA//8AALgAAAAAAAAAQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAgAAAAA4fug4AtAnNIbgBTM0hVGhpcyBwcm9ncmFt" +
            "IGNhbm5vdCBiZSBydW4gaW4gRE9TIG1vZGUuDQ0KJAAAAAAAAABQRQAATAEDADdyaFsAAAAAAAAAAOAAIiALATAAAAYAAAAGAAAAAAAAQiQAAAAgAAAAQAAA" +
            "AAAAEAAgAAAAAgAABAAAAAAAAAAEAAAAAAAAAACAAAAAAgAAAAAAAAMAQIUAABAAABAAAAAAEAAAEAAAAAAAABAAAAAAAAAAAAAAAPAjAABPAAAAAEAAAJgC" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAGAAAAwAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAIAAACAAAAAAAAAAAAAAA" +
            "CCAAAEgAAAAAAAAAAAAAAC50ZXh0AAAASAQAAAAgAAAABgAAAAIAAAAAAAAAAAAAAAAAACAAAGAucnNyYwAAAJgCAAAAQAAAAAQAAAAIAAAAAAAAAAAAAAAA" +
            "AABAAABALnJlbG9jAAAMAAAAAGAAAAACAAAADAAAAAAAAAAAAAAAAAAAQAAAQgAAAAAAAAAAAAAAAAAAAAAkJAAAAAAAAEgAAAACAAUAXCAAAJQDAAABAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACICKAQAAAoAKgAAAEJTSkIBAAEAAAAAAAwAAAB2NC4wLjMwMzE5" +
            "AAAAAAUAbAAAALABAAAjfgAAHAIAABgBAAAjU3RyaW5ncwAAAAA0AwAABAAAACNVUwA4AwAAEAAAACNHVUlEAAAASAMAAEwAAAAjQmxvYgAAAAAAAAACAAAB" +
            "RxQAAAkCAAAA+gEzABYAAAEAAAAFAAAACwAAAAUAAAAEAAAAAwAAAAEAAAABAAAABQAAAAAAsQABAAAAAAAGAHMA4QAGAJMA4QAGAF8AzgAPAAEBAAAGABAB" +
            "uwAAAAAAJQAAAAAAAQABAIEBEAABAAAAFQABAAEAgQEQABAAAAAVAAEAAQCBARAAHgAAABUAAQABAIEBEAAIAAAAFQABAAEAgQEQABcAAAAVAAEAAQACABAA" +
            "LgAAABUAAQABAAQAEAA2AAAAFQABAAIABQAQAEcAAAAVAAEAAwADABAATwAAABUAAQAEAAcAEABXAAAAFQABAAUAUCAAAAAAhhjIAAYAAQBQIAAAAACGGMgA" +
            "BgABAFAgAAAAAIYYyAAGAAEAUCAAAAAAhhjIAAYAAQBQIAAAAACGGMgABgABAAkAyAABABEAyAAGABkAyAAKACkAyAAGAC4ACwAZAC4AEwAiAC4AGwBBAASA" +
            "AAAAAAAAAAAAAAAAAAAAAMIAAAAEAAAAAAAAAAAAAAAQAD4AAAAAAAcABgAIAAYACQAGAAoABgALAAYAAAAAAABMb3dlcjEATWlkZGxlMgBMb3dlcjIAVXBw" +
            "ZXIzAExvd2VyMwA8TW9kdWxlPgBVcHBlcjNhAFVwcGVyM2IAbXNjb3JsaWIAVXBwZXIzYwBVcHBlcjNkAFVwcGVyM2UARGVidWdnYWJsZUF0dHJpYnV0ZQBD" +
            "b21waWxhdGlvblJlbGF4YXRpb25zQXR0cmlidXRlAFJ1bnRpbWVDb21wYXRpYmlsaXR5QXR0cmlidXRlAExvd2VyLmRsbABTeXN0ZW0ATG93ZXIALmN0b3IA" +
            "U3lzdGVtLkRpYWdub3N0aWNzAFN5c3RlbS5SdW50aW1lLkNvbXBpbGVyU2VydmljZXMARGVidWdnaW5nTW9kZXMAT2JqZWN0AAAAAAAAEq5b2WILYEeeO045" +
            "Dt3Y7QAEIAEBCAMgAAEFIAEBEREIt3pcVhk04IkIAQAIAAAAAAAeAQABAFQCFldyYXBOb25FeGNlcHRpb25UaHJvd3MBCAEABwEAAAAAAAAYJAAAAAAAAAAA" +
            "AAAyJAAAACAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAJCQAAAAAAAAAAAAAAABfQ29yRGxsTWFpbgBtc2NvcmVlLmRsbAAAAAAA/yUAIAAQAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAEAEAAAABgA" +
            "AIAAAAAAAAAAAAAAAAAAAAEAAQAAADAAAIAAAAAAAAAAAAAAAAAAAAEAAAAAAEgAAABYQAAAPAIAAAAAAAAAAAAAPAI0AAAAVgBTAF8AVgBFAFIAUwBJAE8A" +
            "TgBfAEkATgBGAE8AAAAAAL0E7/4AAAEAAAAAAAAAAAAAAAAAAAAAAD8AAAAAAAAABAAAAAIAAAAAAAAAAAAAAAAAAABEAAAAAQBWAGEAcgBGAGkAbABlAEkA" +
            "bgBmAG8AAAAAACQABAAAAFQAcgBhAG4AcwBsAGEAdABpAG8AbgAAAAAAAACwBJwBAAABAFMAdAByAGkAbgBnAEYAaQBsAGUASQBuAGYAbwAAAHgBAAABADAA" +
            "MAAwADAAMAA0AGIAMAAAACwAAgABAEYAaQBsAGUARABlAHMAYwByAGkAcAB0AGkAbwBuAAAAAAAgAAAAMAAIAAEARgBpAGwAZQBWAGUAcgBzAGkAbwBuAAAA" +
            "AAAwAC4AMAAuADAALgAwAAAANAAKAAEASQBuAHQAZQByAG4AYQBsAE4AYQBtAGUAAABMAG8AdwBlAHIALgBkAGwAbAAAACgAAgABAEwAZQBnAGEAbABDAG8A" +
            "cAB5AHIAaQBnAGgAdAAAACAAAAA8AAoAAQBPAHIAaQBnAGkAbgBhAGwARgBpAGwAZQBuAGEAbQBlAAAATABvAHcAZQByAC4AZABsAGwAAAA0AAgAAQBQAHIA" +
            "bwBkAHUAYwB0AFYAZQByAHMAaQBvAG4AAAAwAC4AMAAuADAALgAwAAAAOAAIAAEAQQBzAHMAZQBtAGIAbAB5ACAAVgBlAHIAcwBpAG8AbgAAADAALgAwAC4A" +
            "MAAuADAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAACAAAAwAAABENAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA="
            );

        // using System.Runtime.CompilerServices;
        //
        // [assembly: TypeForwardedTo(typeof(Middle2))]
        //
        // public static class Middle1 {}
        // public static class Middle3 {}
        //
        // public static class Upper2 {}
        public static readonly byte[] s_MiddleImage = Convert.FromBase64String(
            "TVqQAAMAAAAEAAAA//8AALgAAAAAAAAAQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAgAAAAA4fug4AtAnNIbgBTM0hVGhpcyBwcm9ncmFt" +
            "IGNhbm5vdCBiZSBydW4gaW4gRE9TIG1vZGUuDQ0KJAAAAAAAAABQRQAATAEDAPBvaFsAAAAAAAAAAOAAIiALATAAAAQAAAAGAAAAAAAAbiMAAAAgAAAAQAAA" +
            "AAAAEAAgAAAAAgAABAAAAAAAAAAEAAAAAAAAAACAAAAAAgAAAAAAAAMAQIUAABAAABAAAAAAEAAAEAAAAAAAABAAAAAAAAAAAAAAABwjAABPAAAAAEAAAKAC" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAGAAAAwAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAIAAACAAAAAAAAAAAAAAA" +
            "CCAAAEgAAAAAAAAAAAAAAC50ZXh0AAAAdAMAAAAgAAAABAAAAAIAAAAAAAAAAAAAAAAAACAAAGAucnNyYwAAAKACAAAAQAAAAAQAAAAGAAAAAAAAAAAAAAAA" +
            "AABAAABALnJlbG9jAAAMAAAAAGAAAAACAAAACgAAAAAAAAAAAAAAAAAAQAAAQgAAAAAAAAAAAAAAAAAAAABQIwAAAAAAAEgAAAACAAUAUCAAAMwCAAABAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAEJTSkIBAAEAAAAAAAwAAAB2NC4wLjMwMzE5AAAAAAUAbAAAAAwB" +
            "AAAjfgAAeAEAAPQAAAAjU3RyaW5ncwAAAABsAgAABAAAACNVUwBwAgAAEAAAACNHVUlEAAAAgAIAAEwAAAAjQmxvYgAAAAAAAAACAAABBxQAAIkAAAAA+gEz" +
            "ABYAAAEAAAAFAAAABAAAAAMAAAADAAAAAQAAAAIAAAABAAAAAACLAAEAAAAAAAYATQC8AAYAbQC8AAYAOQCpAA8A3AAAAAYA6wCWAAAAAAAgAAAAAAABAAEA" +
            "gQEQAAEAAAAVAAEAAQCBARAAGAAAABUAAQABAIEBEAARAAAAFQABAAEACQCjAAEAEQCjAAYAGQCjAAoALgALABkALgATACIALgAbAEEABIAAAAAAAAAAAAAA" +
            "AAAAAAAAMgAAAAQAAAAAAAAAAAAAABAAKQAAAAAAAAAAAAAAAAAAAAAAAACdAAAAAAAAACAAAAAAAAkAAAAJAAAAAAAATWlkZGxlMQBNaWRkbGUyAFVwcGVy" +
            "MgBNaWRkbGUzADxNb2R1bGU+AG1zY29ybGliAE1pZGRsZQBEZWJ1Z2dhYmxlQXR0cmlidXRlAENvbXBpbGF0aW9uUmVsYXhhdGlvbnNBdHRyaWJ1dGUAUnVu" +
            "dGltZUNvbXBhdGliaWxpdHlBdHRyaWJ1dGUATWlkZGxlLmRsbABTeXN0ZW0ATG93ZXIALmN0b3IAU3lzdGVtLkRpYWdub3N0aWNzAFN5c3RlbS5SdW50aW1l" +
            "LkNvbXBpbGVyU2VydmljZXMARGVidWdnaW5nTW9kZXMAT2JqZWN0AAAAAAAAANnuLM7A21BPqqGbq49MmJwABCABAQgDIAABBSABARERCLd6XFYZNOCJCAEA" +
            "CAAAAAAAHgEAAQBUAhZXcmFwTm9uRXhjZXB0aW9uVGhyb3dzAQgBAAcBAAAAAAAARCMAAAAAAAAAAAAAXiMAAAAgAAAAAAAAAAAAAAAAAAAAAAAAAAAAAFAj" +
            "AAAAAAAAAAAAAAAAX0NvckRsbE1haW4AbXNjb3JlZS5kbGwAAAAAAP8lACAAEAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAABABAAAAAYAACAAAAAAAAAAAAAAAAAAAABAAEAAAAwAACAAAAAAAAAAAAAAAAAAAABAAAAAABIAAAAWEAAAEQCAAAAAAAA" +
            "AAAAAEQCNAAAAFYAUwBfAFYARQBSAFMASQBPAE4AXwBJAE4ARgBPAAAAAAC9BO/+AAABAAAAAAAAAAAAAAAAAAAAAAA/AAAAAAAAAAQAAAACAAAAAAAAAAAA" +
            "AAAAAAAARAAAAAEAVgBhAHIARgBpAGwAZQBJAG4AZgBvAAAAAAAkAAQAAABUAHIAYQBuAHMAbABhAHQAaQBvAG4AAAAAAAAAsASkAQAAAQBTAHQAcgBpAG4A" +
            "ZwBGAGkAbABlAEkAbgBmAG8AAACAAQAAAQAwADAAMAAwADAANABiADAAAAAsAAIAAQBGAGkAbABlAEQAZQBzAGMAcgBpAHAAdABpAG8AbgAAAAAAIAAAADAA" +
            "CAABAEYAaQBsAGUAVgBlAHIAcwBpAG8AbgAAAAAAMAAuADAALgAwAC4AMAAAADYACwABAEkAbgB0AGUAcgBuAGEAbABOAGEAbQBlAAAATQBpAGQAZABsAGUA" +
            "LgBkAGwAbAAAAAAAKAACAAEATABlAGcAYQBsAEMAbwBwAHkAcgBpAGcAaAB0AAAAIAAAAD4ACwABAE8AcgBpAGcAaQBuAGEAbABGAGkAbABlAG4AYQBtAGUA" +
            "AABNAGkAZABkAGwAZQAuAGQAbABsAAAAAAA0AAgAAQBQAHIAbwBkAHUAYwB0AFYAZQByAHMAaQBvAG4AAAAwAC4AMAAuADAALgAwAAAAOAAIAAEAQQBzAHMA" +
            "ZQBtAGIAbAB5ACAAVgBlAHIAcwBpAG8AbgAAADAALgAwAC4AMAAuADAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAgAAAMAAAAcDMAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAA"
            );

        //
        // using System.Runtime.CompilerServices;
        //
        // [assembly: TypeForwardedTo(typeof(Middle2))]
        // [assembly: TypeForwardedTo(typeof(Upper2))]   // <-- Modified by ILDASM/ILASM to typeforward to Middle.dll rather than Lower.dll so that we can test forward chaining
        // [assembly: TypeForwardedTo(typeof(Upper3))]
        //
        // public static class Upper1 {}
        //
        // internal static class Upper4 {}
        //
        // public static class Outer1
        // {
        //     public static class Inner1 {}
        //     protected static class Inner2 {}
        //     internal static class Inner3 {}
        //     private static class Inner4 {}
        //     protected internal static class Inner5 {}
        // }
        //
        // internal static class Outer2
        // {
        //     public static class Inner1 {}
        //     protected static class Inner2 {}
        //     internal static class Inner3 {}
        //     private static class Inner4 {}
        //     protected internal static class Inner5 {}
        // }
        public static readonly byte[] s_UpperImage = Convert.FromBase64String(
            "TVqQAAMAAAAEAAAA//8AALgAAAAAAAAAQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAgAAAAA4fug4AtAnNIbgBTM0hVGhpcyBwcm9ncmFt" +
            "IGNhbm5vdCBiZSBydW4gaW4gRE9TIG1vZGUuDQ0KJAAAAAAAAABQRQAATAECAIJwaFsAAAAAAAAAAOAAAiELAQsAAAYAAAACAAAAAAAAPiQAAAAgAAAAQAAA" +
            "AAAAEAAgAAAAAgAABAAAAAAAAAAEAAAAAAAAAABgAAAAAgAAAAAAAAMAQIUAABAAABAAAAAAEAAAEAAAAAAAABAAAAAAAAAAAAAAAPAjAABLAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAEAAAAwAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAIAAACAAAAAAAAAAAAAAA" +
            "CCAAAEgAAAAAAAAAAAAAAC50ZXh0AAAARAQAAAAgAAAABgAAAAIAAAAAAAAAAAAAAAAAACAAAGAucmVsb2MAAAwAAAAAQAAAAAIAAAAIAAAAAAAAAAAAAAAA" +
            "AABAAABCAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAgJAAAAAAAAEgAAAACAAUAUCAAAKADAAABAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAEJTSkIBAAEAAAAAAAwAAAB2NC4wLjMwMzE5AAAAAAUAbAAAAOgB" +
            "AAAjfgAAVAIAAPgAAAAjU3RyaW5ncwAAAABMAwAACAAAACNVUwBUAwAAEAAAACNHVUlEAAAAZAMAADwAAAAjQmxvYgAAAAAAAAACAAABBxQAAIkCAAAA+iUz" +
            "ABYAAAEAAAADAAAADwAAAAIAAAACAAAAAQAAAAMAAAADAAAACgAAAAAAfAABAAAAAAAGACoACgAGAFAACgAGAHUAbgAAAAAAAQAAAAAAAQABAIEBEACcAAAA" +
            "DQABAAEAgAEQAKMAAAANAAEAAQCBARAAqgAAAA0AAQABAIIBEACxAAAADQABAAEAhAEQALgAAAANAAEAAQCFARAAvwAAAA0AAQABAIMBEADGAAAADQABAAEA" +
            "hwEQAM0AAAANAAEAAQCAARAA1AAAAA0AAQABAIIBEACxAAAADQABAAEAhAEQALgAAAANAAEAAQCFARAAvwAAAA0AAQABAIMBEADGAAAADQABAAEAhwEQAM0A" +
            "AAANAAEAAQAJAEoAAQARAEoABgAuAAsAEwAuABMAHAAEgAAAAAAAAAAAAAAAAAAAAADbAAAABAAAAAAAAAAAAAAACgCGAAAAAAAAAAAAAAAAAAAAAAAAAI8A" +
            "AAAAAAAAAAAAAAAAAAAAAAAAlQAAAAAAAAAgAAAAAADhAAAADQAAACAAAAAAAOkAAAANAAAAIAAAAAAA8AAAAAkABQAEAAYABAAHAAQACAAEAAkABAALAAoA" +
            "DAAKAA0ACgAOAAoADwAKAAAAADxNb2R1bGU+AFN5c3RlbS5SdW50aW1lLkNvbXBpbGVyU2VydmljZXMAQ29tcGlsYXRpb25SZWxheGF0aW9uc0F0dHJpYnV0" +
            "ZQAuY3RvcgBSdW50aW1lQ29tcGF0aWJpbGl0eUF0dHJpYnV0ZQBTeXN0ZW0AT2JqZWN0AFVwcGVyLmRsbABtc2NvcmxpYgBMb3dlcgBNaWRkbGUAVXBwZXIx" +
            "AFVwcGVyNABPdXRlcjEASW5uZXIxAElubmVyMgBJbm5lcjMASW5uZXI0AElubmVyNQBPdXRlcjIAVXBwZXIATWlkZGxlMgBVcHBlcjIAVXBwZXIzAAAAAyAA" +
            "AAAAAEmZFMqHzZZFlfuJUMGM+vwABCABAQgDIAABCLd6XFYZNOCJCAEACAAAAAAAHgEAAQBUAhZXcmFwTm9uRXhjZXB0aW9uVGhyb3dzAQAYJAAAAAAAAAAA" +
            "AAAuJAAAACAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAICQAAAAAAAAAAF9Db3JEbGxNYWluAG1zY29yZWUuZGxsAAAAAAD/JQAgABAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAIAAADAAAAEA0AAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA=="
        );

        // // Metadata version: v4.0.30319
        // .assembly extern mscorlib
        // {
        //   .publickeytoken = (B7 7A 5C 56 19 34 E0 89 )                         // .z\V.4..
        //   .ver 4:0:0:0
        // }
        // .assembly n
        // {
        //   .custom instance void [mscorlib]System.Runtime.CompilerServices.CompilationRelaxationsAttribute::.ctor(int32) = ( 01 00 08 00 00 00 00 00 )
        //   .custom instance void [mscorlib]System.Runtime.CompilerServices.RuntimeCompatibilityAttribute::.ctor() = ( 01 00 01 00 54 02 16 57 72 61 70 4E 6F 6E 45 78   // ....T..WrapNonEx
        //                                                                                                              63 65 70 74 69 6F 6E 54 68 72 6F 77 73 01 )       // ceptionThrows.
        //
        //   // --- The following custom attribute is added automatically, do not uncomment -------
        //   //  .custom instance void [mscorlib]System.Diagnostics.DebuggableAttribute::.ctor(valuetype [mscorlib]System.Diagnostics.DebuggableAttribute/DebuggingModes) = ( 01 00 07 01 00 00 00 00 )
        //
        //   .hash algorithm 0x00008004
        //   .ver 0:0:0:0
        // }
        // .mresource public MyRes1
        // {
        //   // Offset: 0x00000000 Length: 0x00000009
        //   // WARNING: managed resource file MyRes1 created
        // }
        // .mresource public MyRes2
        // {
        //   // Offset: 0x00000010 Length: 0x00000009
        //   // WARNING: managed resource file MyRes2 created
        // }
        // .mresource public MyRes3
        // {
        //   // Offset: 0x00000020 Length: 0x00000009
        //   // WARNING: managed resource file MyRes3 created
        // }
        // .module n.dll
        // // MVID: {25B1E052-807C-4887-9D0E-02C73D0FFC9D}
        // .imagebase 0x10000000
        // .file alignment 0x00000200
        // .stackreserve 0x00100000
        // .subsystem 0x0003       // WINDOWS_CUI
        // .corflags 0x00000001    //  ILONLY
        // // Image base: 0x00000244E70E0000
        public static readonly byte[] s_AssemblyWithEmbeddedResourcesImage = Convert.FromBase64String(
            "TVqQAAMAAAAEAAAA//8AALgAAAAAAAAAQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAgAAAAA4fug4AtAnNIbgBTM0hVGhpcyBwcm9ncmFt" +
            "IGNhbm5vdCBiZSBydW4gaW4gRE9TIG1vZGUuDQ0KJAAAAAAAAABQRQAATAEDAAuhaFsAAAAAAAAAAOAAIiALATAAAAQAAAAGAAAAAAAARiMAAAAgAAAAQAAA" +
            "AAAAEAAgAAAAAgAABAAAAAAAAAAEAAAAAAAAAACAAAAAAgAAAAAAAAMAQIUAABAAABAAAAAAEAAAEAAAAAAAABAAAAAAAAAAAAAAAPQiAABPAAAAAEAAAIgC" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAGAAAAwAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAIAAACAAAAAAAAAAAAAAA" +
            "CCAAAEgAAAAAAAAAAAAAAC50ZXh0AAAATAMAAAAgAAAABAAAAAIAAAAAAAAAAAAAAAAAACAAAGAucnNyYwAAAIgCAAAAQAAAAAQAAAAGAAAAAAAAAAAAAAAA" +
            "AABAAABALnJlbG9jAAAMAAAAAGAAAAACAAAACgAAAAAAAAAAAAAAAAAAQAAAQgAAAAAAAAAAAAAAAAAAAAAoIwAAAAAAAEgAAAACAAUAUCAAAHQCAAABAAAA" +
            "AAAAAMQiAAAwAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAEJTSkIBAAEAAAAAAAwAAAB2NC4wLjMwMzE5AAAAAAUAbAAAANwA" +
            "AAAjfgAASAEAAMwAAAAjU3RyaW5ncwAAAAAUAgAABAAAACNVUwAYAgAAEAAAACNHVUlEAAAAKAIAAEwAAAAjQmxvYgAAAAAAAAACAAABBxQAAAkBAAAA+gEz" +
            "ABYAAAEAAAAEAAAAAQAAAAMAAAADAAAAAQAAAAEAAAADAAAAAAB6AAEAAAAAAAYAPACbAAYAXACbAAYAKACIAA8AuwAAAAAAAAAWAAAAAAABAAEACQCCAAEA" +
            "EQCCAAYAGQCCAAoALgALABkALgATACIALgAbAEEABIAAAAAAAAAAAAAAAAAAAAAAgAAAAAQAAAAAAAAAAAAAABAAHwAAAAAAAAAAAAEAAAABAAAAEAAAAAEA" +
            "AAAIAAAAIAAAAAEAAAAPAAAAAAAATXlSZXMxAE15UmVzMgBNeVJlczMAPE1vZHVsZT4AbXNjb3JsaWIARGVidWdnYWJsZUF0dHJpYnV0ZQBDb21waWxhdGlv" +
            "blJlbGF4YXRpb25zQXR0cmlidXRlAFJ1bnRpbWVDb21wYXRpYmlsaXR5QXR0cmlidXRlAG4uZGxsAG4ALmN0b3IAU3lzdGVtLkRpYWdub3N0aWNzAFN5c3Rl" +
            "bS5SdW50aW1lLkNvbXBpbGVyU2VydmljZXMARGVidWdnaW5nTW9kZXMAAAAAAAAAUuCxJXyAh0idDgLHPQ/8nQAEIAEBCAMgAAEFIAEBEREIt3pcVhk04IkI" +
            "AQAIAAAAAAAeAQABAFQCFldyYXBOb25FeGNlcHRpb25UaHJvd3MBCAEABwEAAAAAAAAJAAAASGVsbG8NCg0KAAAACQAAAFRoZXJlDQoNCgAAAAkAAABNb3Ju" +
            "aW5nDQoAAAAcIwAAAAAAAAAAAAA2IwAAACAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAKCMAAAAAAAAAAAAAAABfQ29yRGxsTWFpbgBtc2NvcmVlLmRsbAAAAAAA" +
            "/yUAIAAQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAABABAAAAAYAACAAAAAAAAAAAAAAAAAAAABAAEAAAAwAACAAAAAAAAAAAAAAAAAAAABAAAAAABIAAAAWEAAACwCAAAAAAAA" +
            "AAAAACwCNAAAAFYAUwBfAFYARQBSAFMASQBPAE4AXwBJAE4ARgBPAAAAAAC9BO/+AAABAAAAAAAAAAAAAAAAAAAAAAA/AAAAAAAAAAQAAAACAAAAAAAAAAAA" +
            "AAAAAAAARAAAAAEAVgBhAHIARgBpAGwAZQBJAG4AZgBvAAAAAAAkAAQAAABUAHIAYQBuAHMAbABhAHQAaQBvAG4AAAAAAAAAsASMAQAAAQBTAHQAcgBpAG4A" +
            "ZwBGAGkAbABlAEkAbgBmAG8AAABoAQAAAQAwADAAMAAwADAANABiADAAAAAsAAIAAQBGAGkAbABlAEQAZQBzAGMAcgBpAHAAdABpAG8AbgAAAAAAIAAAADAA" +
            "CAABAEYAaQBsAGUAVgBlAHIAcwBpAG8AbgAAAAAAMAAuADAALgAwAC4AMAAAACwABgABAEkAbgB0AGUAcgBuAGEAbABOAGEAbQBlAAAAbgAuAGQAbABsAAAA" +
            "KAACAAEATABlAGcAYQBsAEMAbwBwAHkAcgBpAGcAaAB0AAAAIAAAADQABgABAE8AcgBpAGcAaQBuAGEAbABGAGkAbABlAG4AYQBtAGUAAABuAC4AZABsAGwA" +
            "AAA0AAgAAQBQAHIAbwBkAHUAYwB0AFYAZQByAHMAaQBvAG4AAAAwAC4AMAAuADAALgAwAAAAOAAIAAEAQQBzAHMAZQBtAGIAbAB5ACAAVgBlAHIAcwBpAG8A" +
            "bgAAADAALgAwAC4AMAAuADAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAgAAAMAAAASDMAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAA"
        );

        // // Metadata version: v4.0.30319
        // .assembly extern mscorlib
        // {
        //   .publickeytoken = (B7 7A 5C 56 19 34 E0 89 )                         // .z\V.4..
        //   .ver 4:0:0:0
        // }
        // .assembly n
        // {
        //   .custom instance void [mscorlib]System.Runtime.CompilerServices.CompilationRelaxationsAttribute::.ctor(int32) = ( 01 00 08 00 00 00 00 00 )
        //   .custom instance void [mscorlib]System.Runtime.CompilerServices.RuntimeCompatibilityAttribute::.ctor() = ( 01 00 01 00 54 02 16 57 72 61 70 4E 6F 6E 45 78   // ....T..WrapNonEx
        //                                                                                                              63 65 70 74 69 6F 6E 54 68 72 6F 77 73 01 )       // ceptionThrows.
        //
        //   // --- The following custom attribute is added automatically, do not uncomment -------
        //   //  .custom instance void [mscorlib]System.Diagnostics.DebuggableAttribute::.ctor(valuetype [mscorlib]System.Diagnostics.DebuggableAttribute/DebuggingModes) = ( 01 00 07 01 00 00 00 00 )
        //
        //   .hash algorithm 0x00008004
        //   .ver 0:0:0:0
        // }
        // .file nometadata MyRes1
        //     .hash = (0B 0C 4B 52 C9 FB D2 6C 00 63 9F 22 0F 39 97 7D   // ..KR...l.c.".9.}
        //              CC 6F F6 D2 )                                     // .o..
        // .file nometadata MyRes2
        //     .hash = (A0 4F 98 36 2B 4B 70 CB 09 CB FC D4 A9 73 F5 F0   // .O.6+Kp......s..
        //              96 39 0A 59 )                                     // .9.Y
        // .file nometadata MyRes3
        //     .hash = (6D AC 24 B4 16 23 8F 87 E8 A1 9C 92 13 72 CF BD   // m.$..#.......r..
        //              D3 08 81 51 )                                     // ...Q
        // .mresource public MyRes1
        // {
        //   .file MyRes1 at 0x00000000
        // }
        // .mresource public MyRes2
        // {
        //   .file MyRes2 at 0x00000000
        // }
        // .mresource public MyRes3
        // {
        //   .file MyRes3 at 0x00000000
        // }
        // .module n.dll
        // // MVID: {C097EB74-2B57-4657-B0B9-680781ACA1D6}
        // .imagebase 0x10000000
        // .file alignment 0x00000200
        // .stackreserve 0x00100000
        // .subsystem 0x0003       // WINDOWS_CUI
        // .corflags 0x00000001    //  ILONLY
        // // Image base: 0x00000131E4630000
        public static readonly byte[] s_AssemblyWithResourcesInManifestFilesImage = Convert.FromBase64String(
            "TVqQAAMAAAAEAAAA//8AALgAAAAAAAAAQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAgAAAAA4fug4AtAnNIbgBTM0hVGhpcyBwcm9ncmFt" +
            "IGNhbm5vdCBiZSBydW4gaW4gRE9TIG1vZGUuDQ0KJAAAAAAAAABQRQAATAEDAMGkaFsAAAAAAAAAAOAAIiALATAAAAQAAAAGAAAAAAAAciMAAAAgAAAAQAAA" +
            "AAAAEAAgAAAAAgAABAAAAAAAAAAEAAAAAAAAAACAAAAAAgAAAAAAAAMAQIUAABAAABAAAAAAEAAAEAAAAAAAABAAAAAAAAAAAAAAACAjAABPAAAAAEAAAIgC" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAGAAAAwAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAIAAACAAAAAAAAAAAAAAA" +
            "CCAAAEgAAAAAAAAAAAAAAC50ZXh0AAAAeAMAAAAgAAAABAAAAAIAAAAAAAAAAAAAAAAAACAAAGAucnNyYwAAAIgCAAAAQAAAAAQAAAAGAAAAAAAAAAAAAAAA" +
            "AABAAABALnJlbG9jAAAMAAAAAGAAAAACAAAACgAAAAAAAAAAAAAAAAAAQAAAQgAAAAAAAAAAAAAAAAAAAABUIwAAAAAAAEgAAAACAAUAUCAAANACAAABAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAEJTSkIBAAEAAAAAAAwAAAB2NC4wLjMwMzE5AAAAAAUAbAAAAPgA" +
            "AAAjfgAAZAEAAMwAAAAjU3RyaW5ncwAAAAAwAgAABAAAACNVUwA0AgAAEAAAACNHVUlEAAAARAIAAIwAAAAjQmxvYgAAAAAAAAACAAABBxQAAEkBAAAA+gEz" +
            "ABYAAAEAAAAEAAAAAQAAAAMAAAADAAAAAQAAAAEAAAADAAAAAwAAAAAAegABAAAAAAAGADwAmwAGAFwAmwAGACgAiAAPALsAAAAAAAAAFgAAAAAAAQABAAkA" +
            "ggABABEAggAGABkAggAKAC4ACwBYAC4AEwBhAC4AGwCAAASAAAAAAAAAAAAAAAAAAAAAAIAAAAAEAAAAAAAAAAAAAAAQAB8AAAAAAAEAAAABABkAAQAAAAgA" +
            "LgABAAAADwBDAAAAAAABAAAAAQAEAAAAAAABAAAACAAIAAAAAAABAAAADwAMAAAAAE15UmVzMQBNeVJlczIATXlSZXMzADxNb2R1bGU+AG1zY29ybGliAERl" +
            "YnVnZ2FibGVBdHRyaWJ1dGUAQ29tcGlsYXRpb25SZWxheGF0aW9uc0F0dHJpYnV0ZQBSdW50aW1lQ29tcGF0aWJpbGl0eUF0dHJpYnV0ZQBuLmRsbABuAC5j" +
            "dG9yAFN5c3RlbS5EaWFnbm9zdGljcwBTeXN0ZW0uUnVudGltZS5Db21waWxlclNlcnZpY2VzAERlYnVnZ2luZ01vZGVzAAAAAAAAAHTrl8BXK1dGsLloB4Gs" +
            "odYABCABAQgDIAABBSABARERCLd6XFYZNOCJFAsMS1LJ+9JsAGOfIg85l33Mb/bSFKBPmDYrS3DLCcv81Klz9fCWOQpZFG2sJLQWI4+H6KGckhNyz73TCIFR" +
            "CAEACAAAAAAAHgEAAQBUAhZXcmFwTm9uRXhjZXB0aW9uVGhyb3dzAQgBAAcBAAAAAAAAAEgjAAAAAAAAAAAAAGIjAAAAIAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AABUIwAAAAAAAAAAAAAAAF9Db3JEbGxNYWluAG1zY29yZWUuZGxsAAAAAAD/JQAgABAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAABABAAAAAYAACAAAAAAAAAAAAAAAAAAAABAAEAAAAwAACAAAAAAAAAAAAAAAAAAAABAAAAAABIAAAAWEAAACwCAAAAAAAA" +
            "AAAAACwCNAAAAFYAUwBfAFYARQBSAFMASQBPAE4AXwBJAE4ARgBPAAAAAAC9BO/+AAABAAAAAAAAAAAAAAAAAAAAAAA/AAAAAAAAAAQAAAACAAAAAAAAAAAA" +
            "AAAAAAAARAAAAAEAVgBhAHIARgBpAGwAZQBJAG4AZgBvAAAAAAAkAAQAAABUAHIAYQBuAHMAbABhAHQAaQBvAG4AAAAAAAAAsASMAQAAAQBTAHQAcgBpAG4A" +
            "ZwBGAGkAbABlAEkAbgBmAG8AAABoAQAAAQAwADAAMAAwADAANABiADAAAAAsAAIAAQBGAGkAbABlAEQAZQBzAGMAcgBpAHAAdABpAG8AbgAAAAAAIAAAADAA" +
            "CAABAEYAaQBsAGUAVgBlAHIAcwBpAG8AbgAAAAAAMAAuADAALgAwAC4AMAAAACwABgABAEkAbgB0AGUAcgBuAGEAbABOAGEAbQBlAAAAbgAuAGQAbABsAAAA" +
            "KAACAAEATABlAGcAYQBsAEMAbwBwAHkAcgBpAGcAaAB0AAAAIAAAADQABgABAE8AcgBpAGcAaQBuAGEAbABGAGkAbABlAG4AYQBtAGUAAABuAC4AZABsAGwA" +
            "AAA0AAgAAQBQAHIAbwBkAHUAYwB0AFYAZQByAHMAaQBvAG4AAAAwAC4AMAAuADAALgAwAAAAOAAIAAEAQQBzAHMAZQBtAGIAbAB5ACAAVgBlAHIAcwBpAG8A" +
            "bgAAADAALgAwAC4AMAAuADAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAgAAAMAAAAdDMAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAA"
        );

        // .module extern a.netmodule
        // .assembly extern mscorlib
        // {
        //   .publickeytoken = (B7 7A 5C 56 19 34 E0 89 )                         // .z\V.4..
        //   .ver 4:0:0:0
        // }
        // .assembly n
        // {
        //   .custom instance void [mscorlib]System.Runtime.CompilerServices.CompilationRelaxationsAttribute::.ctor(int32) = ( 01 00 08 00 00 00 00 00 )
        //   .custom instance void [mscorlib]System.Runtime.CompilerServices.RuntimeCompatibilityAttribute::.ctor() = ( 01 00 01 00 54 02 16 57 72 61 70 4E 6F 6E 45 78   // ....T..WrapNonEx
        //                                                                                                              63 65 70 74 69 6F 6E 54 68 72 6F 77 73 01 )       // ceptionThrows.
        //
        //   // --- The following custom attribute is added automatically, do not uncomment -------
        //   //  .custom instance void [mscorlib]System.Diagnostics.DebuggableAttribute::.ctor(valuetype [mscorlib]System.Diagnostics.DebuggableAttribute/DebuggingModes) = ( 01 00 07 01 00 00 00 00 )
        //
        //   .hash algorithm 0x00008004
        //   .ver 0:0:0:0
        // }
        // .file a.netmodule
        //     .hash = (9B C4 70 ED 81 23 FE 75 51 8A 07 99 F2 4A 2F E3   // ..p..#.uQ....J/.
        //              56 A0 E9 22 )                                     // V.."
        // .class extern public A
        // {
        //   .file a.netmodule
        //   .class 0x02000002
        // }
        // .mresource public MyRes1
        // {
        //   .file a.netmodule at 0x00000000
        // }
        // .mresource public MyRes2
        // {
        //   .file a.netmodule at 0x00000010
        // }
        // .mresource public MyRes3
        // {
        //   .file a.netmodule at 0x00000020
        // }
        // .module n.dll
        // // MVID: {9A7E4854-D91C-42AD-8745-0F37D9A306F9}
        // .imagebase 0x10000000
        // .file alignment 0x00000200
        // .stackreserve 0x00100000
        // .subsystem 0x0003       // WINDOWS_CUI
        // .corflags 0x00000001    //  ILONLY
        // // Image base: 0x000001D822FD0000
        //
        //
        // // =============== CLASS MEMBERS DECLARATION ===================
        //
        // .class public auto ansi beforefieldinit N
        //        extends [.module a.netmodule]A
        // {
        //   .method public hidebysig specialname rtspecialname
        //           instance void  .ctor() cil managed
        //   {
        //     // Code size       8 (0x8)
        //     .maxstack  8
        //     IL_0000:  ldarg.0
        //     IL_0001:  call       instance void [.module a.netmodule]A::.ctor()
        //     IL_0006:  nop
        //     IL_0007:  ret
        //   } // end of method N::.ctor
        //
        // } // end of class N
        //
        public static readonly byte[] s_AssemblyWithResourcesInModuleImage = Convert.FromBase64String(
            "TVqQAAMAAAAEAAAA//8AALgAAAAAAAAAQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAgAAAAA4fug4AtAnNIbgBTM0hVGhpcyBwcm9ncmFt" +
            "IGNhbm5vdCBiZSBydW4gaW4gRE9TIG1vZGUuDQ0KJAAAAAAAAABQRQAATAEDADXjaFsAAAAAAAAAAOAAIiALATAAAAQAAAAGAAAAAAAAliMAAAAgAAAAQAAA" +
            "AAAAEAAgAAAAAgAABAAAAAAAAAAEAAAAAAAAAACAAAAAAgAAAAAAAAMAQIUAABAAABAAAAAAEAAAEAAAAAAAABAAAAAAAAAAAAAAAEQjAABPAAAAAEAAAIgC" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAGAAAAwAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAIAAACAAAAAAAAAAAAAAA" +
            "CCAAAEgAAAAAAAAAAAAAAC50ZXh0AAAAnAMAAAAgAAAABAAAAAIAAAAAAAAAAAAAAAAAACAAAGAucnNyYwAAAIgCAAAAQAAAAAQAAAAGAAAAAAAAAAAAAAAA" +
            "AABAAABALnJlbG9jAAAMAAAAAGAAAAACAAAACgAAAAAAAAAAAAAAAAAAQAAAQgAAAAAAAAAAAAAAAAAAAAB4IwAAAAAAAEgAAAACAAUAXCAAAOgCAAABAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACICKAQAAAoAKgAAAEJTSkIBAAEAAAAAAAwAAAB2NC4wLjMwMzE5" +
            "AAAAAAUAbAAAACwBAAAjfgAAmAEAANwAAAAjU3RyaW5ncwAAAAB0AgAABAAAACNVUwB4AgAAEAAAACNHVUlEAAAAiAIAAGAAAAAjQmxvYgAAAAAAAAACAAAB" +
            "RxQABMkBAAAA+gEzABYAAAEAAAAFAAAAAgAAAAEAAAAEAAAAAwAAAAEAAAABAAAAAQAAAAEAAAABAAAAAwAAAAAAigABAAAAAAAGAEwAqwAGAGwAqwAGADgA" +
            "mAAPAMsAAAAFAB8AAAAAAAAAFgAAAAAAAQABAAEAEAAhAAAAFQABAAEAUCAAAAAAhhiSAAYAAQAJAJIAAQARAJIABgAZAJIACgApAJIABgAuAAsALgAuABMA" +
            "NwAuABsAVgAsAASAAAAAAAAAAAAAAAAAAAAAAJAAAAAEAAAAAAAAAAAAAAAQACMAAAAAAAAAAAAsABkAAQAAAAIAAAIfAAAABAAAAAAAAQAAAAEABAAQAAAA" +
            "AQAAAAgABAAgAAAAAQAAAA8ABAAAAABNeVJlczEATXlSZXMyAE15UmVzMwA8TW9kdWxlPgBBAE4AbXNjb3JsaWIAYS5uZXRtb2R1bGUARGVidWdnYWJsZUF0" +
            "dHJpYnV0ZQBDb21waWxhdGlvblJlbGF4YXRpb25zQXR0cmlidXRlAFJ1bnRpbWVDb21wYXRpYmlsaXR5QXR0cmlidXRlAG4uZGxsAG4ALmN0b3IAU3lzdGVt" +
            "LkRpYWdub3N0aWNzAFN5c3RlbS5SdW50aW1lLkNvbXBpbGVyU2VydmljZXMARGVidWdnaW5nTW9kZXMAAAAAAAAAVEh+mhzZrUKHRQ832aMG+QAEIAEBCAMg" +
            "AAEFIAEBEREIt3pcVhk04IkUm8Rw7YEj/nVRigeZ8kov41ag6SIIAQAIAAAAAAAeAQABAFQCFldyYXBOb25FeGNlcHRpb25UaHJvd3MBCAEABwEAAAAAAGwj" +
            "AAAAAAAAAAAAAIYjAAAAIAAAAAAAAAAAAAAAAAAAAAAAAAAAAAB4IwAAAAAAAAAAAAAAAF9Db3JEbGxNYWluAG1zY29yZWUuZGxsAAAAAAD/JQAgABAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAABABAAAAAYAACAAAAAAAAAAAAAAAAAAAABAAEAAAAwAACAAAAAAAAAAAAAAAAAAAABAAAAAABIAAAAWEAAACwCAAAAAAAA" +
            "AAAAACwCNAAAAFYAUwBfAFYARQBSAFMASQBPAE4AXwBJAE4ARgBPAAAAAAC9BO/+AAABAAAAAAAAAAAAAAAAAAAAAAA/AAAAAAAAAAQAAAACAAAAAAAAAAAA" +
            "AAAAAAAARAAAAAEAVgBhAHIARgBpAGwAZQBJAG4AZgBvAAAAAAAkAAQAAABUAHIAYQBuAHMAbABhAHQAaQBvAG4AAAAAAAAAsASMAQAAAQBTAHQAcgBpAG4A" +
            "ZwBGAGkAbABlAEkAbgBmAG8AAABoAQAAAQAwADAAMAAwADAANABiADAAAAAsAAIAAQBGAGkAbABlAEQAZQBzAGMAcgBpAHAAdABpAG8AbgAAAAAAIAAAADAA" +
            "CAABAEYAaQBsAGUAVgBlAHIAcwBpAG8AbgAAAAAAMAAuADAALgAwAC4AMAAAACwABgABAEkAbgB0AGUAcgBuAGEAbABOAGEAbQBlAAAAbgAuAGQAbABsAAAA" +
            "KAACAAEATABlAGcAYQBsAEMAbwBwAHkAcgBpAGcAaAB0AAAAIAAAADQABgABAE8AcgBpAGcAaQBuAGEAbABGAGkAbABlAG4AYQBtAGUAAABuAC4AZABsAGwA" +
            "AAA0AAgAAQBQAHIAbwBkAHUAYwB0AFYAZQByAHMAaQBvAG4AAAAwAC4AMAAuADAALgAwAAAAOAAIAAEAQQBzAHMAZQBtAGIAbAB5ACAAVgBlAHIAcwBpAG8A" +
            "bgAAADAALgAwAC4AMAAuADAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAgAAAMAAAAmDMAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAA"
        );

        //
        // // Metadata version: v4.0.30319
        // .assembly extern mscorlib
        // {
        //   .publickeytoken = (B7 7A 5C 56 19 34 E0 89 )                         // .z\V.4..
        //   .ver 4:0:0:0
        // }
        // .mresource public MyRes1
        // {
        //   // Offset: 0x00000000 Length: 0x00000009
        //   // WARNING: managed resource file MyRes1 created
        // }
        // .mresource public MyRes2
        // {
        //   // Offset: 0x00000010 Length: 0x00000009
        //   // WARNING: managed resource file MyRes2 created
        // }
        // .mresource public MyRes3
        // {
        //   // Offset: 0x00000020 Length: 0x00000009
        //   // WARNING: managed resource file MyRes3 created
        // }
        // .module a.netmodule
        // // MVID: {2783611B-BCBF-43E2-8420-6C54E102D6A5}
        // .imagebase 0x10000000
        // .file alignment 0x00000200
        // .stackreserve 0x00100000
        // .subsystem 0x0003       // WINDOWS_CUI
        // .corflags 0x00000001    //  ILONLY
        // // Image base: 0x0000021F5E0B0000
        //
        //
        // // =============== CLASS MEMBERS DECLARATION ===================
        //
        // .class public auto ansi beforefieldinit A
        //        extends [mscorlib]System.Object
        // {
        //   .method public hidebysig specialname rtspecialname
        //           instance void  .ctor() cil managed
        //   {
        //     // Code size       8 (0x8)
        //     .maxstack  8
        //     IL_0000:  ldarg.0
        //     IL_0001:  call       instance void [mscorlib]System.Object::.ctor()
        //     IL_0006:  nop
        //     IL_0007:  ret
        //   } // end of method A::.ctor
        //
        // } // end of class A
        //
        public static readonly byte[] s_ModuleForAssemblyWithResourcesInModuleImage = Convert.FromBase64String(
            "TVqQAAMAAAAEAAAA//8AALgAAAAAAAAAQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAgAAAAA4fug4AtAnNIbgBTM0hVGhpcyBwcm9ncmFt" +
            "IGNhbm5vdCBiZSBydW4gaW4gRE9TIG1vZGUuDQ0KJAAAAAAAAABQRQAATAEDACbjaFsAAAAAAAAAAOAAIiALATAAAAQAAAAGAAAAAAAAaiIAAAAgAAAAQAAA" +
            "AAAAEAAgAAAAAgAABAAAAAAAAAAEAAAAAAAAAACAAAAAAgAAAAAAAAMAQIUAABAAABAAAAAAEAAAEAAAAAAAABAAAAAAAAAAAAAAABgiAABPAAAAAEAAAKAC" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAGAAAAwAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAIAAACAAAAAAAAAAAAAAA" +
            "CCAAAEgAAAAAAAAAAAAAAC50ZXh0AAAAcAIAAAAgAAAABAAAAAIAAAAAAAAAAAAAAAAAACAAAGAucnNyYwAAAKACAAAAQAAAAAQAAAAGAAAAAAAAAAAAAAAA" +
            "AABAAABALnJlbG9jAAAMAAAAAGAAAAACAAAACgAAAAAAAAAAAAAAAAAAQAAAQgAAAAAAAAAAAAAAAAAAAABMIgAAAAAAAEgAAAACAAUAXCAAAIwBAAABAAAA" +
            "AAAAAOghAAAwAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACICKAEAAAoAKgAAAEJTSkIBAAEAAAAAAAwAAAB2NC4wLjMwMzE5" +
            "AAAAAAUAbAAAALAAAAAjfgAAHAEAAEwAAAAjU3RyaW5ncwAAAABoAQAABAAAACNVUwBsAQAAEAAAACNHVUlEAAAAfAEAABAAAAAjQmxvYgAAAAAAAAACAAAB" +
            "RwQAAAgBAAAA+gEzABYAAAEAAAABAAAAAgAAAAEAAAABAAAAAQAAAAMAAAAAACoAAQAAAAAABgBDADYAAAAAABYAAAAAAAEAAQABABAAHwAAAAUAAQABAFAg" +
            "AAAAAIYYPQABAAEACQA9AAEABAAAAAAAAAAAAAAABQAhAAAAAAAAAAAAAQAAAAEAAAAQAAAAAQAAAAgAAAAgAAAAAQAAAA8AAAAAAAAAAE15UmVzMQBNeVJl" +
            "czIATXlSZXMzADxNb2R1bGU+AEEAbXNjb3JsaWIAYS5uZXRtb2R1bGUAU3lzdGVtAC5jdG9yAE9iamVjdAAAAAAAAAAbYYMnv7ziQ4QgbFThAtalAAMgAAEI" +
            "t3pcVhk04IkAAAkAAABIZWxsbw0KDQoAAAAJAAAAVGhlcmUNCg0KAAAACQAAAE1vcm5pbmcNCgAAAEAiAAAAAAAAAAAAAFoiAAAAIAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAABMIgAAAAAAAAAAAAAAAF9Db3JEbGxNYWluAG1zY29yZWUuZGxsAAAAAAD/JQAgABAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAABABAAAAAYAACAAAAAAAAAAAAAAAAAAAABAAEAAAAwAACAAAAAAAAAAAAAAAAAAAABAAAAAABIAAAAWEAAAEQCAAAAAAAA" +
            "AAAAAEQCNAAAAFYAUwBfAFYARQBSAFMASQBPAE4AXwBJAE4ARgBPAAAAAAC9BO/+AAABAAAAAAAAAAAAAAAAAAAAAAA/AAAAAAAAAAQAAAACAAAAAAAAAAAA" +
            "AAAAAAAARAAAAAEAVgBhAHIARgBpAGwAZQBJAG4AZgBvAAAAAAAkAAQAAABUAHIAYQBuAHMAbABhAHQAaQBvAG4AAAAAAAAAsASkAQAAAQBTAHQAcgBpAG4A" +
            "ZwBGAGkAbABlAEkAbgBmAG8AAACAAQAAAQAwADAAMAAwADAANABiADAAAAAsAAIAAQBGAGkAbABlAEQAZQBzAGMAcgBpAHAAdABpAG8AbgAAAAAAIAAAADAA" +
            "CAABAEYAaQBsAGUAVgBlAHIAcwBpAG8AbgAAAAAAMAAuADAALgAwAC4AMAAAADgADAABAEkAbgB0AGUAcgBuAGEAbABOAGEAbQBlAAAAYQAuAG4AZQB0AG0A" +
            "bwBkAHUAbABlAAAAKAACAAEATABlAGcAYQBsAEMAbwBwAHkAcgBpAGcAaAB0AAAAIAAAAEAADAABAE8AcgBpAGcAaQBuAGEAbABGAGkAbABlAG4AYQBtAGUA" +
            "AABhAC4AbgBlAHQAbQBvAGQAdQBsAGUAAAA0AAgAAQBQAHIAbwBkAHUAYwB0AFYAZQByAHMAaQBvAG4AAAAwAC4AMAAuADAALgAwAAAAOAAIAAEAQQBzAHMA" +
            "ZQBtAGIAbAB5ACAAVgBlAHIAcwBpAG8AbgAAADAALgAwAC4AMAAuADAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAgAAAMAAAAbDIAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAA"
        );

        public static byte[] s_MyRes1 = Convert.FromBase64String("SGVsbG8NCg0K");
        public static byte[] s_MyRes2 = Convert.FromBase64String("VGhlcmUNCg0K");
        public static byte[] s_MyRes3 = Convert.FromBase64String("TW9ybmluZw0K");

        // public class Base1 {}
        // public class Base2 {}
        // public class Base3 {}
        // public class Base4 {}
        // public class Base5 {}
        // public class Base6 {}
        // public class Base7 {}
        // public class Base8 {}
        // public class Base9 {}
        public static readonly byte[] s_BaseClassesImage = Convert.FromBase64String(
            "TVqQAAMAAAAEAAAA//8AALgAAAAAAAAAQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAgAAAAA4fug4AtAnNIbgBTM0hVGhpcyBwcm9ncmFt" +
            "IGNhbm5vdCBiZSBydW4gaW4gRE9TIG1vZGUuDQ0KJAAAAAAAAABQRQAATAEDAE4MaVsAAAAAAAAAAOAAIiALATAAAAYAAAAGAAAAAAAAOiQAAAAgAAAAQAAA" +
            "AAAAEAAgAAAAAgAABAAAAAAAAAAEAAAAAAAAAACAAAAAAgAAAAAAAAMAQIUAABAAABAAAAAAEAAAEAAAAAAAABAAAAAAAAAAAAAAAOgjAABPAAAAAEAAAJgC" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAGAAAAwAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAIAAACAAAAAAAAAAAAAAA" +
            "CCAAAEgAAAAAAAAAAAAAAC50ZXh0AAAAQAQAAAAgAAAABgAAAAIAAAAAAAAAAAAAAAAAACAAAGAucnNyYwAAAJgCAAAAQAAAAAQAAAAIAAAAAAAAAAAAAAAA" +
            "AABAAABALnJlbG9jAAAMAAAAAGAAAAACAAAADAAAAAAAAAAAAAAAAAAAQAAAQgAAAAAAAAAAAAAAAAAAAAAcJAAAAAAAAEgAAAACAAUAXCAAAIwDAAABAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACICKAQAAAoAKgAAAEJTSkIBAAEAAAAAAAwAAAB2NC4wLjMwMzE5" +
            "AAAAAAUAbAAAAMABAAAjfgAALAIAAAABAAAjU3RyaW5ncwAAAAAsAwAABAAAACNVUwAwAwAAEAAAACNHVUlEAAAAQAMAAEwAAAAjQmxvYgAAAAAAAAACAAAB" +
            "RxQAAAkAAAAA+gEzABYAAAEAAAAFAAAACgAAAAkAAAAEAAAAAwAAAAEAAAABAAAAAACgAAEAAAAAAAYAYgDJAAYAggDJAAYATgC2AA8A6QAAAAYA+ACpAAAA" +
            "AAA3AAAAAAABAAEAAQAQAAEAAAAVAAEAAQABABAABwAAABUAAQACAAEAEAANAAAAFQABAAMAAQAQABMAAAAVAAEABAABABAAGQAAABUAAQAFAAEAEAAfAAAA" +
            "FQABAAYAAQAQACUAAAAVAAEABwABABAAKwAAABUAAQAIAAEAEAAxAAAAFQABAAkAUCAAAAAAhhiwAAYAAQBQIAAAAACGGLAABgABAFAgAAAAAIYYsAAGAAEA" +
            "UCAAAAAAhhiwAAYAAQBQIAAAAACGGLAABgABAFAgAAAAAIYYsAAGAAEAUCAAAAAAhhiwAAYAAQBQIAAAAACGGLAABgABAFAgAAAAAIYYsAAGAAEACQCwAAEA" +
            "EQCwAAYAGQCwAAoAKQCwAAYALgALABkALgATACIALgAbAEEABIAAAAAAAAAAAAAAAAAAAAAASQAAAAQAAAAAAAAAAAAAABAAQAAAAAAAAAAAQmFzZTEAQmFz" +
            "ZTIAQmFzZTMAQmFzZTQAQmFzZTUAQmFzZTYAQmFzZTcAQmFzZTgAQmFzZTkAPE1vZHVsZT4AbXNjb3JsaWIAQmFzZQBEZWJ1Z2dhYmxlQXR0cmlidXRlAENv" +
            "bXBpbGF0aW9uUmVsYXhhdGlvbnNBdHRyaWJ1dGUAUnVudGltZUNvbXBhdGliaWxpdHlBdHRyaWJ1dGUAQmFzZS5kbGwAU3lzdGVtAC5jdG9yAFN5c3RlbS5E" +
            "aWFnbm9zdGljcwBTeXN0ZW0uUnVudGltZS5Db21waWxlclNlcnZpY2VzAERlYnVnZ2luZ01vZGVzAE9iamVjdAAAAAAAANDOsbff9aVMp54uTMWNxRgABCAB" +
            "AQgDIAABBSABARERCLd6XFYZNOCJCAEACAAAAAAAHgEAAQBUAhZXcmFwTm9uRXhjZXB0aW9uVGhyb3dzAQgBAAcBAAAAAAAAECQAAAAAAAAAAAAAKiQAAAAg" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAABwkAAAAAAAAAAAAAAAAX0NvckRsbE1haW4AbXNjb3JlZS5kbGwAAAAAAP8lACAAEAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAEAEAAAABgA" +
            "AIAAAAAAAAAAAAAAAAAAAAEAAQAAADAAAIAAAAAAAAAAAAAAAAAAAAEAAAAAAEgAAABYQAAAPAIAAAAAAAAAAAAAPAI0AAAAVgBTAF8AVgBFAFIAUwBJAE8A" +
            "TgBfAEkATgBGAE8AAAAAAL0E7/4AAAEAAAAAAAAAAAAAAAAAAAAAAD8AAAAAAAAABAAAAAIAAAAAAAAAAAAAAAAAAABEAAAAAQBWAGEAcgBGAGkAbABlAEkA" +
            "bgBmAG8AAAAAACQABAAAAFQAcgBhAG4AcwBsAGEAdABpAG8AbgAAAAAAAACwBJwBAAABAFMAdAByAGkAbgBnAEYAaQBsAGUASQBuAGYAbwAAAHgBAAABADAA" +
            "MAAwADAAMAA0AGIAMAAAACwAAgABAEYAaQBsAGUARABlAHMAYwByAGkAcAB0AGkAbwBuAAAAAAAgAAAAMAAIAAEARgBpAGwAZQBWAGUAcgBzAGkAbwBuAAAA" +
            "AAAwAC4AMAAuADAALgAwAAAAMgAJAAEASQBuAHQAZQByAG4AYQBsAE4AYQBtAGUAAABCAGEAcwBlAC4AZABsAGwAAAAAACgAAgABAEwAZQBnAGEAbABDAG8A" +
            "cAB5AHIAaQBnAGgAdAAAACAAAAA6AAkAAQBPAHIAaQBnAGkAbgBhAGwARgBpAGwAZQBuAGEAbQBlAAAAQgBhAHMAZQAuAGQAbABsAAAAAAA0AAgAAQBQAHIA" +
            "bwBkAHUAYwB0AFYAZQByAHMAaQBvAG4AAAAwAC4AMAAuADAALgAwAAAAOAAIAAEAQQBzAHMAZQBtAGIAbAB5ACAAVgBlAHIAcwBpAG8AbgAAADAALgAwAC4A" +
            "MAAuADAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAACAAAAwAAAA8NAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA="
            );


        // // Metadata version: v4.0.30319
        // .assembly extern mscorlib
        // {
        //   .publickeytoken = (B7 7A 5C 56 19 34 E0 89 )                         // .z\V.4..
        //   .ver 4:0:0:0
        // }
        // .assembly extern Foo as Foo1
        // {
        //   .publickeytoken = (CC AC 92 ED 87 3B 18 5C )                         // .....;.\
        //   .ver 0:0:0:0
        // }
        // .assembly extern Foo as Foo2
        // {
        //   .publickeytoken = (CC AC 92 ED 87 3B 18 5C )                         // .....;.\
        //   .ver 0:0:0:0
        // }
        // .assembly extern Goo as Foo3
        // {
        //   .publickeytoken = (CC AC 92 ED 87 3B 18 5C )                         // .....;.\
        //   .ver 0:0:0:0
        // }
        // .assembly extern Foo as Foo4
        // {
        //   .publickeytoken = (CC AC 92 ED 87 3B 18 5C )                         // .....;.\
        //   .ver 0:0:0:1
        // }
        // .assembly extern Foo as Foo5
        // {
        //   .publickeytoken = (CC AC 92 ED 87 3B 18 5C )                         // .....;.\
        //   .locale = (65 00 6E 00 2D 00 75 00 73 00 00 00 )
        //   .ver 0:0:0:0
        // }
        // .assembly extern Foo as Foo6
        // {
        //   .publickeytoken = (DD AC 92 ED 87 3B 18 5C )                         // .....;.\
        //   .ver 0:0:0:0
        // }
        // .assembly extern Foo as Foo7
        // {
        //   .publickeytoken = (CC AC 92 ED 87 3B 18 5C )                         // .....;.\
        //   .ver 0:0:0:0
        // }
        // .assembly extern Foo as Foo8
        // {
        //   .publickeytoken = (CC AC 92 ED 87 3B 18 5C )                         // .....;.\
        //   .ver 0:0:0:0
        // }
        // .assembly extern Foo as Foo9
        // {
        //   .publickeytoken = (CC AC 92 ED 87 3B 18 5C )                         // .....;.\
        //   .ver 0:0:0:0
        // }
        // .assembly Derived
        // {
        //   .custom instance void [mscorlib]System.Runtime.CompilerServices.CompilationRelaxationsAttribute::.ctor(int32) = ( 01 00 08 00 00 00 00 00 )
        //   .custom instance void [mscorlib]System.Runtime.CompilerServices.RuntimeCompatibilityAttribute::.ctor() = ( 01 00 01 00 54 02 16 57 72 61 70 4E 6F 6E 45 78   // ....T..WrapNonEx
        //                                                                                                              63 65 70 74 69 6F 6E 54 68 72 6F 77 73 01 )       // ceptionThrows.
        //
        //   // --- The following custom attribute is added automatically, do not uncomment -------
        //   //  .custom instance void [mscorlib]System.Diagnostics.DebuggableAttribute::.ctor(valuetype [mscorlib]System.Diagnostics.DebuggableAttribute/DebuggingModes) = ( 01 00 07 01 00 00 00 00 )
        //
        //   .hash algorithm 0x00008004
        //   .ver 0:0:0:0
        // }
        // .module Derived.dll
        // // MVID: {373639BE-A81C-4094-96B5-EC03F4BBD281}
        // .imagebase 0x10000000
        // .file alignment 0x00000200
        // .stackreserve 0x00100000
        // .subsystem 0x0003       // WINDOWS_CUI
        // .corflags 0x00000001    //  ILONLY
        // // Image base: 0x000001F439810000
        //
        //
        // // =============== CLASS MEMBERS DECLARATION ===================
        //
        // .class public auto ansi beforefieldinit Derived1
        //        extends [Foo1]Base1
        // {
        //   .method public hidebysig specialname rtspecialname
        //           instance void  .ctor() cil managed
        //   {
        //     // Code size       8 (0x8)
        //     .maxstack  8
        //     IL_0000:  ldarg.0
        //     IL_0001:  call       instance void [Foo1]Base1::.ctor()
        //     IL_0006:  nop
        //     IL_0007:  ret
        //   } // end of method Derived1::.ctor
        //
        // } // end of class Derived1
        //
        // .class public auto ansi beforefieldinit Derived2
        //        extends [Foo2]Base2
        // {
        //   .method public hidebysig specialname rtspecialname
        //           instance void  .ctor() cil managed
        //   {
        //     // Code size       8 (0x8)
        //     .maxstack  8
        //     IL_0000:  ldarg.0
        //     IL_0001:  call       instance void [Foo2]Base2::.ctor()
        //     IL_0006:  nop
        //     IL_0007:  ret
        //   } // end of method Derived2::.ctor
        //
        // } // end of class Derived2
        //
        // .class public auto ansi beforefieldinit Derived3
        //        extends [Foo3]Base3
        // {
        //   .method public hidebysig specialname rtspecialname
        //           instance void  .ctor() cil managed
        //   {
        //     // Code size       8 (0x8)
        //     .maxstack  8
        //     IL_0000:  ldarg.0
        //     IL_0001:  call       instance void [Foo3]Base3::.ctor()
        //     IL_0006:  nop
        //     IL_0007:  ret
        //   } // end of method Derived3::.ctor
        //
        // } // end of class Derived3
        //
        // .class public auto ansi beforefieldinit Derived4
        //        extends [Foo4]Base4
        // {
        //   .method public hidebysig specialname rtspecialname
        //           instance void  .ctor() cil managed
        //   {
        //     // Code size       8 (0x8)
        //     .maxstack  8
        //     IL_0000:  ldarg.0
        //     IL_0001:  call       instance void [Foo4]Base4::.ctor()
        //     IL_0006:  nop
        //     IL_0007:  ret
        //   } // end of method Derived4::.ctor
        //
        // } // end of class Derived4
        //
        // .class public auto ansi beforefieldinit Derived5
        //        extends [Foo5]Base5
        // {
        //   .method public hidebysig specialname rtspecialname
        //           instance void  .ctor() cil managed
        //   {
        //     // Code size       8 (0x8)
        //     .maxstack  8
        //     IL_0000:  ldarg.0
        //     IL_0001:  call       instance void [Foo5]Base5::.ctor()
        //     IL_0006:  nop
        //     IL_0007:  ret
        //   } // end of method Derived5::.ctor
        //
        // } // end of class Derived5
        //
        // .class public auto ansi beforefieldinit Derived6
        //        extends [Foo6]Base6
        // {
        //   .method public hidebysig specialname rtspecialname
        //           instance void  .ctor() cil managed
        //   {
        //     // Code size       8 (0x8)
        //     .maxstack  8
        //     IL_0000:  ldarg.0
        //     IL_0001:  call       instance void [Foo6]Base6::.ctor()
        //     IL_0006:  nop
        //     IL_0007:  ret
        //   } // end of method Derived6::.ctor
        //
        // } // end of class Derived6
        //
        // .class public auto ansi beforefieldinit Derived7
        //        extends [Foo7]Base7
        // {
        //   .method public hidebysig specialname rtspecialname
        //           instance void  .ctor() cil managed
        //   {
        //     // Code size       8 (0x8)
        //     .maxstack  8
        //     IL_0000:  ldarg.0
        //     IL_0001:  call       instance void [Foo7]Base7::.ctor()
        //     IL_0006:  nop
        //     IL_0007:  ret
        //   } // end of method Derived7::.ctor
        //
        // } // end of class Derived7
        //
        // .class public auto ansi beforefieldinit Derived8
        //        extends [Foo8]Base8
        // {
        //   .method public hidebysig specialname rtspecialname
        //           instance void  .ctor() cil managed
        //   {
        //     // Code size       8 (0x8)
        //     .maxstack  8
        //     IL_0000:  ldarg.0
        //     IL_0001:  call       instance void [Foo8]Base8::.ctor()
        //     IL_0006:  nop
        //     IL_0007:  ret
        //   } // end of method Derived8::.ctor
        //
        // } // end of class Derived8
        //
        // .class public auto ansi beforefieldinit Derived9
        //        extends [Foo9]Base9
        // {
        //   .method public hidebysig specialname rtspecialname
        //           instance void  .ctor() cil managed
        //   {
        //     // Code size       8 (0x8)
        //     .maxstack  8
        //     IL_0000:  ldarg.0
        //     IL_0001:  call       instance void [Foo9]Base9::.ctor()
        //     IL_0006:  nop
        //     IL_0007:  ret
        //   } // end of method Derived9::.ctor
        //
        // } // end of class Derived9
        //
        //
        public static readonly byte[] s_DerivedClassWithVariationsOnFooImage = Convert.FromBase64String(
            "TVqQAAMAAAAEAAAA//8AALgAAAAAAAAAQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAgAAAAA4fug4AtAnNIbgBTM0hVGhpcyBwcm9ncmFt" +
            "IGNhbm5vdCBiZSBydW4gaW4gRE9TIG1vZGUuDQ0KJAAAAAAAAABQRQAATAECAIgKaVsAAAAAAAAAAOAAAiELAQsAAAYAAAACAAAAAAAAriUAAAAgAAAAQAAA" +
            "AAAAEAAgAAAAAgAABAAAAAAAAAAEAAAAAAAAAABgAAAAAgAAAAAAAAMAQIUAABAAABAAAAAAEAAAEAAAAAAAABAAAAAAAAAAAAAAAFQlAABXAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAEAAAAwAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAIAAACAAAAAAAAAAAAAAA" +
            "CCAAAEgAAAAAAAAAAAAAAC50ZXh0AAAAtAUAAAAgAAAABgAAAAIAAAAAAAAAAAAAAAAAACAAAGAucmVsb2MAAAwAAAAAQAAAAAIAAAAIAAAAAAAAAAAAAAAA" +
            "AABAAABCAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACQJQAAAAAAAEgAAAACAAUApCAAALAEAAABAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACICKAMAAAoAKiICKAQAAAoAKiICKAUAAAoAKiICKAYAAAoAKiIC" +
            "KAcAAAoAKiICKAgAAAoAKiICKAkAAAoAKiICKAoAAAoAKiICKAsAAAoAKgAAAEJTSkIBAAEAAAAAAAwAAAB2NC4wLjMwMzE5AAAAAAUAbAAAALwCAAAjfgAA" +
            "KAMAACABAAAjU3RyaW5ncwAAAABIBAAACAAAACNVUwBQBAAAEAAAACNHVUlEAAAAYAQAAFAAAAAjQmxvYgAAAAAAAAACAAABRxQAAAkAAAAA+iUzABYAAAEA" +
            "AAALAAAACgAAAAkAAAALAAAAAgAAAAEAAAAKAAAAAACkAAEAAAAAAAYAKgAKAAYAUAAKAAoAbgAAAA4AdAAAABIAegAAABYAgAAAABoAhgAAAB4AjAAAACIA" +
            "kgAAACYAmAAAACoAngAAAAAAAAABAAAAAAABAAEAAQAQAMcAAAANAAEAAQABABAA0AAAABEAAQACAAEAEADZAAAAFQABAAMAAQAQAOIAAAAZAAEABAABABAA" +
            "6wAAAB0AAQAFAAEAEAD0AAAAIQABAAYAAQAQAP0AAAAlAAEABwABABAABgEAACkAAQAIAAEAEAAPAQAALQABAAkAUCAAAAAAhhhKAAYAAQBZIAAAAACGGEoA" +
            "BgABAGIgAAAAAIYYSgAGAAEAayAAAAAAhhhKAAYAAQB0IAAAAACGGEoABgABAH0gAAAAAIYYSgAGAAEAhiAAAAAAhhhKAAYAAQCPIAAAAACGGEoABgABAJgg" +
            "AAAAAIYYSgAGAAEACQBKAAEAEQBKAAYAGQBKAAYAIQBKAAYAKQBKAAYAMQBKAAYAOQBKAAYAQQBKAAYASQBKAAYAUQBKAAYAWQBKAAYALgALACUALgATAC4A" +
            "BIAAAAAAAAAAAAAAAAAAAAAAGAEAAAQAAAAAAAAAAAAAAAoAsAAAAAAAAAAAAAAAAAAAAAAAEwC5AAAAAAAAAAAAAAAAAAAAAAATALkAAAAAAAAAAAAAAAAA" +
            "AAAAABMAvQAAAAAAAAAAAAAAAQAAAAAAEwC5AAAAAAAAAAAAAAAAAAAAAAATALkAwQAAAAAAAAAAAAAAAAAAABwAuQAAAAAAAAAAAAAAAAAAAAAAEwC5AAAA" +
            "AAAAAAAAAAAAAAAAAAATALkAAAAAAAAAAAAAAAAAAAAAABMAuQAAAAAAAAAAPE1vZHVsZT4AU3lzdGVtLlJ1bnRpbWUuQ29tcGlsZXJTZXJ2aWNlcwBDb21w" +
            "aWxhdGlvblJlbGF4YXRpb25zQXR0cmlidXRlAC5jdG9yAFJ1bnRpbWVDb21wYXRpYmlsaXR5QXR0cmlidXRlAEJhc2UxAEJhc2UyAEJhc2UzAEJhc2U0AEJh" +
            "c2U1AEJhc2U2AEJhc2U3AEJhc2U4AEJhc2U5AERlcml2ZWQuZGxsAG1zY29ybGliAEZvbwBHb28AZW4tdXMARGVyaXZlZDEARGVyaXZlZDIARGVyaXZlZDMA" +
            "RGVyaXZlZDQARGVyaXZlZDUARGVyaXZlZDYARGVyaXZlZDcARGVyaXZlZDgARGVyaXZlZDkARGVyaXZlZAAAAyAAAAAAAJ0aH0wAVohAiGLn9KIYpgsABCAB" +
            "AQgDIAABCLd6XFYZNOCJCMysku2HOxhcCN2sku2HOxhcCAEACAAAAAAAHgEAAQBUAhZXcmFwTm9uRXhjZXB0aW9uVGhyb3dzAQAAAHwlAAAAAAAAAAAAAJ4l" +
            "AAAAIAAAAAAAAAAAAAAAAAAAAAAAAAAAAACQJQAAAAAAAAAAAAAAAAAAAAAAAAAAX0NvckRsbE1haW4AbXNjb3JlZS5kbGwAAAAAAP8lACAAEAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAIAAADAAAALA1AAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA=="
            );

        // // Metadata version: v4.0.30319
        // .assembly extern mscorlib
        // {
        //   .publickeytoken = (B7 7A 5C 56 19 34 E0 89 )                         // .z\V.4..
        //   .ver 4:0:0:0
        // }
        // .assembly n
        // {
        //   .hash algorithm 0x00008004
        //   .ver 0:0:0:0
        // }
        // .module n.exe
        // // MVID: {194C2064-38FD-4D1B-9761-4F7B47C017BA}
        // .imagebase 0x00400000
        // .file alignment 0x00000200
        // .stackreserve 0x00100000
        // .subsystem 0x0003       // WINDOWS_CUI
        // .corflags 0x00000001    //  ILONLY
        // // Image base: 0x0000016ECD460000
        //
        //
        // .class private auto ansi beforefieldinit MyClass
        //        extends [mscorlib]System.Object
        // {
        //   .method private hidebysig static void  Foo() cil managed
        //   {
        //     // Code size       2 (0x2)
        //     .maxstack  8
        //     IL_0000:  nop
        //     IL_0001:  ret
        //   } // end of method MyClass::Foo
        //
        //   .method private hidebysig static void  Main() cil managed
        //   {
        //     .entrypoint
        //     // Code size       2 (0x2)
        //     .maxstack  8
        //     IL_0000:  nop
        //     IL_0001:  ret
        //   } // end of method MyClass::Main
        //
        //   .method public hidebysig specialname rtspecialname
        //           instance void  .ctor() cil managed
        //   {
        //     // Code size       8 (0x8)
        //     .maxstack  8
        //     IL_0000:  ldarg.0
        //     IL_0001:  call       instance void [mscorlib]System.Object::.ctor()
        //     IL_0006:  nop
        //     IL_0007:  ret
        //   } // end of method MyClass::.ctor
        //
        // } // end of class MyClass
        //
        public static int s_AssemblyWithEntryPointEntryPointToken = 0x06000002;
        public static readonly byte[] s_AssemblyWithEntryPointImage = Convert.FromBase64String(
            "TVqQAAMAAAAEAAAA//8AALgAAAAAAAAAQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAgAAAAA4fug4AtAnNIbgBTM0hVGhpcyBwcm9ncmFt" +
            "IGNhbm5vdCBiZSBydW4gaW4gRE9TIG1vZGUuDQ0KJAAAAAAAAABQRQAATAECAEDsbFsAAAAAAAAAAOAAAgELAQsAAAQAAAACAAAAAAAATiIAAAAgAAAAQAAA" +
            "AABAAAAgAAAAAgAABAAAAAAAAAAEAAAAAAAAAABgAAAAAgAAAAAAAAMAQIUAABAAABAAAAAAEAAAEAAAAAAAABAAAAAAAAAAAAAAAPQhAABXAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAEAAAAwAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAIAAACAAAAAAAAAAAAAAA" +
            "CCAAAEgAAAAAAAAAAAAAAC50ZXh0AAAAVAIAAAAgAAAABAAAAAIAAAAAAAAAAAAAAAAAACAAAGAucmVsb2MAAAwAAAAAQAAAAAIAAAAGAAAAAAAAAAAAAAAA" +
            "AABAAABCAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAwIgAAAAAAAEgAAAACAAUAYCAAAJQBAAABAAAA" +
            "AgAABgAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAoAKgoAKiICKAEAAAoAKgBCU0pCAQABAAAAAAAMAAAAdjQuMC4z" +
            "MDMxOQAAAAAFAGwAAAC8AAAAI34AACgBAABAAAAAI1N0cmluZ3MAAAAAaAEAAAgAAAAjVVMAcAEAABAAAAAjR1VJRAAAAIABAAAUAAAAI0Jsb2IAAAAAAAAA" +
            "AgAAAUcEAAAJAAAAAPolMwAWAAABAAAAAQAAAAIAAAADAAAAAQAAAAEAAAABAAAAAAAeAAEAAAAAAAYAEQAKAAAAAAABAAAAAAABAAEAAAAQAC0AAAAFAAEA" +
            "AQBQIAAAAACRADUADgABAFMgAAAAAJEAOQAOAAEAViAAAAAAhhgYAAEAAQAJABgAAQAEgAAAAAAAAAAAAAAAAAAAAAA+AAAABAAAAAAAAAAAAAAABQAkAAAA" +
            "AAAAAAA8TW9kdWxlPgBTeXN0ZW0AT2JqZWN0AC5jdG9yAG4uZXhlAG1zY29ybGliAE15Q2xhc3MARm9vAE1haW4AbgAAAyAAAAAAAJmIhFT4FPFCjsFEq1u6" +
            "gRMAAyAAAQi3elxWGTTgiQMAAAEAABwiAAAAAAAAAAAAAD4iAAAAIAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAwIgAAAAAAAAAAAAAAAAAAAAAAAAAAX0NvckV4" +
            "ZU1haW4AbXNjb3JlZS5kbGwAAAAAAP8lACBAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAACAAAAwAAABQMgAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA="
            );

        // using System;
        // using System.Collections.Generic;
        //
        // public unsafe class Nonsense<T>
        // {
        //     public unsafe void Foo<M>()
        //     {
        //         float f1 = 3.2f;
        //         double d1 = 3.5;
        //         T t1 = default(T);
        //         T[] t2 = null;
        //         IList<M> i1 = null;
        //
        //         string s = f1 + d1.ToString() + t1 + t2 + i1;
        //         Console.WriteLine(s);
        //
        //         try
        //         {
        //             int[] ia = new int[3];
        //             fixed (int* pa = ia)
        //             {
        //                 Console.WriteLine(ia);
        //             }
        //         }
        //         catch (ArgumentNullException) when (t2 == null)
        //         {
        //             Console.WriteLine("Whatever");
        //         }
        //     }
        // }
        public static readonly byte[] s_AssemblyWithMethodBodyILBytes =
            ("0022cdcc4c400a230000000000000c400b1202fe150100001b140d1413041b8d080000012516068c0a000001a225171201280600000aa2251808" +
             "8c0100001ba2251909a2251a1104a2280700000a13051105280800000a0000198d0e000001130611062513082c0611088e692d0616e013072b0a" +
             "1108168f0e0000011307001106280900000a0000de0516e01307dc00de2a750f000001252d0426162b0c260914fe011309110916fe03fe112600" +
             "7201000070280800000a0000de002a").HexToByteArray();

        public static readonly byte[] s_AssemblyWithMethodBodyImage = Convert.FromBase64String(
            "TVqQAAMAAAAEAAAA//8AALgAAAAAAAAAQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAgAAAAA4fug4AtAnNIbgBTM0hVGhpcyBwcm9ncmFt" +
            "IGNhbm5vdCBiZSBydW4gaW4gRE9TIG1vZGUuDQ0KJAAAAAAAAABQRQAATAEDANTwbFsAAAAAAAAAAOAAIiALATAAAAgAAAAGAAAAAAAAhiYAAAAgAAAAQAAA" +
            "AAAAEAAgAAAAAgAABAAAAAAAAAAEAAAAAAAAAACAAAAAAgAAAAAAAAMAQIUAABAAABAAAAAAEAAAEAAAAAAAABAAAAAAAAAAAAAAADQmAABPAAAAAEAAAIgC" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAGAAAAwAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAIAAACAAAAAAAAAAAAAAA" +
            "CCAAAEgAAAAAAAAAAAAAAC50ZXh0AAAAjAYAAAAgAAAACAAAAAIAAAAAAAAAAAAAAAAAACAAAGAucnNyYwAAAIgCAAAAQAAAAAQAAAAKAAAAAAAAAAAAAAAA" +
            "AABAAABALnJlbG9jAAAMAAAAAGAAAAACAAAADgAAAAAAAAAAAAAAAAAAQAAAQgAAAAAAAAAAAAAAAAAAAABoJgAAAAAAAEgAAAACAAUARCEAAPAEAAABAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAABswBAC9AAAAAQAAEQAizcxMQAojAAAAAAAADEALEgL+FQEAABsU" +
            "DRQTBBuNCAAAASUWBowKAAABoiUXEgEoBgAACqIlGAiMAQAAG6IlGQmiJRoRBKIoBwAAChMFEQUoCAAACgAAGY0OAAABEwYRBiUTCCwGEQiOaS0GFuATBysK" +
            "EQgWjw4AAAETBwARBigJAAAKAADeBRbgEwfcAN4qdQ8AAAElLQQmFisMJgkU/gETCREJFv4D/hEmAHIBAABwKAgAAAoAAN4AKgAAAAEcAAACAGEAKYoABQAA" +
            "AAABAFgAOqwAEJIAAAAiAigKAAAKACoAAABCU0pCAQABAAAAAAAMAAAAdjQuMC4zMDMxOQAAAAAFAGwAAACAAQAAI34AAOwBAAC0AQAAI1N0cmluZ3MAAAAA" +
            "oAMAABQAAAAjVVMAtAMAABAAAAAjR1VJRAAAAMQDAAAsAQAAI0Jsb2IAAAAAAAAAAgAAAUdUAggJBAAAAPoBMwAWAAABAAAADwAAAAIAAAACAAAACgAAAAQA" +
            "AAABAAAAAQAAAAEAAAABAAAAAQAAAAIAAAAAAPwAAQAAAAAABgC1AEsBBgDVAEsBBgCFADgBDwBrAQAABgAJAXoBBgCZAHoBBgBrAKQBBgCdAQIBBgAMADAA" +
            "BgBSAAIBBgBLAAIBBgD1AAIBBgBZAAIBBgAUAAIBBgAYAQIBAAAAABoAAAAAAAEAAQABABAAAQAAACEAAQABAFAgAAAAAIYALgHvAAEAOCEAAAAAhhgyAQYA" +
            "AQAJADIBAQARADIBBgAZADIBCgAxADIBEAA5ADIBBgBZAPMAMgBhAJYBNgBpAGEAPABpAGEAQQBBADIBBgAnACsAJQEuAAsA9AAuABMA/QAuABsAHAEIAAYA" +
            "TwAWAC8ABIAAAAAAAAAAAAAAAAAAAAAALAEAAAQAAAAAAAAAAAAAAEYAJwAAAAAAAAAAAAMAIwAAAAAABAAlAAAAAAAATm9uc2Vuc2VgMQBJTGlzdGAxAElu" +
            "dDMyADxNb2R1bGU+AE0AVABtc2NvcmxpYgBTeXN0ZW0uQ29sbGVjdGlvbnMuR2VuZXJpYwBEb3VibGUAU2luZ2xlAENvbnNvbGUAV3JpdGVMaW5lAFVudmVy" +
            "aWZpYWJsZUNvZGVBdHRyaWJ1dGUARGVidWdnYWJsZUF0dHJpYnV0ZQBTZWN1cml0eVBlcm1pc3Npb25BdHRyaWJ1dGUAQ29tcGlsYXRpb25SZWxheGF0aW9u" +
            "c0F0dHJpYnV0ZQBSdW50aW1lQ29tcGF0aWJpbGl0eUF0dHJpYnV0ZQBUb1N0cmluZwBuLmRsbABTeXN0ZW0AU2VjdXJpdHlBY3Rpb24AQXJndW1lbnROdWxs" +
            "RXhjZXB0aW9uAEZvbwAuY3RvcgBTeXN0ZW0uRGlhZ25vc3RpY3MAU3lzdGVtLlJ1bnRpbWUuQ29tcGlsZXJTZXJ2aWNlcwBEZWJ1Z2dpbmdNb2RlcwBTeXN0" +
            "ZW0uU2VjdXJpdHkuUGVybWlzc2lvbnMAQ29uY2F0AE9iamVjdABTeXN0ZW0uU2VjdXJpdHkAABFXAGgAYQB0AGUAdgBlAHIAAAA96X++ibX1RZaVceS42NaZ" +
            "AAQgAQEIAyAAAQUgAQEREQUgAQERFRgHCgwNEwAdEwAVEiUBHgAOHQhFEAgdCAICEwADIAAOBQABDh0cBAABAQ4EAAEBHAi3elxWGTTgiYCeLgGAhFN5c3Rl" +
            "bS5TZWN1cml0eS5QZXJtaXNzaW9ucy5TZWN1cml0eVBlcm1pc3Npb25BdHRyaWJ1dGUsIG1zY29ybGliLCBWZXJzaW9uPTQuMC4wLjAsIEN1bHR1cmU9bmV1" +
            "dHJhbCwgUHVibGljS2V5VG9rZW49Yjc3YTVjNTYxOTM0ZTA4ORUBVAIQU2tpcFZlcmlmaWNhdGlvbgEEMAEAAQgBAAgAAAAAAB4BAAEAVAIWV3JhcE5vbkV4" +
            "Y2VwdGlvblRocm93cwEIAQAHAQAAAAAEAQAAAAAAXCYAAAAAAAAAAAAAdiYAAAAgAAAAAAAAAAAAAAAAAAAAAAAAAAAAAGgmAAAAAAAAAAAAAAAAX0NvckRs" +
            "bE1haW4AbXNjb3JlZS5kbGwAAAAAAP8lACAAEAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAQAQAAAAGAAAgAAAAAAAAAAAAAAAAAAAAQABAAAAMAAAgAAA" +
            "AAAAAAAAAAAAAAAAAQAAAAAASAAAAFhAAAAsAgAAAAAAAAAAAAAsAjQAAABWAFMAXwBWAEUAUgBTAEkATwBOAF8ASQBOAEYATwAAAAAAvQTv/gAAAQAAAAAA" +
            "AAAAAAAAAAAAAAAAPwAAAAAAAAAEAAAAAgAAAAAAAAAAAAAAAAAAAEQAAAABAFYAYQByAEYAaQBsAGUASQBuAGYAbwAAAAAAJAAEAAAAVAByAGEAbgBzAGwA" +
            "YQB0AGkAbwBuAAAAAAAAALAEjAEAAAEAUwB0AHIAaQBuAGcARgBpAGwAZQBJAG4AZgBvAAAAaAEAAAEAMAAwADAAMAAwADQAYgAwAAAALAACAAEARgBpAGwA" +
            "ZQBEAGUAcwBjAHIAaQBwAHQAaQBvAG4AAAAAACAAAAAwAAgAAQBGAGkAbABlAFYAZQByAHMAaQBvAG4AAAAAADAALgAwAC4AMAAuADAAAAAsAAYAAQBJAG4A" +
            "dABlAHIAbgBhAGwATgBhAG0AZQAAAG4ALgBkAGwAbAAAACgAAgABAEwAZQBnAGEAbABDAG8AcAB5AHIAaQBnAGgAdAAAACAAAAA0AAYAAQBPAHIAaQBnAGkA" +
            "bgBhAGwARgBpAGwAZQBuAGEAbQBlAAAAbgAuAGQAbABsAAAANAAIAAEAUAByAG8AZAB1AGMAdABWAGUAcgBzAGkAbwBuAAAAMAAuADAALgAwAC4AMAAAADgA" +
            "CAABAEEAcwBzAGUAbQBiAGwAeQAgAFYAZQByAHMAaQBvAG4AAAAwAC4AMAAuADAALgAwAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAIAAADAAAAIg2AAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA=="
            );

        // // Metadata version: v4.0.30319
        // .assembly extern mscorlib
        // {
        //   .publickeytoken = (B7 7A 5C 56 19 34 E0 89 )                         // .z\V.4..
        //   .ver 4:0:0:0
        // }
        // .assembly EhClauses
        // {
        //   .custom instance void [mscorlib]System.Runtime.CompilerServices.CompilationRelaxationsAttribute::.ctor(int32) = ( 01 00 08 00 00 00 00 00 )
        //   .custom instance void [mscorlib]System.Runtime.CompilerServices.RuntimeCompatibilityAttribute::.ctor() = ( 01 00 01 00 54 02 16 57 72 61 70 4E 6F 6E 45 78   // ....T..WrapNonEx
        //                                                                                                              63 65 70 74 69 6F 6E 54 68 72 6F 77 73 01 )       // ceptionThrows.
        //   .hash algorithm 0x00008004
        //   .ver 0:0:0:0
        // }
        // .module EhClauses.dll
        // // MVID: {266C1EC9-F57F-420B-B30C-35B7D1E5B741}
        // .imagebase 0x10000000
        // .file alignment 0x00000200
        // .stackreserve 0x00100000
        // .subsystem 0x0003       // WINDOWS_CUI
        // .corflags 0x00000001    //  ILONLY
        // // Image base: 0x0000018B01460000
        //
        //
        // // =============== CLASS MEMBERS DECLARATION ===================
        //
        // .class public auto ansi beforefieldinit G`1<T>
        //        extends [mscorlib]System.Object
        // {
        //   .method public hidebysig instance void
        //           Catch<M>() cil managed
        //   {
        //     // Code size       33 (0x21)
        //     .maxstack  1
        //     IL_0000:  nop
        //     .try
        //     {
        //       IL_0001:  nop
        //       IL_0002:  ldstr      "Hello"
        //       IL_0007:  call       void [mscorlib]System.Console::WriteLine(string)
        //       IL_000c:  nop
        //       IL_000d:  nop
        //       IL_000e:  leave.s    IL_0020
        //
        //     }  // end .try
        //     catch class MyException`2<!T,!!M>
        //     {
        //       IL_0010:  pop
        //       IL_0011:  nop
        //       IL_0012:  ldstr      "Catch"
        //       IL_0017:  call       void [mscorlib]System.Console::WriteLine(string)
        //       IL_001c:  nop
        //       IL_001d:  nop
        //       IL_001e:  leave.s    IL_0020
        //
        //     }  // end handler
        //     IL_0020:  ret
        //   } // end of method G`1::Catch
        //
        //   .method public hidebysig instance void
        //           Finally() cil managed
        //   {
        //     // Code size       31 (0x1f)
        //     .maxstack  1
        //     IL_0000:  nop
        //     .try
        //     {
        //       IL_0001:  nop
        //       IL_0002:  ldstr      "Hello"
        //       IL_0007:  call       void [mscorlib]System.Console::WriteLine(string)
        //       IL_000c:  nop
        //       IL_000d:  nop
        //       IL_000e:  leave.s    IL_001e
        //
        //     }  // end .try
        //     finally
        //     {
        //       IL_0010:  nop
        //       IL_0011:  ldstr      "Finally"
        //       IL_0016:  call       void [mscorlib]System.Console::WriteLine(string)
        //       IL_001b:  nop
        //       IL_001c:  nop
        //       IL_001d:  endfinally
        //     }  // end handler
        //     IL_001e:  ret
        //   } // end of method G`1::Finally
        //
        //   .method public hidebysig instance void
        //           Fault() cil managed
        //   {
        //     // Code size       31 (0x1f)
        //     .maxstack  1
        //     IL_0000:  nop
        //     .try
        //     {
        //       IL_0001:  nop
        //       IL_0002:  ldstr      "Hello"
        //       IL_0007:  call       void [mscorlib]System.Console::WriteLine(string)
        //       IL_000c:  nop
        //       IL_000d:  nop
        //       IL_000e:  leave.s    IL_001e
        //
        //     }  // end .try
        //     fault
        //     {
        //       IL_0010:  nop
        //       IL_0011:  ldstr      "Fault"
        //       IL_0016:  call       void [mscorlib]System.Console::WriteLine(string)
        //       IL_001b:  nop
        //       IL_001c:  nop
        //       IL_001d:  endfinally
        //     }  // end handler
        //     IL_001e:  ret
        //   } // end of method G`1::Fault
        //
        //   .method public hidebysig instance void
        //           Filter() cil managed
        //   {
        //     // Code size       57 (0x39)
        //     .maxstack  2
        //     .locals init (class [mscorlib]System.Exception V_0,
        //              bool V_1)
        //     IL_0000:  nop
        //     .try
        //     {
        //       IL_0001:  nop
        //       IL_0002:  ldstr      "Hello"
        //       IL_0007:  call       void [mscorlib]System.Console::WriteLine(string)
        //       IL_000c:  nop
        //       IL_000d:  nop
        //       IL_000e:  leave.s    IL_0038
        //
        //     }  // end .try
        //     filter
        //     {
        //       IL_0010:  isinst     [mscorlib]System.Exception
        //       IL_0015:  dup
        //       IL_0016:  brtrue.s   IL_001c
        //
        //       IL_0018:  pop
        //       IL_0019:  ldc.i4.0
        //       IL_001a:  br.s       IL_0026
        //
        //       IL_001c:  stloc.0
        //       IL_001d:  ldloc.0
        //       IL_001e:  ldnull
        //       IL_001f:  cgt.un
        //       IL_0021:  stloc.1
        //       IL_0022:  ldloc.1
        //       IL_0023:  ldc.i4.0
        //       IL_0024:  cgt.un
        //       IL_0026:  endfilter
        //     }  // end filter
        //     {  // handler
        //       IL_0028:  pop
        //       IL_0029:  nop
        //       IL_002a:  ldstr      "Filter"
        //       IL_002f:  call       void [mscorlib]System.Console::WriteLine(string)
        //       IL_0034:  nop
        //       IL_0035:  nop
        //       IL_0036:  leave.s    IL_0038
        //
        //     }  // end handler
        //     IL_0038:  ret
        //   } // end of method G`1::Filter
        //
        //   .method public hidebysig specialname rtspecialname
        //           instance void  .ctor() cil managed
        //   {
        //     // Code size       8 (0x8)
        //     .maxstack  8
        //     IL_0000:  ldarg.0
        //     IL_0001:  call       instance void [mscorlib]System.Object::.ctor()
        //     IL_0006:  nop
        //     IL_0007:  ret
        //   } // end of method G`1::.ctor
        //
        // } // end of class G`1
        //
        // .class public auto ansi beforefieldinit MyException`2<T,U>
        //        extends [mscorlib]System.Exception
        // {
        //   .method public hidebysig specialname rtspecialname
        //           instance void  .ctor() cil managed
        //   {
        //     // Code size       8 (0x8)
        //     .maxstack  8
        //     IL_0000:  ldarg.0
        //     IL_0001:  call       instance void [mscorlib]System.Exception::.ctor()
        //     IL_0006:  nop
        //     IL_0007:  ret
        //   } // end of method MyException`2::.ctor
        //
        // } // end of class MyException`2
        //
        public static readonly byte[] s_AssemblyWithEhClausesImage = Convert.FromBase64String(
            "TVqQAAMAAAAEAAAA//8AALgAAAAAAAAAQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAgAAAAA4fug4AtAnNIbgBTM0hVGhpcyBwcm9ncmFt" +
            "IGNhbm5vdCBiZSBydW4gaW4gRE9TIG1vZGUuDQ0KJAAAAAAAAABQRQAATAECAE3DbVsAAAAAAAAAAOAAAiELAQsAAAYAAAACAAAAAAAALiUAAAAgAAAAQAAA" +
            "AAAAEAAgAAAAAgAABAAAAAAAAAAEAAAAAAAAAABgAAAAAgAAAAAAAAMAQIUAABAAABAAAAAAEAAAEAAAAAAAABAAAAAAAAAAAAAAANgkAABTAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAEAAAAwAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAIAAACAAAAAAAAAAAAAAA" +
            "CCAAAEgAAAAAAAAAAAAAAC50ZXh0AAAANAUAAAAgAAAABgAAAAIAAAAAAAAAAAAAAAAAACAAAGAucmVsb2MAAAwAAAAAQAAAAAIAAAAIAAAAAAAAAAAAAAAA" +
            "AABAAABCAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAQJQAAAAAAAEgAAAACAAUAdCEAAGQDAAABAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAswAQAhAAAAAAAAAAAAcgEAAHAoAwAACgAA3hAmAHINAABwKAMA" +
            "AAoAAN4AKgAAAAEQAAAAAAEADxAAEAEAABsLMAEAHwAAAAAAAAAAAHIBAABwKAMAAAoAAN4OAHIZAABwKAMAAAoAANwqAAEQAAACAAEADxAADgAAAAALMAEA" +
            "HwAAAAAAAAAAAHIBAABwKAMAAAoAAN4OAHIpAABwKAMAAAoAANwqAAEQAAAEAAEADxAADgAAAAAbMAIAOQAAAAEAABEAAHIBAABwKAMAAAoAAN4odQUAAAEl" +
            "LQQmFisKCgYU/gMLBxb+A/4RJgByNQAAcCgDAAAKAADeACoAAAABEAAAAQABAA8oABAQAAAAIgIoBAAACgAqIgIoBQAACgAqAABCU0pCAQABAAAAAAAMAAAA" +
            "djQuMC4zMDMxOQAAAAAFAGwAAABkAQAAI34AANABAADsAAAAI1N0cmluZ3MAAAAAvAIAAEQAAAAjVVMAAAMAABAAAAAjR1VJRAAAABADAABUAAAAI0Jsb2IA" +
            "AAAAAAAAAgAAAUcUAggJBAAAAPolMwAWAAABAAAABQAAAAMAAAAGAAAABQAAAAIAAAABAAAAAQAAAAEAAAABAAAABAAAAAAAmAABAAAAAAAGACoACgAGAFAA" +
            "CgAGAHUAbgAGAHwAbgAGAI4AbgAAAAAAAQAAAAAAAQABAAEAEACvAAAADQABAAEAAQAQALUAAAAVAAEABgBQIAAAAACGAMUAIQABAJAgAAAAAIYAzQAGAAEA" +
            "zCAAAAAAhgDVAAYAAQAIIQAAAACGANsABgABAGAhAAAAAIYYSgAGAAEAaSEAAAAAhhhKAAYAAQAJAEoAAQARAEoABgAhAIQACgAZAEoABgApAEoABgAuAAsA" +
            "JgAuABMALwBOAA8ABIAAAAAAAAAAAAAAAAAAAAAA4gAAAAQAAAAAAAAAAAAAABgApgAAAAAAAAAAAAMAywAAAAAABACzAAAAAAAGALMAAQAAAAYAwwAAAAA8" +
            "TW9kdWxlPgBTeXN0ZW0uUnVudGltZS5Db21waWxlclNlcnZpY2VzAENvbXBpbGF0aW9uUmVsYXhhdGlvbnNBdHRyaWJ1dGUALmN0b3IAUnVudGltZUNvbXBh" +
            "dGliaWxpdHlBdHRyaWJ1dGUAU3lzdGVtAE9iamVjdABDb25zb2xlAFdyaXRlTGluZQBFeGNlcHRpb24ARWhDbGF1c2VzLmRsbABtc2NvcmxpYgBHYDEAVABN" +
            "eUV4Y2VwdGlvbmAyAFUAQ2F0Y2gATQBGaW5hbGx5AEZhdWx0AEZpbHRlcgBFaENsYXVzZXMAAAtIAGUAbABsAG8AAAtDAGEAdABjAGgAAA9GAGkAbgBhAGwA" +
            "bAB5AAALRgBhAHUAbAB0AAANRgBpAGwAdABlAHIAAADJHmwmf/ULQrMMNbfR5bdBAAQgAQEIAyAAAQQAAQEOCBUSDAITAB4ACLd6XFYZNOCJBDABAAEIAQAI" +
            "AAAAAAAeAQABAFQCFldyYXBOb25FeGNlcHRpb25UaHJvd3MBBQcCEhUCACUAAAAAAAAAAAAAHiUAAAAgAAAAAAAAAAAAAAAAAAAAAAAAAAAAABAlAAAAAAAA" +
            "AAAAAAAAAAAAAF9Db3JEbGxNYWluAG1zY29yZWUuZGxsAAAAAAD/JQAgABAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAIAAADAAAADA1AAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA=="
        );

        // public class N : Outer.Inner.ReallyInner
        // {
        // }
        public static readonly byte[] s_AssemblyWithTypeRefToNestedTypeImage = Convert.FromBase64String(
            "TVqQAAMAAAAEAAAA//8AALgAAAAAAAAAQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAgAAAAA4fug4AtAnNIbgBTM0hVGhpcyBwcm9ncmFt" +
            "IGNhbm5vdCBiZSBydW4gaW4gRE9TIG1vZGUuDQ0KJAAAAAAAAABQRQAATAEDAL49blsAAAAAAAAAAOAAIiALATAAAAQAAAAGAAAAAAAARiMAAAAgAAAAQAAA" +
            "AAAAEAAgAAAAAgAABAAAAAAAAAAEAAAAAAAAAACAAAAAAgAAAAAAAAMAQIUAABAAABAAAAAAEAAAEAAAAAAAABAAAAAAAAAAAAAAAPQiAABPAAAAAEAAAIgC" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAGAAAAwAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAIAAACAAAAAAAAAAAAAAA" +
            "CCAAAEgAAAAAAAAAAAAAAC50ZXh0AAAATAMAAAAgAAAABAAAAAIAAAAAAAAAAAAAAAAAACAAAGAucnNyYwAAAIgCAAAAQAAAAAQAAAAGAAAAAAAAAAAAAAAA" +
            "AABAAABALnJlbG9jAAAMAAAAAGAAAAACAAAACgAAAAAAAAAAAAAAAAAAQAAAQgAAAAAAAAAAAAAAAAAAAAAoIwAAAAAAAEgAAAACAAUAXCAAAJgCAAABAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACICKAQAAAoAKgAAAEJTSkIBAAEAAAAAAAwAAAB2NC4wLjMwMzE5" +
            "AAAAAAUAbAAAAAABAAAjfgAAbAEAAMwAAAAjU3RyaW5ncwAAAAA4AgAABAAAACNVUwA8AgAAEAAAACNHVUlEAAAATAIAAEwAAAAjQmxvYgAAAAAAAAACAAAB" +
            "RxQAAAkAAAAA+gEzABYAAAEAAAAHAAAAAgAAAAEAAAAEAAAAAwAAAAEAAAACAAAAAABpAAEAAAAAAAYAKwCcAAYASwCcAAYAFwCJAA8AvAAAAAoAfQAAABcA" +
            "dwAAABsAcQAAAAAAAAABAAAAAAABAAEAAQAQAAoAAAAdAAEAAQBQIAAAAACGGIMABgABAAkAgwABABEAgwAGABkAgwAKADkAgwAGAC4ACwAZAC4AEwAiAC4A" +
            "GwBBAASAAAAAAAAAAAAAAAAAAAAAAG8AAAAEAAAAAAAAAAAAAAAQAA4AAAAAAAAAAAAAAAAAAAAAAAAADAAAAAAAAAAAPE1vZHVsZT4ATgBhAG1zY29ybGli" +
            "AERlYnVnZ2FibGVBdHRyaWJ1dGUAQ29tcGlsYXRpb25SZWxheGF0aW9uc0F0dHJpYnV0ZQBSdW50aW1lQ29tcGF0aWJpbGl0eUF0dHJpYnV0ZQBuLmRsbABu" +
            "AFJlYWxseUlubmVyAE91dGVyAC5jdG9yAFN5c3RlbS5EaWFnbm9zdGljcwBTeXN0ZW0uUnVudGltZS5Db21waWxlclNlcnZpY2VzAERlYnVnZ2luZ01vZGVz" +
            "AAAAAAAAF65LwDk73EuolUEDaAJX9gAEIAEBCAMgAAEFIAEBEREIt3pcVhk04IkIAQAIAAAAAAAeAQABAFQCFldyYXBOb25FeGNlcHRpb25UaHJvd3MBCAEA" +
            "BwEAAAAAAAAcIwAAAAAAAAAAAAA2IwAAACAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAKCMAAAAAAAAAAAAAAABfQ29yRGxsTWFpbgBtc2NvcmVlLmRsbAAAAAAA" +
            "/yUAIAAQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAABABAAAAAYAACAAAAAAAAAAAAAAAAAAAABAAEAAAAwAACAAAAAAAAAAAAAAAAAAAABAAAAAABIAAAAWEAAACwCAAAAAAAA" +
            "AAAAACwCNAAAAFYAUwBfAFYARQBSAFMASQBPAE4AXwBJAE4ARgBPAAAAAAC9BO/+AAABAAAAAAAAAAAAAAAAAAAAAAA/AAAAAAAAAAQAAAACAAAAAAAAAAAA" +
            "AAAAAAAARAAAAAEAVgBhAHIARgBpAGwAZQBJAG4AZgBvAAAAAAAkAAQAAABUAHIAYQBuAHMAbABhAHQAaQBvAG4AAAAAAAAAsASMAQAAAQBTAHQAcgBpAG4A" +
            "ZwBGAGkAbABlAEkAbgBmAG8AAABoAQAAAQAwADAAMAAwADAANABiADAAAAAsAAIAAQBGAGkAbABlAEQAZQBzAGMAcgBpAHAAdABpAG8AbgAAAAAAIAAAADAA" +
            "CAABAEYAaQBsAGUAVgBlAHIAcwBpAG8AbgAAAAAAMAAuADAALgAwAC4AMAAAACwABgABAEkAbgB0AGUAcgBuAGEAbABOAGEAbQBlAAAAbgAuAGQAbABsAAAA" +
            "KAACAAEATABlAGcAYQBsAEMAbwBwAHkAcgBpAGcAaAB0AAAAIAAAADQABgABAE8AcgBpAGcAaQBuAGEAbABGAGkAbABlAG4AYQBtAGUAAABuAC4AZABsAGwA" +
            "AAA0AAgAAQBQAHIAbwBkAHUAYwB0AFYAZQByAHMAaQBvAG4AAAAwAC4AMAAuADAALgAwAAAAOAAIAAEAQQBzAHMAZQBtAGIAbAB5ACAAVgBlAHIAcwBpAG8A" +
            "bgAAADAALgAwAC4AMAAuADAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAgAAAMAAAASDMAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAA"
        );

        // public class Outer
        // {
        //     public class Inner
        //     {
        //         public class NotThisOne {}
        //         public class NorThisOne {}
        //         public class ReallyInner {}
        //     }
        // }
        public static readonly byte[] s_AssemblyWithNestedTypeImage = Convert.FromBase64String(
            "TVqQAAMAAAAEAAAA//8AALgAAAAAAAAAQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAgAAAAA4fug4AtAnNIbgBTM0hVGhpcyBwcm9ncmFt" +
            "IGNhbm5vdCBiZSBydW4gaW4gRE9TIG1vZGUuDQ0KJAAAAAAAAABQRQAATAEDALc9blsAAAAAAAAAAOAAIiALATAAAAQAAAAGAAAAAAAAyiMAAAAgAAAAQAAA" +
            "AAAAEAAgAAAAAgAABAAAAAAAAAAEAAAAAAAAAACAAAAAAgAAAAAAAAMAQIUAABAAABAAAAAAEAAAEAAAAAAAABAAAAAAAAAAAAAAAHgjAABPAAAAAEAAAIgC" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAGAAAAwAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAIAAACAAAAAAAAAAAAAAA" +
            "CCAAAEgAAAAAAAAAAAAAAC50ZXh0AAAA0AMAAAAgAAAABAAAAAIAAAAAAAAAAAAAAAAAACAAAGAucnNyYwAAAIgCAAAAQAAAAAQAAAAGAAAAAAAAAAAAAAAA" +
            "AABAAABALnJlbG9jAAAMAAAAAGAAAAACAAAACgAAAAAAAAAAAAAAAAAAQAAAQgAAAAAAAAAAAAAAAAAAAACsIwAAAAAAAEgAAAACAAUAXCAAABwDAAABAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACICKAQAAAoAKgAAAEJTSkIBAAEAAAAAAAwAAAB2NC4wLjMwMzE5" +
            "AAAAAAUAbAAAAGQBAAAjfgAA0AEAAOwAAAAjU3RyaW5ncwAAAAC8AgAABAAAACNVUwDAAgAAEAAAACNHVUlEAAAA0AIAAEwAAAAjQmxvYgAAAAAAAAACAAAB" +
            "RxQAAAkCAAAA+gEzABYAAAEAAAAFAAAABgAAAAUAAAAEAAAAAwAAAAEAAAABAAAABAAAAAAAfQABAAAAAAAGAD8AtQAGAF8AtQAGACsAogAPANUAAAAGAOQA" +
            "gwAAAAAAAQAAAAAAAQABAAEAEACWAAAAFQABAAEAAgAQAJAAAAAVAAEAAgACABAAIAAAABUAAQADAAIAEAAVAAAAFQABAAQAAgAQAIoAAAAVAAEABQBQIAAA" +
            "AACGGJwABgABAFAgAAAAAIYYnAAGAAEAUCAAAAAAhhicAAYAAQBQIAAAAACGGJwABgABAFAgAAAAAIYYnAAGAAEACQCcAAEAEQCcAAYAGQCcAAoAKQCcAAYA" +
            "LgALABkALgATACIALgAbAEEABIAAAAAAAAAAAAAAAAAAAAAACgAAAAQAAAAAAAAAAAAAABAADAAAAAAAAwACAAQAAwAFAAMABgADAAAAADxNb2R1bGU+AGEA" +
            "bXNjb3JsaWIATm9yVGhpc09uZQBOb3RUaGlzT25lAERlYnVnZ2FibGVBdHRyaWJ1dGUAQ29tcGlsYXRpb25SZWxheGF0aW9uc0F0dHJpYnV0ZQBSdW50aW1l" +
            "Q29tcGF0aWJpbGl0eUF0dHJpYnV0ZQBhLmRsbABTeXN0ZW0AUmVhbGx5SW5uZXIAT3V0ZXIALmN0b3IAU3lzdGVtLkRpYWdub3N0aWNzAFN5c3RlbS5SdW50" +
            "aW1lLkNvbXBpbGVyU2VydmljZXMARGVidWdnaW5nTW9kZXMAT2JqZWN0AAAAAAAAbaM4i5qTekyPvwzhTbx1vQAEIAEBCAMgAAEFIAEBEREIt3pcVhk04IkI" +
            "AQAIAAAAAAAeAQABAFQCFldyYXBOb25FeGNlcHRpb25UaHJvd3MBCAEABwEAAAAAAACgIwAAAAAAAAAAAAC6IwAAACAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "rCMAAAAAAAAAAAAAAABfQ29yRGxsTWFpbgBtc2NvcmVlLmRsbAAAAAAA/yUAIAAQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAABABAAAAAYAACAAAAAAAAAAAAAAAAAAAABAAEAAAAwAACAAAAAAAAAAAAAAAAAAAABAAAAAABIAAAAWEAAACwCAAAAAAAA" +
            "AAAAACwCNAAAAFYAUwBfAFYARQBSAFMASQBPAE4AXwBJAE4ARgBPAAAAAAC9BO/+AAABAAAAAAAAAAAAAAAAAAAAAAA/AAAAAAAAAAQAAAACAAAAAAAAAAAA" +
            "AAAAAAAARAAAAAEAVgBhAHIARgBpAGwAZQBJAG4AZgBvAAAAAAAkAAQAAABUAHIAYQBuAHMAbABhAHQAaQBvAG4AAAAAAAAAsASMAQAAAQBTAHQAcgBpAG4A" +
            "ZwBGAGkAbABlAEkAbgBmAG8AAABoAQAAAQAwADAAMAAwADAANABiADAAAAAsAAIAAQBGAGkAbABlAEQAZQBzAGMAcgBpAHAAdABpAG8AbgAAAAAAIAAAADAA" +
            "CAABAEYAaQBsAGUAVgBlAHIAcwBpAG8AbgAAAAAAMAAuADAALgAwAC4AMAAAACwABgABAEkAbgB0AGUAcgBuAGEAbABOAGEAbQBlAAAAYQAuAGQAbABsAAAA" +
            "KAACAAEATABlAGcAYQBsAEMAbwBwAHkAcgBpAGcAaAB0AAAAIAAAADQABgABAE8AcgBpAGcAaQBuAGEAbABGAGkAbABlAG4AYQBtAGUAAABhAC4AZABsAGwA" +
            "AAA0AAgAAQBQAHIAbwBkAHUAYwB0AFYAZQByAHMAaQBvAG4AAAAwAC4AMAAuADAALgAwAAAAOAAIAAEAQQBzAHMAZQBtAGIAbAB5ACAAVgBlAHIAcwBpAG8A" +
            "bgAAADAALgAwAC4AMAAuADAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAgAAAMAAAAzDMAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAA"
        );

        // .assembly extern mscorlib
        // {
        //   .publickeytoken = (B7 7A 5C 56 19 34 E0 89 )                         // .z\V.4..
        //   .ver 4:0:0:0
        // }
        // .assembly n
        // {
        //   .custom instance void [mscorlib]System.Runtime.CompilerServices.CompilationRelaxationsAttribute::.ctor(int32) = ( 01 00 08 00 00 00 00 00 )
        //   .custom instance void [mscorlib]System.Runtime.CompilerServices.RuntimeCompatibilityAttribute::.ctor() = ( 01 00 01 00 54 02 16 57 72 61 70 4E 6F 6E 45 78   // ....T..WrapNonEx
        //                                                                                                              63 65 70 74 69 6F 6E 54 68 72 6F 77 73 01 )       // ceptionThrows.
        //
        //   // --- The following custom attribute is added automatically, do not uncomment -------
        //   //  .custom instance void [mscorlib]System.Diagnostics.DebuggableAttribute::.ctor(valuetype [mscorlib]System.Diagnostics.DebuggableAttribute/DebuggingModes) = ( 01 00 07 01 00 00 00 00 )
        //
        //   .hash algorithm 0x00008004
        //   .ver 0:0:0:0
        // }
        // .module n.dll
        // // MVID: {C866D908-3B82-4972-921D-CE45E9DF5EA3}
        // .imagebase 0x10000000
        // .file alignment 0x00000200
        // .stackreserve 0x00100000
        // .subsystem 0x0003       // WINDOWS_CUI
        // .corflags 0x00000001    //  ILONLY
        // // Image base: 0x0000026B7C8E0000
        //
        //
        // // =============== CLASS MEMBERS DECLARATION ===================
        //
        // .class public auto ansi beforefieldinit 'Typ\\W[t]S+r*n&e,haracters'
        //        extends [mscorlib]System.Object
        // {
        //   .method public hidebysig specialname rtspecialname
        //           instance void  .ctor() cil managed
        //   {
        //     // Code size       8 (0x8)
        //     .maxstack  8
        //     IL_0000:  ldarg.0
        //     IL_0001:  call       instance void [mscorlib]System.Object::.ctor()
        //     IL_0006:  nop
        //     IL_0007:  ret
        //   } // end of method 'Typ\\W[t]S+r*n&e,haracters'::.ctor
        //
        // } // end of class 'Typ\\W[t]S+r*n&e,haracters'
        public const string s_NameOfTypeWithStrangeCharacters = @"Typ\\W\[t\]S\+r\*n\&e\,haracters";
        public static readonly byte[] s_TypeWithStrangeCharacters = Convert.FromBase64String(
            "TVqQAAMAAAAEAAAA//8AALgAAAAAAAAAQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAgAAAAA4fug4AtAnNIbgBTM0hVGhpcyBwcm9ncmFt" +
            "IGNhbm5vdCBiZSBydW4gaW4gRE9TIG1vZGUuDQ0KJAAAAAAAAABQRQAATAEDACiijlsAAAAAAAAAAOAAIiALATAAAAQAAAAGAAAAAAAAOiMAAAAgAAAAQAAA" +
            "AAAAEAAgAAAAAgAABAAAAAAAAAAEAAAAAAAAAACAAAAAAgAAAAAAAAMAQIUAABAAABAAAAAAEAAAEAAAAAAAABAAAAAAAAAAAAAAAOgiAABPAAAAAEAAAIgC" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAGAAAAwAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAIAAACAAAAAAAAAAAAAAA" +
            "CCAAAEgAAAAAAAAAAAAAAC50ZXh0AAAAQAMAAAAgAAAABAAAAAIAAAAAAAAAAAAAAAAAACAAAGAucnNyYwAAAIgCAAAAQAAAAAQAAAAGAAAAAAAAAAAAAAAA" +
            "AABAAABALnJlbG9jAAAMAAAAAGAAAAACAAAACgAAAAAAAAAAAAAAAAAAQAAAQgAAAAAAAAAAAAAAAAAAAAAcIwAAAAAAAEgAAAACAAUAXCAAAIwCAAABAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACICKAQAAAoAKgAAAEJTSkIBAAEAAAAAAAwAAAB2NC4wLjMwMzE5" +
            "AAAAAAUAbAAAAOAAAAAjfgAATAEAAOAAAAAjU3RyaW5ncwAAAAAsAgAABAAAACNVUwAwAgAAEAAAACNHVUlEAAAAQAIAAEwAAAAjQmxvYgAAAAAAAAACAAAB" +
            "RxQAAAkAAAAA+gEzABYAAAEAAAAFAAAAAgAAAAEAAAAEAAAAAwAAAAEAAAABAAAAAABlAAEAAAAAAAYAJwCNAAYARwCNAAYAEwB6AA8ArQAAAAYA1gBrAAAA" +
            "AAABAAAAAAABAAEAAQAQALwAAAAVAAEAAQBQIAAAAACGGHQABgABAAkAdAABABEAdAAGABkAdAAKACkAdAAGAC4ACwAZAC4AEwAiAC4AGwBBAASAAAAAAAAA" +
            "AAAAAAAAAAAAAHIAAAAEAAAAAAAAAAAAAAAQAAoAAAAAAAAAADxNb2R1bGU+AG1zY29ybGliAERlYnVnZ2FibGVBdHRyaWJ1dGUAQ29tcGlsYXRpb25SZWxh" +
            "eGF0aW9uc0F0dHJpYnV0ZQBSdW50aW1lQ29tcGF0aWJpbGl0eUF0dHJpYnV0ZQBuLmRsbABTeXN0ZW0AbgAuY3RvcgBTeXN0ZW0uRGlhZ25vc3RpY3MAU3lz" +
            "dGVtLlJ1bnRpbWUuQ29tcGlsZXJTZXJ2aWNlcwBEZWJ1Z2dpbmdNb2RlcwBUeXBcV1t0XVMrcipuJmUsaGFyYWN0ZXJzAE9iamVjdAAAAAAAAAAACNlmyII7" +
            "ckmSHc5F6d9eowAEIAEBCAMgAAEFIAEBEREIt3pcVhk04IkIAQAIAAAAAAAeAQABAFQCFldyYXBOb25FeGNlcHRpb25UaHJvd3MBCAEABwEAAAAAAAAQIwAA" +
            "AAAAAAAAAAAqIwAAACAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAHCMAAAAAAAAAAAAAAABfQ29yRGxsTWFpbgBtc2NvcmVlLmRsbAAAAAAA/yUAIAAQAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAABABAAAAAYAACAAAAAAAAAAAAAAAAAAAABAAEAAAAwAACAAAAAAAAAAAAAAAAAAAABAAAAAABIAAAAWEAAACwCAAAAAAAA" +
            "AAAAACwCNAAAAFYAUwBfAFYARQBSAFMASQBPAE4AXwBJAE4ARgBPAAAAAAC9BO/+AAABAAAAAAAAAAAAAAAAAAAAAAA/AAAAAAAAAAQAAAACAAAAAAAAAAAA" +
            "AAAAAAAARAAAAAEAVgBhAHIARgBpAGwAZQBJAG4AZgBvAAAAAAAkAAQAAABUAHIAYQBuAHMAbABhAHQAaQBvAG4AAAAAAAAAsASMAQAAAQBTAHQAcgBpAG4A" +
            "ZwBGAGkAbABlAEkAbgBmAG8AAABoAQAAAQAwADAAMAAwADAANABiADAAAAAsAAIAAQBGAGkAbABlAEQAZQBzAGMAcgBpAHAAdABpAG8AbgAAAAAAIAAAADAA" +
            "CAABAEYAaQBsAGUAVgBlAHIAcwBpAG8AbgAAAAAAMAAuADAALgAwAC4AMAAAACwABgABAEkAbgB0AGUAcgBuAGEAbABOAGEAbQBlAAAAbgAuAGQAbABsAAAA" +
            "KAACAAEATABlAGcAYQBsAEMAbwBwAHkAcgBpAGcAaAB0AAAAIAAAADQABgABAE8AcgBpAGcAaQBuAGEAbABGAGkAbABlAG4AYQBtAGUAAABuAC4AZABsAGwA" +
            "AAA0AAgAAQBQAHIAbwBkAHUAYwB0AFYAZQByAHMAaQBvAG4AAAAwAC4AMAAuADAALgAwAAAAOAAIAAEAQQBzAHMAZQBtAGIAbAB5ACAAVgBlAHIAcwBpAG8A" +
            "bgAAADAALgAwAC4AMAAuADAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAgAAAMAAAAPDMAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAA"
        );

        //// Metadata version: v4.0.30319
        //.assembly extern mscorlib
        //{
        //  .publickeytoken = (B7 7A 5C 56 19 34 E0 89 )                         // .z\V.4..
        //  .ver 4:0:0:0
        //}
        //.assembly SimpleAssemblyVersioned
        //    {
        //  .custom instance void [mscorlib]
        //        System.Runtime.CompilerServices.CompilationRelaxationsAttribute::.ctor(int32) = ( 01 00 08 00 00 00 00 00 )
        //  .custom instance void [mscorlib]
        //        System.Runtime.CompilerServices.RuntimeCompatibilityAttribute::.ctor() = ( 01 00 01 00 54 02 16 57 72 61 70 4E 6F 6E 45 78   // ....T..WrapNonEx
        //                                                                                                             63 65 70 74 69 6F 6E 54 68 72 6F 77 73 01 )       // ceptionThrows.

        //  // --- The following custom attribute is added automatically, do not uncomment -------
        //  //  .custom instance void [mscorlib]System.Diagnostics.DebuggableAttribute::.ctor(valuetype [mscorlib]System.Diagnostics.DebuggableAttribute/DebuggingModes) = ( 01 00 07 01 00 00 00 00 )

        //  .publickey = (00 24 00 00 04 80 00 00 94 00 00 00 06 02 00 00   // .$..............
        //                00 24 00 00 52 53 41 31 00 04 00 00 01 00 01 00   // .$..RSA1........
        //                1D 7A 8F 71 66 7E EB BA 21 84 1A 14 4E AF C8 39   // .z.qf~..!...N..9
        //                5E BF AF 6D 17 70 D6 5E A8 D9 5E 7C F3 89 B5 B8   // ^..m.p.^..^|....
        //                B6 F4 7D F5 2C C8 8B 47 ED 05 0D 84 25 4A F6 5F   // ..}.,..G....%J._
        //                ED 0A 9F F9 1C 06 BB AC 6A 0A 03 D4 12 72 A2 C1   // ........j....r..
        //                1E CA 7A F0 91 1A C7 3A FB F5 BE 65 72 2B 96 79   // ..z....:...er+.y
        //                1B 0C 7C 87 71 B2 A9 26 CB 13 EB 90 1A 11 47 93   // ..|.q..&......G.
        //                C8 75 A8 65 FC E7 2A 78 4A 86 31 03 02 6A FA 59   // .u.e..*xJ.1..j.Y
        //                78 8B C9 54 F3 56 3B 81 9D 91 05 09 1A 05 8A 9D ) // x..T.V;.........
        //  .hash algorithm 0x00008004
        //  .ver 1:0:0:0
        //}
        //.module SimpleAssemblyVersioned.dll
        //// MVID: {646136F1-7D3C-4AAA-8C64-BB9F2A5AC5C8}
        //.imagebase 0x10000000
        //.file alignment 0x00000200
        //.stackreserve 0x00100000
        //.subsystem 0x0003       // WINDOWS_CUI
        //.corflags 0x00000009    //  ILONLY
        //// Image base: 0x0F610000
        public static readonly string s_SimpleVersionedShortName = "SimpleAssemblyVersioned";
        public static readonly string s_SimpleSignedVersioned100FullName = "SimpleAssemblyVersioned, Version=1.0.0.0, Culture=neutral, PublicKeyToken=a5bca3eed6ce66f9";
        public static readonly byte[] s_SimpleSignedVersioned100Image = Convert.FromBase64String(
            "TVqQAAMAAAAEAAAA//8AALgAAAAAAAAAQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAgAAAAA4fug4AtAnNIbgBTM0hVGhpcyBwcm9ncmFt" +
            "IGNhbm5vdCBiZSBydW4gaW4gRE9TIG1vZGUuDQ0KJAAAAAAAAABQRQAATAEDAE6t7FsAAAAAAAAAAOAAIiALATAAAAYAAAAGAAAAAAAAJiQAAAAgAAAAQAAA" +
            "AAAAEAAgAAAAAgAABAAAAAAAAAAEAAAAAAAAAACAAAAAAgAAe/YAAAMAQIUAABAAABAAAAAAEAAAEAAAAAAAABAAAAAAAAAAAAAAANQjAABPAAAAAEAAAOAC" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAGAAAAwAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAIAAACAAAAAAAAAAAAAAA" +
            "CCAAAEgAAAAAAAAAAAAAAC50ZXh0AAAALAQAAAAgAAAABgAAAAIAAAAAAAAAAAAAAAAAACAAAGAucnNyYwAAAOACAAAAQAAAAAQAAAAIAAAAAAAAAAAAAAAA" +
            "AABAAABALnJlbG9jAAAMAAAAAGAAAAACAAAADAAAAAAAAAAAAAAAAAAAQAAAQgAAAAAAAAAAAAAAAAAAAAAIJAAAAAAAAEgAAAACAAUAUCAAAAQDAAAJAAAA" +
            "AAAAAAAAAAAAAAAAVCMAAIAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAEJTSkIBAAEAAAAAAAwAAAB2NC4wLjMwMzE5AAAAAAUAbAAAALQA" +
            "AAAjfgAAIAEAAOQAAAAjU3RyaW5ncwAAAAAEAgAABAAAACNVUwAIAgAAEAAAACNHVUlEAAAAGAIAAOwAAAAjQmxvYgAAAAAAAAACAAABBxQAAAkAAAAA+gEz" +
            "ABYAAAEAAAAEAAAAAQAAAAMAAAADAAAAAQAAAAEAAAAAAH0AAQAAAAAABgA/ALIABgBfALIABgArAJ8ADwDSAAAAAAAAAAEAAAAAAAEAAQAJAJkAAQARAJkA" +
            "BgAZAJkACgAuAAsAuwAuABMAxAAuABsA4wAEgAAAAQAAAAAAAAABAAAAGQATAAAABAAAAAAAAAAAAAAAEAAKAAAAAAAAAAA8TW9kdWxlPgBtc2NvcmxpYgBT" +
            "aW1wbGVBc3NlbWJseVZlcnNpb25lZABEZWJ1Z2dhYmxlQXR0cmlidXRlAENvbXBpbGF0aW9uUmVsYXhhdGlvbnNBdHRyaWJ1dGUAUnVudGltZUNvbXBhdGli" +
            "aWxpdHlBdHRyaWJ1dGUAU2ltcGxlQXNzZW1ibHlWZXJzaW9uZWQuZGxsAC5jdG9yAFN5c3RlbS5EaWFnbm9zdGljcwBTeXN0ZW0uUnVudGltZS5Db21waWxl" +
            "clNlcnZpY2VzAERlYnVnZ2luZ01vZGVzAAAAAAAAAADxNmFkPH2qSoxku58qWsXIAAQgAQEIAyAAAQUgAQEREQi3elxWGTTgiYCgACQAAASAAACUAAAABgIA" +
            "AAAkAABSU0ExAAQAAAEAAQAdeo9xZn7ruiGEGhROr8g5Xr+vbRdw1l6o2V5884m1uLb0ffUsyItH7QUNhCVK9l/tCp/5HAa7rGoKA9QScqLBHsp68JEaxzr7" +
            "9b5lciuWeRsMfIdxsqkmyxPrkBoRR5PIdahl/OcqeEqGMQMCavpZeIvJVPNWO4GdkQUJGgWKnQgBAAgAAAAAAB4BAAEAVAIWV3JhcE5vbkV4Y2VwdGlvblRo" +
            "cm93cwEIAQAHAQAAAADtLI0rjWHaFctiRRuk3OtVM4H2c0E2/rzo/6llsSBCgw8vPcFkqZJe8JF4rITo/1364wOdHb87nm7vepp7oN0C83owHtSzNtErjzDS" +
            "xGDe3Aqvvvk/tHy08OpVIVV+ynUj6U+2YG96QGZ0tbq2mPMJESuYJF3DCoqBrHBD62KDb/wjAAAAAAAAAAAAABYkAAAAIAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAIJAAAAAAAAAAAAAAAAF9Db3JEbGxNYWluAG1zY29yZWUuZGxsAAAAAAD/JQAgABAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAEAEAAAABgA" +
            "AIAAAAAAAAAAAAAAAAAAAAEAAQAAADAAAIAAAAAAAAAAAAAAAAAAAAEAAAAAAEgAAABYQAAAhAIAAAAAAAAAAAAAhAI0AAAAVgBTAF8AVgBFAFIAUwBJAE8A" +
            "TgBfAEkATgBGAE8AAAAAAL0E7/4AAAEAAAABAAAAAAAAAAEAAAAAAD8AAAAAAAAABAAAAAIAAAAAAAAAAAAAAAAAAABEAAAAAQBWAGEAcgBGAGkAbABlAEkA" +
            "bgBmAG8AAAAAACQABAAAAFQAcgBhAG4AcwBsAGEAdABpAG8AbgAAAAAAAACwBOQBAAABAFMAdAByAGkAbgBnAEYAaQBsAGUASQBuAGYAbwAAAMABAAABADAA" +
            "MAAwADAAMAA0AGIAMAAAACwAAgABAEYAaQBsAGUARABlAHMAYwByAGkAcAB0AGkAbwBuAAAAAAAgAAAAMAAIAAEARgBpAGwAZQBWAGUAcgBzAGkAbwBuAAAA" +
            "AAAxAC4AMAAuADAALgAwAAAAWAAcAAEASQBuAHQAZQByAG4AYQBsAE4AYQBtAGUAAABTAGkAbQBwAGwAZQBBAHMAcwBlAG0AYgBsAHkAVgBlAHIAcwBpAG8A" +
            "bgBlAGQALgBkAGwAbAAAACgAAgABAEwAZQBnAGEAbABDAG8AcAB5AHIAaQBnAGgAdAAAACAAAABgABwAAQBPAHIAaQBnAGkAbgBhAGwARgBpAGwAZQBuAGEA" +
            "bQBlAAAAUwBpAG0AcABsAGUAQQBzAHMAZQBtAGIAbAB5AFYAZQByAHMAaQBvAG4AZQBkAC4AZABsAGwAAAA0AAgAAQBQAHIAbwBkAHUAYwB0AFYAZQByAHMA" +
            "aQBvAG4AAAAxAC4AMAAuADAALgAwAAAAOAAIAAEAQQBzAHMAZQBtAGIAbAB5ACAAVgBlAHIAcwBpAG8AbgAAADEALgAwAC4AMAAuADAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAACAAAAwAAAAoNAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA="
        );

        //// Metadata version: v4.0.30319
        //.assembly extern mscorlib
        //{
        //  .publickeytoken = (B7 7A 5C 56 19 34 E0 89 )                         // .z\V.4..
        //  .ver 4:0:0:0
        //}
        //.assembly SimpleAssemblyVersioned
        //    {
        //  .custom instance void [mscorlib]
        //        System.Runtime.CompilerServices.CompilationRelaxationsAttribute::.ctor(int32) = ( 01 00 08 00 00 00 00 00 )
        //  .custom instance void [mscorlib]
        //        System.Runtime.CompilerServices.RuntimeCompatibilityAttribute::.ctor() = ( 01 00 01 00 54 02 16 57 72 61 70 4E 6F 6E 45 78   // ....T..WrapNonEx
        //                                                                                                             63 65 70 74 69 6F 6E 54 68 72 6F 77 73 01 )       // ceptionThrows.

        //  // --- The following custom attribute is added automatically, do not uncomment -------
        //  //  .custom instance void [mscorlib]System.Diagnostics.DebuggableAttribute::.ctor(valuetype [mscorlib]System.Diagnostics.DebuggableAttribute/DebuggingModes) = ( 01 00 07 01 00 00 00 00 )

        //  .publickey = (00 24 00 00 04 80 00 00 94 00 00 00 06 02 00 00   // .$..............
        //                00 24 00 00 52 53 41 31 00 04 00 00 01 00 01 00   // .$..RSA1........
        //                1D 7A 8F 71 66 7E EB BA 21 84 1A 14 4E AF C8 39   // .z.qf~..!...N..9
        //                5E BF AF 6D 17 70 D6 5E A8 D9 5E 7C F3 89 B5 B8   // ^..m.p.^..^|....
        //                B6 F4 7D F5 2C C8 8B 47 ED 05 0D 84 25 4A F6 5F   // ..}.,..G....%J._
        //                ED 0A 9F F9 1C 06 BB AC 6A 0A 03 D4 12 72 A2 C1   // ........j....r..
        //                1E CA 7A F0 91 1A C7 3A FB F5 BE 65 72 2B 96 79   // ..z....:...er+.y
        //                1B 0C 7C 87 71 B2 A9 26 CB 13 EB 90 1A 11 47 93   // ..|.q..&......G.
        //                C8 75 A8 65 FC E7 2A 78 4A 86 31 03 02 6A FA 59   // .u.e..*xJ.1..j.Y
        //                78 8B C9 54 F3 56 3B 81 9D 91 05 09 1A 05 8A 9D ) // x..T.V;.........
        //  .hash algorithm 0x00008004
        //  .ver 2:0:0:0
        //}
        //.module SimpleAssemblyVersioned.dll
        //// MVID: {BD748E78-FA19-4141-9DC6-1A0619907DDC}
        //.imagebase 0x10000000
        //.file alignment 0x00000200
        //.stackreserve 0x00100000
        //.subsystem 0x0003       // WINDOWS_CUI
        //.corflags 0x00000009    //  ILONLY
        //// Image base: 0x099E0000
        public static readonly string s_SimpleSignedVersioned200FullName = "SimpleAssemblyVersioned, Version=2.0.0.0, Culture=neutral, PublicKeyToken=a5bca3eed6ce66f9";
        public static readonly byte[] s_SimpleSignedVersioned200Image = Convert.FromBase64String(
            "TVqQAAMAAAAEAAAA//8AALgAAAAAAAAAQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAgAAAAA4fug4AtAnNIbgBTM0hVGhpcyBwcm9ncmFt" +
            "IGNhbm5vdCBiZSBydW4gaW4gRE9TIG1vZGUuDQ0KJAAAAAAAAABQRQAATAEDAKKY7VsAAAAAAAAAAOAAIiALATAAAAYAAAAGAAAAAAAAJiQAAAAgAAAAQAAA" +
            "AAAAEAAgAAAAAgAABAAAAAAAAAAEAAAAAAAAAACAAAAAAgAAj8gAAAMAQIUAABAAABAAAAAAEAAAEAAAAAAAABAAAAAAAAAAAAAAANQjAABPAAAAAEAAAOAC" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAGAAAAwAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAIAAACAAAAAAAAAAAAAAA" +
            "CCAAAEgAAAAAAAAAAAAAAC50ZXh0AAAALAQAAAAgAAAABgAAAAIAAAAAAAAAAAAAAAAAACAAAGAucnNyYwAAAOACAAAAQAAAAAQAAAAIAAAAAAAAAAAAAAAA" +
            "AABAAABALnJlbG9jAAAMAAAAAGAAAAACAAAADAAAAAAAAAAAAAAAAAAAQAAAQgAAAAAAAAAAAAAAAAAAAAAIJAAAAAAAAEgAAAACAAUAUCAAAAQDAAAJAAAA" +
            "AAAAAAAAAAAAAAAAVCMAAIAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAEJTSkIBAAEAAAAAAAwAAAB2NC4wLjMwMzE5AAAAAAUAbAAAALQA" +
            "AAAjfgAAIAEAAOQAAAAjU3RyaW5ncwAAAAAEAgAABAAAACNVUwAIAgAAEAAAACNHVUlEAAAAGAIAAOwAAAAjQmxvYgAAAAAAAAACAAABBxQAAAkAAAAA+gEz" +
            "ABYAAAEAAAAEAAAAAQAAAAMAAAADAAAAAQAAAAEAAAAAAH0AAQAAAAAABgA/ALIABgBfALIABgArAJ8ADwDSAAAAAAAAAAEAAAAAAAEAAQAJAJkAAQARAJkA" +
            "BgAZAJkACgAuAAsAuwAuABMAxAAuABsA4wAEgAAAAgAAAAAAAAABAAAAGQATAAAABAAAAAAAAAAAAAAAEAAKAAAAAAAAAAA8TW9kdWxlPgBtc2NvcmxpYgBT" +
            "aW1wbGVBc3NlbWJseVZlcnNpb25lZABEZWJ1Z2dhYmxlQXR0cmlidXRlAENvbXBpbGF0aW9uUmVsYXhhdGlvbnNBdHRyaWJ1dGUAUnVudGltZUNvbXBhdGli" +
            "aWxpdHlBdHRyaWJ1dGUAU2ltcGxlQXNzZW1ibHlWZXJzaW9uZWQuZGxsAC5jdG9yAFN5c3RlbS5EaWFnbm9zdGljcwBTeXN0ZW0uUnVudGltZS5Db21waWxl" +
            "clNlcnZpY2VzAERlYnVnZ2luZ01vZGVzAAAAAAAAAAB4jnS9GfpBQZ3GGgYZkH3cAAQgAQEIAyAAAQUgAQEREQi3elxWGTTgiYCgACQAAASAAACUAAAABgIA" +
            "AAAkAABSU0ExAAQAAAEAAQAdeo9xZn7ruiGEGhROr8g5Xr+vbRdw1l6o2V5884m1uLb0ffUsyItH7QUNhCVK9l/tCp/5HAa7rGoKA9QScqLBHsp68JEaxzr7" +
            "9b5lciuWeRsMfIdxsqkmyxPrkBoRR5PIdahl/OcqeEqGMQMCavpZeIvJVPNWO4GdkQUJGgWKnQgBAAgAAAAAAB4BAAEAVAIWV3JhcE5vbkV4Y2VwdGlvblRo" +
            "cm93cwEIAQAHAQAAAAA3DCuDcGQTfM35GVNSYnUkTmubHNEqySSEbm0cvNmprI79mAcRTteEvSRNGBURiQs9cp1/qZ7kYaPp8K3U5dIjTgfXJuoZMcKpgJ+N" +
            "vviWKxNqasz5OeqIIEmuyDtfi76dIlTOwcY7aWZKtyCzrUZlZI/eXgmR1+S75w429gzhdfwjAAAAAAAAAAAAABYkAAAAIAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAIJAAAAAAAAAAAAAAAAF9Db3JEbGxNYWluAG1zY29yZWUuZGxsAAAAAAD/JQAgABAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAEAEAAAABgA" +
            "AIAAAAAAAAAAAAAAAAAAAAEAAQAAADAAAIAAAAAAAAAAAAAAAAAAAAEAAAAAAEgAAABYQAAAhAIAAAAAAAAAAAAAhAI0AAAAVgBTAF8AVgBFAFIAUwBJAE8A" +
            "TgBfAEkATgBGAE8AAAAAAL0E7/4AAAEAAAACAAAAAAAAAAIAAAAAAD8AAAAAAAAABAAAAAIAAAAAAAAAAAAAAAAAAABEAAAAAQBWAGEAcgBGAGkAbABlAEkA" +
            "bgBmAG8AAAAAACQABAAAAFQAcgBhAG4AcwBsAGEAdABpAG8AbgAAAAAAAACwBOQBAAABAFMAdAByAGkAbgBnAEYAaQBsAGUASQBuAGYAbwAAAMABAAABADAA" +
            "MAAwADAAMAA0AGIAMAAAACwAAgABAEYAaQBsAGUARABlAHMAYwByAGkAcAB0AGkAbwBuAAAAAAAgAAAAMAAIAAEARgBpAGwAZQBWAGUAcgBzAGkAbwBuAAAA" +
            "AAAyAC4AMAAuADAALgAwAAAAWAAcAAEASQBuAHQAZQByAG4AYQBsAE4AYQBtAGUAAABTAGkAbQBwAGwAZQBBAHMAcwBlAG0AYgBsAHkAVgBlAHIAcwBpAG8A" +
            "bgBlAGQALgBkAGwAbAAAACgAAgABAEwAZQBnAGEAbABDAG8AcAB5AHIAaQBnAGgAdAAAACAAAABgABwAAQBPAHIAaQBnAGkAbgBhAGwARgBpAGwAZQBuAGEA" +
            "bQBlAAAAUwBpAG0AcABsAGUAQQBzAHMAZQBtAGIAbAB5AFYAZQByAHMAaQBvAG4AZQBkAC4AZABsAGwAAAA0AAgAAQBQAHIAbwBkAHUAYwB0AFYAZQByAHMA" +
            "aQBvAG4AAAAyAC4AMAAuADAALgAwAAAAOAAIAAEAQQBzAHMAZQBtAGIAbAB5ACAAVgBlAHIAcwBpAG8AbgAAADIALgAwAC4AMAAuADAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAACAAAAwAAAAoNAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA="
        );

        //// Metadata version: v4.0.30319
        //.assembly extern mscorlib
        //{
        //  .publickeytoken = (B7 7A 5C 56 19 34 E0 89 )                         // .z\V.4..
        //  .ver 4:0:0:0
        //}
        //.assembly SimpleAssemblyVersioned
        //    {
        //  .custom instance void [mscorlib]
        //        System.Runtime.CompilerServices.CompilationRelaxationsAttribute::.ctor(int32) = ( 01 00 08 00 00 00 00 00 )
        //  .custom instance void [mscorlib]
        //        System.Runtime.CompilerServices.RuntimeCompatibilityAttribute::.ctor() = ( 01 00 01 00 54 02 16 57 72 61 70 4E 6F 6E 45 78   // ....T..WrapNonEx
        //                                                                                                             63 65 70 74 69 6F 6E 54 68 72 6F 77 73 01 )       // ceptionThrows.

        //  // --- The following custom attribute is added automatically, do not uncomment -------
        //  //  .custom instance void [mscorlib]System.Diagnostics.DebuggableAttribute::.ctor(valuetype [mscorlib]System.Diagnostics.DebuggableAttribute/DebuggingModes) = ( 01 00 07 01 00 00 00 00 )

        //  .hash algorithm 0x00008004
        //  .ver 1:0:0:0
        //}
        //.module SimpleAssemblyVersioned.dll
        //// MVID: {5D75CBC1-81BF-4055-A9E2-8083D5B060C8}
        //.imagebase 0x10000000
        //.file alignment 0x00000200
        //.stackreserve 0x00100000
        //.subsystem 0x0003       // WINDOWS_CUI
        //.corflags 0x00000001    //  ILONLY
        //// Image base: 0x0EBE0000
        public static readonly string s_SimpleUnsignedVersioned100FullName = "SimpleAssemblyVersioned, Version=1.0.0.0, Culture=neutral, PublicKeyToken=null";
        public static readonly byte[] s_SimpleUnsignedVersioned100Image = Convert.FromBase64String(
            "TVqQAAMAAAAEAAAA//8AALgAAAAAAAAAQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAgAAAAA4fug4AtAnNIbgBTM0hVGhpcyBwcm9ncmFt" +
            "IGNhbm5vdCBiZSBydW4gaW4gRE9TIG1vZGUuDQ0KJAAAAAAAAABQRQAATAEDAGOW7VsAAAAAAAAAAOAAIiALATAAAAQAAAAGAAAAAAAABiMAAAAgAAAAQAAA" +
            "AAAAEAAgAAAAAgAABAAAAAAAAAAEAAAAAAAAAACAAAAAAgAAAAAAAAMAQIUAABAAABAAAAAAEAAAEAAAAAAAABAAAAAAAAAAAAAAALQiAABPAAAAAEAAAOAC" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAGAAAAwAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAIAAACAAAAAAAAAAAAAAA" +
            "CCAAAEgAAAAAAAAAAAAAAC50ZXh0AAAADAMAAAAgAAAABAAAAAIAAAAAAAAAAAAAAAAAACAAAGAucnNyYwAAAOACAAAAQAAAAAQAAAAGAAAAAAAAAAAAAAAA" +
            "AABAAABALnJlbG9jAAAMAAAAAGAAAAACAAAACgAAAAAAAAAAAAAAAAAAQAAAQgAAAAAAAAAAAAAAAAAAAADoIgAAAAAAAEgAAAACAAUAUCAAAGQCAAABAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAEJTSkIBAAEAAAAAAAwAAAB2NC4wLjMwMzE5AAAAAAUAbAAAALQA" +
            "AAAjfgAAIAEAAOQAAAAjU3RyaW5ncwAAAAAEAgAABAAAACNVUwAIAgAAEAAAACNHVUlEAAAAGAIAAEwAAAAjQmxvYgAAAAAAAAACAAABBxQAAAkAAAAA+gEz" +
            "ABYAAAEAAAAEAAAAAQAAAAMAAAADAAAAAQAAAAEAAAAAAH0AAQAAAAAABgA/ALIABgBfALIABgArAJ8ADwDSAAAAAAAAAAEAAAAAAAEAAQAJAJkAAQARAJkA" +
            "BgAZAJkACgAuAAsAGQAuABMAIgAuABsAQQAEgAAAAQAAAAAAAAAAAAAAAAATAAAABAAAAAAAAAAAAAAAEAAKAAAAAAAAAAA8TW9kdWxlPgBtc2NvcmxpYgBT" +
            "aW1wbGVBc3NlbWJseVZlcnNpb25lZABEZWJ1Z2dhYmxlQXR0cmlidXRlAENvbXBpbGF0aW9uUmVsYXhhdGlvbnNBdHRyaWJ1dGUAUnVudGltZUNvbXBhdGli" +
            "aWxpdHlBdHRyaWJ1dGUAU2ltcGxlQXNzZW1ibHlWZXJzaW9uZWQuZGxsAC5jdG9yAFN5c3RlbS5EaWFnbm9zdGljcwBTeXN0ZW0uUnVudGltZS5Db21waWxl" +
            "clNlcnZpY2VzAERlYnVnZ2luZ01vZGVzAAAAAAAAAADBy3Vdv4FVQKnigIPVsGDIAAQgAQEIAyAAAQUgAQEREQi3elxWGTTgiQgBAAgAAAAAAB4BAAEAVAIW" +
            "V3JhcE5vbkV4Y2VwdGlvblRocm93cwEIAQAHAQAAAAAAANwiAAAAAAAAAAAAAPYiAAAAIAAAAAAAAAAAAAAAAAAAAAAAAAAAAADoIgAAAAAAAAAAAAAAAF9D" +
            "b3JEbGxNYWluAG1zY29yZWUuZGxsAAAAAAD/JQAgABAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAABABAAAAAYAACAAAAAAAAAAAAAAAAAAAABAAEAAAAwAACAAAAAAAAAAAAAAAAAAAABAAAAAABIAAAAWEAAAIQCAAAAAAAA" +
            "AAAAAIQCNAAAAFYAUwBfAFYARQBSAFMASQBPAE4AXwBJAE4ARgBPAAAAAAC9BO/+AAABAAAAAQAAAAAAAAABAAAAAAA/AAAAAAAAAAQAAAACAAAAAAAAAAAA" +
            "AAAAAAAARAAAAAEAVgBhAHIARgBpAGwAZQBJAG4AZgBvAAAAAAAkAAQAAABUAHIAYQBuAHMAbABhAHQAaQBvAG4AAAAAAAAAsATkAQAAAQBTAHQAcgBpAG4A" +
            "ZwBGAGkAbABlAEkAbgBmAG8AAADAAQAAAQAwADAAMAAwADAANABiADAAAAAsAAIAAQBGAGkAbABlAEQAZQBzAGMAcgBpAHAAdABpAG8AbgAAAAAAIAAAADAA" +
            "CAABAEYAaQBsAGUAVgBlAHIAcwBpAG8AbgAAAAAAMQAuADAALgAwAC4AMAAAAFgAHAABAEkAbgB0AGUAcgBuAGEAbABOAGEAbQBlAAAAUwBpAG0AcABsAGUA" +
            "QQBzAHMAZQBtAGIAbAB5AFYAZQByAHMAaQBvAG4AZQBkAC4AZABsAGwAAAAoAAIAAQBMAGUAZwBhAGwAQwBvAHAAeQByAGkAZwBoAHQAAAAgAAAAYAAcAAEA" +
            "TwByAGkAZwBpAG4AYQBsAEYAaQBsAGUAbgBhAG0AZQAAAFMAaQBtAHAAbABlAEEAcwBzAGUAbQBiAGwAeQBWAGUAcgBzAGkAbwBuAGUAZAAuAGQAbABsAAAA" +
            "NAAIAAEAUAByAG8AZAB1AGMAdABWAGUAcgBzAGkAbwBuAAAAMQAuADAALgAwAC4AMAAAADgACAABAEEAcwBzAGUAbQBiAGwAeQAgAFYAZQByAHMAaQBvAG4A" +
            "AAAxAC4AMAAuADAALgAwAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAgAAAMAAAACDMAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAA"
        );

        //// Metadata version: v4.0.30319
        //.assembly extern mscorlib
        //{
        //  .publickeytoken = (B7 7A 5C 56 19 34 E0 89 )                         // .z\V.4..
        //  .ver 4:0:0:0
        //}
        //.assembly SimpleAssemblyVersioned
        //    {
        //  .custom instance void [mscorlib]
        //        System.Runtime.CompilerServices.CompilationRelaxationsAttribute::.ctor(int32) = ( 01 00 08 00 00 00 00 00 )
        //  .custom instance void [mscorlib]
        //        System.Runtime.CompilerServices.RuntimeCompatibilityAttribute::.ctor() = ( 01 00 01 00 54 02 16 57 72 61 70 4E 6F 6E 45 78   // ....T..WrapNonEx
        //                                                                                                             63 65 70 74 69 6F 6E 54 68 72 6F 77 73 01 )       // ceptionThrows.

        //  // --- The following custom attribute is added automatically, do not uncomment -------
        //  //  .custom instance void [mscorlib]System.Diagnostics.DebuggableAttribute::.ctor(valuetype [mscorlib]System.Diagnostics.DebuggableAttribute/DebuggingModes) = ( 01 00 07 01 00 00 00 00 )

        //  .hash algorithm 0x00008004
        //  .ver 1:0:0:0
        //  .locale = (65 00 6E 00 00 00 )                               // e.n...
        //}
        //.module SimpleAssemblyVersioned.dll
        //// MVID: {228A5B84-2F88-451D-BA6A-34F4384B1B77}
        //.imagebase 0x10000000
        //.file alignment 0x00000200
        //.stackreserve 0x00100000
        //.subsystem 0x0003       // WINDOWS_CUI
        //.corflags 0x00000001    //  ILONLY
        //// Image base: 0x0F010000
        public static readonly string s_SimpleUnsignedVersioned100EnFullName = "SimpleAssemblyVersioned, Version=1.0.0.0, Culture=en, PublicKeyToken=null";
        public static readonly byte[] s_SimpleUnsignedVersioned100EnImage = Convert.FromBase64String(
            "TVqQAAMAAAAEAAAA//8AALgAAAAAAAAAQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAgAAAAA4fug4AtAnNIbgBTM0hVGhpcyBwcm9ncmFt" +
            "IGNhbm5vdCBiZSBydW4gaW4gRE9TIG1vZGUuDQ0KJAAAAAAAAABQRQAATAEDAKKY7VsAAAAAAAAAAOAAIiALATAAAAYAAAAGAAAAAAAAJiQAAAAgAAAAQAAA" +
            "AAAAEAAgAAAAAgAABAAAAAAAAAAEAAAAAAAAAACAAAAAAgAAj8gAAAMAQIUAABAAABAAAAAAEAAAEAAAAAAAABAAAAAAAAAAAAAAANQjAABPAAAAAEAAAOAC" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAGAAAAwAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAIAAACAAAAAAAAAAAAAAA" +
            "CCAAAEgAAAAAAAAAAAAAAC50ZXh0AAAALAQAAAAgAAAABgAAAAIAAAAAAAAAAAAAAAAAACAAAGAucnNyYwAAAOACAAAAQAAAAAQAAAAIAAAAAAAAAAAAAAAA" +
            "AABAAABALnJlbG9jAAAMAAAAAGAAAAACAAAADAAAAAAAAAAAAAAAAAAAQAAAQgAAAAAAAAAAAAAAAAAAAAAIJAAAAAAAAEgAAAACAAUAUCAAAAQDAAAJAAAA" +
            "AAAAAAAAAAAAAAAAVCMAAIAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAEJTSkIBAAEAAAAAAAwAAAB2NC4wLjMwMzE5AAAAAAUAbAAAALQA" +
            "AAAjfgAAIAEAAOQAAAAjU3RyaW5ncwAAAAAEAgAABAAAACNVUwAIAgAAEAAAACNHVUlEAAAAGAIAAOwAAAAjQmxvYgAAAAAAAAACAAABBxQAAAkAAAAA+gEz" +
            "ABYAAAEAAAAEAAAAAQAAAAMAAAADAAAAAQAAAAEAAAAAAH0AAQAAAAAABgA/ALIABgBfALIABgArAJ8ADwDSAAAAAAAAAAEAAAAAAAEAAQAJAJkAAQARAJkA" +
            "BgAZAJkACgAuAAsAuwAuABMAxAAuABsA4wAEgAAAAgAAAAAAAAABAAAAGQATAAAABAAAAAAAAAAAAAAAEAAKAAAAAAAAAAA8TW9kdWxlPgBtc2NvcmxpYgBT" +
            "aW1wbGVBc3NlbWJseVZlcnNpb25lZABEZWJ1Z2dhYmxlQXR0cmlidXRlAENvbXBpbGF0aW9uUmVsYXhhdGlvbnNBdHRyaWJ1dGUAUnVudGltZUNvbXBhdGli" +
            "aWxpdHlBdHRyaWJ1dGUAU2ltcGxlQXNzZW1ibHlWZXJzaW9uZWQuZGxsAC5jdG9yAFN5c3RlbS5EaWFnbm9zdGljcwBTeXN0ZW0uUnVudGltZS5Db21waWxl" +
            "clNlcnZpY2VzAERlYnVnZ2luZ01vZGVzAAAAAAAAAAB4jnS9GfpBQZ3GGgYZkH3cAAQgAQEIAyAAAQUgAQEREQi3elxWGTTgiYCgACQAAASAAACUAAAABgIA" +
            "AAAkAABSU0ExAAQAAAEAAQAdeo9xZn7ruiGEGhROr8g5Xr+vbRdw1l6o2V5884m1uLb0ffUsyItH7QUNhCVK9l/tCp/5HAa7rGoKA9QScqLBHsp68JEaxzr7" +
            "9b5lciuWeRsMfIdxsqkmyxPrkBoRR5PIdahl/OcqeEqGMQMCavpZeIvJVPNWO4GdkQUJGgWKnQgBAAgAAAAAAB4BAAEAVAIWV3JhcE5vbkV4Y2VwdGlvblRo" +
            "cm93cwEIAQAHAQAAAAA3DCuDcGQTfM35GVNSYnUkTmubHNEqySSEbm0cvNmprI79mAcRTteEvSRNGBURiQs9cp1/qZ7kYaPp8K3U5dIjTgfXJuoZMcKpgJ+N" +
            "vviWKxNqasz5OeqIIEmuyDtfi76dIlTOwcY7aWZKtyCzrUZlZI/eXgmR1+S75w429gzhdfwjAAAAAAAAAAAAABYkAAAAIAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAIJAAAAAAAAAAAAAAAAF9Db3JEbGxNYWluAG1zY29yZWUuZGxsAAAAAAD/JQAgABAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAEAEAAAABgA" +
            "AIAAAAAAAAAAAAAAAAAAAAEAAQAAADAAAIAAAAAAAAAAAAAAAAAAAAEAAAAAAEgAAABYQAAAhAIAAAAAAAAAAAAAhAI0AAAAVgBTAF8AVgBFAFIAUwBJAE8A" +
            "TgBfAEkATgBGAE8AAAAAAL0E7/4AAAEAAAACAAAAAAAAAAIAAAAAAD8AAAAAAAAABAAAAAIAAAAAAAAAAAAAAAAAAABEAAAAAQBWAGEAcgBGAGkAbABlAEkA" +
            "bgBmAG8AAAAAACQABAAAAFQAcgBhAG4AcwBsAGEAdABpAG8AbgAAAAAAAACwBOQBAAABAFMAdAByAGkAbgBnAEYAaQBsAGUASQBuAGYAbwAAAMABAAABADAA" +
            "MAAwADAAMAA0AGIAMAAAACwAAgABAEYAaQBsAGUARABlAHMAYwByAGkAcAB0AGkAbwBuAAAAAAAgAAAAMAAIAAEARgBpAGwAZQBWAGUAcgBzAGkAbwBuAAAA" +
            "AAAyAC4AMAAuADAALgAwAAAAWAAcAAEASQBuAHQAZQByAG4AYQBsAE4AYQBtAGUAAABTAGkAbQBwAGwAZQBBAHMAcwBlAG0AYgBsAHkAVgBlAHIAcwBpAG8A" +
            "bgBlAGQALgBkAGwAbAAAACgAAgABAEwAZQBnAGEAbABDAG8AcAB5AHIAaQBnAGgAdAAAACAAAABgABwAAQBPAHIAaQBnAGkAbgBhAGwARgBpAGwAZQBuAGEA" +
            "bQBlAAAAUwBpAG0AcABsAGUAQQBzAHMAZQBtAGIAbAB5AFYAZQByAHMAaQBvAG4AZQBkAC4AZABsAGwAAAA0AAgAAQBQAHIAbwBkAHUAYwB0AFYAZQByAHMA" +
            "aQBvAG4AAAAyAC4AMAAuADAALgAwAAAAOAAIAAEAQQBzAHMAZQBtAGIAbAB5ACAAVgBlAHIAcwBpAG8AbgAAADIALgAwAC4AMAAuADAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAACAAAAwAAAAoNAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA="
        );

        //// Metadata version: v4.0.30319
        //.assembly extern mscorlib
        //{
        //  .publickeytoken = (B7 7A 5C 56 19 34 E0 89 )                         // .z\V.4..
        //  .ver 4:0:0:0
        //}
        //.assembly SimpleAssemblyVersioned
        //    {
        //  .custom instance void [mscorlib]
        //        System.Runtime.CompilerServices.CompilationRelaxationsAttribute::.ctor(int32) = ( 01 00 08 00 00 00 00 00 )
        //  .custom instance void [mscorlib]
        //        System.Runtime.CompilerServices.RuntimeCompatibilityAttribute::.ctor() = ( 01 00 01 00 54 02 16 57 72 61 70 4E 6F 6E 45 78   // ....T..WrapNonEx
        //                                                                                                             63 65 70 74 69 6F 6E 54 68 72 6F 77 73 01 )       // ceptionThrows.

        //  // --- The following custom attribute is added automatically, do not uncomment -------
        //  //  .custom instance void [mscorlib]System.Diagnostics.DebuggableAttribute::.ctor(valuetype [mscorlib]System.Diagnostics.DebuggableAttribute/DebuggingModes) = ( 01 00 07 01 00 00 00 00 )

        //  .hash algorithm 0x00008004
        //  .ver 2:0:0:0
        //}
        //.module SimpleAssemblyVersioned.dll
        //// MVID: {143B330C-1F34-4F50-80C1-E7FE74148029}
        //.imagebase 0x10000000
        //.file alignment 0x00000200
        //.stackreserve 0x00100000
        //.subsystem 0x0003       // WINDOWS_CUI
        //.corflags 0x00000001    //  ILONLY
        //// Image base: 0x07500000
        public static readonly string s_SimpleUnsignedVersioned200FullName = "SimpleAssemblyVersioned, Version=2.0.0.0, Culture=neutral, PublicKeyToken=null";
        public static readonly byte[] s_SimpleUnsignedVersioned200Image = Convert.FromBase64String(
            "TVqQAAMAAAAEAAAA//8AALgAAAAAAAAAQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAgAAAAA4fug4AtAnNIbgBTM0hVGhpcyBwcm9ncmFt" +
            "IGNhbm5vdCBiZSBydW4gaW4gRE9TIG1vZGUuDQ0KJAAAAAAAAABQRQAATAEDAGOV7VsAAAAAAAAAAOAAIiALATAAAAQAAAAGAAAAAAAABiMAAAAgAAAAQAAA" +
            "AAAAEAAgAAAAAgAABAAAAAAAAAAEAAAAAAAAAACAAAAAAgAAAAAAAAMAQIUAABAAABAAAAAAEAAAEAAAAAAAABAAAAAAAAAAAAAAALQiAABPAAAAAEAAAOAC" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAGAAAAwAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAIAAACAAAAAAAAAAAAAAA" +
            "CCAAAEgAAAAAAAAAAAAAAC50ZXh0AAAADAMAAAAgAAAABAAAAAIAAAAAAAAAAAAAAAAAACAAAGAucnNyYwAAAOACAAAAQAAAAAQAAAAGAAAAAAAAAAAAAAAA" +
            "AABAAABALnJlbG9jAAAMAAAAAGAAAAACAAAACgAAAAAAAAAAAAAAAAAAQAAAQgAAAAAAAAAAAAAAAAAAAADoIgAAAAAAAEgAAAACAAUAUCAAAGQCAAABAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAEJTSkIBAAEAAAAAAAwAAAB2NC4wLjMwMzE5AAAAAAUAbAAAALQA" +
            "AAAjfgAAIAEAAOQAAAAjU3RyaW5ncwAAAAAEAgAABAAAACNVUwAIAgAAEAAAACNHVUlEAAAAGAIAAEwAAAAjQmxvYgAAAAAAAAACAAABBxQAAAkAAAAA+gEz" +
            "ABYAAAEAAAAEAAAAAQAAAAMAAAADAAAAAQAAAAEAAAAAAH0AAQAAAAAABgA/ALIABgBfALIABgArAJ8ADwDSAAAAAAAAAAEAAAAAAAEAAQAJAJkAAQARAJkA" +
            "BgAZAJkACgAuAAsAGQAuABMAIgAuABsAQQAEgAAAAgAAAAAAAAAAAAAAAAATAAAABAAAAAAAAAAAAAAAEAAKAAAAAAAAAAA8TW9kdWxlPgBtc2NvcmxpYgBT" +
            "aW1wbGVBc3NlbWJseVZlcnNpb25lZABEZWJ1Z2dhYmxlQXR0cmlidXRlAENvbXBpbGF0aW9uUmVsYXhhdGlvbnNBdHRyaWJ1dGUAUnVudGltZUNvbXBhdGli" +
            "aWxpdHlBdHRyaWJ1dGUAU2ltcGxlQXNzZW1ibHlWZXJzaW9uZWQuZGxsAC5jdG9yAFN5c3RlbS5EaWFnbm9zdGljcwBTeXN0ZW0uUnVudGltZS5Db21waWxl" +
            "clNlcnZpY2VzAERlYnVnZ2luZ01vZGVzAAAAAAAAAAAMMzsUNB9QT4DB5/50FIApAAQgAQEIAyAAAQUgAQEREQi3elxWGTTgiQgBAAgAAAAAAB4BAAEAVAIW" +
            "V3JhcE5vbkV4Y2VwdGlvblRocm93cwEIAQAHAQAAAAAAANwiAAAAAAAAAAAAAPYiAAAAIAAAAAAAAAAAAAAAAAAAAAAAAAAAAADoIgAAAAAAAAAAAAAAAF9D" +
            "b3JEbGxNYWluAG1zY29yZWUuZGxsAAAAAAD/JQAgABAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAABABAAAAAYAACAAAAAAAAAAAAAAAAAAAABAAEAAAAwAACAAAAAAAAAAAAAAAAAAAABAAAAAABIAAAAWEAAAIQCAAAAAAAA" +
            "AAAAAIQCNAAAAFYAUwBfAFYARQBSAFMASQBPAE4AXwBJAE4ARgBPAAAAAAC9BO/+AAABAAAAAgAAAAAAAAACAAAAAAA/AAAAAAAAAAQAAAACAAAAAAAAAAAA" +
            "AAAAAAAARAAAAAEAVgBhAHIARgBpAGwAZQBJAG4AZgBvAAAAAAAkAAQAAABUAHIAYQBuAHMAbABhAHQAaQBvAG4AAAAAAAAAsATkAQAAAQBTAHQAcgBpAG4A" +
            "ZwBGAGkAbABlAEkAbgBmAG8AAADAAQAAAQAwADAAMAAwADAANABiADAAAAAsAAIAAQBGAGkAbABlAEQAZQBzAGMAcgBpAHAAdABpAG8AbgAAAAAAIAAAADAA" +
            "CAABAEYAaQBsAGUAVgBlAHIAcwBpAG8AbgAAAAAAMgAuADAALgAwAC4AMAAAAFgAHAABAEkAbgB0AGUAcgBuAGEAbABOAGEAbQBlAAAAUwBpAG0AcABsAGUA" +
            "QQBzAHMAZQBtAGIAbAB5AFYAZQByAHMAaQBvAG4AZQBkAC4AZABsAGwAAAAoAAIAAQBMAGUAZwBhAGwAQwBvAHAAeQByAGkAZwBoAHQAAAAgAAAAYAAcAAEA" +
            "TwByAGkAZwBpAG4AYQBsAEYAaQBsAGUAbgBhAG0AZQAAAFMAaQBtAHAAbABlAEEAcwBzAGUAbQBiAGwAeQBWAGUAcgBzAGkAbwBuAGUAZAAuAGQAbABsAAAA" +
            "NAAIAAEAUAByAG8AZAB1AGMAdABWAGUAcgBzAGkAbwBuAAAAMgAuADAALgAwAC4AMAAAADgACAABAEEAcwBzAGUAbQBiAGwAeQAgAFYAZQByAHMAaQBvAG4A" +
            "AAAyAC4AMAAuADAALgAwAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAgAAAMAAAACDMAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAA"
        );

        //// Metadata version: v4.0.30319
        //.assembly extern retargetable mscorlib
        //        {
        //  .publickeytoken = (7C EC 85 D7 BE A7 79 8E )                         // |.....y.
        //  .ver 2:0:5:0
        //}
        //.assembly SimpleAssembly
        //    {
        //  .custom instance void [mscorlib]
        //        System.Runtime.CompilerServices.CompilationRelaxationsAttribute::.ctor(int32) = ( 01 00 08 00 00 00 00 00 ) 
        //  .custom instance void [mscorlib]
        //        System.Runtime.CompilerServices.RuntimeCompatibilityAttribute::.ctor() = ( 01 00 01 00 54 02 16 57 72 61 70 4E 6F 6E 45 78   // ....T..WrapNonEx
        //                                                                                                             63 65 70 74 69 6F 6E 54 68 72 6F 77 73 01 )       // ceptionThrows.
        //  // --- The following custom attribute is added automatically, do not uncomment -------
        //  //  .custom instance void [mscorlib]System.Diagnostics.DebuggableAttribute::.ctor(valuetype [mscorlib]System.Diagnostics.DebuggableAttribute/DebuggingModes) = ( 01 00 07 01 00 00 00 00 ) 
        //  .hash algorithm 0x00008004
        //  .ver 0:0:0:0
        //}
        //.module SimpleAssembly.dll
        //// MVID: {DCD1E0C4-4B2E-4E02-952F-DA6B0600F478}
        //.imagebase 0x10000000
        //.file alignment 0x00000200
        //.stackreserve 0x00100000
        //.subsystem 0x0003       // WINDOWS_CUI
        //.corflags 0x00000001    //  ILONLY
        //// Image base: 0x03550000
        public static readonly string s_RetargetableAssemblySimpleName = "SimpleAssembly";
        public static readonly byte[] s_RetargetableImage = Convert.FromBase64String(
            "TVqQAAMAAAAEAAAA//8AALgAAAAAAAAAQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAgAAAAA4fug4AtAnNIbgBTM0hVGhpcyBwcm9ncmFt" +
            "IGNhbm5vdCBiZSBydW4gaW4gRE9TIG1vZGUuDQ0KJAAAAAAAAABQRQAATAEDAP1PYF0AAAAAAAAAAOAAIiALATAAAAQAAAAGAAAAAAAAfiMAAAAgAAAAQAAA" +
            "AAAAEAAgAAAAAgAABAAAAAAAAAAEAAAAAAAAAACAAAAAAgAAAAAAAAMAQIUAABAAABAAAAAAEAAAEAAAAAAAABAAAAAAAAAAAAAAACwjAABPAAAAAEAAAMAC" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAGAAAAwAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAIAAACAAAAAAAAAAAAAAA" +
            "CCAAAEgAAAAAAAAAAAAAAC50ZXh0AAAAhAMAAAAgAAAABAAAAAIAAAAAAAAAAAAAAAAAACAAAGAucnNyYwAAAMACAAAAQAAAAAQAAAAGAAAAAAAAAAAAAAAA" +
            "AABAAABALnJlbG9jAAAMAAAAAGAAAAACAAAACgAAAAAAAAAAAAAAAAAAQAAAQgAAAAAAAAAAAAAAAAAAAABgIwAAAAAAAEgAAAACAAUAXCAAANACAAABAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACICKAQAAAoAKgAAAEJTSkIBAAEAAAAAAAwAAAB2NC4wLjMwMzE5" +
            "AAAAAAUAbAAAAPAAAAAjfgAAXAEAABABAAAjU3RyaW5ncwAAAABsAgAABAAAACNVUwBwAgAAEAAAACNHVUlEAAAAgAIAAFAAAAAjQmxvYgAAAAAAAAACAAAB" +
            "VxQAAAkAAAAA+gEzABYAAAEAAAAGAAAAAgAAAAEAAAABAAAABAAAAAMAAAABAAAAAQAAAAAAdAABAAAAAAAGADAApwAGAFAApwAGABwAlAAPAMcAAAAGAPEA" +
            "hwAGAPgA1gAAAAAAAQAAAAAAAQABAAEAEADpABMAFQABAAEAFgBuABkAUCAAAAAAhhiOAAYAAQAJAI4AAQARAI4ABgAZAI4ACgApAI4ABgAuAAsAHQAuABMA" +
            "JgAuABsARQAEgAAAAAAAAAAAAAAAAAAAAAABAQAAAgAAAAUAAAAAAQAAEAAKAAAAAAAAAAA8TW9kdWxlPgBtc2NvcmxpYgBSZWxvY2F0ZQBEZWJ1Z2dhYmxl" +
            "QXR0cmlidXRlAENvbXBpbGF0aW9uUmVsYXhhdGlvbnNBdHRyaWJ1dGUAUnVudGltZUNvbXBhdGliaWxpdHlBdHRyaWJ1dGUATXlPYmoAU2ltcGxlQXNzZW1i" +
            "bHkuZGxsAFN5c3RlbQAuY3RvcgBTeXN0ZW0uRGlhZ25vc3RpY3MAU3lzdGVtLlJ1bnRpbWUuQ29tcGlsZXJTZXJ2aWNlcwBEZWJ1Z2dpbmdNb2RlcwBTeXN0" +
            "ZW0uQ29sbGVjdGlvbnMATXlDbGFzcwBPYmplY3QAQml0QXJyYXkAU2ltcGxlQXNzZW1ibHkAAAAAAMTg0dwuSwJOlS/aawYA9HgABCABAQgDIAABBSABARER" +
            "CHzshde+p3mOAwYSGQgBAAgAAAAAAB4BAAEAVAIWV3JhcE5vbkV4Y2VwdGlvblRocm93cwEIAQAHAQAAAAAAAFQjAAAAAAAAAAAAAG4jAAAAIAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAABgIwAAAAAAAAAAAAAAAF9Db3JEbGxNYWluAG1zY29yZWUuZGxsAAAAAAD/JQAgABAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAABABAAAAAYAACAAAAAAAAAAAAAAAAAAAABAAEAAAAwAACAAAAAAAAAAAAAAAAAAAABAAAAAABIAAAAWEAAAGQCAAAAAAAA" +
            "AAAAAGQCNAAAAFYAUwBfAFYARQBSAFMASQBPAE4AXwBJAE4ARgBPAAAAAAC9BO/+AAABAAAAAAAAAAAAAAAAAAAAAAA/AAAAAAAAAAQAAAACAAAAAAAAAAAA" +
            "AAAAAAAARAAAAAEAVgBhAHIARgBpAGwAZQBJAG4AZgBvAAAAAAAkAAQAAABUAHIAYQBuAHMAbABhAHQAaQBvAG4AAAAAAAAAsATEAQAAAQBTAHQAcgBpAG4A" +
            "ZwBGAGkAbABlAEkAbgBmAG8AAACgAQAAAQAwADAAMAAwADAANABiADAAAAAsAAIAAQBGAGkAbABlAEQAZQBzAGMAcgBpAHAAdABpAG8AbgAAAAAAIAAAADAA" +
            "CAABAEYAaQBsAGUAVgBlAHIAcwBpAG8AbgAAAAAAMAAuADAALgAwAC4AMAAAAEYAEwABAEkAbgB0AGUAcgBuAGEAbABOAGEAbQBlAAAAUwBpAG0AcABsAGUA" +
            "QQBzAHMAZQBtAGIAbAB5AC4AZABsAGwAAAAAACgAAgABAEwAZQBnAGEAbABDAG8AcAB5AHIAaQBnAGgAdAAAACAAAABOABMAAQBPAHIAaQBnAGkAbgBhAGwA" +
            "RgBpAGwAZQBuAGEAbQBlAAAAUwBpAG0AcABsAGUAQQBzAHMAZQBtAGIAbAB5AC4AZABsAGwAAAAAADQACAABAFAAcgBvAGQAdQBjAHQAVgBlAHIAcwBpAG8A" +
            "bgAAADAALgAwAC4AMAAuADAAAAA4AAgAAQBBAHMAcwBlAG0AYgBsAHkAIABWAGUAcgBzAGkAbwBuAAAAMAAuADAALgAwAC4AMAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAgAAAMAAAAgDMAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
            "AAAAAAAAAAAAAAAA");
    }
}
