// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.

namespace System.Drawing.Text
{
    /// <summary>
    /// Specifies the type of display for hotkey prefixes for text.
    /// </summary>
    public enum HotkeyPrefix
    {
        /// <summary>
        /// No hotkey prefix.
        /// </summary>
        None = 0,

        /// <summary>
        /// Display the hotkey prefix.
        /// </summary>
        Show = 1,

        /// <summary>
        /// Do not display the hotkey prefix.
        /// </summary>
        Hide = 2
    }
}
