# System.Net.Security

``` diff
 namespace System.Net.Security {
+    public abstract class AuthenticatedStream : Stream {
+        protected AuthenticatedStream(Stream innerStream, bool leaveInnerStreamOpen);
+        protected Stream InnerStream { get; }
+        public abstract bool IsAuthenticated { get; }
+        public abstract bool IsEncrypted { get; }
+        public abstract bool IsMutuallyAuthenticated { get; }
+        public abstract bool IsServer { get; }
+        public abstract bool IsSigned { get; }
+        public bool LeaveInnerStreamOpen { get; }
+        protected override void Dispose(bool disposing);
+    }
+    public enum EncryptionPolicy {
+        AllowNoEncryption = 1,
+        NoEncryption = 2,
+        RequireEncryption = 0,
+    }
+    public delegate X509Certificate LocalCertificateSelectionCallback(object sender, string targetHost, X509CertificateCollection localCertificates, X509Certificate remoteCertificate, string[] acceptableIssuers);
+    public class NegotiateStream : AuthenticatedStream {
+        public NegotiateStream(Stream innerStream);
+        public NegotiateStream(Stream innerStream, bool leaveInnerStreamOpen);
+        public override bool CanRead { get; }
+        public override bool CanSeek { get; }
+        public override bool CanTimeout { get; }
+        public override bool CanWrite { get; }
+        public virtual TokenImpersonationLevel ImpersonationLevel { get; }
+        public override bool IsAuthenticated { get; }
+        public override bool IsEncrypted { get; }
+        public override bool IsMutuallyAuthenticated { get; }
+        public override bool IsServer { get; }
+        public override bool IsSigned { get; }
+        public override long Length { get; }
+        public override long Position { get; set; }
+        public override int ReadTimeout { get; set; }
+        public virtual IIdentity RemoteIdentity { get; }
+        public override int WriteTimeout { get; set; }
+        public virtual Task AuthenticateAsClientAsync();
+        public virtual Task AuthenticateAsClientAsync(NetworkCredential credential, ChannelBinding binding, string targetName);
+        public virtual Task AuthenticateAsClientAsync(NetworkCredential credential, ChannelBinding binding, string targetName, ProtectionLevel requiredProtectionLevel, TokenImpersonationLevel allowedImpersonationLevel);
+        public virtual Task AuthenticateAsClientAsync(NetworkCredential credential, string targetName);
+        public virtual Task AuthenticateAsClientAsync(NetworkCredential credential, string targetName, ProtectionLevel requiredProtectionLevel, TokenImpersonationLevel allowedImpersonationLevel);
+        public virtual Task AuthenticateAsServerAsync();
+        public virtual Task AuthenticateAsServerAsync(NetworkCredential credential, ProtectionLevel requiredProtectionLevel, TokenImpersonationLevel requiredImpersonationLevel);
+        public virtual Task AuthenticateAsServerAsync(NetworkCredential credential, ExtendedProtectionPolicy policy, ProtectionLevel requiredProtectionLevel, TokenImpersonationLevel requiredImpersonationLevel);
+        public virtual Task AuthenticateAsServerAsync(ExtendedProtectionPolicy policy);
+        public override void Flush();
+        public override int Read(byte[] buffer, int offset, int count);
+        public override long Seek(long offset, SeekOrigin origin);
+        public override void SetLength(long value);
+        public override void Write(byte[] buffer, int offset, int count);
+    }
+    public enum ProtectionLevel {
+        EncryptAndSign = 2,
+        None = 0,
+        Sign = 1,
+    }
+    public delegate bool RemoteCertificateValidationCallback(object sender, X509Certificate certificate, X509Chain chain, SslPolicyErrors sslPolicyErrors);
+    public class SslStream : AuthenticatedStream {
+        public SslStream(Stream innerStream);
+        public SslStream(Stream innerStream, bool leaveInnerStreamOpen);
+        public SslStream(Stream innerStream, bool leaveInnerStreamOpen, RemoteCertificateValidationCallback userCertificateValidationCallback);
+        public SslStream(Stream innerStream, bool leaveInnerStreamOpen, RemoteCertificateValidationCallback userCertificateValidationCallback, LocalCertificateSelectionCallback userCertificateSelectionCallback);
+        public SslStream(Stream innerStream, bool leaveInnerStreamOpen, RemoteCertificateValidationCallback userCertificateValidationCallback, LocalCertificateSelectionCallback userCertificateSelectionCallback, EncryptionPolicy encryptionPolicy);
+        public override bool CanRead { get; }
+        public override bool CanSeek { get; }
+        public override bool CanTimeout { get; }
+        public override bool CanWrite { get; }
+        public virtual bool CheckCertRevocationStatus { get; }
+        public virtual CipherAlgorithmType CipherAlgorithm { get; }
+        public virtual int CipherStrength { get; }
+        public virtual HashAlgorithmType HashAlgorithm { get; }
+        public virtual int HashStrength { get; }
+        public override bool IsAuthenticated { get; }
+        public override bool IsEncrypted { get; }
+        public override bool IsMutuallyAuthenticated { get; }
+        public override bool IsServer { get; }
+        public override bool IsSigned { get; }
+        public virtual ExchangeAlgorithmType KeyExchangeAlgorithm { get; }
+        public virtual int KeyExchangeStrength { get; }
+        public override long Length { get; }
+        public virtual X509Certificate LocalCertificate { get; }
+        public override long Position { get; set; }
+        public override int ReadTimeout { get; set; }
+        public virtual X509Certificate RemoteCertificate { get; }
+        public virtual SslProtocols SslProtocol { get; }
+        public TransportContext TransportContext { get; }
+        public override int WriteTimeout { get; set; }
+        public virtual Task AuthenticateAsClientAsync(string targetHost);
+        public virtual Task AuthenticateAsClientAsync(string targetHost, X509CertificateCollection clientCertificates, SslProtocols enabledSslProtocols, bool checkCertificateRevocation);
+        public virtual Task AuthenticateAsServerAsync(X509Certificate serverCertificate);
+        public virtual Task AuthenticateAsServerAsync(X509Certificate serverCertificate, bool clientCertificateRequired, SslProtocols enabledSslProtocols, bool checkCertificateRevocation);
+        public override void Flush();
+        public override int Read(byte[] buffer, int offset, int count);
+        public override long Seek(long offset, SeekOrigin origin);
+        public override void SetLength(long value);
+        public void Write(byte[] buffer);
+        public override void Write(byte[] buffer, int offset, int count);
+    }
 }
```

