namespace System.Management
{
    public enum AuthenticationLevel
    {
        Unchanged = -1,
        Default = 0,
        None = 1,
        Connect = 2,
        Call = 3,
        Packet = 4,
        PacketIntegrity = 5,
        PacketPrivacy = 6,
    }
    public enum CimType
    {
        None = 0,
        SInt16 = 2,
        SInt32 = 3,
        Real32 = 4,
        Real64 = 5,
        String = 8,
        Boolean = 11,
        Object = 13,
        SInt8 = 16,
        UInt8 = 17,
        UInt16 = 18,
        UInt32 = 19,
        SInt64 = 20,
        UInt64 = 21,
        DateTime = 101,
        Reference = 102,
        Char16 = 103,
    }
    public enum CodeLanguage
    {
        CSharp = 0,
        JScript = 1,
        VB = 2,
        VJSharp = 3,
        Mcpp = 4,
    }
    [System.FlagsAttribute]
    public enum ComparisonSettings
    {
        IncludeAll = 0,
        IgnoreQualifiers = 1,
        IgnoreObjectSource = 2,
        IgnoreDefaultValues = 4,
        IgnoreClass = 8,
        IgnoreCase = 16,
        IgnoreFlavor = 32,
    }
    public partial class CompletedEventArgs : System.Management.ManagementEventArgs
    {
        internal CompletedEventArgs() { }
        public System.Management.ManagementStatus Status { get { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } }
        public System.Management.ManagementBaseObject StatusObject { get { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } }
    }
    public delegate void CompletedEventHandler(object sender, System.Management.CompletedEventArgs e);
    public partial class ConnectionOptions : System.Management.ManagementOptions
    {
        public ConnectionOptions() { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public ConnectionOptions(string locale, string username, System.Security.SecureString password, string authority, System.Management.ImpersonationLevel impersonation, System.Management.AuthenticationLevel authentication, bool enablePrivileges, System.Management.ManagementNamedValueCollection context, System.TimeSpan timeout) { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public ConnectionOptions(string locale, string username, string password, string authority, System.Management.ImpersonationLevel impersonation, System.Management.AuthenticationLevel authentication, bool enablePrivileges, System.Management.ManagementNamedValueCollection context, System.TimeSpan timeout) { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public System.Management.AuthenticationLevel Authentication { get { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } set { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } }
        public string Authority { get { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } set { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } }
        public bool EnablePrivileges { get { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } set { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } }
        public System.Management.ImpersonationLevel Impersonation { get { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } set { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } }
        public string Locale { get { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } set { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } }
        public string Password { set { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } }
        public System.Security.SecureString SecurePassword { set { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } }
        public string Username { get { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } set { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } }
        public override object Clone() { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
    }
    public partial class DeleteOptions : System.Management.ManagementOptions
    {
        public DeleteOptions() { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public DeleteOptions(System.Management.ManagementNamedValueCollection context, System.TimeSpan timeout) { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public override object Clone() { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
    }
    public partial class EnumerationOptions : System.Management.ManagementOptions
    {
        public EnumerationOptions() { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public EnumerationOptions(System.Management.ManagementNamedValueCollection context, System.TimeSpan timeout, int blockSize, bool rewindable, bool returnImmediatley, bool useAmendedQualifiers, bool ensureLocatable, bool prototypeOnly, bool directRead, bool enumerateDeep) { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public int BlockSize { get { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } set { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } }
        public bool DirectRead { get { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } set { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } }
        public bool EnsureLocatable { get { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } set { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } }
        public bool EnumerateDeep { get { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } set { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } }
        public bool PrototypeOnly { get { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } set { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } }
        public bool ReturnImmediately { get { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } set { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } }
        public bool Rewindable { get { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } set { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } }
        public bool UseAmendedQualifiers { get { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } set { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } }
        public override object Clone() { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
    }
    public partial class EventArrivedEventArgs : System.Management.ManagementEventArgs
    {
        internal EventArrivedEventArgs() { }
        public System.Management.ManagementBaseObject NewEvent { get { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } }
    }
    public delegate void EventArrivedEventHandler(object sender, System.Management.EventArrivedEventArgs e);
    public partial class EventQuery : System.Management.ManagementQuery
    {
        public EventQuery() { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public EventQuery(string query) { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public EventQuery(string language, string query) { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public override object Clone() { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
    }
    public partial class EventWatcherOptions : System.Management.ManagementOptions
    {
        public EventWatcherOptions() { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public EventWatcherOptions(System.Management.ManagementNamedValueCollection context, System.TimeSpan timeout, int blockSize) { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public int BlockSize { get { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } set { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } }
        public override object Clone() { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
    }
    public enum ImpersonationLevel
    {
        Default = 0,
        Anonymous = 1,
        Identify = 2,
        Impersonate = 3,
        Delegate = 4,
    }
    public partial class InvokeMethodOptions : System.Management.ManagementOptions
    {
        public InvokeMethodOptions() { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public InvokeMethodOptions(System.Management.ManagementNamedValueCollection context, System.TimeSpan timeout) { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public override object Clone() { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
    }
    [System.ComponentModel.ToolboxItemAttribute(false)]
    public partial class ManagementBaseObject : System.ComponentModel.Component, System.ICloneable, System.Runtime.Serialization.ISerializable
    {
        protected ManagementBaseObject(System.Runtime.Serialization.SerializationInfo info, System.Runtime.Serialization.StreamingContext context) { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public virtual System.Management.ManagementPath ClassPath { get { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } }
        public object this[string propertyName] { get { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } set { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } }
        public virtual System.Management.PropertyDataCollection Properties { get { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } }
        public virtual System.Management.QualifierDataCollection Qualifiers { get { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } }
        public virtual System.Management.PropertyDataCollection SystemProperties { get { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } }
        public virtual object Clone() { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public bool CompareTo(System.Management.ManagementBaseObject otherObject, System.Management.ComparisonSettings settings) { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public new void Dispose() { }
        public override bool Equals(object obj) { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public override int GetHashCode() { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        protected virtual void GetObjectData(System.Runtime.Serialization.SerializationInfo info, System.Runtime.Serialization.StreamingContext context) { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public object GetPropertyQualifierValue(string propertyName, string qualifierName) { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public object GetPropertyValue(string propertyName) { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public object GetQualifierValue(string qualifierName) { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public string GetText(System.Management.TextFormat format) { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public static explicit operator System.IntPtr (System.Management.ManagementBaseObject managementObject) { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public void SetPropertyQualifierValue(string propertyName, string qualifierName, object qualifierValue) { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public void SetPropertyValue(string propertyName, object propertyValue) { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public void SetQualifierValue(string qualifierName, object qualifierValue) { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        void System.Runtime.Serialization.ISerializable.GetObjectData(System.Runtime.Serialization.SerializationInfo info, System.Runtime.Serialization.StreamingContext context) { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
    }
    public partial class ManagementClass : System.Management.ManagementObject
    {
        public ManagementClass() { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public ManagementClass(System.Management.ManagementPath path) { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public ManagementClass(System.Management.ManagementPath path, System.Management.ObjectGetOptions options) { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public ManagementClass(System.Management.ManagementScope scope, System.Management.ManagementPath path, System.Management.ObjectGetOptions options) { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        protected ManagementClass(System.Runtime.Serialization.SerializationInfo info, System.Runtime.Serialization.StreamingContext context) { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public ManagementClass(string path) { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public ManagementClass(string path, System.Management.ObjectGetOptions options) { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public ManagementClass(string scope, string path, System.Management.ObjectGetOptions options) { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public System.Collections.Specialized.StringCollection Derivation { get { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } }
        public System.Management.MethodDataCollection Methods { get { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } }
        public override System.Management.ManagementPath Path { get { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } set { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } }
        public override object Clone() { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public System.Management.ManagementObject CreateInstance() { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public System.Management.ManagementClass Derive(string newClassName) { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public System.Management.ManagementObjectCollection GetInstances() { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public System.Management.ManagementObjectCollection GetInstances(System.Management.EnumerationOptions options) { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public void GetInstances(System.Management.ManagementOperationObserver watcher) { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public void GetInstances(System.Management.ManagementOperationObserver watcher, System.Management.EnumerationOptions options) { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        protected override void GetObjectData(System.Runtime.Serialization.SerializationInfo info, System.Runtime.Serialization.StreamingContext context) { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public System.Management.ManagementObjectCollection GetRelatedClasses() { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public void GetRelatedClasses(System.Management.ManagementOperationObserver watcher) { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public void GetRelatedClasses(System.Management.ManagementOperationObserver watcher, string relatedClass) { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public void GetRelatedClasses(System.Management.ManagementOperationObserver watcher, string relatedClass, string relationshipClass, string relationshipQualifier, string relatedQualifier, string relatedRole, string thisRole, System.Management.EnumerationOptions options) { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public System.Management.ManagementObjectCollection GetRelatedClasses(string relatedClass) { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public System.Management.ManagementObjectCollection GetRelatedClasses(string relatedClass, string relationshipClass, string relationshipQualifier, string relatedQualifier, string relatedRole, string thisRole, System.Management.EnumerationOptions options) { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public System.Management.ManagementObjectCollection GetRelationshipClasses() { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public void GetRelationshipClasses(System.Management.ManagementOperationObserver watcher) { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public void GetRelationshipClasses(System.Management.ManagementOperationObserver watcher, string relationshipClass) { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public void GetRelationshipClasses(System.Management.ManagementOperationObserver watcher, string relationshipClass, string relationshipQualifier, string thisRole, System.Management.EnumerationOptions options) { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public System.Management.ManagementObjectCollection GetRelationshipClasses(string relationshipClass) { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public System.Management.ManagementObjectCollection GetRelationshipClasses(string relationshipClass, string relationshipQualifier, string thisRole, System.Management.EnumerationOptions options) { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public System.CodeDom.CodeTypeDeclaration GetStronglyTypedClassCode(bool includeSystemClassInClassDef, bool systemPropertyClass) { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public bool GetStronglyTypedClassCode(System.Management.CodeLanguage lang, string filePath, string classNamespace) { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public System.Management.ManagementObjectCollection GetSubclasses() { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public System.Management.ManagementObjectCollection GetSubclasses(System.Management.EnumerationOptions options) { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public void GetSubclasses(System.Management.ManagementOperationObserver watcher) { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public void GetSubclasses(System.Management.ManagementOperationObserver watcher, System.Management.EnumerationOptions options) { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
    }
    public sealed partial class ManagementDateTimeConverter
    {
        internal ManagementDateTimeConverter() { }
        public static System.DateTime ToDateTime(string dmtfDate) { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public static string ToDmtfDateTime(System.DateTime date) { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public static string ToDmtfTimeInterval(System.TimeSpan timespan) { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public static System.TimeSpan ToTimeSpan(string dmtfTimespan) { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
    }
    public abstract partial class ManagementEventArgs : System.EventArgs
    {
        internal ManagementEventArgs() { }
        public object Context { get { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } }
    }
    [System.ComponentModel.ToolboxItemAttribute(false)]
    public partial class ManagementEventWatcher : System.ComponentModel.Component
    {
        public ManagementEventWatcher() { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public ManagementEventWatcher(System.Management.EventQuery query) { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public ManagementEventWatcher(System.Management.ManagementScope scope, System.Management.EventQuery query) { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public ManagementEventWatcher(System.Management.ManagementScope scope, System.Management.EventQuery query, System.Management.EventWatcherOptions options) { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public ManagementEventWatcher(string query) { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public ManagementEventWatcher(string scope, string query) { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public ManagementEventWatcher(string scope, string query, System.Management.EventWatcherOptions options) { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public System.Management.EventWatcherOptions Options { get { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } set { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } }
        public System.Management.EventQuery Query { get { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } set { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } }
        public System.Management.ManagementScope Scope { get { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } set { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } }
        public event System.Management.EventArrivedEventHandler EventArrived { add { } remove { } }
        public event System.Management.StoppedEventHandler Stopped { add { } remove { } }
        public void Start() { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public void Stop() { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public System.Management.ManagementBaseObject WaitForNextEvent() { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
    }
    public partial class ManagementException : System.SystemException
    {
        public ManagementException() { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        protected ManagementException(System.Runtime.Serialization.SerializationInfo info, System.Runtime.Serialization.StreamingContext context) { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public ManagementException(string message) { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public ManagementException(string message, System.Exception innerException) { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public System.Management.ManagementStatus ErrorCode { get { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } }
        public System.Management.ManagementBaseObject ErrorInformation { get { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } }
        public override void GetObjectData(System.Runtime.Serialization.SerializationInfo info, System.Runtime.Serialization.StreamingContext context) { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
    }
    public partial class ManagementNamedValueCollection : System.Collections.Specialized.NameObjectCollectionBase
    {
        public ManagementNamedValueCollection() { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        protected ManagementNamedValueCollection(System.Runtime.Serialization.SerializationInfo info, System.Runtime.Serialization.StreamingContext context) { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public object this[string name] { get { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } }
        public void Add(string name, object value) { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public System.Management.ManagementNamedValueCollection Clone() { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public void Remove(string name) { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public void RemoveAll() { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
    }
    public partial class ManagementObject : System.Management.ManagementBaseObject, System.ICloneable
    {
        public ManagementObject() : base (default(System.Runtime.Serialization.SerializationInfo), default(System.Runtime.Serialization.StreamingContext)) { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public ManagementObject(System.Management.ManagementPath path) : base (default(System.Runtime.Serialization.SerializationInfo), default(System.Runtime.Serialization.StreamingContext)) { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public ManagementObject(System.Management.ManagementPath path, System.Management.ObjectGetOptions options) : base (default(System.Runtime.Serialization.SerializationInfo), default(System.Runtime.Serialization.StreamingContext)) { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public ManagementObject(System.Management.ManagementScope scope, System.Management.ManagementPath path, System.Management.ObjectGetOptions options) : base (default(System.Runtime.Serialization.SerializationInfo), default(System.Runtime.Serialization.StreamingContext)) { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        protected ManagementObject(System.Runtime.Serialization.SerializationInfo info, System.Runtime.Serialization.StreamingContext context) : base (default(System.Runtime.Serialization.SerializationInfo), default(System.Runtime.Serialization.StreamingContext)) { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public ManagementObject(string path) : base (default(System.Runtime.Serialization.SerializationInfo), default(System.Runtime.Serialization.StreamingContext)) { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public ManagementObject(string path, System.Management.ObjectGetOptions options) : base (default(System.Runtime.Serialization.SerializationInfo), default(System.Runtime.Serialization.StreamingContext)) { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public ManagementObject(string scopeString, string pathString, System.Management.ObjectGetOptions options) : base (default(System.Runtime.Serialization.SerializationInfo), default(System.Runtime.Serialization.StreamingContext)) { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public override System.Management.ManagementPath ClassPath { get { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } }
        public System.Management.ObjectGetOptions Options { get { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } set { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } }
        public virtual System.Management.ManagementPath Path { get { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } set { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } }
        public System.Management.ManagementScope Scope { get { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } set { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } }
        public override object Clone() { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public void CopyTo(System.Management.ManagementOperationObserver watcher, System.Management.ManagementPath path) { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public void CopyTo(System.Management.ManagementOperationObserver watcher, System.Management.ManagementPath path, System.Management.PutOptions options) { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public void CopyTo(System.Management.ManagementOperationObserver watcher, string path) { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public void CopyTo(System.Management.ManagementOperationObserver watcher, string path, System.Management.PutOptions options) { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public System.Management.ManagementPath CopyTo(System.Management.ManagementPath path) { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public System.Management.ManagementPath CopyTo(System.Management.ManagementPath path, System.Management.PutOptions options) { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public System.Management.ManagementPath CopyTo(string path) { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public System.Management.ManagementPath CopyTo(string path, System.Management.PutOptions options) { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public void Delete() { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public void Delete(System.Management.DeleteOptions options) { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public void Delete(System.Management.ManagementOperationObserver watcher) { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public void Delete(System.Management.ManagementOperationObserver watcher, System.Management.DeleteOptions options) { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public new void Dispose() { }
        public void Get() { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public void Get(System.Management.ManagementOperationObserver watcher) { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public System.Management.ManagementBaseObject GetMethodParameters(string methodName) { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        protected override void GetObjectData(System.Runtime.Serialization.SerializationInfo info, System.Runtime.Serialization.StreamingContext context) { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public System.Management.ManagementObjectCollection GetRelated() { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public void GetRelated(System.Management.ManagementOperationObserver watcher) { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public void GetRelated(System.Management.ManagementOperationObserver watcher, string relatedClass) { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public void GetRelated(System.Management.ManagementOperationObserver watcher, string relatedClass, string relationshipClass, string relationshipQualifier, string relatedQualifier, string relatedRole, string thisRole, bool classDefinitionsOnly, System.Management.EnumerationOptions options) { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public System.Management.ManagementObjectCollection GetRelated(string relatedClass) { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public System.Management.ManagementObjectCollection GetRelated(string relatedClass, string relationshipClass, string relationshipQualifier, string relatedQualifier, string relatedRole, string thisRole, bool classDefinitionsOnly, System.Management.EnumerationOptions options) { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public System.Management.ManagementObjectCollection GetRelationships() { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public void GetRelationships(System.Management.ManagementOperationObserver watcher) { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public void GetRelationships(System.Management.ManagementOperationObserver watcher, string relationshipClass) { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public void GetRelationships(System.Management.ManagementOperationObserver watcher, string relationshipClass, string relationshipQualifier, string thisRole, bool classDefinitionsOnly, System.Management.EnumerationOptions options) { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public System.Management.ManagementObjectCollection GetRelationships(string relationshipClass) { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public System.Management.ManagementObjectCollection GetRelationships(string relationshipClass, string relationshipQualifier, string thisRole, bool classDefinitionsOnly, System.Management.EnumerationOptions options) { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public void InvokeMethod(System.Management.ManagementOperationObserver watcher, string methodName, System.Management.ManagementBaseObject inParameters, System.Management.InvokeMethodOptions options) { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public void InvokeMethod(System.Management.ManagementOperationObserver watcher, string methodName, object[] args) { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public System.Management.ManagementBaseObject InvokeMethod(string methodName, System.Management.ManagementBaseObject inParameters, System.Management.InvokeMethodOptions options) { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public object InvokeMethod(string methodName, object[] args) { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public System.Management.ManagementPath Put() { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public void Put(System.Management.ManagementOperationObserver watcher) { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public void Put(System.Management.ManagementOperationObserver watcher, System.Management.PutOptions options) { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public System.Management.ManagementPath Put(System.Management.PutOptions options) { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public override string ToString() { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
    }
    public partial class ManagementObjectCollection : System.Collections.ICollection, System.Collections.IEnumerable, System.IDisposable
    {
        internal ManagementObjectCollection() { }
        public int Count { get { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } }
        public bool IsSynchronized { get { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } }
        public object SyncRoot { get { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } }
        public void CopyTo(System.Array array, int index) { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public void CopyTo(System.Management.ManagementBaseObject[] objectCollection, int index) { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public void Dispose() { }
        public System.Management.ManagementObjectCollection.ManagementObjectEnumerator GetEnumerator() { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        System.Collections.IEnumerator System.Collections.IEnumerable.GetEnumerator() { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public partial class ManagementObjectEnumerator : System.Collections.IEnumerator, System.IDisposable
        {
            internal ManagementObjectEnumerator() { }
            public System.Management.ManagementBaseObject Current { get { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } }
            object System.Collections.IEnumerator.Current { get { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } }
            public void Dispose() { }
            public bool MoveNext() { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
            public void Reset() { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        }
    }
    [System.ComponentModel.ToolboxItemAttribute(false)]
    public partial class ManagementObjectSearcher : System.ComponentModel.Component
    {
        public ManagementObjectSearcher() { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public ManagementObjectSearcher(System.Management.ManagementScope scope, System.Management.ObjectQuery query) { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public ManagementObjectSearcher(System.Management.ManagementScope scope, System.Management.ObjectQuery query, System.Management.EnumerationOptions options) { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public ManagementObjectSearcher(System.Management.ObjectQuery query) { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public ManagementObjectSearcher(string queryString) { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public ManagementObjectSearcher(string scope, string queryString) { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public ManagementObjectSearcher(string scope, string queryString, System.Management.EnumerationOptions options) { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public System.Management.EnumerationOptions Options { get { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } set { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } }
        public System.Management.ObjectQuery Query { get { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } set { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } }
        public System.Management.ManagementScope Scope { get { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } set { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } }
        public System.Management.ManagementObjectCollection Get() { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public void Get(System.Management.ManagementOperationObserver watcher) { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
    }
    public partial class ManagementOperationObserver
    {
        public ManagementOperationObserver() { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public event System.Management.CompletedEventHandler Completed { add { } remove { } }
        public event System.Management.ObjectPutEventHandler ObjectPut { add { } remove { } }
        public event System.Management.ObjectReadyEventHandler ObjectReady { add { } remove { } }
        public event System.Management.ProgressEventHandler Progress { add { } remove { } }
        public void Cancel() { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
    }
    [System.ComponentModel.TypeConverterAttribute(typeof(System.ComponentModel.ExpandableObjectConverter))]
    public abstract partial class ManagementOptions : System.ICloneable
    {
        internal ManagementOptions() { }
        public static readonly System.TimeSpan InfiniteTimeout;
        public System.Management.ManagementNamedValueCollection Context { get { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } set { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } }
        public System.TimeSpan Timeout { get { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } set { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } }
        public abstract object Clone();
    }
    public partial class ManagementPath : System.ICloneable
    {
        public ManagementPath() { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public ManagementPath(string path) { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        [System.ComponentModel.RefreshPropertiesAttribute(System.ComponentModel.RefreshProperties.All)]
        public string ClassName { get { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } set { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } }
        public static System.Management.ManagementPath DefaultPath { get { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } set { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } }
        public bool IsClass { get { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } }
        public bool IsInstance { get { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } }
        public bool IsSingleton { get { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } }
        [System.ComponentModel.RefreshPropertiesAttribute(System.ComponentModel.RefreshProperties.All)]
        public string NamespacePath { get { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } set { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } }
        [System.ComponentModel.RefreshPropertiesAttribute(System.ComponentModel.RefreshProperties.All)]
        public string Path { get { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } set { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } }
        [System.ComponentModel.RefreshPropertiesAttribute(System.ComponentModel.RefreshProperties.All)]
        public string RelativePath { get { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } set { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } }
        [System.ComponentModel.RefreshPropertiesAttribute(System.ComponentModel.RefreshProperties.All)]
        public string Server { get { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } set { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } }
        public System.Management.ManagementPath Clone() { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public void SetAsClass() { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public void SetAsSingleton() { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        object System.ICloneable.Clone() { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public override string ToString() { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
    }
    public abstract partial class ManagementQuery : System.ICloneable
    {
        internal ManagementQuery() { }
        public virtual string QueryLanguage { get { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } set { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } }
        public virtual string QueryString { get { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } set { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } }
        public abstract object Clone();
        protected internal virtual void ParseQuery(string query) { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
    }
    public partial class ManagementScope : System.ICloneable
    {
        public ManagementScope() { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public ManagementScope(System.Management.ManagementPath path) { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public ManagementScope(System.Management.ManagementPath path, System.Management.ConnectionOptions options) { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public ManagementScope(string path) { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public ManagementScope(string path, System.Management.ConnectionOptions options) { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public bool IsConnected { get { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } }
        public System.Management.ConnectionOptions Options { get { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } set { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } }
        public System.Management.ManagementPath Path { get { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } set { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } }
        public System.Management.ManagementScope Clone() { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public void Connect() { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        object System.ICloneable.Clone() { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
    }
    public enum ManagementStatus
    {
        Failed = -2147217407,
        NotFound = -2147217406,
        AccessDenied = -2147217405,
        ProviderFailure = -2147217404,
        TypeMismatch = -2147217403,
        OutOfMemory = -2147217402,
        InvalidContext = -2147217401,
        InvalidParameter = -2147217400,
        NotAvailable = -2147217399,
        CriticalError = -2147217398,
        InvalidStream = -2147217397,
        NotSupported = -2147217396,
        InvalidSuperclass = -2147217395,
        InvalidNamespace = -2147217394,
        InvalidObject = -2147217393,
        InvalidClass = -2147217392,
        ProviderNotFound = -2147217391,
        InvalidProviderRegistration = -2147217390,
        ProviderLoadFailure = -2147217389,
        InitializationFailure = -2147217388,
        TransportFailure = -2147217387,
        InvalidOperation = -2147217386,
        InvalidQuery = -2147217385,
        InvalidQueryType = -2147217384,
        AlreadyExists = -2147217383,
        OverrideNotAllowed = -2147217382,
        PropagatedQualifier = -2147217381,
        PropagatedProperty = -2147217380,
        Unexpected = -2147217379,
        IllegalOperation = -2147217378,
        CannotBeKey = -2147217377,
        IncompleteClass = -2147217376,
        InvalidSyntax = -2147217375,
        NondecoratedObject = -2147217374,
        ReadOnly = -2147217373,
        ProviderNotCapable = -2147217372,
        ClassHasChildren = -2147217371,
        ClassHasInstances = -2147217370,
        QueryNotImplemented = -2147217369,
        IllegalNull = -2147217368,
        InvalidQualifierType = -2147217367,
        InvalidPropertyType = -2147217366,
        ValueOutOfRange = -2147217365,
        CannotBeSingleton = -2147217364,
        InvalidCimType = -2147217363,
        InvalidMethod = -2147217362,
        InvalidMethodParameters = -2147217361,
        SystemProperty = -2147217360,
        InvalidProperty = -2147217359,
        CallCanceled = -2147217358,
        ShuttingDown = -2147217357,
        PropagatedMethod = -2147217356,
        UnsupportedParameter = -2147217355,
        MissingParameterID = -2147217354,
        InvalidParameterID = -2147217353,
        NonconsecutiveParameterIDs = -2147217352,
        ParameterIDOnRetval = -2147217351,
        InvalidObjectPath = -2147217350,
        OutOfDiskSpace = -2147217349,
        BufferTooSmall = -2147217348,
        UnsupportedPutExtension = -2147217347,
        UnknownObjectType = -2147217346,
        UnknownPacketType = -2147217345,
        MarshalVersionMismatch = -2147217344,
        MarshalInvalidSignature = -2147217343,
        InvalidQualifier = -2147217342,
        InvalidDuplicateParameter = -2147217341,
        TooMuchData = -2147217340,
        ServerTooBusy = -2147217339,
        InvalidFlavor = -2147217338,
        CircularReference = -2147217337,
        UnsupportedClassUpdate = -2147217336,
        CannotChangeKeyInheritance = -2147217335,
        CannotChangeIndexInheritance = -2147217328,
        TooManyProperties = -2147217327,
        UpdateTypeMismatch = -2147217326,
        UpdateOverrideNotAllowed = -2147217325,
        UpdatePropagatedMethod = -2147217324,
        MethodNotImplemented = -2147217323,
        MethodDisabled = -2147217322,
        RefresherBusy = -2147217321,
        UnparsableQuery = -2147217320,
        NotEventClass = -2147217319,
        MissingGroupWithin = -2147217318,
        MissingAggregationList = -2147217317,
        PropertyNotAnObject = -2147217316,
        AggregatingByObject = -2147217315,
        UninterpretableProviderQuery = -2147217313,
        BackupRestoreWinmgmtRunning = -2147217312,
        QueueOverflow = -2147217311,
        PrivilegeNotHeld = -2147217310,
        InvalidOperator = -2147217309,
        LocalCredentials = -2147217308,
        CannotBeAbstract = -2147217307,
        AmendedObject = -2147217306,
        ClientTooSlow = -2147217305,
        RegistrationTooBroad = -2147213311,
        RegistrationTooPrecise = -2147213310,
        NoError = 0,
        False = 1,
        ResetToDefault = 262146,
        Different = 262147,
        Timedout = 262148,
        NoMoreData = 262149,
        OperationCanceled = 262150,
        Pending = 262151,
        DuplicateObjects = 262152,
        PartialResults = 262160,
    }
    public partial class MethodData
    {
        internal MethodData() { }
        public System.Management.ManagementBaseObject InParameters { get { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } }
        public string Name { get { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } }
        public string Origin { get { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } }
        public System.Management.ManagementBaseObject OutParameters { get { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } }
        public System.Management.QualifierDataCollection Qualifiers { get { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } }
    }
    public partial class MethodDataCollection : System.Collections.ICollection, System.Collections.IEnumerable
    {
        internal MethodDataCollection() { }
        public int Count { get { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } }
        public bool IsSynchronized { get { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } }
        public virtual System.Management.MethodData this[string methodName] { get { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } }
        public object SyncRoot { get { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } }
        public virtual void Add(string methodName) { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public virtual void Add(string methodName, System.Management.ManagementBaseObject inParameters, System.Management.ManagementBaseObject outParameters) { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public void CopyTo(System.Array array, int index) { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public void CopyTo(System.Management.MethodData[] methodArray, int index) { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public System.Management.MethodDataCollection.MethodDataEnumerator GetEnumerator() { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public virtual void Remove(string methodName) { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        System.Collections.IEnumerator System.Collections.IEnumerable.GetEnumerator() { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public partial class MethodDataEnumerator : System.Collections.IEnumerator
        {
            internal MethodDataEnumerator() { }
            public System.Management.MethodData Current { get { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } }
            object System.Collections.IEnumerator.Current { get { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } }
            public bool MoveNext() { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
            public void Reset() { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        }
    }
    public partial class ObjectGetOptions : System.Management.ManagementOptions
    {
        public ObjectGetOptions() { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public ObjectGetOptions(System.Management.ManagementNamedValueCollection context) { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public ObjectGetOptions(System.Management.ManagementNamedValueCollection context, System.TimeSpan timeout, bool useAmendedQualifiers) { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public bool UseAmendedQualifiers { get { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } set { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } }
        public override object Clone() { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
    }
    public partial class ObjectPutEventArgs : System.Management.ManagementEventArgs
    {
        internal ObjectPutEventArgs() { }
        public System.Management.ManagementPath Path { get { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } }
    }
    public delegate void ObjectPutEventHandler(object sender, System.Management.ObjectPutEventArgs e);
    public partial class ObjectQuery : System.Management.ManagementQuery
    {
        public ObjectQuery() { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public ObjectQuery(string query) { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public ObjectQuery(string language, string query) { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public override object Clone() { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
    }
    public partial class ObjectReadyEventArgs : System.Management.ManagementEventArgs
    {
        internal ObjectReadyEventArgs() { }
        public System.Management.ManagementBaseObject NewObject { get { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } }
    }
    public delegate void ObjectReadyEventHandler(object sender, System.Management.ObjectReadyEventArgs e);
    public partial class ProgressEventArgs : System.Management.ManagementEventArgs
    {
        internal ProgressEventArgs() { }
        public int Current { get { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } }
        public string Message { get { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } }
        public int UpperBound { get { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } }
    }
    public delegate void ProgressEventHandler(object sender, System.Management.ProgressEventArgs e);
    public partial class PropertyData
    {
        internal PropertyData() { }
        public bool IsArray { get { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } }
        public bool IsLocal { get { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } }
        public string Name { get { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } }
        public string Origin { get { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } }
        public System.Management.QualifierDataCollection Qualifiers { get { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } }
        public System.Management.CimType Type { get { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } }
        public object Value { get { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } set { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } }
    }
    public partial class PropertyDataCollection : System.Collections.ICollection, System.Collections.IEnumerable
    {
        internal PropertyDataCollection() { }
        public int Count { get { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } }
        public bool IsSynchronized { get { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } }
        public virtual System.Management.PropertyData this[string propertyName] { get { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } }
        public object SyncRoot { get { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } }
        public void Add(string propertyName, System.Management.CimType propertyType, bool isArray) { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public virtual void Add(string propertyName, object propertyValue) { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public void Add(string propertyName, object propertyValue, System.Management.CimType propertyType) { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public void CopyTo(System.Array array, int index) { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public void CopyTo(System.Management.PropertyData[] propertyArray, int index) { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public System.Management.PropertyDataCollection.PropertyDataEnumerator GetEnumerator() { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public virtual void Remove(string propertyName) { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        System.Collections.IEnumerator System.Collections.IEnumerable.GetEnumerator() { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public partial class PropertyDataEnumerator : System.Collections.IEnumerator
        {
            internal PropertyDataEnumerator() { }
            public System.Management.PropertyData Current { get { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } }
            object System.Collections.IEnumerator.Current { get { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } }
            public bool MoveNext() { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
            public void Reset() { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        }
    }
    public partial class PutOptions : System.Management.ManagementOptions
    {
        public PutOptions() { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public PutOptions(System.Management.ManagementNamedValueCollection context) { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public PutOptions(System.Management.ManagementNamedValueCollection context, System.TimeSpan timeout, bool useAmendedQualifiers, System.Management.PutType putType) { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public System.Management.PutType Type { get { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } set { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } }
        public bool UseAmendedQualifiers { get { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } set { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } }
        public override object Clone() { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
    }
    public enum PutType
    {
        None = 0,
        UpdateOnly = 1,
        CreateOnly = 2,
        UpdateOrCreate = 3,
    }
    public partial class QualifierData
    {
        internal QualifierData() { }
        public bool IsAmended { get { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } set { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } }
        public bool IsLocal { get { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } }
        public bool IsOverridable { get { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } set { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } }
        public string Name { get { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } }
        public bool PropagatesToInstance { get { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } set { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } }
        public bool PropagatesToSubclass { get { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } set { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } }
        public object Value { get { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } set { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } }
    }
    public partial class QualifierDataCollection : System.Collections.ICollection, System.Collections.IEnumerable
    {
        internal QualifierDataCollection() { }
        public int Count { get { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } }
        public bool IsSynchronized { get { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } }
        public virtual System.Management.QualifierData this[string qualifierName] { get { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } }
        public object SyncRoot { get { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } }
        public virtual void Add(string qualifierName, object qualifierValue) { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public virtual void Add(string qualifierName, object qualifierValue, bool isAmended, bool propagatesToInstance, bool propagatesToSubclass, bool isOverridable) { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public void CopyTo(System.Array array, int index) { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public void CopyTo(System.Management.QualifierData[] qualifierArray, int index) { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public System.Management.QualifierDataCollection.QualifierDataEnumerator GetEnumerator() { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public virtual void Remove(string qualifierName) { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        System.Collections.IEnumerator System.Collections.IEnumerable.GetEnumerator() { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public partial class QualifierDataEnumerator : System.Collections.IEnumerator
        {
            internal QualifierDataEnumerator() { }
            public System.Management.QualifierData Current { get { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } }
            object System.Collections.IEnumerator.Current { get { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } }
            public bool MoveNext() { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
            public void Reset() { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        }
    }
    public partial class RelatedObjectQuery : System.Management.WqlObjectQuery
    {
        public RelatedObjectQuery() { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public RelatedObjectQuery(bool isSchemaQuery, string sourceObject, string relatedClass, string relationshipClass, string relatedQualifier, string relationshipQualifier, string relatedRole, string thisRole) { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public RelatedObjectQuery(string queryOrSourceObject) { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public RelatedObjectQuery(string sourceObject, string relatedClass) { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public RelatedObjectQuery(string sourceObject, string relatedClass, string relationshipClass, string relatedQualifier, string relationshipQualifier, string relatedRole, string thisRole, bool classDefinitionsOnly) { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public bool ClassDefinitionsOnly { get { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } set { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } }
        public bool IsSchemaQuery { get { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } set { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } }
        public string RelatedClass { get { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } set { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } }
        public string RelatedQualifier { get { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } set { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } }
        public string RelatedRole { get { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } set { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } }
        public string RelationshipClass { get { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } set { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } }
        public string RelationshipQualifier { get { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } set { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } }
        public string SourceObject { get { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } set { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } }
        public string ThisRole { get { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } set { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } }
        protected internal void BuildQuery() { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public override object Clone() { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        protected internal override void ParseQuery(string query) { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
    }
    public partial class RelationshipQuery : System.Management.WqlObjectQuery
    {
        public RelationshipQuery() { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public RelationshipQuery(bool isSchemaQuery, string sourceObject, string relationshipClass, string relationshipQualifier, string thisRole) { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public RelationshipQuery(string queryOrSourceObject) { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public RelationshipQuery(string sourceObject, string relationshipClass) { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public RelationshipQuery(string sourceObject, string relationshipClass, string relationshipQualifier, string thisRole, bool classDefinitionsOnly) { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public bool ClassDefinitionsOnly { get { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } set { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } }
        public bool IsSchemaQuery { get { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } set { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } }
        public string RelationshipClass { get { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } set { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } }
        public string RelationshipQualifier { get { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } set { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } }
        public string SourceObject { get { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } set { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } }
        public string ThisRole { get { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } set { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } }
        protected internal void BuildQuery() { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public override object Clone() { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        protected internal override void ParseQuery(string query) { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
    }
    public partial class SelectQuery : System.Management.WqlObjectQuery
    {
        public SelectQuery() { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public SelectQuery(bool isSchemaQuery, string condition) { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public SelectQuery(string queryOrClassName) { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public SelectQuery(string className, string condition) { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public SelectQuery(string className, string condition, string[] selectedProperties) { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public string ClassName { get { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } set { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } }
        public string Condition { get { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } set { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } }
        public bool IsSchemaQuery { get { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } set { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } }
        public override string QueryString { get { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } set { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } }
        public System.Collections.Specialized.StringCollection SelectedProperties { get { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } set { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } }
        protected internal void BuildQuery() { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public override object Clone() { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        protected internal override void ParseQuery(string query) { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
    }
    public partial class StoppedEventArgs : System.Management.ManagementEventArgs
    {
        internal StoppedEventArgs() { }
        public System.Management.ManagementStatus Status { get { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } }
    }
    public delegate void StoppedEventHandler(object sender, System.Management.StoppedEventArgs e);
    public enum TextFormat
    {
        Mof = 0,
        CimDtd20 = 1,
        WmiDtd20 = 2,
    }
    public partial class WqlEventQuery : System.Management.EventQuery
    {
        public WqlEventQuery() { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public WqlEventQuery(string queryOrEventClassName) { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public WqlEventQuery(string eventClassName, string condition) { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public WqlEventQuery(string eventClassName, string condition, System.TimeSpan groupWithinInterval) { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public WqlEventQuery(string eventClassName, string condition, System.TimeSpan groupWithinInterval, string[] groupByPropertyList) { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public WqlEventQuery(string eventClassName, System.TimeSpan withinInterval) { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public WqlEventQuery(string eventClassName, System.TimeSpan withinInterval, string condition) { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public WqlEventQuery(string eventClassName, System.TimeSpan withinInterval, string condition, System.TimeSpan groupWithinInterval, string[] groupByPropertyList, string havingCondition) { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public string Condition { get { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } set { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } }
        public string EventClassName { get { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } set { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } }
        public System.Collections.Specialized.StringCollection GroupByPropertyList { get { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } set { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } }
        public System.TimeSpan GroupWithinInterval { get { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } set { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } }
        public string HavingCondition { get { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } set { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } }
        public override string QueryLanguage { get { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } }
        public override string QueryString { get { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } set { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } }
        public System.TimeSpan WithinInterval { get { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } set { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } }
        protected internal void BuildQuery() { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public override object Clone() { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        protected internal override void ParseQuery(string query) { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
    }
    public partial class WqlObjectQuery : System.Management.ObjectQuery
    {
        public WqlObjectQuery() { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public WqlObjectQuery(string query) { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
        public override string QueryLanguage { get { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); } }
        public override object Clone() { throw new System.PlatformNotSupportedException(System.SR.PlatformNotSupported_SystemManagement); }
    }
}
